# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetBandwidthPublicipResult',
    'GetEipsEipResult',
]

@pulumi.output_type
class GetBandwidthPublicipResult(dict):
    def __init__(__self__, *,
                 id: str,
                 ip_address: str,
                 ip_version: int,
                 type: str):
        """
        :param str id: The ID of the EIP or IPv6 port that uses the bandwidth.
        :param str ip_address: The IPv4 or IPv6 address.
        :param int ip_version: The IP version, either 4 or 6.
        :param str type: The EIP type. Possible values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP).
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the EIP or IPv6 port that uses the bandwidth.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IPv4 or IPv6 address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> int:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The EIP type. Possible values are *5_bgp* (dynamic BGP) and *5_sbgp* (static BGP).
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetEipsEipResult(dict):
    def __init__(__self__, *,
                 bandwidth_id: str,
                 bandwidth_name: str,
                 bandwidth_share_type: str,
                 bandwidth_size: int,
                 enterprise_project_id: str,
                 id: str,
                 ip_version: int,
                 name: str,
                 port_id: str,
                 private_ip: str,
                 public_ip: str,
                 public_ipv6: str,
                 status: str,
                 tags: Mapping[str, str],
                 type: str):
        """
        :param str bandwidth_id: The bandwidth id of the EIP.
        :param str bandwidth_name: The bandwidth name of the EIP.
        :param str bandwidth_share_type: The bandwidth share type of the EIP.
        :param int bandwidth_size: The bandwidth size of the EIP.
        :param str enterprise_project_id: Specifies the enterprise project ID which the desired EIP belongs to.
        :param str id: The ID of the EIP.
        :param int ip_version: Specifies ip version of the desired EIP. The options are:
               + `4`: IPv4.
               + `6`: IPv6.
        :param str name: The name of the EIP.
        :param str port_id: The port id bound to the EIP.
        :param str private_ip: The private ip address of the EIP.
        :param str public_ip: The public ip address of the EIP.
        :param str public_ipv6: The public ipv6 address of the EIP.
        :param str status: The status of the EIP.
        :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired EIP.
        :param str type: The type of the EIP.
        """
        pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        pulumi.set(__self__, "bandwidth_name", bandwidth_name)
        pulumi.set(__self__, "bandwidth_share_type", bandwidth_share_type)
        pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port_id", port_id)
        pulumi.set(__self__, "private_ip", private_ip)
        pulumi.set(__self__, "public_ip", public_ip)
        pulumi.set(__self__, "public_ipv6", public_ipv6)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> str:
        """
        The bandwidth id of the EIP.
        """
        return pulumi.get(self, "bandwidth_id")

    @property
    @pulumi.getter(name="bandwidthName")
    def bandwidth_name(self) -> str:
        """
        The bandwidth name of the EIP.
        """
        return pulumi.get(self, "bandwidth_name")

    @property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> str:
        """
        The bandwidth share type of the EIP.
        """
        return pulumi.get(self, "bandwidth_share_type")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> int:
        """
        The bandwidth size of the EIP.
        """
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        """
        Specifies the enterprise project ID which the desired EIP belongs to.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the EIP.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> int:
        """
        Specifies ip version of the desired EIP. The options are:
        + `4`: IPv4.
        + `6`: IPv6.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the EIP.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> str:
        """
        The port id bound to the EIP.
        """
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private ip address of the EIP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public ip address of the EIP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter(name="publicIpv6")
    def public_ipv6(self) -> str:
        """
        The public ipv6 address of the EIP.
        """
        return pulumi.get(self, "public_ipv6")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Mapping[str, str]:
        """
        Specifies the included key/value pairs which associated with the desired EIP.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the EIP.
        """
        return pulumi.get(self, "type")


