# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetEipsResult',
    'AwaitableGetEipsResult',
    'get_eips',
    'get_eips_output',
]

@pulumi.output_type
class GetEipsResult:
    """
    A collection of values returned by getEips.
    """
    def __init__(__self__, eips=None, enterprise_project_id=None, id=None, ids=None, ip_version=None, port_ids=None, public_ips=None, region=None, tags=None):
        if eips and not isinstance(eips, list):
            raise TypeError("Expected argument 'eips' to be a list")
        pulumi.set(__self__, "eips", eips)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if port_ids and not isinstance(port_ids, list):
            raise TypeError("Expected argument 'port_ids' to be a list")
        pulumi.set(__self__, "port_ids", port_ids)
        if public_ips and not isinstance(public_ips, list):
            raise TypeError("Expected argument 'public_ips' to be a list")
        pulumi.set(__self__, "public_ips", public_ips)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter
    def eips(self) -> Sequence['outputs.GetEipsEipResult']:
        """
        Indicates a list of all EIPs found. Structure is documented below.
        """
        return pulumi.get(self, "eips")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The the enterprise project ID of the EIP.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> Optional[int]:
        """
        The ip version of the EIP.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="portIds")
    def port_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "port_ids")

    @property
    @pulumi.getter(name="publicIps")
    def public_ips(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "public_ips")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        The key/value pairs which associated with the EIP.
        """
        return pulumi.get(self, "tags")


class AwaitableGetEipsResult(GetEipsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipsResult(
            eips=self.eips,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ids=self.ids,
            ip_version=self.ip_version,
            port_ids=self.port_ids,
            public_ips=self.public_ips,
            region=self.region,
            tags=self.tags)


def get_eips(enterprise_project_id: Optional[str] = None,
             ids: Optional[Sequence[str]] = None,
             ip_version: Optional[int] = None,
             port_ids: Optional[Sequence[str]] = None,
             public_ips: Optional[Sequence[str]] = None,
             region: Optional[str] = None,
             tags: Optional[Mapping[str, str]] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipsResult:
    """
    Use this data source to get a list of EIPs.


    :param str enterprise_project_id: Specifies the enterprise project ID which the desired EIP belongs to.
    :param Sequence[str] ids: Specifies an array of one or more IDs of the desired EIP.
    :param int ip_version: Specifies ip version of the desired EIP. The options are:
           + `4`: IPv4.
           + `6`: IPv6.
    :param Sequence[str] port_ids: Specifies an array of one or more port ids which bound to the desired EIP.
    :param Sequence[str] public_ips: Specifies an array of one or more public ip addresses of the desired EIP.
    :param str region: Specifies the region in which to obtain the EIP. If omitted, the provider-level region
           will be used.
    :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired EIP.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['ids'] = ids
    __args__['ipVersion'] = ip_version
    __args__['portIds'] = port_ids
    __args__['publicIps'] = public_ips
    __args__['region'] = region
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Eip/getEips:getEips', __args__, opts=opts, typ=GetEipsResult).value

    return AwaitableGetEipsResult(
        eips=__ret__.eips,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        ids=__ret__.ids,
        ip_version=__ret__.ip_version,
        port_ids=__ret__.port_ids,
        public_ips=__ret__.public_ips,
        region=__ret__.region,
        tags=__ret__.tags)


@_utilities.lift_output_func(get_eips)
def get_eips_output(enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    ip_version: Optional[pulumi.Input[Optional[int]]] = None,
                    port_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    public_ips: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    region: Optional[pulumi.Input[Optional[str]]] = None,
                    tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEipsResult]:
    """
    Use this data source to get a list of EIPs.


    :param str enterprise_project_id: Specifies the enterprise project ID which the desired EIP belongs to.
    :param Sequence[str] ids: Specifies an array of one or more IDs of the desired EIP.
    :param int ip_version: Specifies ip version of the desired EIP. The options are:
           + `4`: IPv4.
           + `6`: IPv6.
    :param Sequence[str] port_ids: Specifies an array of one or more port ids which bound to the desired EIP.
    :param Sequence[str] public_ips: Specifies an array of one or more public ip addresses of the desired EIP.
    :param str region: Specifies the region in which to obtain the EIP. If omitted, the provider-level region
           will be used.
    :param Mapping[str, str] tags: Specifies the included key/value pairs which associated with the desired EIP.
    """
    ...
