# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetEipResult',
    'AwaitableGetEipResult',
    'get_eip',
    'get_eip_output',
]

@pulumi.output_type
class GetEipResult:
    """
    A collection of values returned by getEip.
    """
    def __init__(__self__, bandwidth_id=None, bandwidth_share_type=None, bandwidth_size=None, enterprise_project_id=None, id=None, ip_version=None, ipv6_address=None, port_id=None, private_ip=None, public_ip=None, region=None, status=None, type=None):
        if bandwidth_id and not isinstance(bandwidth_id, str):
            raise TypeError("Expected argument 'bandwidth_id' to be a str")
        pulumi.set(__self__, "bandwidth_id", bandwidth_id)
        if bandwidth_share_type and not isinstance(bandwidth_share_type, str):
            raise TypeError("Expected argument 'bandwidth_share_type' to be a str")
        pulumi.set(__self__, "bandwidth_share_type", bandwidth_share_type)
        if bandwidth_size and not isinstance(bandwidth_size, int):
            raise TypeError("Expected argument 'bandwidth_size' to be a int")
        pulumi.set(__self__, "bandwidth_size", bandwidth_size)
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ip_version and not isinstance(ip_version, int):
            raise TypeError("Expected argument 'ip_version' to be a int")
        pulumi.set(__self__, "ip_version", ip_version)
        if ipv6_address and not isinstance(ipv6_address, str):
            raise TypeError("Expected argument 'ipv6_address' to be a str")
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        if port_id and not isinstance(port_id, str):
            raise TypeError("Expected argument 'port_id' to be a str")
        pulumi.set(__self__, "port_id", port_id)
        if private_ip and not isinstance(private_ip, str):
            raise TypeError("Expected argument 'private_ip' to be a str")
        pulumi.set(__self__, "private_ip", private_ip)
        if public_ip and not isinstance(public_ip, str):
            raise TypeError("Expected argument 'public_ip' to be a str")
        pulumi.set(__self__, "public_ip", public_ip)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="bandwidthId")
    def bandwidth_id(self) -> str:
        """
        The bandwidth id of the EIP.
        """
        return pulumi.get(self, "bandwidth_id")

    @property
    @pulumi.getter(name="bandwidthShareType")
    def bandwidth_share_type(self) -> str:
        """
        The bandwidth share type of the EIP.
        """
        return pulumi.get(self, "bandwidth_share_type")

    @property
    @pulumi.getter(name="bandwidthSize")
    def bandwidth_size(self) -> int:
        """
        The bandwidth size of the EIP.
        """
        return pulumi.get(self, "bandwidth_size")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> str:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> int:
        """
        The IP version, either 4 or 6.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The IPv6 address of the EIP.
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> str:
        return pulumi.get(self, "port_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private ip of the EIP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the EIP.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the EIP.
        """
        return pulumi.get(self, "type")


class AwaitableGetEipResult(GetEipResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEipResult(
            bandwidth_id=self.bandwidth_id,
            bandwidth_share_type=self.bandwidth_share_type,
            bandwidth_size=self.bandwidth_size,
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            ip_version=self.ip_version,
            ipv6_address=self.ipv6_address,
            port_id=self.port_id,
            private_ip=self.private_ip,
            public_ip=self.public_ip,
            region=self.region,
            status=self.status,
            type=self.type)


def get_eip(enterprise_project_id: Optional[str] = None,
            port_id: Optional[str] = None,
            public_ip: Optional[str] = None,
            region: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEipResult:
    """
    Use this data source to get the details of an available EIP.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    by_address = huaweicloud.Eip.get_eip(public_ip="123.60.208.163")
    ```


    :param str enterprise_project_id: Specifies the enterprise project id of the EIP.
    :param str port_id: Specifies the port id of the EIP.
    :param str public_ip: Specifies the public **IPv4** address of the EIP.
    :param str region: Specifies the region in which to obtain the EIP.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['portId'] = port_id
    __args__['publicIp'] = public_ip
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Eip/getEip:getEip', __args__, opts=opts, typ=GetEipResult).value

    return AwaitableGetEipResult(
        bandwidth_id=__ret__.bandwidth_id,
        bandwidth_share_type=__ret__.bandwidth_share_type,
        bandwidth_size=__ret__.bandwidth_size,
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        ip_version=__ret__.ip_version,
        ipv6_address=__ret__.ipv6_address,
        port_id=__ret__.port_id,
        private_ip=__ret__.private_ip,
        public_ip=__ret__.public_ip,
        region=__ret__.region,
        status=__ret__.status,
        type=__ret__.type)


@_utilities.lift_output_func(get_eip)
def get_eip_output(enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                   port_id: Optional[pulumi.Input[Optional[str]]] = None,
                   public_ip: Optional[pulumi.Input[Optional[str]]] = None,
                   region: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetEipResult]:
    """
    Use this data source to get the details of an available EIP.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    by_address = huaweicloud.Eip.get_eip(public_ip="123.60.208.163")
    ```


    :param str enterprise_project_id: Specifies the enterprise project id of the EIP.
    :param str port_id: Specifies the port id of the EIP.
    :param str public_ip: Specifies the public **IPv4** address of the EIP.
    :param str region: Specifies the region in which to obtain the EIP.
           If omitted, the provider-level region will be used.
    """
    ...
