# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetProductResult',
    'AwaitableGetProductResult',
    'get_product',
    'get_product_output',
]

@pulumi.output_type
class GetProductResult:
    """
    A collection of values returned by getProduct.
    """
    def __init__(__self__, availability_zones=None, bandwidth=None, engine=None, id=None, instance_type=None, io_type=None, node_num=None, partition_num=None, region=None, storage=None, storage_spec_code=None, storage_spec_codes=None, version=None, vm_specification=None):
        if availability_zones and not isinstance(availability_zones, list):
            raise TypeError("Expected argument 'availability_zones' to be a list")
        pulumi.set(__self__, "availability_zones", availability_zones)
        if bandwidth and not isinstance(bandwidth, str):
            raise TypeError("Expected argument 'bandwidth' to be a str")
        pulumi.set(__self__, "bandwidth", bandwidth)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if io_type and not isinstance(io_type, str):
            raise TypeError("Expected argument 'io_type' to be a str")
        if io_type is not None:
            warnings.warn("""io_type has deprecated, please use storage_spec_code""", DeprecationWarning)
            pulumi.log.warn("""io_type is deprecated: io_type has deprecated, please use storage_spec_code""")

        pulumi.set(__self__, "io_type", io_type)
        if node_num and not isinstance(node_num, str):
            raise TypeError("Expected argument 'node_num' to be a str")
        pulumi.set(__self__, "node_num", node_num)
        if partition_num and not isinstance(partition_num, str):
            raise TypeError("Expected argument 'partition_num' to be a str")
        pulumi.set(__self__, "partition_num", partition_num)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if storage and not isinstance(storage, str):
            raise TypeError("Expected argument 'storage' to be a str")
        pulumi.set(__self__, "storage", storage)
        if storage_spec_code and not isinstance(storage_spec_code, str):
            raise TypeError("Expected argument 'storage_spec_code' to be a str")
        pulumi.set(__self__, "storage_spec_code", storage_spec_code)
        if storage_spec_codes and not isinstance(storage_spec_codes, list):
            raise TypeError("Expected argument 'storage_spec_codes' to be a list")
        pulumi.set(__self__, "storage_spec_codes", storage_spec_codes)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)
        if vm_specification and not isinstance(vm_specification, str):
            raise TypeError("Expected argument 'vm_specification' to be a str")
        pulumi.set(__self__, "vm_specification", vm_specification)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Sequence[str]:
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter
    def bandwidth(self) -> str:
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter
    def engine(self) -> str:
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="ioType")
    def io_type(self) -> str:
        return pulumi.get(self, "io_type")

    @property
    @pulumi.getter(name="nodeNum")
    def node_num(self) -> str:
        return pulumi.get(self, "node_num")

    @property
    @pulumi.getter(name="partitionNum")
    def partition_num(self) -> str:
        return pulumi.get(self, "partition_num")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def storage(self) -> str:
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter(name="storageSpecCode")
    def storage_spec_code(self) -> str:
        return pulumi.get(self, "storage_spec_code")

    @property
    @pulumi.getter(name="storageSpecCodes")
    def storage_spec_codes(self) -> Sequence[str]:
        return pulumi.get(self, "storage_spec_codes")

    @property
    @pulumi.getter
    def version(self) -> str:
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vmSpecification")
    def vm_specification(self) -> str:
        return pulumi.get(self, "vm_specification")


class AwaitableGetProductResult(GetProductResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProductResult(
            availability_zones=self.availability_zones,
            bandwidth=self.bandwidth,
            engine=self.engine,
            id=self.id,
            instance_type=self.instance_type,
            io_type=self.io_type,
            node_num=self.node_num,
            partition_num=self.partition_num,
            region=self.region,
            storage=self.storage,
            storage_spec_code=self.storage_spec_code,
            storage_spec_codes=self.storage_spec_codes,
            version=self.version,
            vm_specification=self.vm_specification)


def get_product(availability_zones: Optional[Sequence[str]] = None,
                bandwidth: Optional[str] = None,
                engine: Optional[str] = None,
                instance_type: Optional[str] = None,
                io_type: Optional[str] = None,
                node_num: Optional[str] = None,
                partition_num: Optional[str] = None,
                region: Optional[str] = None,
                storage: Optional[str] = None,
                storage_spec_code: Optional[str] = None,
                storage_spec_codes: Optional[Sequence[str]] = None,
                version: Optional[str] = None,
                vm_specification: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProductResult:
    """
    Use this data source to get the ID of an available HuaweiCloud dms product.

    ## Example Usage
    ### Filter DMS kafka product list by I/O specification

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    product1 = huaweicloud.Dms.get_product(engine="kafka",
        instance_type="cluster",
        partition_num="300",
        storage="600",
        storage_spec_code="dms.physical.storage.high",
        version="1.1.0")
    ```
    ### Filter DMS kafka product list by underlying VM specification

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    product2 = huaweicloud.Dms.get_product(engine="kafka",
        instance_type="cluster",
        version="2.3.0",
        vm_specification="c6.large.2")
    ```


    :param Sequence[str] availability_zones: Indicates the list of availability zones with available resources.
    :param str bandwidth: Indicates the baseline bandwidth of a DMS instance.
           The valid values are **100MB**, **300MB**, **600MB** and **1200MB**.
    :param str engine: Indicates the name of a message engine. The valid values are **kafka**, **rabbitmq**.
    :param str instance_type: Indicates an instance type. The valid values are **single** and **cluster**.
    :param str node_num: Indicates the number of nodes in a cluster.
    :param str partition_num: Indicates the maximum number of topics that can be created for a Kafka instance.
           The valid values are **300**, **900** and **1800**.
    :param str region: The region in which to obtain the dms products. If omitted, the provider-level region
           will be used.
    :param str storage: Indicates the storage capacity of the resource.
           The default value is the storage capacity of the product.
    :param str storage_spec_code: Indicates an I/O specification.
           The valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
    :param str version: Indicates the version of a message engine.
    :param str vm_specification: Indicates underlying VM specification, such as **c6.large.2**.
    """
    __args__ = dict()
    __args__['availabilityZones'] = availability_zones
    __args__['bandwidth'] = bandwidth
    __args__['engine'] = engine
    __args__['instanceType'] = instance_type
    __args__['ioType'] = io_type
    __args__['nodeNum'] = node_num
    __args__['partitionNum'] = partition_num
    __args__['region'] = region
    __args__['storage'] = storage
    __args__['storageSpecCode'] = storage_spec_code
    __args__['storageSpecCodes'] = storage_spec_codes
    __args__['version'] = version
    __args__['vmSpecification'] = vm_specification
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dms/getProduct:getProduct', __args__, opts=opts, typ=GetProductResult).value

    return AwaitableGetProductResult(
        availability_zones=__ret__.availability_zones,
        bandwidth=__ret__.bandwidth,
        engine=__ret__.engine,
        id=__ret__.id,
        instance_type=__ret__.instance_type,
        io_type=__ret__.io_type,
        node_num=__ret__.node_num,
        partition_num=__ret__.partition_num,
        region=__ret__.region,
        storage=__ret__.storage,
        storage_spec_code=__ret__.storage_spec_code,
        storage_spec_codes=__ret__.storage_spec_codes,
        version=__ret__.version,
        vm_specification=__ret__.vm_specification)


@_utilities.lift_output_func(get_product)
def get_product_output(availability_zones: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       bandwidth: Optional[pulumi.Input[Optional[str]]] = None,
                       engine: Optional[pulumi.Input[str]] = None,
                       instance_type: Optional[pulumi.Input[str]] = None,
                       io_type: Optional[pulumi.Input[Optional[str]]] = None,
                       node_num: Optional[pulumi.Input[Optional[str]]] = None,
                       partition_num: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       storage: Optional[pulumi.Input[Optional[str]]] = None,
                       storage_spec_code: Optional[pulumi.Input[Optional[str]]] = None,
                       storage_spec_codes: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       version: Optional[pulumi.Input[Optional[str]]] = None,
                       vm_specification: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProductResult]:
    """
    Use this data source to get the ID of an available HuaweiCloud dms product.

    ## Example Usage
    ### Filter DMS kafka product list by I/O specification

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    product1 = huaweicloud.Dms.get_product(engine="kafka",
        instance_type="cluster",
        partition_num="300",
        storage="600",
        storage_spec_code="dms.physical.storage.high",
        version="1.1.0")
    ```
    ### Filter DMS kafka product list by underlying VM specification

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    product2 = huaweicloud.Dms.get_product(engine="kafka",
        instance_type="cluster",
        version="2.3.0",
        vm_specification="c6.large.2")
    ```


    :param Sequence[str] availability_zones: Indicates the list of availability zones with available resources.
    :param str bandwidth: Indicates the baseline bandwidth of a DMS instance.
           The valid values are **100MB**, **300MB**, **600MB** and **1200MB**.
    :param str engine: Indicates the name of a message engine. The valid values are **kafka**, **rabbitmq**.
    :param str instance_type: Indicates an instance type. The valid values are **single** and **cluster**.
    :param str node_num: Indicates the number of nodes in a cluster.
    :param str partition_num: Indicates the maximum number of topics that can be created for a Kafka instance.
           The valid values are **300**, **900** and **1800**.
    :param str region: The region in which to obtain the dms products. If omitted, the provider-level region
           will be used.
    :param str storage: Indicates the storage capacity of the resource.
           The default value is the storage capacity of the product.
    :param str storage_spec_code: Indicates an I/O specification.
           The valid values are **dms.physical.storage.high** and **dms.physical.storage.ultra**.
    :param str version: Indicates the version of a message engine.
    :param str vm_specification: Indicates underlying VM specification, such as **c6.large.2**.
    """
    ...
