# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PermissionArgs', 'Permission']

@pulumi.input_type
class PermissionArgs:
    def __init__(__self__, *,
                 object: pulumi.Input[str],
                 privileges: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_name: pulumi.Input[str],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Permission resource.
        :param pulumi.Input[str] object: Specifies which object's data usage permissions will be shared.
               Its naming format is as follows:
               + **queues.`queues_name`**: the usage permissions of queue.
               + **databases.`database_name`**: the usage permissions of data in the database.
               + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
               + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
               + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
               + **groups.`package_group_name`**: the usage permissions of data in the package group.
               + **resources.`package_name`**: the usage permissions of data in the package.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] privileges: Specifies the usage permissions of data.
               + **Permissions on Queue, Database and Table**,
               please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        :param pulumi.Input[str] user_name: Specifies name of the user who is granted with usage permission.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] region: The region in which to create the DLI permission resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        """
        pulumi.set(__self__, "object", object)
        pulumi.set(__self__, "privileges", privileges)
        pulumi.set(__self__, "user_name", user_name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def object(self) -> pulumi.Input[str]:
        """
        Specifies which object's data usage permissions will be shared.
        Its naming format is as follows:
        + **queues.`queues_name`**: the usage permissions of queue.
        + **databases.`database_name`**: the usage permissions of data in the database.
        + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
        + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
        + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
        + **groups.`package_group_name`**: the usage permissions of data in the package group.
        + **resources.`package_name`**: the usage permissions of data in the package.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: pulumi.Input[str]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def privileges(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the usage permissions of data.
        + **Permissions on Queue, Database and Table**,
        please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        Specifies name of the user who is granted with usage permission.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DLI permission resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _PermissionState:
    def __init__(__self__, *,
                 is_admin: Optional[pulumi.Input[bool]] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Permission resources.
        :param pulumi.Input[bool] is_admin: Whether this user is an administrator.
        :param pulumi.Input[str] object: Specifies which object's data usage permissions will be shared.
               Its naming format is as follows:
               + **queues.`queues_name`**: the usage permissions of queue.
               + **databases.`database_name`**: the usage permissions of data in the database.
               + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
               + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
               + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
               + **groups.`package_group_name`**: the usage permissions of data in the package group.
               + **resources.`package_name`**: the usage permissions of data in the package.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] privileges: Specifies the usage permissions of data.
               + **Permissions on Queue, Database and Table**,
               please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        :param pulumi.Input[str] region: The region in which to create the DLI permission resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] user_name: Specifies name of the user who is granted with usage permission.
               Changing this parameter will create a new resource.
        """
        if is_admin is not None:
            pulumi.set(__self__, "is_admin", is_admin)
        if object is not None:
            pulumi.set(__self__, "object", object)
        if privileges is not None:
            pulumi.set(__self__, "privileges", privileges)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this user is an administrator.
        """
        return pulumi.get(self, "is_admin")

    @is_admin.setter
    def is_admin(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_admin", value)

    @property
    @pulumi.getter
    def object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies which object's data usage permissions will be shared.
        Its naming format is as follows:
        + **queues.`queues_name`**: the usage permissions of queue.
        + **databases.`database_name`**: the usage permissions of data in the database.
        + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
        + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
        + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
        + **groups.`package_group_name`**: the usage permissions of data in the package group.
        + **resources.`package_name`**: the usage permissions of data in the package.
        """
        return pulumi.get(self, "object")

    @object.setter
    def object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "object", value)

    @property
    @pulumi.getter
    def privileges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the usage permissions of data.
        + **Permissions on Queue, Database and Table**,
        please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        """
        return pulumi.get(self, "privileges")

    @privileges.setter
    def privileges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "privileges", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the DLI permission resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies name of the user who is granted with usage permission.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)


class Permission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages the usage permissions of those resources: `Dli.Queue`, `Dli.Database`,
         `Dli.Table`, `Dli.Package`, `Dli.FlinksqlJob`, `Dli.FlinkjarJob`
          within HuaweiCloud DLI.

        ## Example Usage
        ### Grant a permission of queue

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        user_name = config.require_object("userName")
        queue_name = config.require_object("queueName")
        test = huaweicloud.dli.Permission("test",
            user_name=user_name,
            object=f"queues.{queue_name}",
            privileges=[
                "SUBMIT_JOB",
                "DROP_QUEUE",
            ])
        ```
        ### Grant a permission of database

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        user_name = config.require_object("userName")
        database_name = config.require_object("databaseName")
        test = huaweicloud.dli.Permission("test",
            user_name=user_name,
            object=f"databases.{database_name}",
            privileges=["SELECT"])
        ```

        ## Import

        The permission can be imported by `id`, it is composed of `object` and `user_name`, separated by a slash. e.g.

        ```sh
         $ pulumi import huaweicloud:Dli/permission:Permission test databases.database_name/user_name
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] object: Specifies which object's data usage permissions will be shared.
               Its naming format is as follows:
               + **queues.`queues_name`**: the usage permissions of queue.
               + **databases.`database_name`**: the usage permissions of data in the database.
               + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
               + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
               + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
               + **groups.`package_group_name`**: the usage permissions of data in the package group.
               + **resources.`package_name`**: the usage permissions of data in the package.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] privileges: Specifies the usage permissions of data.
               + **Permissions on Queue, Database and Table**,
               please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        :param pulumi.Input[str] region: The region in which to create the DLI permission resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] user_name: Specifies name of the user who is granted with usage permission.
               Changing this parameter will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages the usage permissions of those resources: `Dli.Queue`, `Dli.Database`,
         `Dli.Table`, `Dli.Package`, `Dli.FlinksqlJob`, `Dli.FlinkjarJob`
          within HuaweiCloud DLI.

        ## Example Usage
        ### Grant a permission of queue

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        user_name = config.require_object("userName")
        queue_name = config.require_object("queueName")
        test = huaweicloud.dli.Permission("test",
            user_name=user_name,
            object=f"queues.{queue_name}",
            privileges=[
                "SUBMIT_JOB",
                "DROP_QUEUE",
            ])
        ```
        ### Grant a permission of database

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        user_name = config.require_object("userName")
        database_name = config.require_object("databaseName")
        test = huaweicloud.dli.Permission("test",
            user_name=user_name,
            object=f"databases.{database_name}",
            privileges=["SELECT"])
        ```

        ## Import

        The permission can be imported by `id`, it is composed of `object` and `user_name`, separated by a slash. e.g.

        ```sh
         $ pulumi import huaweicloud:Dli/permission:Permission test databases.database_name/user_name
        ```

        :param str resource_name: The name of the resource.
        :param PermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 object: Optional[pulumi.Input[str]] = None,
                 privileges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PermissionArgs.__new__(PermissionArgs)

            if object is None and not opts.urn:
                raise TypeError("Missing required property 'object'")
            __props__.__dict__["object"] = object
            if privileges is None and not opts.urn:
                raise TypeError("Missing required property 'privileges'")
            __props__.__dict__["privileges"] = privileges
            __props__.__dict__["region"] = region
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["is_admin"] = None
        super(Permission, __self__).__init__(
            'huaweicloud:Dli/permission:Permission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            is_admin: Optional[pulumi.Input[bool]] = None,
            object: Optional[pulumi.Input[str]] = None,
            privileges: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            user_name: Optional[pulumi.Input[str]] = None) -> 'Permission':
        """
        Get an existing Permission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] is_admin: Whether this user is an administrator.
        :param pulumi.Input[str] object: Specifies which object's data usage permissions will be shared.
               Its naming format is as follows:
               + **queues.`queues_name`**: the usage permissions of queue.
               + **databases.`database_name`**: the usage permissions of data in the database.
               + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
               + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
               + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
               + **groups.`package_group_name`**: the usage permissions of data in the package group.
               + **resources.`package_name`**: the usage permissions of data in the package.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] privileges: Specifies the usage permissions of data.
               + **Permissions on Queue, Database and Table**,
               please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        :param pulumi.Input[str] region: The region in which to create the DLI permission resource. If omitted, the
               provider-level region will be used. Changing this parameter will create a new resource.
        :param pulumi.Input[str] user_name: Specifies name of the user who is granted with usage permission.
               Changing this parameter will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PermissionState.__new__(_PermissionState)

        __props__.__dict__["is_admin"] = is_admin
        __props__.__dict__["object"] = object
        __props__.__dict__["privileges"] = privileges
        __props__.__dict__["region"] = region
        __props__.__dict__["user_name"] = user_name
        return Permission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="isAdmin")
    def is_admin(self) -> pulumi.Output[bool]:
        """
        Whether this user is an administrator.
        """
        return pulumi.get(self, "is_admin")

    @property
    @pulumi.getter
    def object(self) -> pulumi.Output[str]:
        """
        Specifies which object's data usage permissions will be shared.
        Its naming format is as follows:
        + **queues.`queues_name`**: the usage permissions of queue.
        + **databases.`database_name`**: the usage permissions of data in the database.
        + **databases.`database_name`.tables.`table_name`**: the usage permissions of data in the table.
        + **databases.`database_name`.tables.`table_name`.columns.`column_name`**: the usage permissions of data in the column.
        + **jobs.flink.`flink_job_id`**: the usage permissions of data in the flink job.
        + **groups.`package_group_name`**: the usage permissions of data in the package group.
        + **resources.`package_name`**: the usage permissions of data in the package.
        """
        return pulumi.get(self, "object")

    @property
    @pulumi.getter
    def privileges(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the usage permissions of data.
        + **Permissions on Queue, Database and Table**,
        please see [Permissions Management](https://support.huaweicloud.com/intl/en-us/productdesc-dli/dli_07_0006.html)
        """
        return pulumi.get(self, "privileges")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the DLI permission resource. If omitted, the
        provider-level region will be used. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        Specifies name of the user who is granted with usage permission.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "user_name")

