# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetKeypairsResult',
    'AwaitableGetKeypairsResult',
    'get_keypairs',
    'get_keypairs_output',
]

@pulumi.output_type
class GetKeypairsResult:
    """
    A collection of values returned by getKeypairs.
    """
    def __init__(__self__, fingerprint=None, id=None, is_managed=None, keypairs=None, name=None, public_key=None, region=None):
        if fingerprint and not isinstance(fingerprint, str):
            raise TypeError("Expected argument 'fingerprint' to be a str")
        pulumi.set(__self__, "fingerprint", fingerprint)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_managed and not isinstance(is_managed, bool):
            raise TypeError("Expected argument 'is_managed' to be a bool")
        pulumi.set(__self__, "is_managed", is_managed)
        if keypairs and not isinstance(keypairs, list):
            raise TypeError("Expected argument 'keypairs' to be a list")
        pulumi.set(__self__, "keypairs", keypairs)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if public_key and not isinstance(public_key, str):
            raise TypeError("Expected argument 'public_key' to be a str")
        pulumi.set(__self__, "public_key", public_key)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def fingerprint(self) -> Optional[str]:
        """
        Indicates the fingerprint information about an key pair.
        """
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isManaged")
    def is_managed(self) -> Optional[bool]:
        """
        Indicates whether the private key is managed by HuaweiCloud.
        """
        return pulumi.get(self, "is_managed")

    @property
    @pulumi.getter
    def keypairs(self) -> Sequence['outputs.GetKeypairsKeypairResult']:
        """
        Indicates a list of all keypairs found. Structure is documented below.
        """
        return pulumi.get(self, "keypairs")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Indicates the name of the keypair.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[str]:
        """
        Indicates the imported OpenSSH-formatted public key.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")


class AwaitableGetKeypairsResult(GetKeypairsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKeypairsResult(
            fingerprint=self.fingerprint,
            id=self.id,
            is_managed=self.is_managed,
            keypairs=self.keypairs,
            name=self.name,
            public_key=self.public_key,
            region=self.region)


def get_keypairs(fingerprint: Optional[str] = None,
                 is_managed: Optional[bool] = None,
                 name: Optional[str] = None,
                 public_key: Optional[str] = None,
                 region: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKeypairsResult:
    """
    Use this data source to get a list of keypairs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    keypair_name = config.require_object("keypairName")
    test = huaweicloud.Dew.get_keypairs(name=keypair_name)
    ```


    :param str fingerprint: Specifies the fingerprint of the keypair.
    :param bool is_managed: Specifies whether the private key is managed by HuaweiCloud.
    :param str name: Specifies the name of the keypair.
    :param str public_key: Specifies the imported OpenSSH-formatted public key.
    :param str region: The region in which to obtain the keypairs. If omitted, the provider-level region will
           be used.
    """
    __args__ = dict()
    __args__['fingerprint'] = fingerprint
    __args__['isManaged'] = is_managed
    __args__['name'] = name
    __args__['publicKey'] = public_key
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dew/getKeypairs:getKeypairs', __args__, opts=opts, typ=GetKeypairsResult).value

    return AwaitableGetKeypairsResult(
        fingerprint=__ret__.fingerprint,
        id=__ret__.id,
        is_managed=__ret__.is_managed,
        keypairs=__ret__.keypairs,
        name=__ret__.name,
        public_key=__ret__.public_key,
        region=__ret__.region)


@_utilities.lift_output_func(get_keypairs)
def get_keypairs_output(fingerprint: Optional[pulumi.Input[Optional[str]]] = None,
                        is_managed: Optional[pulumi.Input[Optional[bool]]] = None,
                        name: Optional[pulumi.Input[Optional[str]]] = None,
                        public_key: Optional[pulumi.Input[Optional[str]]] = None,
                        region: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetKeypairsResult]:
    """
    Use this data source to get a list of keypairs.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    keypair_name = config.require_object("keypairName")
    test = huaweicloud.Dew.get_keypairs(name=keypair_name)
    ```


    :param str fingerprint: Specifies the fingerprint of the keypair.
    :param bool is_managed: Specifies whether the private key is managed by HuaweiCloud.
    :param str name: Specifies the name of the keypair.
    :param str public_key: Specifies the imported OpenSSH-formatted public key.
    :param str region: The region in which to obtain the keypairs. If omitted, the provider-level region will
           be used.
    """
    ...
