# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ThrottlingPolicyAssociateArgs', 'ThrottlingPolicyAssociate']

@pulumi.input_type
class ThrottlingPolicyAssociateArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 policy_id: pulumi.Input[str],
                 publish_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ThrottlingPolicyAssociate resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the APIG dedicated instance to which the APIs and the
               throttling policy belongs. Changing this will create a new resource.
        :param pulumi.Input[str] policy_id: Specifies the ID of the API group to which the API response belongs to.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] publish_ids: Specifies the publish ID corresponding to the API bound by the throttling policy.
        :param pulumi.Input[str] region: Specifies the region where the API instance and throttling policy are located.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "policy_id", policy_id)
        pulumi.set(__self__, "publish_ids", publish_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the APIG dedicated instance to which the APIs and the
        throttling policy belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the API group to which the API response belongs to.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="publishIds")
    def publish_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the publish ID corresponding to the API bound by the throttling policy.
        """
        return pulumi.get(self, "publish_ids")

    @publish_ids.setter
    def publish_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "publish_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the API instance and throttling policy are located.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _ThrottlingPolicyAssociateState:
    def __init__(__self__, *,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ThrottlingPolicyAssociate resources.
        :param pulumi.Input[str] instance_id: Specifies the ID of the APIG dedicated instance to which the APIs and the
               throttling policy belongs. Changing this will create a new resource.
        :param pulumi.Input[str] policy_id: Specifies the ID of the API group to which the API response belongs to.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] publish_ids: Specifies the publish ID corresponding to the API bound by the throttling policy.
        :param pulumi.Input[str] region: Specifies the region where the API instance and throttling policy are located.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if policy_id is not None:
            pulumi.set(__self__, "policy_id", policy_id)
        if publish_ids is not None:
            pulumi.set(__self__, "publish_ids", publish_ids)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the APIG dedicated instance to which the APIs and the
        throttling policy belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the API group to which the API response belongs to.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "policy_id")

    @policy_id.setter
    def policy_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_id", value)

    @property
    @pulumi.getter(name="publishIds")
    def publish_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the publish ID corresponding to the API bound by the throttling policy.
        """
        return pulumi.get(self, "publish_ids")

    @publish_ids.setter
    def publish_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "publish_ids", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region where the API instance and throttling policy are located.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


class ThrottlingPolicyAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Use this resource to bind the APIs to the throttling policy within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        policy_id = config.require_object("policyId")
        api_publish_id1 = config.require_object("apiPublishId1")
        api_publish_id2 = config.require_object("apiPublishId2")
        test = huaweicloud.dedicated_apig.ThrottlingPolicyAssociate("test",
            instance_id=instance_id,
            policy_id=policy_id,
            publish_ids=[
                api_publish_id1,
                api_publish_id2,
            ])
        ```

        ## Import

        Associate resources can be imported using their `policy_id` and the APIG dedicated instance ID to which the policy belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/throttlingPolicyAssociate:ThrottlingPolicyAssociate test &ltinstance id&gt/&ltpolicy_id&gt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the APIG dedicated instance to which the APIs and the
               throttling policy belongs. Changing this will create a new resource.
        :param pulumi.Input[str] policy_id: Specifies the ID of the API group to which the API response belongs to.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] publish_ids: Specifies the publish ID corresponding to the API bound by the throttling policy.
        :param pulumi.Input[str] region: Specifies the region where the API instance and throttling policy are located.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThrottlingPolicyAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Use this resource to bind the APIs to the throttling policy within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        policy_id = config.require_object("policyId")
        api_publish_id1 = config.require_object("apiPublishId1")
        api_publish_id2 = config.require_object("apiPublishId2")
        test = huaweicloud.dedicated_apig.ThrottlingPolicyAssociate("test",
            instance_id=instance_id,
            policy_id=policy_id,
            publish_ids=[
                api_publish_id1,
                api_publish_id2,
            ])
        ```

        ## Import

        Associate resources can be imported using their `policy_id` and the APIG dedicated instance ID to which the policy belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/throttlingPolicyAssociate:ThrottlingPolicyAssociate test &ltinstance id&gt/&ltpolicy_id&gt
        ```

        :param str resource_name: The name of the resource.
        :param ThrottlingPolicyAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThrottlingPolicyAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 policy_id: Optional[pulumi.Input[str]] = None,
                 publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThrottlingPolicyAssociateArgs.__new__(ThrottlingPolicyAssociateArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if policy_id is None and not opts.urn:
                raise TypeError("Missing required property 'policy_id'")
            __props__.__dict__["policy_id"] = policy_id
            if publish_ids is None and not opts.urn:
                raise TypeError("Missing required property 'publish_ids'")
            __props__.__dict__["publish_ids"] = publish_ids
            __props__.__dict__["region"] = region
        super(ThrottlingPolicyAssociate, __self__).__init__(
            'huaweicloud:DedicatedApig/throttlingPolicyAssociate:ThrottlingPolicyAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            policy_id: Optional[pulumi.Input[str]] = None,
            publish_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            region: Optional[pulumi.Input[str]] = None) -> 'ThrottlingPolicyAssociate':
        """
        Get an existing ThrottlingPolicyAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: Specifies the ID of the APIG dedicated instance to which the APIs and the
               throttling policy belongs. Changing this will create a new resource.
        :param pulumi.Input[str] policy_id: Specifies the ID of the API group to which the API response belongs to.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] publish_ids: Specifies the publish ID corresponding to the API bound by the throttling policy.
        :param pulumi.Input[str] region: Specifies the region where the API instance and throttling policy are located.
               If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThrottlingPolicyAssociateState.__new__(_ThrottlingPolicyAssociateState)

        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["policy_id"] = policy_id
        __props__.__dict__["publish_ids"] = publish_ids
        __props__.__dict__["region"] = region
        return ThrottlingPolicyAssociate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the APIG dedicated instance to which the APIs and the
        throttling policy belongs. Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="policyId")
    def policy_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the API group to which the API response belongs to.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "policy_id")

    @property
    @pulumi.getter(name="publishIds")
    def publish_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the publish ID corresponding to the API bound by the throttling policy.
        """
        return pulumi.get(self, "publish_ids")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region where the API instance and throttling policy are located.
        If omitted, the provider-level region will be used. Changing this will create a new resource.
        """
        return pulumi.get(self, "region")

