# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['GroupArgs', 'Group']

@pulumi.input_type
class GroupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Group resource.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API group
               belongs to. Changing this will create a new API group resource.
        :param pulumi.Input[str] description: Specifies the description about the API group. The description contain a maximum of
               255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
               format.
        :param pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]] environments: Specifies an array of one or more APIG environments of the associated APIG group. The
               object structure is documented below.
        :param pulumi.Input[str] name: Specifies the variable name, which can contains of 3 to 32 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
               case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
               an environment. The variable names are not allowed to be repeated for an API group.
        :param pulumi.Input[str] region: Specifies the region in which to create the API group resource. If omitted,
               the provider-level region will be used. Changing this will create a new API group resource.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the API group
        belongs to. Changing this will create a new API group resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description about the API group. The description contain a maximum of
        255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
        format.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]:
        """
        Specifies an array of one or more APIG environments of the associated APIG group. The
        object structure is documented below.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the variable name, which can contains of 3 to 32 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
        case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
        an environment. The variable names are not allowed to be repeated for an API group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the API group resource. If omitted,
        the provider-level region will be used. Changing this will create a new API group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _GroupState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 registraion_time: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Group resources.
        :param pulumi.Input[str] description: Specifies the description about the API group. The description contain a maximum of
               255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
               format.
        :param pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]] environments: Specifies an array of one or more APIG environments of the associated APIG group. The
               object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API group
               belongs to. Changing this will create a new API group resource.
        :param pulumi.Input[str] name: Specifies the variable name, which can contains of 3 to 32 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
               case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
               an environment. The variable names are not allowed to be repeated for an API group.
        :param pulumi.Input[str] region: Specifies the region in which to create the API group resource. If omitted,
               the provider-level region will be used. Changing this will create a new API group resource.
        :param pulumi.Input[str] registraion_time: Registration time, in RFC-3339 format.
        :param pulumi.Input[str] update_time: Time when the API group was last modified, in RFC-3339 format.
               * `environment/variable/variable_id` - ID of the environment variable.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if environments is not None:
            pulumi.set(__self__, "environments", environments)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if registraion_time is not None:
            pulumi.set(__self__, "registraion_time", registraion_time)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description about the API group. The description contain a maximum of
        255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
        format.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def environments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]:
        """
        Specifies an array of one or more APIG environments of the associated APIG group. The
        object structure is documented below.
        """
        return pulumi.get(self, "environments")

    @environments.setter
    def environments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['GroupEnvironmentArgs']]]]):
        pulumi.set(self, "environments", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies an ID of the APIG dedicated instance to which the API group
        belongs to. Changing this will create a new API group resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the variable name, which can contains of 3 to 32 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
        case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
        an environment. The variable names are not allowed to be repeated for an API group.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the API group resource. If omitted,
        the provider-level region will be used. Changing this will create a new API group resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="registraionTime")
    def registraion_time(self) -> Optional[pulumi.Input[str]]:
        """
        Registration time, in RFC-3339 format.
        """
        return pulumi.get(self, "registraion_time")

    @registraion_time.setter
    def registraion_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "registraion_time", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the API group was last modified, in RFC-3339 format.
        * `environment/variable/variable_id` - ID of the environment variable.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Group(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupEnvironmentArgs']]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an APIG (API) group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        group_name = config.require_object("groupName")
        description = config.require_object("description")
        environment_id = config.require_object("environmentId")
        test = huaweicloud.dedicated_apig.Group("test",
            instance_id=instance_id,
            description=description,
            environments=[huaweicloud.dedicated_apig.GroupEnvironmentArgs(
                variables=[huaweicloud.dedicated_apig.GroupEnvironmentVariableArgs(
                    name="TERRAFORM",
                    value="/stage/terraform",
                )],
                environment_id=environment_id,
            )])
        ```

        ## Import

        API groups of the APIG can be imported using their `id` and the ID of the APIG instance to which the group belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/group:Group test <instance id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description about the API group. The description contain a maximum of
               255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
               format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupEnvironmentArgs']]]] environments: Specifies an array of one or more APIG environments of the associated APIG group. The
               object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API group
               belongs to. Changing this will create a new API group resource.
        :param pulumi.Input[str] name: Specifies the variable name, which can contains of 3 to 32 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
               case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
               an environment. The variable names are not allowed to be repeated for an API group.
        :param pulumi.Input[str] region: Specifies the region in which to create the API group resource. If omitted,
               the provider-level region will be used. Changing this will create a new API group resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: GroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an APIG (API) group resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        instance_id = config.require_object("instanceId")
        group_name = config.require_object("groupName")
        description = config.require_object("description")
        environment_id = config.require_object("environmentId")
        test = huaweicloud.dedicated_apig.Group("test",
            instance_id=instance_id,
            description=description,
            environments=[huaweicloud.dedicated_apig.GroupEnvironmentArgs(
                variables=[huaweicloud.dedicated_apig.GroupEnvironmentVariableArgs(
                    name="TERRAFORM",
                    value="/stage/terraform",
                )],
                environment_id=environment_id,
            )])
        ```

        ## Import

        API groups of the APIG can be imported using their `id` and the ID of the APIG instance to which the group belongs, separated by a slash, e.g.

        ```sh
         $ pulumi import huaweicloud:DedicatedApig/group:Group test <instance id>/<id>
        ```

        :param str resource_name: The name of the resource.
        :param GroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(GroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupEnvironmentArgs']]]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = GroupArgs.__new__(GroupArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["environments"] = environments
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["name"] = name
            __props__.__dict__["region"] = region
            __props__.__dict__["registraion_time"] = None
            __props__.__dict__["update_time"] = None
        super(Group, __self__).__init__(
            'huaweicloud:DedicatedApig/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            environments: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupEnvironmentArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            registraion_time: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Group':
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Specifies the description about the API group. The description contain a maximum of
               255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
               format.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['GroupEnvironmentArgs']]]] environments: Specifies an array of one or more APIG environments of the associated APIG group. The
               object structure is documented below.
        :param pulumi.Input[str] instance_id: Specifies an ID of the APIG dedicated instance to which the API group
               belongs to. Changing this will create a new API group resource.
        :param pulumi.Input[str] name: Specifies the variable name, which can contains of 3 to 32 characters, starting with a
               letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
               case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
               an environment. The variable names are not allowed to be repeated for an API group.
        :param pulumi.Input[str] region: Specifies the region in which to create the API group resource. If omitted,
               the provider-level region will be used. Changing this will create a new API group resource.
        :param pulumi.Input[str] registraion_time: Registration time, in RFC-3339 format.
        :param pulumi.Input[str] update_time: Time when the API group was last modified, in RFC-3339 format.
               * `environment/variable/variable_id` - ID of the environment variable.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _GroupState.__new__(_GroupState)

        __props__.__dict__["description"] = description
        __props__.__dict__["environments"] = environments
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["name"] = name
        __props__.__dict__["region"] = region
        __props__.__dict__["registraion_time"] = registraion_time
        __props__.__dict__["update_time"] = update_time
        return Group(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description about the API group. The description contain a maximum of
        255 characters and the angle brackets (< and >) are not allowed. Chinese characters must be in UTF-8 or Unicode
        format.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Optional[Sequence['outputs.GroupEnvironment']]]:
        """
        Specifies an array of one or more APIG environments of the associated APIG group. The
        object structure is documented below.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Specifies an ID of the APIG dedicated instance to which the API group
        belongs to. Changing this will create a new API group resource.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the variable name, which can contains of 3 to 32 characters, starting with a
        letter. Only letters, digits, hyphens (-), and underscores (_) are allowed. In the definition of an API, `name` (
        case-sensitive) indicates a variable, such as #Name#. It is replaced by the actual value when the API is published in
        an environment. The variable names are not allowed to be repeated for an API group.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the API group resource. If omitted,
        the provider-level region will be used. Changing this will create a new API group resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="registraionTime")
    def registraion_time(self) -> pulumi.Output[str]:
        """
        Registration time, in RFC-3339 format.
        """
        return pulumi.get(self, "registraion_time")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time when the API group was last modified, in RFC-3339 format.
        * `environment/variable/variable_id` - ID of the environment variable.
        """
        return pulumi.get(self, "update_time")

