# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 availability_zone: pulumi.Input[str],
                 datastore: pulumi.Input['InstanceDatastoreArgs'],
                 flavors: pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]],
                 mode: pulumi.Input[str],
                 password: pulumi.Input[str],
                 security_group_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 disk_encryption_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input['InstanceDatastoreArgs'] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] mode: Specifies the mode of the database instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Specifies the database access port. The valid values are range from `2,100` to `9,500` and
               `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        :param pulumi.Input[str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DDS instance.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "datastore", datastore)
        pulumi.set(__self__, "flavors", flavors)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "security_group_id", security_group_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Input[str]:
        """
        Specifies the ID of the availability zone. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Input['InstanceDatastoreArgs']:
        """
        Specifies database information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: pulumi.Input['InstanceDatastoreArgs']):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter
    def flavors(self) -> pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]:
        """
        Specifies the flavors information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavors")

    @flavors.setter
    def flavors(self, value: pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]):
        pulumi.set(self, "flavors", value)

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Input[str]:
        """
        Specifies the mode of the database instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        Specifies the Administrator password of the database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Input[str]:
        """
        Specifies the security group ID of the DDS instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Specifies the subnet Network ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. The structure is described below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk encryption ID of the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the dds instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the database access port. The valid values are range from `2,100` to `9,500` and
        `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region of the DDS instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to true.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DDS instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['InstanceBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input['InstanceDatastoreArgs']] = None,
                 db_username: Optional[pulumi.Input[str]] = None,
                 disk_encryption_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavors: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input['InstanceBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input['InstanceDatastoreArgs'] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] db_username: Indicates the DB Administator name.
        :param pulumi.Input[str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] mode: Specifies the mode of the database instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Specifies the database access port. The valid values are range from `2,100` to `9,500` and
               `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        :param pulumi.Input[str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DDS instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        if auto_pay is not None:
            pulumi.set(__self__, "auto_pay", auto_pay)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if datastore is not None:
            pulumi.set(__self__, "datastore", datastore)
        if db_username is not None:
            pulumi.set(__self__, "db_username", db_username)
        if disk_encryption_id is not None:
            pulumi.set(__self__, "disk_encryption_id", disk_encryption_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if flavors is not None:
            pulumi.set(__self__, "flavors", flavors)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if ssl is not None:
            pulumi.set(__self__, "ssl", ssl)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "auto_pay")

    @auto_pay.setter
    def auto_pay(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_pay", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of the availability zone. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['InstanceBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. The structure is described below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['InstanceBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter
    def datastore(self) -> Optional[pulumi.Input['InstanceDatastoreArgs']]:
        """
        Specifies database information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @datastore.setter
    def datastore(self, value: Optional[pulumi.Input['InstanceDatastoreArgs']]):
        pulumi.set(self, "datastore", value)

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the DB Administator name.
        """
        return pulumi.get(self, "db_username")

    @db_username.setter
    def db_username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_username", value)

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the disk encryption ID of the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "disk_encryption_id")

    @disk_encryption_id.setter
    def disk_encryption_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_encryption_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the dds instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter
    def flavors(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]]:
        """
        Specifies the flavors information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavors")

    @flavors.setter
    def flavors(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceFlavorArgs']]]]):
        pulumi.set(self, "flavors", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the mode of the database instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Administrator password of the database instance.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the database access port. The valid values are range from `2,100` to `9,500` and
        `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region of the DDS instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the security group ID of the DDS instance.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter
    def ssl(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to true.
        """
        return pulumi.get(self, "ssl")

    @ssl.setter
    def ssl(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ssl", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the subnet Network ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the DDS instance.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']]] = None,
                 disk_encryption_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFlavorArgs']]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages dds instance resource within HuaweiCloud.

        ## Example Usage
        ### Creating A Cluster Community Edition

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance = huaweicloud.dds.Instance("instance",
            availability_zone="{{ availability_zone }}",
            backup_strategy=huaweicloud.dds.InstanceBackupStrategyArgs(
                keep_days=8,
                start_time="08:00-09:00",
            ),
            datastore=huaweicloud.dds.InstanceDatastoreArgs(
                storage_engine="wiredTiger",
                type="DDS-Community",
                version="3.4",
            ),
            flavors=[
                huaweicloud.dds.InstanceFlavorArgs(
                    num=2,
                    spec_code="dds.mongodb.c3.medium.4.mongos",
                    type="mongos",
                ),
                huaweicloud.dds.InstanceFlavorArgs(
                    num=2,
                    size=20,
                    spec_code="dds.mongodb.c3.medium.4.shard",
                    storage="ULTRAHIGH",
                    type="shard",
                ),
                huaweicloud.dds.InstanceFlavorArgs(
                    num=1,
                    size=20,
                    spec_code="dds.mongodb.c3.large.2.config",
                    storage="ULTRAHIGH",
                    type="config",
                ),
            ],
            mode="Sharding",
            password="Test@123",
            security_group_id="{{ security_group_id }}",
            subnet_id="{{ subnet_network_id }}}",
            vpc_id="{{ vpc_id }}")
        ```
        ### Creating A Replica Set

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance = huaweicloud.dds.Instance("instance",
            availability_zone="{{ availability_zone }}",
            datastore=huaweicloud.dds.InstanceDatastoreArgs(
                storage_engine="wiredTiger",
                type="DDS-Community",
                version="3.4",
            ),
            flavors=[huaweicloud.dds.InstanceFlavorArgs(
                num=1,
                size=30,
                spec_code="dds.mongodb.c3.medium.4.repset",
                storage="ULTRAHIGH",
                type="replica",
            )],
            mode="ReplicaSet",
            password="Test@123",
            security_group_id="{{ security_group_id }}",
            subnet_id="{{ subnet_network_id }}}",
            vpc_id="{{ vpc_id }}")
        ```

        ## Import

        DDS instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Dds/instance:Instance instance 9c6d6ff2cba3434293fd479571517e16in02
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `availability_zone`, `flavor`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dds_instance" "instance" {

         ...

         lifecycle {

         ignore_changes = [

         password, availability_zone, flavor,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFlavorArgs']]]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] mode: Specifies the mode of the database instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Specifies the database access port. The valid values are range from `2,100` to `9,500` and
               `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        :param pulumi.Input[str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
        :param pulumi.Input[str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DDS instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages dds instance resource within HuaweiCloud.

        ## Example Usage
        ### Creating A Cluster Community Edition

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance = huaweicloud.dds.Instance("instance",
            availability_zone="{{ availability_zone }}",
            backup_strategy=huaweicloud.dds.InstanceBackupStrategyArgs(
                keep_days=8,
                start_time="08:00-09:00",
            ),
            datastore=huaweicloud.dds.InstanceDatastoreArgs(
                storage_engine="wiredTiger",
                type="DDS-Community",
                version="3.4",
            ),
            flavors=[
                huaweicloud.dds.InstanceFlavorArgs(
                    num=2,
                    spec_code="dds.mongodb.c3.medium.4.mongos",
                    type="mongos",
                ),
                huaweicloud.dds.InstanceFlavorArgs(
                    num=2,
                    size=20,
                    spec_code="dds.mongodb.c3.medium.4.shard",
                    storage="ULTRAHIGH",
                    type="shard",
                ),
                huaweicloud.dds.InstanceFlavorArgs(
                    num=1,
                    size=20,
                    spec_code="dds.mongodb.c3.large.2.config",
                    storage="ULTRAHIGH",
                    type="config",
                ),
            ],
            mode="Sharding",
            password="Test@123",
            security_group_id="{{ security_group_id }}",
            subnet_id="{{ subnet_network_id }}}",
            vpc_id="{{ vpc_id }}")
        ```
        ### Creating A Replica Set

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        instance = huaweicloud.dds.Instance("instance",
            availability_zone="{{ availability_zone }}",
            datastore=huaweicloud.dds.InstanceDatastoreArgs(
                storage_engine="wiredTiger",
                type="DDS-Community",
                version="3.4",
            ),
            flavors=[huaweicloud.dds.InstanceFlavorArgs(
                num=1,
                size=30,
                spec_code="dds.mongodb.c3.medium.4.repset",
                storage="ULTRAHIGH",
                type="replica",
            )],
            mode="ReplicaSet",
            password="Test@123",
            security_group_id="{{ security_group_id }}",
            subnet_id="{{ subnet_network_id }}}",
            vpc_id="{{ vpc_id }}")
        ```

        ## Import

        DDS instance can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Dds/instance:Instance instance 9c6d6ff2cba3434293fd479571517e16in02
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes include`password`, `availability_zone`, `flavor`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_dds_instance" "instance" {

         ...

         lifecycle {

         ignore_changes = [

         password, availability_zone, flavor,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_pay: Optional[pulumi.Input[str]] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 datastore: Optional[pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']]] = None,
                 disk_encryption_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 flavors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFlavorArgs']]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 ssl: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["auto_pay"] = auto_pay
            __props__.__dict__["auto_renew"] = auto_renew
            if availability_zone is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zone'")
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            if datastore is None and not opts.urn:
                raise TypeError("Missing required property 'datastore'")
            __props__.__dict__["datastore"] = datastore
            __props__.__dict__["disk_encryption_id"] = disk_encryption_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if flavors is None and not opts.urn:
                raise TypeError("Missing required property 'flavors'")
            __props__.__dict__["flavors"] = flavors
            if mode is None and not opts.urn:
                raise TypeError("Missing required property 'mode'")
            __props__.__dict__["mode"] = mode
            __props__.__dict__["name"] = name
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["port"] = port
            __props__.__dict__["region"] = region
            if security_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'security_group_id'")
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["ssl"] = ssl
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["db_username"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
        super(Instance, __self__).__init__(
            'huaweicloud:Dds/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_pay: Optional[pulumi.Input[str]] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_strategy: Optional[pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            datastore: Optional[pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']]] = None,
            db_username: Optional[pulumi.Input[str]] = None,
            disk_encryption_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            flavors: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFlavorArgs']]]]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            ssl: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this creates a new instance.
        :param pulumi.Input[str] availability_zone: Specifies the ID of the availability zone. Changing this creates a
               new instance.
        :param pulumi.Input[pulumi.InputType['InstanceBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. The structure is described below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the instance.
               The valid values are as follows:
               + `prePaid`: indicates the yearly/monthly billing mode.
               + `postPaid`: indicates the pay-per-use billing mode.
        :param pulumi.Input[pulumi.InputType['InstanceDatastoreArgs']] datastore: Specifies database information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] db_username: Indicates the DB Administator name.
        :param pulumi.Input[str] disk_encryption_id: Specifies the disk encryption ID of the instance. Changing this
               creates a new instance.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the dds instance.
               Changing this creates a new instance.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceFlavorArgs']]]] flavors: Specifies the flavors information. The structure is described below. Changing
               this creates a new instance.
        :param pulumi.Input[str] mode: Specifies the mode of the database instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] name: Specifies the DB instance name. The DB instance name of the same type is unique in the
               same tenant.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]] nodes: Indicates the instance nodes information. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the Administrator password of the database instance.
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
               Changing this creates a new instance.
        :param pulumi.Input[int] port: Specifies the database access port. The valid values are range from `2,100` to `9,500` and
               `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        :param pulumi.Input[str] region: Specifies the region of the DDS instance. Changing this creates a new
               instance.
        :param pulumi.Input[str] security_group_id: Specifies the security group ID of the DDS instance.
        :param pulumi.Input[bool] ssl: Specifies whether to enable or disable SSL. Defaults to true.
        :param pulumi.Input[str] status: Indicates the node status.
        :param pulumi.Input[str] subnet_id: Specifies the subnet Network ID. Changing this creates a new instance.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the DDS instance.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this creates a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["auto_pay"] = auto_pay
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["datastore"] = datastore
        __props__.__dict__["db_username"] = db_username
        __props__.__dict__["disk_encryption_id"] = disk_encryption_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["flavors"] = flavors
        __props__.__dict__["mode"] = mode
        __props__.__dict__["name"] = name
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["port"] = port
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["ssl"] = ssl
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoPay")
    def auto_pay(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "auto_pay")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the ID of the availability zone. Changing this creates a
        new instance.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output['outputs.InstanceBackupStrategy']:
        """
        Specifies the advanced backup policy. The structure is described below.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the instance.
        The valid values are as follows:
        + `prePaid`: indicates the yearly/monthly billing mode.
        + `postPaid`: indicates the pay-per-use billing mode.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter
    def datastore(self) -> pulumi.Output['outputs.InstanceDatastore']:
        """
        Specifies database information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "datastore")

    @property
    @pulumi.getter(name="dbUsername")
    def db_username(self) -> pulumi.Output[str]:
        """
        Indicates the DB Administator name.
        """
        return pulumi.get(self, "db_username")

    @property
    @pulumi.getter(name="diskEncryptionId")
    def disk_encryption_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the disk encryption ID of the instance. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "disk_encryption_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the dds instance.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def flavors(self) -> pulumi.Output[Sequence['outputs.InstanceFlavor']]:
        """
        Specifies the flavors information. The structure is described below. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        Specifies the mode of the database instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the DB instance name. The DB instance name of the same type is unique in the
        same tenant.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Indicates the instance nodes information. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        Specifies the Administrator password of the database instance.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*. This parameter is mandatory if `charging_mode` is set to *prePaid*.
        Changing this creates a new instance.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[int]:
        """
        Specifies the database access port. The valid values are range from `2,100` to `9,500` and
        `27,017`, `27,018`, `27,019`. Defaults to `8,635`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region of the DDS instance. Changing this creates a new
        instance.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies the security group ID of the DDS instance.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter
    def ssl(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable or disable SSL. Defaults to true.
        """
        return pulumi.get(self, "ssl")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the node status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the subnet Network ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the DDS instance.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this creates a new instance.
        """
        return pulumi.get(self, "vpc_id")

