# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InstanceBackupPolicy',
    'InstanceWhitelist',
    'GetFlavorsFlavorResult',
]

@pulumi.output_type
class InstanceBackupPolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupAts":
            suggest = "backup_ats"
        elif key == "beginAt":
            suggest = "begin_at"
        elif key == "backupType":
            suggest = "backup_type"
        elif key == "periodType":
            suggest = "period_type"
        elif key == "saveDays":
            suggest = "save_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceBackupPolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceBackupPolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceBackupPolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_ats: Sequence[int],
                 begin_at: str,
                 backup_type: Optional[str] = None,
                 period_type: Optional[str] = None,
                 save_days: Optional[int] = None):
        """
        :param Sequence[int] backup_ats: Day in a week on which backup starts, the value ranges from 1 to 7.
               Where: 1 indicates Monday; 7 indicates Sunday.
        :param str begin_at: Time at which backup starts.
               Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        :param str backup_type: Backup type. Default value is `auto`. The valid values are as follows:
               + `auto`: automatic backup.
               + `manual`: manual backup.
        :param str period_type: Interval at which backup is performed. Default value is `weekly`.
               Currently, only weekly backup is supported.
        :param int save_days: Retention time. Unit: day, the value ranges from 1 to 7.
        """
        pulumi.set(__self__, "backup_ats", backup_ats)
        pulumi.set(__self__, "begin_at", begin_at)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if period_type is not None:
            pulumi.set(__self__, "period_type", period_type)
        if save_days is not None:
            pulumi.set(__self__, "save_days", save_days)

    @property
    @pulumi.getter(name="backupAts")
    def backup_ats(self) -> Sequence[int]:
        """
        Day in a week on which backup starts, the value ranges from 1 to 7.
        Where: 1 indicates Monday; 7 indicates Sunday.
        """
        return pulumi.get(self, "backup_ats")

    @property
    @pulumi.getter(name="beginAt")
    def begin_at(self) -> str:
        """
        Time at which backup starts.
        Format: `hh24:00-hh24:00`, "00:00-01:00" indicates that backup starts at 00:00:00.
        """
        return pulumi.get(self, "begin_at")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[str]:
        """
        Backup type. Default value is `auto`. The valid values are as follows:
        + `auto`: automatic backup.
        + `manual`: manual backup.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="periodType")
    def period_type(self) -> Optional[str]:
        """
        Interval at which backup is performed. Default value is `weekly`.
        Currently, only weekly backup is supported.
        """
        return pulumi.get(self, "period_type")

    @property
    @pulumi.getter(name="saveDays")
    def save_days(self) -> Optional[int]:
        """
        Retention time. Unit: day, the value ranges from 1 to 7.
        """
        return pulumi.get(self, "save_days")


@pulumi.output_type
class InstanceWhitelist(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "ipAddresses":
            suggest = "ip_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceWhitelist. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceWhitelist.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceWhitelist.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: str,
                 ip_addresses: Sequence[str]):
        """
        :param str group_name: Specifies the name of IP address group.
        :param Sequence[str] ip_addresses: Specifies the list of IP address or CIDR which can be whitelisted for an instance.
               The maximum is 20.
        """
        pulumi.set(__self__, "group_name", group_name)
        pulumi.set(__self__, "ip_addresses", ip_addresses)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> str:
        """
        Specifies the name of IP address group.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="ipAddresses")
    def ip_addresses(self) -> Sequence[str]:
        """
        Specifies the list of IP address or CIDR which can be whitelisted for an instance.
        The maximum is 20.
        """
        return pulumi.get(self, "ip_addresses")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 available_zones: Sequence[str],
                 cache_mode: str,
                 capacity: float,
                 charging_modes: Sequence[str],
                 cpu_architecture: str,
                 engine: str,
                 engine_versions: str,
                 ip_count: int,
                 name: str):
        """
        :param Sequence[str] available_zones: An array of available zones where the cache specification can be used.
        :param str cache_mode: The mode of a cache engine. The valid values are as follows:
        :param float capacity: The total memory of the cache, in GB.
               + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values:
               `0.125`, `0.25`, `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
               Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
               `1024`.
               + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
               Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
               + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        :param Sequence[str] charging_modes: The charging modes for the specification cache instance.
        :param str cpu_architecture: The CPU architecture of cache instance.
               Valid values *x86_64* and *aarch64*.
        :param str engine: The engine of the cache instance. Valid values are *Redis* and *Memcached*.
               Default value is *Redis*.
        :param str engine_versions: Supported versions of the specification.
        :param int ip_count: Number of IP addresses corresponding to the specifications.
        :param str name: The flavor name of the cache instance.
        """
        pulumi.set(__self__, "available_zones", available_zones)
        pulumi.set(__self__, "cache_mode", cache_mode)
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "charging_modes", charging_modes)
        pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        pulumi.set(__self__, "engine", engine)
        pulumi.set(__self__, "engine_versions", engine_versions)
        pulumi.set(__self__, "ip_count", ip_count)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="availableZones")
    def available_zones(self) -> Sequence[str]:
        """
        An array of available zones where the cache specification can be used.
        """
        return pulumi.get(self, "available_zones")

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> str:
        """
        The mode of a cache engine. The valid values are as follows:
        """
        return pulumi.get(self, "cache_mode")

    @property
    @pulumi.getter
    def capacity(self) -> float:
        """
        The total memory of the cache, in GB.
        + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values:
        `0.125`, `0.25`, `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
        Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
        `1024`.
        + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
        + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="chargingModes")
    def charging_modes(self) -> Sequence[str]:
        """
        The charging modes for the specification cache instance.
        """
        return pulumi.get(self, "charging_modes")

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> str:
        """
        The CPU architecture of cache instance.
        Valid values *x86_64* and *aarch64*.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter
    def engine(self) -> str:
        """
        The engine of the cache instance. Valid values are *Redis* and *Memcached*.
        Default value is *Redis*.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersions")
    def engine_versions(self) -> str:
        """
        Supported versions of the specification.
        """
        return pulumi.get(self, "engine_versions")

    @property
    @pulumi.getter(name="ipCount")
    def ip_count(self) -> int:
        """
        Number of IP addresses corresponding to the specifications.
        """
        return pulumi.get(self, "ip_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The flavor name of the cache instance.
        """
        return pulumi.get(self, "name")


