# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetFlavorsResult',
    'AwaitableGetFlavorsResult',
    'get_flavors',
    'get_flavors_output',
]

@pulumi.output_type
class GetFlavorsResult:
    """
    A collection of values returned by getFlavors.
    """
    def __init__(__self__, cache_mode=None, capacity=None, cpu_architecture=None, engine=None, engine_version=None, flavors=None, id=None, name=None, region=None):
        if cache_mode and not isinstance(cache_mode, str):
            raise TypeError("Expected argument 'cache_mode' to be a str")
        pulumi.set(__self__, "cache_mode", cache_mode)
        if capacity and not isinstance(capacity, float):
            raise TypeError("Expected argument 'capacity' to be a float")
        pulumi.set(__self__, "capacity", capacity)
        if cpu_architecture and not isinstance(cpu_architecture, str):
            raise TypeError("Expected argument 'cpu_architecture' to be a str")
        pulumi.set(__self__, "cpu_architecture", cpu_architecture)
        if engine and not isinstance(engine, str):
            raise TypeError("Expected argument 'engine' to be a str")
        pulumi.set(__self__, "engine", engine)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if flavors and not isinstance(flavors, list):
            raise TypeError("Expected argument 'flavors' to be a list")
        pulumi.set(__self__, "flavors", flavors)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="cacheMode")
    def cache_mode(self) -> Optional[str]:
        """
        The mode of a cache instance.
        """
        return pulumi.get(self, "cache_mode")

    @property
    @pulumi.getter
    def capacity(self) -> float:
        """
        The total memory of the cache, in GB.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="cpuArchitecture")
    def cpu_architecture(self) -> Optional[str]:
        """
        The CPU architecture of cache instance. Value is *x86_64* or *aarch64*.
        """
        return pulumi.get(self, "cpu_architecture")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The engine of the cache instance. Value is *redis* or *memcached*.
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[str]:
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def flavors(self) -> Sequence['outputs.GetFlavorsFlavorResult']:
        """
        A list of DCS flavors.
        """
        return pulumi.get(self, "flavors")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The flavor name of the cache instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")


class AwaitableGetFlavorsResult(GetFlavorsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFlavorsResult(
            cache_mode=self.cache_mode,
            capacity=self.capacity,
            cpu_architecture=self.cpu_architecture,
            engine=self.engine,
            engine_version=self.engine_version,
            flavors=self.flavors,
            id=self.id,
            name=self.name,
            region=self.region)


def get_flavors(cache_mode: Optional[str] = None,
                capacity: Optional[float] = None,
                cpu_architecture: Optional[str] = None,
                engine: Optional[str] = None,
                engine_version: Optional[str] = None,
                name: Optional[str] = None,
                region: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFlavorsResult:
    """
    Use this data source to get a list of available DCS flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.Dcs.get_flavors(capacity=4)
    ```


    :param str cache_mode: The mode of a cache engine. The valid values are as follows:
    :param float capacity: The total memory of the cache, in GB.
           + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values:
           `0.125`, `0.25`, `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
           Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
           `1024`.
           + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
           Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
           + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
    :param str cpu_architecture: The CPU architecture of cache instance.
           Valid values *x86_64* and *aarch64*.
    :param str engine: The engine of the cache instance. Valid values are *Redis* and *Memcached*.
           Default value is *Redis*.
    :param str engine_version: The version of a cache engine.
           It is mandatory when the engine is *Redis*, the value can be `3.0`, `4.0`, or `5.0`.
    :param str name: The flavor name of the cache instance.
    :param str region: Specifies the region in which to obtain the DCS flavors.
           If omitted, the provider-level region will be used.
    """
    __args__ = dict()
    __args__['cacheMode'] = cache_mode
    __args__['capacity'] = capacity
    __args__['cpuArchitecture'] = cpu_architecture
    __args__['engine'] = engine
    __args__['engineVersion'] = engine_version
    __args__['name'] = name
    __args__['region'] = region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Dcs/getFlavors:getFlavors', __args__, opts=opts, typ=GetFlavorsResult).value

    return AwaitableGetFlavorsResult(
        cache_mode=__ret__.cache_mode,
        capacity=__ret__.capacity,
        cpu_architecture=__ret__.cpu_architecture,
        engine=__ret__.engine,
        engine_version=__ret__.engine_version,
        flavors=__ret__.flavors,
        id=__ret__.id,
        name=__ret__.name,
        region=__ret__.region)


@_utilities.lift_output_func(get_flavors)
def get_flavors_output(cache_mode: Optional[pulumi.Input[Optional[str]]] = None,
                       capacity: Optional[pulumi.Input[float]] = None,
                       cpu_architecture: Optional[pulumi.Input[Optional[str]]] = None,
                       engine: Optional[pulumi.Input[Optional[str]]] = None,
                       engine_version: Optional[pulumi.Input[Optional[str]]] = None,
                       name: Optional[pulumi.Input[Optional[str]]] = None,
                       region: Optional[pulumi.Input[Optional[str]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFlavorsResult]:
    """
    Use this data source to get a list of available DCS flavors.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    flavors = huaweicloud.Dcs.get_flavors(capacity=4)
    ```


    :param str cache_mode: The mode of a cache engine. The valid values are as follows:
    :param float capacity: The total memory of the cache, in GB.
           + **Redis4.0 and Redis5.0**: Stand-alone and active/standby type instance values:
           `0.125`, `0.25`, `0.5`, `1`, `2`, `4`, `8`, `16`, `32` and `64`.
           Cluster instance specifications support `24`, `32`, `48`, `64`, `96`, `128`, `192`, `256`, `384`, `512`, `768` and
           `1024`.
           + **Redis3.0**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
           Proxy cluster instance specifications support `64`, `128`, `256`, `512`, and `1024`.
           + **Memcached**: Stand-alone and active/standby type instance values: `2`, `4`, `8`, `16`, `32` and `64`.
    :param str cpu_architecture: The CPU architecture of cache instance.
           Valid values *x86_64* and *aarch64*.
    :param str engine: The engine of the cache instance. Valid values are *Redis* and *Memcached*.
           Default value is *Redis*.
    :param str engine_version: The version of a cache engine.
           It is mandatory when the engine is *Redis*, the value can be `3.0`, `4.0`, or `5.0`.
    :param str name: The flavor name of the cache instance.
    :param str region: Specifies the region in which to obtain the DCS flavors.
           If omitted, the provider-level region will be used.
    """
    ...
