# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NotificationArgs', 'Notification']

@pulumi.input_type
class NotificationArgs:
    def __init__(__self__, *,
                 operation_type: pulumi.Input[str],
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Notification resource.
        :param pulumi.Input[str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[bool] enabled: Specifies whether notification is enabled, defaults to true.
        :param pulumi.Input[str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] smn_topic: Specifies the URN of a topic.
        """
        pulumi.set(__self__, "operation_type", operation_type)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if operation_users is not None:
            pulumi.set(__self__, "operation_users", operation_users)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> pulumi.Input[str]:
        """
        Specifies the operation type, possible options include **complete** and
        **customized**.
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether notification is enabled, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the notification name. The value contains a maximum of 64 characters,
        and only letters, digits, underscores(_), and Chinese characters are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="operationUsers")
    def operation_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]:
        """
        Specifies an array of users. Notifications will be sent when specified users
        perform specified operations. All users are selected by default.
        The object structure is documented below.
        """
        return pulumi.get(self, "operation_users")

    @operation_users.setter
    def operation_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]):
        pulumi.set(self, "operation_users", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]:
        """
        Specifies an array of operations that will trigger notifications.
        For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
        The object structure is documented below.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to manage the CTS notification resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the URN of a topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smn_topic", value)


@pulumi.input_type
class _NotificationState:
    def __init__(__self__, *,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 notification_id: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Notification resources.
        :param pulumi.Input[bool] enabled: Specifies whether notification is enabled, defaults to true.
        :param pulumi.Input[str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[str] notification_id: The notification ID in UUID format.
        :param pulumi.Input[str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] smn_topic: Specifies the URN of a topic.
        :param pulumi.Input[str] status: The notification status, the value can be **enabled** or **disabled**.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notification_id is not None:
            pulumi.set(__self__, "notification_id", notification_id)
        if operation_type is not None:
            pulumi.set(__self__, "operation_type", operation_type)
        if operation_users is not None:
            pulumi.set(__self__, "operation_users", operation_users)
        if operations is not None:
            pulumi.set(__self__, "operations", operations)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if smn_topic is not None:
            pulumi.set(__self__, "smn_topic", smn_topic)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether notification is enabled, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enabled", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the notification name. The value contains a maximum of 64 characters,
        and only letters, digits, underscores(_), and Chinese characters are allowed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="notificationId")
    def notification_id(self) -> Optional[pulumi.Input[str]]:
        """
        The notification ID in UUID format.
        """
        return pulumi.get(self, "notification_id")

    @notification_id.setter
    def notification_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "notification_id", value)

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation type, possible options include **complete** and
        **customized**.
        """
        return pulumi.get(self, "operation_type")

    @operation_type.setter
    def operation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation_type", value)

    @property
    @pulumi.getter(name="operationUsers")
    def operation_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]:
        """
        Specifies an array of users. Notifications will be sent when specified users
        perform specified operations. All users are selected by default.
        The object structure is documented below.
        """
        return pulumi.get(self, "operation_users")

    @operation_users.setter
    def operation_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationUserArgs']]]]):
        pulumi.set(self, "operation_users", value)

    @property
    @pulumi.getter
    def operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]:
        """
        Specifies an array of operations that will trigger notifications.
        For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
        The object structure is documented below.
        """
        return pulumi.get(self, "operations")

    @operations.setter
    def operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NotificationOperationArgs']]]]):
        pulumi.set(self, "operations", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to manage the CTS notification resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the URN of a topic.
        """
        return pulumi.get(self, "smn_topic")

    @smn_topic.setter
    def smn_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "smn_topic", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The notification status, the value can be **enabled** or **disabled**.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Notification(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationUserArgs']]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages CTS key event notification resource within HuaweiCloud.

        ## Example Usage
        ### Complete Notification

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = huaweicloud.cts.Notification("notify",
            operation_type="complete",
            smn_topic=topic_urn)
        ```
        ### Customized Notification

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = huaweicloud.cts.Notification("notify",
            operation_type="customized",
            smn_topic=topic_urn,
            operations=[huaweicloud.cts.NotificationOperationArgs(
                service="ECS",
                resource="ecs",
                trace_names=[
                    "createServer",
                    "deleteServer",
                ],
            )])
        ```

        ## Import

        CTS notifications can be imported using `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cts/notification:Notification tracker your_notification
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Specifies whether notification is enabled, defaults to true.
        :param pulumi.Input[str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationUserArgs']]]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationArgs']]]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] smn_topic: Specifies the URN of a topic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NotificationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CTS key event notification resource within HuaweiCloud.

        ## Example Usage
        ### Complete Notification

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = huaweicloud.cts.Notification("notify",
            operation_type="complete",
            smn_topic=topic_urn)
        ```
        ### Customized Notification

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        topic_urn = config.require_object("topicUrn")
        notify = huaweicloud.cts.Notification("notify",
            operation_type="customized",
            smn_topic=topic_urn,
            operations=[huaweicloud.cts.NotificationOperationArgs(
                service="ECS",
                resource="ecs",
                trace_names=[
                    "createServer",
                    "deleteServer",
                ],
            )])
        ```

        ## Import

        CTS notifications can be imported using `name`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cts/notification:Notification tracker your_notification
        ```

        :param str resource_name: The name of the resource.
        :param NotificationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NotificationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 enabled: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 operation_type: Optional[pulumi.Input[str]] = None,
                 operation_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationUserArgs']]]]] = None,
                 operations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 smn_topic: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NotificationArgs.__new__(NotificationArgs)

            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["name"] = name
            if operation_type is None and not opts.urn:
                raise TypeError("Missing required property 'operation_type'")
            __props__.__dict__["operation_type"] = operation_type
            __props__.__dict__["operation_users"] = operation_users
            __props__.__dict__["operations"] = operations
            __props__.__dict__["region"] = region
            __props__.__dict__["smn_topic"] = smn_topic
            __props__.__dict__["notification_id"] = None
            __props__.__dict__["status"] = None
        super(Notification, __self__).__init__(
            'huaweicloud:Cts/notification:Notification',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            enabled: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            notification_id: Optional[pulumi.Input[str]] = None,
            operation_type: Optional[pulumi.Input[str]] = None,
            operation_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationUserArgs']]]]] = None,
            operations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            smn_topic: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Notification':
        """
        Get an existing Notification resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] enabled: Specifies whether notification is enabled, defaults to true.
        :param pulumi.Input[str] name: Specifies the notification name. The value contains a maximum of 64 characters,
               and only letters, digits, underscores(_), and Chinese characters are allowed.
        :param pulumi.Input[str] notification_id: The notification ID in UUID format.
        :param pulumi.Input[str] operation_type: Specifies the operation type, possible options include **complete** and
               **customized**.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationUserArgs']]]] operation_users: Specifies an array of users. Notifications will be sent when specified users
               perform specified operations. All users are selected by default.
               The object structure is documented below.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NotificationOperationArgs']]]] operations: Specifies an array of operations that will trigger notifications.
               For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
               The object structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to manage the CTS notification resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] smn_topic: Specifies the URN of a topic.
        :param pulumi.Input[str] status: The notification status, the value can be **enabled** or **disabled**.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NotificationState.__new__(_NotificationState)

        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["name"] = name
        __props__.__dict__["notification_id"] = notification_id
        __props__.__dict__["operation_type"] = operation_type
        __props__.__dict__["operation_users"] = operation_users
        __props__.__dict__["operations"] = operations
        __props__.__dict__["region"] = region
        __props__.__dict__["smn_topic"] = smn_topic
        __props__.__dict__["status"] = status
        return Notification(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether notification is enabled, defaults to true.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the notification name. The value contains a maximum of 64 characters,
        and only letters, digits, underscores(_), and Chinese characters are allowed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="notificationId")
    def notification_id(self) -> pulumi.Output[str]:
        """
        The notification ID in UUID format.
        """
        return pulumi.get(self, "notification_id")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> pulumi.Output[str]:
        """
        Specifies the operation type, possible options include **complete** and
        **customized**.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter(name="operationUsers")
    def operation_users(self) -> pulumi.Output[Optional[Sequence['outputs.NotificationOperationUser']]]:
        """
        Specifies an array of users. Notifications will be sent when specified users
        perform specified operations. All users are selected by default.
        The object structure is documented below.
        """
        return pulumi.get(self, "operation_users")

    @property
    @pulumi.getter
    def operations(self) -> pulumi.Output[Optional[Sequence['outputs.NotificationOperation']]]:
        """
        Specifies an array of operations that will trigger notifications.
        For details, see [Supported Services and Operations](https://support.huaweicloud.com/intl/en-us/usermanual-cts/cts_03_0022.html).
        The object structure is documented below.
        """
        return pulumi.get(self, "operations")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to manage the CTS notification resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="smnTopic")
    def smn_topic(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the URN of a topic.
        """
        return pulumi.get(self, "smn_topic")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The notification status, the value can be **enabled** or **disabled**.
        """
        return pulumi.get(self, "status")

