# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ThesaurusArgs', 'Thesaurus']

@pulumi.input_type
class ThesaurusArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 cluster_id: pulumi.Input[str],
                 main_object: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stop_object: Optional[pulumi.Input[str]] = None,
                 synonym_object: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Thesaurus resource.
        :param pulumi.Input[str] bucket_name: Specifies the OBS bucket where the thesaurus files are stored
               (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        :param pulumi.Input[str] cluster_id: Specifies the CSS cluster ID for configuring the thesaurus.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] main_object: Specifies the path of the main thesaurus file object.
        :param pulumi.Input[str] region: The region in which to create the thesaurus resource. If omitted, the
               provider-level region will be used. Changing this creates a new thesaurus resource.
        :param pulumi.Input[str] stop_object: Specifies the path of the stop word library file object.
        :param pulumi.Input[str] synonym_object: Specifies the path of the synonyms thesaurus file object.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "cluster_id", cluster_id)
        if main_object is not None:
            pulumi.set(__self__, "main_object", main_object)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if stop_object is not None:
            pulumi.set(__self__, "stop_object", stop_object)
        if synonym_object is not None:
            pulumi.set(__self__, "synonym_object", synonym_object)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        Specifies the OBS bucket where the thesaurus files are stored
        (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        Specifies the CSS cluster ID for configuring the thesaurus.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="mainObject")
    def main_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of the main thesaurus file object.
        """
        return pulumi.get(self, "main_object")

    @main_object.setter
    def main_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_object", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the thesaurus resource. If omitted, the
        provider-level region will be used. Changing this creates a new thesaurus resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="stopObject")
    def stop_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of the stop word library file object.
        """
        return pulumi.get(self, "stop_object")

    @stop_object.setter
    def stop_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_object", value)

    @property
    @pulumi.getter(name="synonymObject")
    def synonym_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of the synonyms thesaurus file object.
        """
        return pulumi.get(self, "synonym_object")

    @synonym_object.setter
    def synonym_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synonym_object", value)


@pulumi.input_type
class _ThesaurusState:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 main_object: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 stop_object: Optional[pulumi.Input[str]] = None,
                 synonym_object: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Thesaurus resources.
        :param pulumi.Input[str] bucket_name: Specifies the OBS bucket where the thesaurus files are stored
               (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        :param pulumi.Input[str] cluster_id: Specifies the CSS cluster ID for configuring the thesaurus.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] main_object: Specifies the path of the main thesaurus file object.
        :param pulumi.Input[str] region: The region in which to create the thesaurus resource. If omitted, the
               provider-level region will be used. Changing this creates a new thesaurus resource.
        :param pulumi.Input[str] status: Indicates the status of the thesaurus loading
        :param pulumi.Input[str] stop_object: Specifies the path of the stop word library file object.
        :param pulumi.Input[str] synonym_object: Specifies the path of the synonyms thesaurus file object.
        :param pulumi.Input[str] update_time: Specifies the time (UTC) when the thesaurus was modified. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if main_object is not None:
            pulumi.set(__self__, "main_object", main_object)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if stop_object is not None:
            pulumi.set(__self__, "stop_object", stop_object)
        if synonym_object is not None:
            pulumi.set(__self__, "synonym_object", synonym_object)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the OBS bucket where the thesaurus files are stored
        (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the CSS cluster ID for configuring the thesaurus.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="mainObject")
    def main_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of the main thesaurus file object.
        """
        return pulumi.get(self, "main_object")

    @main_object.setter
    def main_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "main_object", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the thesaurus resource. If omitted, the
        provider-level region will be used. Changing this creates a new thesaurus resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the status of the thesaurus loading
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="stopObject")
    def stop_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of the stop word library file object.
        """
        return pulumi.get(self, "stop_object")

    @stop_object.setter
    def stop_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "stop_object", value)

    @property
    @pulumi.getter(name="synonymObject")
    def synonym_object(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the path of the synonyms thesaurus file object.
        """
        return pulumi.get(self, "synonym_object")

    @synonym_object.setter
    def synonym_object(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "synonym_object", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the time (UTC) when the thesaurus was modified. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class Thesaurus(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 main_object: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stop_object: Optional[pulumi.Input[str]] = None,
                 synonym_object: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages CSS thesaurus resource within HuaweiCloud

        > Only one thesaurus resource can be created for the specified cluster

        ## Example Usage

        ## Import

        CSS thesaurus can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Css/thesaurus:Thesaurus example e9ee3f48-f097-406a-aa74-cfece0af3e31
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket_name: Specifies the OBS bucket where the thesaurus files are stored
               (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        :param pulumi.Input[str] cluster_id: Specifies the CSS cluster ID for configuring the thesaurus.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] main_object: Specifies the path of the main thesaurus file object.
        :param pulumi.Input[str] region: The region in which to create the thesaurus resource. If omitted, the
               provider-level region will be used. Changing this creates a new thesaurus resource.
        :param pulumi.Input[str] stop_object: Specifies the path of the stop word library file object.
        :param pulumi.Input[str] synonym_object: Specifies the path of the synonyms thesaurus file object.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ThesaurusArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CSS thesaurus resource within HuaweiCloud

        > Only one thesaurus resource can be created for the specified cluster

        ## Example Usage

        ## Import

        CSS thesaurus can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Css/thesaurus:Thesaurus example e9ee3f48-f097-406a-aa74-cfece0af3e31
        ```

        :param str resource_name: The name of the resource.
        :param ThesaurusArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ThesaurusArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 main_object: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 stop_object: Optional[pulumi.Input[str]] = None,
                 synonym_object: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ThesaurusArgs.__new__(ThesaurusArgs)

            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            __props__.__dict__["main_object"] = main_object
            __props__.__dict__["region"] = region
            __props__.__dict__["stop_object"] = stop_object
            __props__.__dict__["synonym_object"] = synonym_object
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(Thesaurus, __self__).__init__(
            'huaweicloud:Css/thesaurus:Thesaurus',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_name: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            main_object: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            stop_object: Optional[pulumi.Input[str]] = None,
            synonym_object: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'Thesaurus':
        """
        Get an existing Thesaurus resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket_name: Specifies the OBS bucket where the thesaurus files are stored
               (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        :param pulumi.Input[str] cluster_id: Specifies the CSS cluster ID for configuring the thesaurus.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] main_object: Specifies the path of the main thesaurus file object.
        :param pulumi.Input[str] region: The region in which to create the thesaurus resource. If omitted, the
               provider-level region will be used. Changing this creates a new thesaurus resource.
        :param pulumi.Input[str] status: Indicates the status of the thesaurus loading
        :param pulumi.Input[str] stop_object: Specifies the path of the stop word library file object.
        :param pulumi.Input[str] synonym_object: Specifies the path of the synonyms thesaurus file object.
        :param pulumi.Input[str] update_time: Specifies the time (UTC) when the thesaurus was modified. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ThesaurusState.__new__(_ThesaurusState)

        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["main_object"] = main_object
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["stop_object"] = stop_object
        __props__.__dict__["synonym_object"] = synonym_object
        __props__.__dict__["update_time"] = update_time
        return Thesaurus(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[str]:
        """
        Specifies the OBS bucket where the thesaurus files are stored
        (the bucket type must be standard storage or low-frequency storage, and archive storage is not supported).
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        Specifies the CSS cluster ID for configuring the thesaurus.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="mainObject")
    def main_object(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the path of the main thesaurus file object.
        """
        return pulumi.get(self, "main_object")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the thesaurus resource. If omitted, the
        provider-level region will be used. Changing this creates a new thesaurus resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Indicates the status of the thesaurus loading
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stopObject")
    def stop_object(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the path of the stop word library file object.
        """
        return pulumi.get(self, "stop_object")

    @property
    @pulumi.getter(name="synonymObject")
    def synonym_object(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the path of the synonyms thesaurus file object.
        """
        return pulumi.get(self, "synonym_object")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Specifies the time (UTC) when the thesaurus was modified. The format is ISO8601:YYYY-MM-DDThh:mm:ssZ
        """
        return pulumi.get(self, "update_time")

