# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 engine_version: pulumi.Input[str],
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['ClusterBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 client_node_config: Optional[pulumi.Input['ClusterClientNodeConfigArgs']] = None,
                 cold_node_config: Optional[pulumi.Input['ClusterColdNodeConfigArgs']] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ess_node_config: Optional[pulumi.Input['ClusterEssNodeConfigArgs']] = None,
                 expect_node_num: Optional[pulumi.Input[int]] = None,
                 kibana_public_access: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']] = None,
                 master_node_config: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input['ClusterNodeConfigArgs']] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_access: Optional[pulumi.Input['ClusterPublicAccessArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input['ClusterVpcepEndpointArgs']] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input[str] engine_version: Specifies the engine version.
               [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterClientNodeConfigArgs'] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input['ClusterColdNodeConfigArgs'] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[str] engine_type: Specifies the engine type. The valid value is `elasticsearch`.
               Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the css cluster, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterEssNodeConfigArgs'] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input['ClusterKibanaPublicAccessArgs'] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to true.
               The kibana_public_access structure is documented below.
        :param pulumi.Input['ClusterMasterNodeConfigArgs'] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[str] name: Specifies the cluster name. It contains 4 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterPublicAccessArgs'] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: Specifies Security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] security_mode: Specifies whether to enable communication encryption and security
               authentication. Available values include *true* and *false*. security_mode is disabled by default.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the Subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterVpcepEndpointArgs'] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        """
        pulumi.set(__self__, "engine_version", engine_version)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if client_node_config is not None:
            pulumi.set(__self__, "client_node_config", client_node_config)
        if cold_node_config is not None:
            pulumi.set(__self__, "cold_node_config", cold_node_config)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ess_node_config is not None:
            pulumi.set(__self__, "ess_node_config", ess_node_config)
        if expect_node_num is not None:
            warnings.warn("""please use ess_node_config.instance_number instead""", DeprecationWarning)
            pulumi.log.warn("""expect_node_num is deprecated: please use ess_node_config.instance_number instead""")
        if expect_node_num is not None:
            pulumi.set(__self__, "expect_node_num", expect_node_num)
        if kibana_public_access is not None:
            pulumi.set(__self__, "kibana_public_access", kibana_public_access)
        if master_node_config is not None:
            pulumi.set(__self__, "master_node_config", master_node_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            warnings.warn("""please use ess_node_config instead""", DeprecationWarning)
            pulumi.log.warn("""node_config is deprecated: please use ess_node_config instead""")
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpcep_endpoint is not None:
            pulumi.set(__self__, "vpcep_endpoint", vpcep_endpoint)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        Specifies the engine version.
        [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['ClusterBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['ClusterBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the cluster.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="clientNodeConfig")
    def client_node_config(self) -> Optional[pulumi.Input['ClusterClientNodeConfigArgs']]:
        """
        Specifies the config of client node.
        The client_node_config structure is documented below.
        """
        return pulumi.get(self, "client_node_config")

    @client_node_config.setter
    def client_node_config(self, value: Optional[pulumi.Input['ClusterClientNodeConfigArgs']]):
        pulumi.set(self, "client_node_config", value)

    @property
    @pulumi.getter(name="coldNodeConfig")
    def cold_node_config(self) -> Optional[pulumi.Input['ClusterColdNodeConfigArgs']]:
        """
        Specifies the config of cold data node.
        The cold_node_config structure is documented below.
        """
        return pulumi.get(self, "cold_node_config")

    @cold_node_config.setter
    def cold_node_config(self, value: Optional[pulumi.Input['ClusterColdNodeConfigArgs']]):
        pulumi.set(self, "cold_node_config", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the engine type. The valid value is `elasticsearch`.
        Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the css cluster, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="essNodeConfig")
    def ess_node_config(self) -> Optional[pulumi.Input['ClusterEssNodeConfigArgs']]:
        """
        Specifies the config of data node.
        The ess_node_config structure is documented below.
        """
        return pulumi.get(self, "ess_node_config")

    @ess_node_config.setter
    def ess_node_config(self, value: Optional[pulumi.Input['ClusterEssNodeConfigArgs']]):
        pulumi.set(self, "ess_node_config", value)

    @property
    @pulumi.getter(name="expectNodeNum")
    def expect_node_num(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "expect_node_num")

    @expect_node_num.setter
    def expect_node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expect_node_num", value)

    @property
    @pulumi.getter(name="kibanaPublicAccess")
    def kibana_public_access(self) -> Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]:
        """
        Specifies Kibana public network access information.
        This parameter is valid only when security_mode is set to true.
        The kibana_public_access structure is documented below.
        """
        return pulumi.get(self, "kibana_public_access")

    @kibana_public_access.setter
    def kibana_public_access(self, value: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]):
        pulumi.set(self, "kibana_public_access", value)

    @property
    @pulumi.getter(name="masterNodeConfig")
    def master_node_config(self) -> Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]:
        """
        Specifies the config of master node.
        The master_node_config structure is documented below.
        """
        return pulumi.get(self, "master_node_config")

    @master_node_config.setter
    def master_node_config(self, value: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]):
        pulumi.set(self, "master_node_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster name. It contains 4 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['ClusterNodeConfigArgs']]:
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['ClusterNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the cluster administrator in security mode.
        This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
        The administrator password must meet the following requirements:
        + The password can contain 8 to 32 characters.
        + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
        and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[pulumi.Input['ClusterPublicAccessArgs']]:
        """
        Specifies the public network access information.
        The public_access structure is documented below.
        """
        return pulumi.get(self, "public_access")

    @public_access.setter
    def public_access(self, value: Optional[pulumi.Input['ClusterPublicAccessArgs']]):
        pulumi.set(self, "public_access", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies Security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable communication encryption and security
        authentication. Available values include *true* and *false*. security_mode is disabled by default.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcepEndpoint")
    def vpcep_endpoint(self) -> Optional[pulumi.Input['ClusterVpcepEndpointArgs']]:
        """
        Specifies the VPC endpoint service information.
        The vpcep_endpoint structure is documented below.
        """
        return pulumi.get(self, "vpcep_endpoint")

    @vpcep_endpoint.setter
    def vpcep_endpoint(self, value: Optional[pulumi.Input['ClusterVpcepEndpointArgs']]):
        pulumi.set(self, "vpcep_endpoint", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input['ClusterBackupStrategyArgs']] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 client_node_config: Optional[pulumi.Input['ClusterClientNodeConfigArgs']] = None,
                 cold_node_config: Optional[pulumi.Input['ClusterColdNodeConfigArgs']] = None,
                 created: Optional[pulumi.Input[str]] = None,
                 endpoint: Optional[pulumi.Input[str]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ess_node_config: Optional[pulumi.Input['ClusterEssNodeConfigArgs']] = None,
                 expect_node_num: Optional[pulumi.Input[int]] = None,
                 kibana_public_access: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']] = None,
                 master_node_config: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input['ClusterNodeConfigArgs']] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_access: Optional[pulumi.Input['ClusterPublicAccessArgs']] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[bool]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input['ClusterVpcepEndpointArgs']] = None,
                 vpcep_endpoint_id: Optional[pulumi.Input[str]] = None,
                 vpcep_ip: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterBackupStrategyArgs'] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterClientNodeConfigArgs'] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input['ClusterColdNodeConfigArgs'] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[str] created: Time when a cluster is created. The format is ISO8601:
               CCYY-MM-DDThh:mm:ss.
        :param pulumi.Input[str] endpoint: The IP address and port number.
        :param pulumi.Input[str] engine_type: Specifies the engine type. The valid value is `elasticsearch`.
               Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] engine_version: Specifies the engine version.
               [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the css cluster, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterEssNodeConfigArgs'] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input['ClusterKibanaPublicAccessArgs'] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to true.
               The kibana_public_access structure is documented below.
        :param pulumi.Input['ClusterMasterNodeConfigArgs'] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[str] name: Specifies the cluster name. It contains 4 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]] nodes: List of node objects. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterPublicAccessArgs'] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: Specifies Security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] security_mode: Specifies whether to enable communication encryption and security
               authentication. Available values include *true* and *false*. security_mode is disabled by default.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The cluster status
               + `100`: The operation, such as instance creation, is in progress.
               + `200`: The cluster is available.
               + `303`: The cluster is unavailable.
        :param pulumi.Input[str] subnet_id: Specifies the Subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input['ClusterVpcepEndpointArgs'] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        :param pulumi.Input[str] vpcep_endpoint_id: The VPC endpoint service ID.
        :param pulumi.Input[str] vpcep_ip: The private IP address of VPC endpoint service.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if charging_mode is not None:
            pulumi.set(__self__, "charging_mode", charging_mode)
        if client_node_config is not None:
            pulumi.set(__self__, "client_node_config", client_node_config)
        if cold_node_config is not None:
            pulumi.set(__self__, "cold_node_config", cold_node_config)
        if created is not None:
            pulumi.set(__self__, "created", created)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if engine_type is not None:
            pulumi.set(__self__, "engine_type", engine_type)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if ess_node_config is not None:
            pulumi.set(__self__, "ess_node_config", ess_node_config)
        if expect_node_num is not None:
            warnings.warn("""please use ess_node_config.instance_number instead""", DeprecationWarning)
            pulumi.log.warn("""expect_node_num is deprecated: please use ess_node_config.instance_number instead""")
        if expect_node_num is not None:
            pulumi.set(__self__, "expect_node_num", expect_node_num)
        if kibana_public_access is not None:
            pulumi.set(__self__, "kibana_public_access", kibana_public_access)
        if master_node_config is not None:
            pulumi.set(__self__, "master_node_config", master_node_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            warnings.warn("""please use ess_node_config instead""", DeprecationWarning)
            pulumi.log.warn("""node_config is deprecated: please use ess_node_config instead""")
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)
        if public_access is not None:
            pulumi.set(__self__, "public_access", public_access)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if security_group_id is not None:
            pulumi.set(__self__, "security_group_id", security_group_id)
        if security_mode is not None:
            pulumi.set(__self__, "security_mode", security_mode)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if vpcep_endpoint is not None:
            pulumi.set(__self__, "vpcep_endpoint", vpcep_endpoint)
        if vpcep_endpoint_id is not None:
            pulumi.set(__self__, "vpcep_endpoint_id", vpcep_endpoint_id)
        if vpcep_ip is not None:
            pulumi.set(__self__, "vpcep_ip", vpcep_ip)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @availability_zone.setter
    def availability_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_zone", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input['ClusterBackupStrategyArgs']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input['ClusterBackupStrategyArgs']]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging mode of the cluster.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="clientNodeConfig")
    def client_node_config(self) -> Optional[pulumi.Input['ClusterClientNodeConfigArgs']]:
        """
        Specifies the config of client node.
        The client_node_config structure is documented below.
        """
        return pulumi.get(self, "client_node_config")

    @client_node_config.setter
    def client_node_config(self, value: Optional[pulumi.Input['ClusterClientNodeConfigArgs']]):
        pulumi.set(self, "client_node_config", value)

    @property
    @pulumi.getter(name="coldNodeConfig")
    def cold_node_config(self) -> Optional[pulumi.Input['ClusterColdNodeConfigArgs']]:
        """
        Specifies the config of cold data node.
        The cold_node_config structure is documented below.
        """
        return pulumi.get(self, "cold_node_config")

    @cold_node_config.setter
    def cold_node_config(self, value: Optional[pulumi.Input['ClusterColdNodeConfigArgs']]):
        pulumi.set(self, "cold_node_config", value)

    @property
    @pulumi.getter
    def created(self) -> Optional[pulumi.Input[str]]:
        """
        Time when a cluster is created. The format is ISO8601:
        CCYY-MM-DDThh:mm:ss.
        """
        return pulumi.get(self, "created")

    @created.setter
    def created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created", value)

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The IP address and port number.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "endpoint", value)

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the engine type. The valid value is `elasticsearch`.
        Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_type")

    @engine_type.setter
    def engine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_type", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the engine version.
        [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the css cluster, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="essNodeConfig")
    def ess_node_config(self) -> Optional[pulumi.Input['ClusterEssNodeConfigArgs']]:
        """
        Specifies the config of data node.
        The ess_node_config structure is documented below.
        """
        return pulumi.get(self, "ess_node_config")

    @ess_node_config.setter
    def ess_node_config(self, value: Optional[pulumi.Input['ClusterEssNodeConfigArgs']]):
        pulumi.set(self, "ess_node_config", value)

    @property
    @pulumi.getter(name="expectNodeNum")
    def expect_node_num(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "expect_node_num")

    @expect_node_num.setter
    def expect_node_num(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expect_node_num", value)

    @property
    @pulumi.getter(name="kibanaPublicAccess")
    def kibana_public_access(self) -> Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]:
        """
        Specifies Kibana public network access information.
        This parameter is valid only when security_mode is set to true.
        The kibana_public_access structure is documented below.
        """
        return pulumi.get(self, "kibana_public_access")

    @kibana_public_access.setter
    def kibana_public_access(self, value: Optional[pulumi.Input['ClusterKibanaPublicAccessArgs']]):
        pulumi.set(self, "kibana_public_access", value)

    @property
    @pulumi.getter(name="masterNodeConfig")
    def master_node_config(self) -> Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]:
        """
        Specifies the config of master node.
        The master_node_config structure is documented below.
        """
        return pulumi.get(self, "master_node_config")

    @master_node_config.setter
    def master_node_config(self, value: Optional[pulumi.Input['ClusterMasterNodeConfigArgs']]):
        pulumi.set(self, "master_node_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the cluster name. It contains 4 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['ClusterNodeConfigArgs']]:
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['ClusterNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]]]:
        """
        List of node objects. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the password of the cluster administrator in security mode.
        This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
        The administrator password must meet the following requirements:
        + The password can contain 8 to 32 characters.
        + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
        and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @period_unit.setter
    def period_unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "period_unit", value)

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> Optional[pulumi.Input['ClusterPublicAccessArgs']]:
        """
        Specifies the public network access information.
        The public_access structure is documented below.
        """
        return pulumi.get(self, "public_access")

    @public_access.setter
    def public_access(self, value: Optional[pulumi.Input['ClusterPublicAccessArgs']]):
        pulumi.set(self, "public_access", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies Security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @security_group_id.setter
    def security_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "security_group_id", value)

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable communication encryption and security
        authentication. Available values include *true* and *false*. security_mode is disabled by default.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_mode")

    @security_mode.setter
    def security_mode(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "security_mode", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster status
        + `100`: The operation, such as instance creation, is in progress.
        + `200`: The cluster is available.
        + `303`: The cluster is unavailable.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="vpcepEndpoint")
    def vpcep_endpoint(self) -> Optional[pulumi.Input['ClusterVpcepEndpointArgs']]:
        """
        Specifies the VPC endpoint service information.
        The vpcep_endpoint structure is documented below.
        """
        return pulumi.get(self, "vpcep_endpoint")

    @vpcep_endpoint.setter
    def vpcep_endpoint(self, value: Optional[pulumi.Input['ClusterVpcepEndpointArgs']]):
        pulumi.set(self, "vpcep_endpoint", value)

    @property
    @pulumi.getter(name="vpcepEndpointId")
    def vpcep_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The VPC endpoint service ID.
        """
        return pulumi.get(self, "vpcep_endpoint_id")

    @vpcep_endpoint_id.setter
    def vpcep_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpcep_endpoint_id", value)

    @property
    @pulumi.getter(name="vpcepIp")
    def vpcep_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The private IP address of VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_ip")

    @vpcep_ip.setter
    def vpcep_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpcep_ip", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['ClusterBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 client_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterClientNodeConfigArgs']]] = None,
                 cold_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterColdNodeConfigArgs']]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ess_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterEssNodeConfigArgs']]] = None,
                 expect_node_num: Optional[pulumi.Input[int]] = None,
                 kibana_public_access: Optional[pulumi.Input[pulumi.InputType['ClusterKibanaPublicAccessArgs']]] = None,
                 master_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterMasterNodeConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input[pulumi.InputType['ClusterNodeConfigArgs']]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_access: Optional[pulumi.Input[pulumi.InputType['ClusterPublicAccessArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input[pulumi.InputType['ClusterVpcepEndpointArgs']]] = None,
                 __props__=None):
        """
        Manages CSS cluster resource within HuaweiCloud

        ## Example Usage
        ### create a cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = huaweicloud.css.Cluster("cluster",
            engine_version="7.10.2",
            ess_node_config=huaweicloud.css.ClusterEssNodeConfigArgs(
                flavor="ess.spec-4u8g",
                instance_number=1,
                volume=huaweicloud.css.ClusterEssNodeConfigVolumeArgs(
                    volume_type="HIGH",
                    size=40,
                ),
            ),
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```
        ### create a cluster with ess-data node and master node

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = huaweicloud.css.Cluster("cluster",
            engine_version="7.10.2",
            ess_node_config=huaweicloud.css.ClusterEssNodeConfigArgs(
                flavor="ess.spec-4u8g",
                instance_number=1,
                volume=huaweicloud.css.ClusterEssNodeConfigVolumeArgs(
                    volume_type="HIGH",
                    size=40,
                ),
            ),
            master_node_config=huaweicloud.css.ClusterMasterNodeConfigArgs(
                flavor="ess.spec-4u8g",
                instance_number=3,
                volume=huaweicloud.css.ClusterMasterNodeConfigVolumeArgs(
                    volume_type="HIGH",
                    size=40,
                ),
            ),
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ## Import

        CSS cluster can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Css/cluster:Cluster example 6d793124-3d5d-47be-bf09-f694fdf2d9ed
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterClientNodeConfigArgs']] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterColdNodeConfigArgs']] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[str] engine_type: Specifies the engine type. The valid value is `elasticsearch`.
               Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] engine_version: Specifies the engine version.
               [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the css cluster, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterEssNodeConfigArgs']] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterKibanaPublicAccessArgs']] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to true.
               The kibana_public_access structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterMasterNodeConfigArgs']] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[str] name: Specifies the cluster name. It contains 4 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterPublicAccessArgs']] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: Specifies Security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] security_mode: Specifies whether to enable communication encryption and security
               authentication. Available values include *true* and *false*. security_mode is disabled by default.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] subnet_id: Specifies the Subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterVpcepEndpointArgs']] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages CSS cluster resource within HuaweiCloud

        ## Example Usage
        ### create a cluster

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = huaweicloud.css.Cluster("cluster",
            engine_version="7.10.2",
            ess_node_config=huaweicloud.css.ClusterEssNodeConfigArgs(
                flavor="ess.spec-4u8g",
                instance_number=1,
                volume=huaweicloud.css.ClusterEssNodeConfigVolumeArgs(
                    volume_type="HIGH",
                    size=40,
                ),
            ),
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```
        ### create a cluster with ess-data node and master node

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        availability_zone = config.require_object("availabilityZone")
        vpc_id = config.require_object("vpcId")
        subnet_id = config.require_object("subnetId")
        secgroup_id = config.require_object("secgroupId")
        cluster = huaweicloud.css.Cluster("cluster",
            engine_version="7.10.2",
            ess_node_config=huaweicloud.css.ClusterEssNodeConfigArgs(
                flavor="ess.spec-4u8g",
                instance_number=1,
                volume=huaweicloud.css.ClusterEssNodeConfigVolumeArgs(
                    volume_type="HIGH",
                    size=40,
                ),
            ),
            master_node_config=huaweicloud.css.ClusterMasterNodeConfigArgs(
                flavor="ess.spec-4u8g",
                instance_number=3,
                volume=huaweicloud.css.ClusterMasterNodeConfigVolumeArgs(
                    volume_type="HIGH",
                    size=40,
                ),
            ),
            availability_zone=availability_zone,
            vpc_id=vpc_id,
            subnet_id=subnet_id,
            security_group_id=secgroup_id)
        ```

        ## Import

        CSS cluster can be imported by `id`. For example,

        ```sh
         $ pulumi import huaweicloud:Css/cluster:Cluster example 6d793124-3d5d-47be-bf09-f694fdf2d9ed
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_renew: Optional[pulumi.Input[str]] = None,
                 availability_zone: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[pulumi.InputType['ClusterBackupStrategyArgs']]] = None,
                 charging_mode: Optional[pulumi.Input[str]] = None,
                 client_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterClientNodeConfigArgs']]] = None,
                 cold_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterColdNodeConfigArgs']]] = None,
                 engine_type: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 ess_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterEssNodeConfigArgs']]] = None,
                 expect_node_num: Optional[pulumi.Input[int]] = None,
                 kibana_public_access: Optional[pulumi.Input[pulumi.InputType['ClusterKibanaPublicAccessArgs']]] = None,
                 master_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterMasterNodeConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input[pulumi.InputType['ClusterNodeConfigArgs']]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 period_unit: Optional[pulumi.Input[str]] = None,
                 public_access: Optional[pulumi.Input[pulumi.InputType['ClusterPublicAccessArgs']]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 security_group_id: Optional[pulumi.Input[str]] = None,
                 security_mode: Optional[pulumi.Input[bool]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 vpcep_endpoint: Optional[pulumi.Input[pulumi.InputType['ClusterVpcepEndpointArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["availability_zone"] = availability_zone
            __props__.__dict__["backup_strategy"] = backup_strategy
            __props__.__dict__["charging_mode"] = charging_mode
            __props__.__dict__["client_node_config"] = client_node_config
            __props__.__dict__["cold_node_config"] = cold_node_config
            __props__.__dict__["engine_type"] = engine_type
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["ess_node_config"] = ess_node_config
            if expect_node_num is not None and not opts.urn:
                warnings.warn("""please use ess_node_config.instance_number instead""", DeprecationWarning)
                pulumi.log.warn("""expect_node_num is deprecated: please use ess_node_config.instance_number instead""")
            __props__.__dict__["expect_node_num"] = expect_node_num
            __props__.__dict__["kibana_public_access"] = kibana_public_access
            __props__.__dict__["master_node_config"] = master_node_config
            __props__.__dict__["name"] = name
            if node_config is not None and not opts.urn:
                warnings.warn("""please use ess_node_config instead""", DeprecationWarning)
                pulumi.log.warn("""node_config is deprecated: please use ess_node_config instead""")
            __props__.__dict__["node_config"] = node_config
            __props__.__dict__["password"] = password
            __props__.__dict__["period"] = period
            __props__.__dict__["period_unit"] = period_unit
            __props__.__dict__["public_access"] = public_access
            __props__.__dict__["region"] = region
            __props__.__dict__["security_group_id"] = security_group_id
            __props__.__dict__["security_mode"] = security_mode
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["vpcep_endpoint"] = vpcep_endpoint
            __props__.__dict__["created"] = None
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vpcep_endpoint_id"] = None
            __props__.__dict__["vpcep_ip"] = None
        super(Cluster, __self__).__init__(
            'huaweicloud:Css/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_renew: Optional[pulumi.Input[str]] = None,
            availability_zone: Optional[pulumi.Input[str]] = None,
            backup_strategy: Optional[pulumi.Input[pulumi.InputType['ClusterBackupStrategyArgs']]] = None,
            charging_mode: Optional[pulumi.Input[str]] = None,
            client_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterClientNodeConfigArgs']]] = None,
            cold_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterColdNodeConfigArgs']]] = None,
            created: Optional[pulumi.Input[str]] = None,
            endpoint: Optional[pulumi.Input[str]] = None,
            engine_type: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            ess_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterEssNodeConfigArgs']]] = None,
            expect_node_num: Optional[pulumi.Input[int]] = None,
            kibana_public_access: Optional[pulumi.Input[pulumi.InputType['ClusterKibanaPublicAccessArgs']]] = None,
            master_node_config: Optional[pulumi.Input[pulumi.InputType['ClusterMasterNodeConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_config: Optional[pulumi.Input[pulumi.InputType['ClusterNodeConfigArgs']]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            period_unit: Optional[pulumi.Input[str]] = None,
            public_access: Optional[pulumi.Input[pulumi.InputType['ClusterPublicAccessArgs']]] = None,
            region: Optional[pulumi.Input[str]] = None,
            security_group_id: Optional[pulumi.Input[str]] = None,
            security_mode: Optional[pulumi.Input[bool]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            vpcep_endpoint: Optional[pulumi.Input[pulumi.InputType['ClusterVpcepEndpointArgs']]] = None,
            vpcep_endpoint_id: Optional[pulumi.Input[str]] = None,
            vpcep_ip: Optional[pulumi.Input[str]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] auto_renew: Specifies whether auto renew is enabled.
               Valid values are `true` and `false`, defaults to `false`.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] availability_zone: Specifies the availability zone name.
               Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
               than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
               distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
               between node quantity in any two AZs is 1 at most.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterBackupStrategyArgs']] backup_strategy: Specifies the advanced backup policy. Structure is documented below.
        :param pulumi.Input[str] charging_mode: Specifies the charging mode of the cluster.
               Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterClientNodeConfigArgs']] client_node_config: Specifies the config of client node.
               The client_node_config structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterColdNodeConfigArgs']] cold_node_config: Specifies the config of cold data node.
               The cold_node_config structure is documented below.
        :param pulumi.Input[str] created: Time when a cluster is created. The format is ISO8601:
               CCYY-MM-DDThh:mm:ss.
        :param pulumi.Input[str] endpoint: The IP address and port number.
        :param pulumi.Input[str] engine_type: Specifies the engine type. The valid value is `elasticsearch`.
               Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        :param pulumi.Input[str] engine_version: Specifies the engine version.
               [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the css cluster, Value 0
               indicates the default enterprise project. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterEssNodeConfigArgs']] ess_node_config: Specifies the config of data node.
               The ess_node_config structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterKibanaPublicAccessArgs']] kibana_public_access: Specifies Kibana public network access information.
               This parameter is valid only when security_mode is set to true.
               The kibana_public_access structure is documented below.
        :param pulumi.Input[pulumi.InputType['ClusterMasterNodeConfigArgs']] master_node_config: Specifies the config of master node.
               The master_node_config structure is documented below.
        :param pulumi.Input[str] name: Specifies the cluster name. It contains 4 to 32 characters.
               Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
               Changing this parameter will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterNodeArgs']]]] nodes: List of node objects. Structure is documented below.
        :param pulumi.Input[str] password: Specifies the password of the cluster administrator in security mode.
               This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
               The administrator password must meet the following requirements:
               + The password can contain 8 to 32 characters.
               + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
               and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        :param pulumi.Input[int] period: Specifies the charging period of the instance.
               If `period_unit` is set to *month*, the value ranges from 1 to 9.
               If `period_unit` is set to *year*, the value ranges from 1 to 3.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] period_unit: Specifies the charging period unit of the instance.
               Valid values are *month* and *year*.
               Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterPublicAccessArgs']] public_access: Specifies the public network access information.
               The public_access structure is documented below.
        :param pulumi.Input[str] region: Specifies the region in which to create the cluster resource. If omitted, the
               provider-level region will be used. Changing this creates a new cluster resource.
        :param pulumi.Input[str] security_group_id: Specifies Security group ID.
               Changing this parameter will create a new resource.
        :param pulumi.Input[bool] security_mode: Specifies whether to enable communication encryption and security
               authentication. Available values include *true* and *false*. security_mode is disabled by default.
               Changing this parameter will create a new resource.
        :param pulumi.Input[str] status: The cluster status
               + `100`: The operation, such as instance creation, is in progress.
               + `200`: The cluster is available.
               + `303`: The cluster is unavailable.
        :param pulumi.Input[str] subnet_id: Specifies the Subnet ID. Changing this parameter will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] tags: The key/value pairs to associate with the cluster.
        :param pulumi.Input[str] vpc_id: Specifies the VPC ID. Changing this parameter will create a new resource.
        :param pulumi.Input[pulumi.InputType['ClusterVpcepEndpointArgs']] vpcep_endpoint: Specifies the VPC endpoint service information.
               The vpcep_endpoint structure is documented below.
        :param pulumi.Input[str] vpcep_endpoint_id: The VPC endpoint service ID.
        :param pulumi.Input[str] vpcep_ip: The private IP address of VPC endpoint service.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["availability_zone"] = availability_zone
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["charging_mode"] = charging_mode
        __props__.__dict__["client_node_config"] = client_node_config
        __props__.__dict__["cold_node_config"] = cold_node_config
        __props__.__dict__["created"] = created
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["engine_type"] = engine_type
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["ess_node_config"] = ess_node_config
        __props__.__dict__["expect_node_num"] = expect_node_num
        __props__.__dict__["kibana_public_access"] = kibana_public_access
        __props__.__dict__["master_node_config"] = master_node_config
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["password"] = password
        __props__.__dict__["period"] = period
        __props__.__dict__["period_unit"] = period_unit
        __props__.__dict__["public_access"] = public_access
        __props__.__dict__["region"] = region
        __props__.__dict__["security_group_id"] = security_group_id
        __props__.__dict__["security_mode"] = security_mode
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["vpcep_endpoint"] = vpcep_endpoint
        __props__.__dict__["vpcep_endpoint_id"] = vpcep_endpoint_id
        __props__.__dict__["vpcep_ip"] = vpcep_ip
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies whether auto renew is enabled.
        Valid values are `true` and `false`, defaults to `false`.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> pulumi.Output[str]:
        """
        Specifies the availability zone name.
        Separate multiple AZs with commas (,), for example, az1,az2. AZs must be unique. The number of nodes must be greater
        than or equal to the number of AZs. If the number of nodes is a multiple of the number of AZs, the nodes are evenly
        distributed to each AZ. If the number of nodes is not a multiple of the number of AZs, the absolute difference
        between node quantity in any two AZs is 1 at most.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output[Optional['outputs.ClusterBackupStrategy']]:
        """
        Specifies the advanced backup policy. Structure is documented below.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Output[str]:
        """
        Specifies the charging mode of the cluster.
        Valid values are **prePaid** and **postPaid**, defaults to **postPaid**.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @property
    @pulumi.getter(name="clientNodeConfig")
    def client_node_config(self) -> pulumi.Output[Optional['outputs.ClusterClientNodeConfig']]:
        """
        Specifies the config of client node.
        The client_node_config structure is documented below.
        """
        return pulumi.get(self, "client_node_config")

    @property
    @pulumi.getter(name="coldNodeConfig")
    def cold_node_config(self) -> pulumi.Output[Optional['outputs.ClusterColdNodeConfig']]:
        """
        Specifies the config of cold data node.
        The cold_node_config structure is documented below.
        """
        return pulumi.get(self, "cold_node_config")

    @property
    @pulumi.getter
    def created(self) -> pulumi.Output[str]:
        """
        Time when a cluster is created. The format is ISO8601:
        CCYY-MM-DDThh:mm:ss.
        """
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[str]:
        """
        The IP address and port number.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="engineType")
    def engine_type(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the engine type. The valid value is `elasticsearch`.
        Defaults to `elasticsearch`. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_type")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        Specifies the engine version.
        [Supported Cluster Versions](https://support.huaweicloud.com/intl/en-us/api-css/css_03_0056.html)
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the css cluster, Value 0
        indicates the default enterprise project. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="essNodeConfig")
    def ess_node_config(self) -> pulumi.Output['outputs.ClusterEssNodeConfig']:
        """
        Specifies the config of data node.
        The ess_node_config structure is documented below.
        """
        return pulumi.get(self, "ess_node_config")

    @property
    @pulumi.getter(name="expectNodeNum")
    def expect_node_num(self) -> pulumi.Output[int]:
        return pulumi.get(self, "expect_node_num")

    @property
    @pulumi.getter(name="kibanaPublicAccess")
    def kibana_public_access(self) -> pulumi.Output[Optional['outputs.ClusterKibanaPublicAccess']]:
        """
        Specifies Kibana public network access information.
        This parameter is valid only when security_mode is set to true.
        The kibana_public_access structure is documented below.
        """
        return pulumi.get(self, "kibana_public_access")

    @property
    @pulumi.getter(name="masterNodeConfig")
    def master_node_config(self) -> pulumi.Output[Optional['outputs.ClusterMasterNodeConfig']]:
        """
        Specifies the config of master node.
        The master_node_config structure is documented below.
        """
        return pulumi.get(self, "master_node_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the cluster name. It contains 4 to 32 characters.
        Only letters, digits, hyphens (-), and underscores (_) are allowed. The value must start with a letter.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.ClusterNodeConfig']:
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.ClusterNode']]:
        """
        List of node objects. Structure is documented below.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the password of the cluster administrator in security mode.
        This parameter is mandatory only when security_mode is set to true. Changing this parameter will create a new resource.
        The administrator password must meet the following requirements:
        + The password can contain 8 to 32 characters.
        + The password must contain at least 3 of the following character types: uppercase letters, lowercase letters, digits,
        and special characters (~!@#$%^&*()-_=+\\\\|[{}];:,<.>/?).
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the charging period of the instance.
        If `period_unit` is set to *month*, the value ranges from 1 to 9.
        If `period_unit` is set to *year*, the value ranges from 1 to 3.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the charging period unit of the instance.
        Valid values are *month* and *year*.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "period_unit")

    @property
    @pulumi.getter(name="publicAccess")
    def public_access(self) -> pulumi.Output[Optional['outputs.ClusterPublicAccess']]:
        """
        Specifies the public network access information.
        The public_access structure is documented below.
        """
        return pulumi.get(self, "public_access")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the cluster resource. If omitted, the
        provider-level region will be used. Changing this creates a new cluster resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="securityGroupId")
    def security_group_id(self) -> pulumi.Output[str]:
        """
        Specifies Security group ID.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_group_id")

    @property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable communication encryption and security
        authentication. Available values include *true* and *false*. security_mode is disabled by default.
        Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "security_mode")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The cluster status
        + `100`: The operation, such as instance creation, is in progress.
        + `200`: The cluster is available.
        + `303`: The cluster is unavailable.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Specifies the Subnet ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        The key/value pairs to associate with the cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Specifies the VPC ID. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="vpcepEndpoint")
    def vpcep_endpoint(self) -> pulumi.Output[Optional['outputs.ClusterVpcepEndpoint']]:
        """
        Specifies the VPC endpoint service information.
        The vpcep_endpoint structure is documented below.
        """
        return pulumi.get(self, "vpcep_endpoint")

    @property
    @pulumi.getter(name="vpcepEndpointId")
    def vpcep_endpoint_id(self) -> pulumi.Output[str]:
        """
        The VPC endpoint service ID.
        """
        return pulumi.get(self, "vpcep_endpoint_id")

    @property
    @pulumi.getter(name="vpcepIp")
    def vpcep_ip(self) -> pulumi.Output[str]:
        """
        The private IP address of VPC endpoint service.
        """
        return pulumi.get(self, "vpcep_ip")

