# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MicroserviceEngineArgs', 'MicroserviceEngine']

@pulumi.input_type
class MicroserviceEngineArgs:
    def __init__(__self__, *,
                 auth_type: pulumi.Input[str],
                 availability_zones: pulumi.Input[Sequence[pulumi.Input[str]]],
                 flavor: pulumi.Input[str],
                 network_id: pulumi.Input[str],
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 extend_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MicroserviceEngine resource.
        :param pulumi.Input[str] auth_type: Specifies the authentication method for the dedicated microservice engine.
               Changing this will create a new engine.
               + **RBAC**: Enable security authentication.
               Security authentication applies to the scenario where multiple users use the same engine.
               After security authentication is enabled, all users who use the engine can log in using the account and password.
               You can assign the account and role in the System Management.
               + **NONE**: Disable security authentication.
               After security authentication is disabled, all users who use the engine can use the engine without using the account
               and password, and have the same operation permissions on all services.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of availability zone.
               Changing this will create a new engine.
        :param pulumi.Input[str] flavor: Specifies the flavor of the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[str] network_id: Specifies the network ID of the subnet to which the dedicated microservice
               engine belongs. Changing this will create a new engine.
        :param pulumi.Input[str] admin_pass: Specifies the account password. The corresponding account name is **root**.
               Required if `auth_type` is **RBAC**. Changing this will create a new engine.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice engine.
               The description can contian a maximum of `255` characters.
               Changing this will create a new engine.
        :param pulumi.Input[str] eip_id: Specifies the EIP ID to which the dedicated microservice engine assocated.
               Changing this will create a new engine.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_params: Specifies the additional parameters for the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice engine.
               The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter and cannot end with a hyphen (-).
               Changing this will create a new engine.
        :param pulumi.Input[str] region: Specifies the region in which to create the dedicated microservice engine.
               If omitted, the provider-level region will be used. Changing this will create a new engine.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice engine. The value can be:
               **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        pulumi.set(__self__, "auth_type", auth_type)
        pulumi.set(__self__, "availability_zones", availability_zones)
        pulumi.set(__self__, "flavor", flavor)
        pulumi.set(__self__, "network_id", network_id)
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Input[str]:
        """
        Specifies the authentication method for the dedicated microservice engine.
        Changing this will create a new engine.
        + **RBAC**: Enable security authentication.
        Security authentication applies to the scenario where multiple users use the same engine.
        After security authentication is enabled, all users who use the engine can log in using the account and password.
        You can assign the account and role in the System Management.
        + **NONE**: Disable security authentication.
        After security authentication is disabled, all users who use the engine can use the engine without using the account
        and password, and have the same operation permissions on all services.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Specifies the list of availability zone.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Input[str]:
        """
        Specifies the flavor of the dedicated microservice engine.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: pulumi.Input[str]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        Specifies the network ID of the subnet to which the dedicated microservice
        engine belongs. Changing this will create a new engine.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account password. The corresponding account name is **root**.
        Required if `auth_type` is **RBAC**. Changing this will create a new engine.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the dedicated microservice engine.
        The description can contian a maximum of `255` characters.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP ID to which the dedicated microservice engine assocated.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the additional parameters for the dedicated microservice engine.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "extend_params")

    @extend_params.setter
    def extend_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extend_params", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dedicated microservice engine.
        The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter and cannot end with a hyphen (-).
        Changing this will create a new engine.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the dedicated microservice engine.
        If omitted, the provider-level region will be used. Changing this will create a new engine.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the dedicated microservice engine. The value can be:
        **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class _MicroserviceEngineState:
    def __init__(__self__, *,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 config_center_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineConfigCenterAddressArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 extend_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 instance_limit: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 service_limit: Optional[pulumi.Input[int]] = None,
                 service_registry_addresses: Optional[pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineServiceRegistryAddressArgs']]]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MicroserviceEngine resources.
        :param pulumi.Input[str] admin_pass: Specifies the account password. The corresponding account name is **root**.
               Required if `auth_type` is **RBAC**. Changing this will create a new engine.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] auth_type: Specifies the authentication method for the dedicated microservice engine.
               Changing this will create a new engine.
               + **RBAC**: Enable security authentication.
               Security authentication applies to the scenario where multiple users use the same engine.
               After security authentication is enabled, all users who use the engine can log in using the account and password.
               You can assign the account and role in the System Management.
               + **NONE**: Disable security authentication.
               After security authentication is disabled, all users who use the engine can use the engine without using the account
               and password, and have the same operation permissions on all services.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of availability zone.
               Changing this will create a new engine.
        :param pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineConfigCenterAddressArgs']]] config_center_addresses: The address of config center.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice engine.
               The description can contian a maximum of `255` characters.
               Changing this will create a new engine.
        :param pulumi.Input[str] eip_id: Specifies the EIP ID to which the dedicated microservice engine assocated.
               Changing this will create a new engine.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_params: Specifies the additional parameters for the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[str] flavor: Specifies the flavor of the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[int] instance_limit: The maximum number of the microservice instance resources.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice engine.
               The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter and cannot end with a hyphen (-).
               Changing this will create a new engine.
        :param pulumi.Input[str] network_id: Specifies the network ID of the subnet to which the dedicated microservice
               engine belongs. Changing this will create a new engine.
        :param pulumi.Input[str] region: Specifies the region in which to create the dedicated microservice engine.
               If omitted, the provider-level region will be used. Changing this will create a new engine.
        :param pulumi.Input[int] service_limit: The maximum number of the microservice resources.
        :param pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineServiceRegistryAddressArgs']]] service_registry_addresses: The connection address of service center.
               The object structure is documented below.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice engine. The value can be:
               **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        if admin_pass is not None:
            pulumi.set(__self__, "admin_pass", admin_pass)
        if auth_type is not None:
            pulumi.set(__self__, "auth_type", auth_type)
        if availability_zones is not None:
            pulumi.set(__self__, "availability_zones", availability_zones)
        if config_center_addresses is not None:
            pulumi.set(__self__, "config_center_addresses", config_center_addresses)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if extend_params is not None:
            pulumi.set(__self__, "extend_params", extend_params)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if instance_limit is not None:
            pulumi.set(__self__, "instance_limit", instance_limit)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if service_limit is not None:
            pulumi.set(__self__, "service_limit", service_limit)
        if service_registry_addresses is not None:
            pulumi.set(__self__, "service_registry_addresses", service_registry_addresses)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the account password. The corresponding account name is **root**.
        Required if `auth_type` is **RBAC**. Changing this will create a new engine.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @admin_pass.setter
    def admin_pass(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "admin_pass", value)

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the authentication method for the dedicated microservice engine.
        Changing this will create a new engine.
        + **RBAC**: Enable security authentication.
        Security authentication applies to the scenario where multiple users use the same engine.
        After security authentication is enabled, all users who use the engine can log in using the account and password.
        You can assign the account and role in the System Management.
        + **NONE**: Disable security authentication.
        After security authentication is disabled, all users who use the engine can use the engine without using the account
        and password, and have the same operation permissions on all services.
        """
        return pulumi.get(self, "auth_type")

    @auth_type.setter
    def auth_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "auth_type", value)

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of availability zone.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "availability_zones")

    @availability_zones.setter
    def availability_zones(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "availability_zones", value)

    @property
    @pulumi.getter(name="configCenterAddresses")
    def config_center_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineConfigCenterAddressArgs']]]]:
        """
        The address of config center.
        The object structure is documented below.
        """
        return pulumi.get(self, "config_center_addresses")

    @config_center_addresses.setter
    def config_center_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineConfigCenterAddressArgs']]]]):
        pulumi.set(self, "config_center_addresses", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the dedicated microservice engine.
        The description can contian a maximum of `255` characters.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the EIP ID to which the dedicated microservice engine assocated.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the additional parameters for the dedicated microservice engine.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "extend_params")

    @extend_params.setter
    def extend_params(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "extend_params", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the flavor of the dedicated microservice engine.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter(name="instanceLimit")
    def instance_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of the microservice instance resources.
        """
        return pulumi.get(self, "instance_limit")

    @instance_limit.setter
    def instance_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_limit", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the dedicated microservice engine.
        The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter and cannot end with a hyphen (-).
        Changing this will create a new engine.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the network ID of the subnet to which the dedicated microservice
        engine belongs. Changing this will create a new engine.
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to create the dedicated microservice engine.
        If omitted, the provider-level region will be used. Changing this will create a new engine.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="serviceLimit")
    def service_limit(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum number of the microservice resources.
        """
        return pulumi.get(self, "service_limit")

    @service_limit.setter
    def service_limit(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "service_limit", value)

    @property
    @pulumi.getter(name="serviceRegistryAddresses")
    def service_registry_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineServiceRegistryAddressArgs']]]]:
        """
        The connection address of service center.
        The object structure is documented below.
        """
        return pulumi.get(self, "service_registry_addresses")

    @service_registry_addresses.setter
    def service_registry_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MicroserviceEngineServiceRegistryAddressArgs']]]]):
        pulumi.set(self, "service_registry_addresses", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the version of the dedicated microservice engine. The value can be:
        **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class MicroserviceEngine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 extend_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a dedicated microservice engine (2.0+) resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        engine_name = config.require_object("engineName")
        network_id = config.require_object("networkId")
        az1 = config.require_object("az1")
        test = huaweicloud.cse.MicroserviceEngine("test",
            flavor="cse.s1.small2",
            network_id=network_id,
            auth_type="NONE",
            availability_zones=[az1])
        ```

        ## Import

        Engines can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microserviceEngine:MicroserviceEngine test eddc5d42-f9d5-4f8e-984b-d6f3e088561c
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes are `admin_pass` and `extend_params`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_cse_microservice_engine" "test" {

         ...

         lifecycle {

         ignore_changes = [

         admin_pass,

         extend_params,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the account password. The corresponding account name is **root**.
               Required if `auth_type` is **RBAC**. Changing this will create a new engine.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] auth_type: Specifies the authentication method for the dedicated microservice engine.
               Changing this will create a new engine.
               + **RBAC**: Enable security authentication.
               Security authentication applies to the scenario where multiple users use the same engine.
               After security authentication is enabled, all users who use the engine can log in using the account and password.
               You can assign the account and role in the System Management.
               + **NONE**: Disable security authentication.
               After security authentication is disabled, all users who use the engine can use the engine without using the account
               and password, and have the same operation permissions on all services.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of availability zone.
               Changing this will create a new engine.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice engine.
               The description can contian a maximum of `255` characters.
               Changing this will create a new engine.
        :param pulumi.Input[str] eip_id: Specifies the EIP ID to which the dedicated microservice engine assocated.
               Changing this will create a new engine.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_params: Specifies the additional parameters for the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[str] flavor: Specifies the flavor of the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice engine.
               The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter and cannot end with a hyphen (-).
               Changing this will create a new engine.
        :param pulumi.Input[str] network_id: Specifies the network ID of the subnet to which the dedicated microservice
               engine belongs. Changing this will create a new engine.
        :param pulumi.Input[str] region: Specifies the region in which to create the dedicated microservice engine.
               If omitted, the provider-level region will be used. Changing this will create a new engine.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice engine. The value can be:
               **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MicroserviceEngineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a dedicated microservice engine (2.0+) resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        engine_name = config.require_object("engineName")
        network_id = config.require_object("networkId")
        az1 = config.require_object("az1")
        test = huaweicloud.cse.MicroserviceEngine("test",
            flavor="cse.s1.small2",
            network_id=network_id,
            auth_type="NONE",
            availability_zones=[az1])
        ```

        ## Import

        Engines can be imported using their `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/microserviceEngine:MicroserviceEngine test eddc5d42-f9d5-4f8e-984b-d6f3e088561c
        ```

         Note that the imported state may not be identical to your resource definition, due to some attributes missing from the API response, security or some other reason. The missing attributes are `admin_pass` and `extend_params`. It is generally recommended running `terraform plan` after importing an instance. You can then decide if changes should be applied to the instance, or the resource definition should be updated to align with the instance. Also you can ignore changes as below. resource "huaweicloud_cse_microservice_engine" "test" {

         ...

         lifecycle {

         ignore_changes = [

         admin_pass,

         extend_params,

         ]

         } }

        :param str resource_name: The name of the resource.
        :param MicroserviceEngineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MicroserviceEngineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_pass: Optional[pulumi.Input[str]] = None,
                 auth_type: Optional[pulumi.Input[str]] = None,
                 availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 extend_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MicroserviceEngineArgs.__new__(MicroserviceEngineArgs)

            __props__.__dict__["admin_pass"] = admin_pass
            if auth_type is None and not opts.urn:
                raise TypeError("Missing required property 'auth_type'")
            __props__.__dict__["auth_type"] = auth_type
            if availability_zones is None and not opts.urn:
                raise TypeError("Missing required property 'availability_zones'")
            __props__.__dict__["availability_zones"] = availability_zones
            __props__.__dict__["description"] = description
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            __props__.__dict__["extend_params"] = extend_params
            if flavor is None and not opts.urn:
                raise TypeError("Missing required property 'flavor'")
            __props__.__dict__["flavor"] = flavor
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["region"] = region
            __props__.__dict__["version"] = version
            __props__.__dict__["config_center_addresses"] = None
            __props__.__dict__["instance_limit"] = None
            __props__.__dict__["service_limit"] = None
            __props__.__dict__["service_registry_addresses"] = None
        super(MicroserviceEngine, __self__).__init__(
            'huaweicloud:Cse/microserviceEngine:MicroserviceEngine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            admin_pass: Optional[pulumi.Input[str]] = None,
            auth_type: Optional[pulumi.Input[str]] = None,
            availability_zones: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            config_center_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MicroserviceEngineConfigCenterAddressArgs']]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            extend_params: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            flavor: Optional[pulumi.Input[str]] = None,
            instance_limit: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            service_limit: Optional[pulumi.Input[int]] = None,
            service_registry_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MicroserviceEngineServiceRegistryAddressArgs']]]]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'MicroserviceEngine':
        """
        Get an existing MicroserviceEngine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_pass: Specifies the account password. The corresponding account name is **root**.
               Required if `auth_type` is **RBAC**. Changing this will create a new engine.
               The password format must meet the following conditions:
               + Must be `8` to `32` characters long.
               + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
               (-~!@#%^*_=+?$&()|<>{}[]).
               + Cannot be the account name or account name spelled backwards.
               + The password can only start with a letter.
        :param pulumi.Input[str] auth_type: Specifies the authentication method for the dedicated microservice engine.
               Changing this will create a new engine.
               + **RBAC**: Enable security authentication.
               Security authentication applies to the scenario where multiple users use the same engine.
               After security authentication is enabled, all users who use the engine can log in using the account and password.
               You can assign the account and role in the System Management.
               + **NONE**: Disable security authentication.
               After security authentication is disabled, all users who use the engine can use the engine without using the account
               and password, and have the same operation permissions on all services.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] availability_zones: Specifies the list of availability zone.
               Changing this will create a new engine.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MicroserviceEngineConfigCenterAddressArgs']]]] config_center_addresses: The address of config center.
               The object structure is documented below.
        :param pulumi.Input[str] description: Specifies the description of the dedicated microservice engine.
               The description can contian a maximum of `255` characters.
               Changing this will create a new engine.
        :param pulumi.Input[str] eip_id: Specifies the EIP ID to which the dedicated microservice engine assocated.
               Changing this will create a new engine.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] extend_params: Specifies the additional parameters for the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[str] flavor: Specifies the flavor of the dedicated microservice engine.
               Changing this will create a new engine.
        :param pulumi.Input[int] instance_limit: The maximum number of the microservice instance resources.
        :param pulumi.Input[str] name: Specifies the name of the dedicated microservice engine.
               The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
               The name must start with a letter and cannot end with a hyphen (-).
               Changing this will create a new engine.
        :param pulumi.Input[str] network_id: Specifies the network ID of the subnet to which the dedicated microservice
               engine belongs. Changing this will create a new engine.
        :param pulumi.Input[str] region: Specifies the region in which to create the dedicated microservice engine.
               If omitted, the provider-level region will be used. Changing this will create a new engine.
        :param pulumi.Input[int] service_limit: The maximum number of the microservice resources.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['MicroserviceEngineServiceRegistryAddressArgs']]]] service_registry_addresses: The connection address of service center.
               The object structure is documented below.
        :param pulumi.Input[str] version: Specifies the version of the dedicated microservice engine. The value can be:
               **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MicroserviceEngineState.__new__(_MicroserviceEngineState)

        __props__.__dict__["admin_pass"] = admin_pass
        __props__.__dict__["auth_type"] = auth_type
        __props__.__dict__["availability_zones"] = availability_zones
        __props__.__dict__["config_center_addresses"] = config_center_addresses
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["extend_params"] = extend_params
        __props__.__dict__["flavor"] = flavor
        __props__.__dict__["instance_limit"] = instance_limit
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["region"] = region
        __props__.__dict__["service_limit"] = service_limit
        __props__.__dict__["service_registry_addresses"] = service_registry_addresses
        __props__.__dict__["version"] = version
        return MicroserviceEngine(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="adminPass")
    def admin_pass(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the account password. The corresponding account name is **root**.
        Required if `auth_type` is **RBAC**. Changing this will create a new engine.
        The password format must meet the following conditions:
        + Must be `8` to `32` characters long.
        + A password must contain at least one digit, one uppercase letter, one lowercase letter, and one special character
        (-~!@#%^*_=+?$&()|<>{}[]).
        + Cannot be the account name or account name spelled backwards.
        + The password can only start with a letter.
        """
        return pulumi.get(self, "admin_pass")

    @property
    @pulumi.getter(name="authType")
    def auth_type(self) -> pulumi.Output[str]:
        """
        Specifies the authentication method for the dedicated microservice engine.
        Changing this will create a new engine.
        + **RBAC**: Enable security authentication.
        Security authentication applies to the scenario where multiple users use the same engine.
        After security authentication is enabled, all users who use the engine can log in using the account and password.
        You can assign the account and role in the System Management.
        + **NONE**: Disable security authentication.
        After security authentication is disabled, all users who use the engine can use the engine without using the account
        and password, and have the same operation permissions on all services.
        """
        return pulumi.get(self, "auth_type")

    @property
    @pulumi.getter(name="availabilityZones")
    def availability_zones(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the list of availability zone.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "availability_zones")

    @property
    @pulumi.getter(name="configCenterAddresses")
    def config_center_addresses(self) -> pulumi.Output[Sequence['outputs.MicroserviceEngineConfigCenterAddress']]:
        """
        The address of config center.
        The object structure is documented below.
        """
        return pulumi.get(self, "config_center_addresses")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the dedicated microservice engine.
        The description can contian a maximum of `255` characters.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the EIP ID to which the dedicated microservice engine assocated.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="extendParams")
    def extend_params(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Specifies the additional parameters for the dedicated microservice engine.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "extend_params")

    @property
    @pulumi.getter
    def flavor(self) -> pulumi.Output[str]:
        """
        Specifies the flavor of the dedicated microservice engine.
        Changing this will create a new engine.
        """
        return pulumi.get(self, "flavor")

    @property
    @pulumi.getter(name="instanceLimit")
    def instance_limit(self) -> pulumi.Output[int]:
        """
        The maximum number of the microservice instance resources.
        """
        return pulumi.get(self, "instance_limit")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the dedicated microservice engine.
        The name can contain `3` to `24` characters, only letters, digits and hyphens (-) are allowed.
        The name must start with a letter and cannot end with a hyphen (-).
        Changing this will create a new engine.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        Specifies the network ID of the subnet to which the dedicated microservice
        engine belongs. Changing this will create a new engine.
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to create the dedicated microservice engine.
        If omitted, the provider-level region will be used. Changing this will create a new engine.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="serviceLimit")
    def service_limit(self) -> pulumi.Output[int]:
        """
        The maximum number of the microservice resources.
        """
        return pulumi.get(self, "service_limit")

    @property
    @pulumi.getter(name="serviceRegistryAddresses")
    def service_registry_addresses(self) -> pulumi.Output[Sequence['outputs.MicroserviceEngineServiceRegistryAddress']]:
        """
        The connection address of service center.
        The object structure is documented below.
        """
        return pulumi.get(self, "service_registry_addresses")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the version of the dedicated microservice engine. The value can be:
        **CSE2**. Defaults to: **CSE2**. Changing this will create a new engine.
        """
        return pulumi.get(self, "version")

