# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmruleArgs', 'Alarmrule']

@pulumi.input_type
class AlarmruleArgs:
    def __init__(__self__, *,
                 alarm_name: pulumi.Input[str],
                 condition: pulumi.Input['AlarmruleConditionArgs'],
                 metric: pulumi.Input['AlarmruleMetricArgs'],
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]] = None,
                 alarm_description: Optional[pulumi.Input[str]] = None,
                 alarm_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 alarm_type: Optional[pulumi.Input[str]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Alarmrule resource.
        :param pulumi.Input[str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input['AlarmruleConditionArgs'] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input['AlarmruleMetricArgs'] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below. Changing this creates a new resource.
        :param pulumi.Input[str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be 1, 2, 3 or 4,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is 2.
        :param pulumi.Input[str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
               or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "alarm_name", alarm_name)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "metric", metric)
        if alarm_action_enabled is not None:
            pulumi.set(__self__, "alarm_action_enabled", alarm_action_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if alarm_enabled is not None:
            pulumi.set(__self__, "alarm_enabled", alarm_enabled)
        if alarm_level is not None:
            pulumi.set(__self__, "alarm_level", alarm_level)
        if alarm_type is not None:
            pulumi.set(__self__, "alarm_type", alarm_type)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if insufficientdata_actions is not None:
            warnings.warn("""insufficientdata_actions is deprecated""", DeprecationWarning)
            pulumi.log.warn("""insufficientdata_actions is deprecated: insufficientdata_actions is deprecated""")
        if insufficientdata_actions is not None:
            pulumi.set(__self__, "insufficientdata_actions", insufficientdata_actions)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of an alarm rule. The value can be a string of 1 to 128
        characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "alarm_name", value)

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Input['AlarmruleConditionArgs']:
        """
        Specifies the alarm triggering condition. The structure is described below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: pulumi.Input['AlarmruleConditionArgs']):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Input['AlarmruleMetricArgs']:
        """
        Specifies the alarm metrics. The structure is described below. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: pulumi.Input['AlarmruleMetricArgs']):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm. The
        default value is true.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @alarm_action_enabled.setter
    def alarm_action_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_action_enabled", value)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]:
        """
        Specifies the action triggered by an alarm. The structure is described
        below. Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]):
        pulumi.set(self, "alarm_actions", value)

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[str]]:
        """
        The value can be a string of 0 to 256 characters.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_description", value)

    @property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the alarm. The default value is true.
        """
        return pulumi.get(self, "alarm_enabled")

    @alarm_enabled.setter
    def alarm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_enabled", value)

    @property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the alarm severity. The value can be 1, 2, 3 or 4,
        which indicates *critical*, *major*, *minor*, and *informational*, respectively.
        The default value is 2.
        """
        return pulumi.get(self, "alarm_level")

    @alarm_level.setter
    def alarm_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alarm_level", value)

    @property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
        or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        """
        return pulumi.get(self, "alarm_type")

    @alarm_type.setter
    def alarm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_type", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the alarm rule. Changing
        this creates a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="insufficientdataActions")
    def insufficientdata_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]:
        return pulumi.get(self, "insufficientdata_actions")

    @insufficientdata_actions.setter
    def insufficientdata_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]):
        pulumi.set(self, "insufficientdata_actions", value)

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]:
        """
        Specifies the action triggered by the clearing of an alarm. The structure is
        described below. Changing this creates a new resource.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]):
        pulumi.set(self, "ok_actions", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AlarmruleState:
    def __init__(__self__, *,
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]] = None,
                 alarm_description: Optional[pulumi.Input[str]] = None,
                 alarm_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 alarm_name: Optional[pulumi.Input[str]] = None,
                 alarm_state: Optional[pulumi.Input[str]] = None,
                 alarm_type: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input['AlarmruleConditionArgs']] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]] = None,
                 metric: Optional[pulumi.Input['AlarmruleMetricArgs']] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Alarmrule resources.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below. Changing this creates a new resource.
        :param pulumi.Input[str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be 1, 2, 3 or 4,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is 2.
        :param pulumi.Input[str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input[str] alarm_state: Indicates the alarm status. The value can be:
               + ok: The alarm status is normal;
               + alarm: An alarm is generated;
               + insufficient_data: The required data is insufficient.
        :param pulumi.Input[str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
               or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input['AlarmruleConditionArgs'] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
        :param pulumi.Input['AlarmruleMetricArgs'] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] update_time: Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        if alarm_action_enabled is not None:
            pulumi.set(__self__, "alarm_action_enabled", alarm_action_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_description is not None:
            pulumi.set(__self__, "alarm_description", alarm_description)
        if alarm_enabled is not None:
            pulumi.set(__self__, "alarm_enabled", alarm_enabled)
        if alarm_level is not None:
            pulumi.set(__self__, "alarm_level", alarm_level)
        if alarm_name is not None:
            pulumi.set(__self__, "alarm_name", alarm_name)
        if alarm_state is not None:
            pulumi.set(__self__, "alarm_state", alarm_state)
        if alarm_type is not None:
            pulumi.set(__self__, "alarm_type", alarm_type)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if enterprise_project_id is not None:
            pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if insufficientdata_actions is not None:
            warnings.warn("""insufficientdata_actions is deprecated""", DeprecationWarning)
            pulumi.log.warn("""insufficientdata_actions is deprecated: insufficientdata_actions is deprecated""")
        if insufficientdata_actions is not None:
            pulumi.set(__self__, "insufficientdata_actions", insufficientdata_actions)
        if metric is not None:
            pulumi.set(__self__, "metric", metric)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm. The
        default value is true.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @alarm_action_enabled.setter
    def alarm_action_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_action_enabled", value)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]:
        """
        Specifies the action triggered by an alarm. The structure is described
        below. Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleAlarmActionArgs']]]]):
        pulumi.set(self, "alarm_actions", value)

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> Optional[pulumi.Input[str]]:
        """
        The value can be a string of 0 to 256 characters.
        """
        return pulumi.get(self, "alarm_description")

    @alarm_description.setter
    def alarm_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_description", value)

    @property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the alarm. The default value is true.
        """
        return pulumi.get(self, "alarm_enabled")

    @alarm_enabled.setter
    def alarm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_enabled", value)

    @property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the alarm severity. The value can be 1, 2, 3 or 4,
        which indicates *critical*, *major*, *minor*, and *informational*, respectively.
        The default value is 2.
        """
        return pulumi.get(self, "alarm_level")

    @alarm_level.setter
    def alarm_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alarm_level", value)

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of an alarm rule. The value can be a string of 1 to 128
        characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        """
        return pulumi.get(self, "alarm_name")

    @alarm_name.setter
    def alarm_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_name", value)

    @property
    @pulumi.getter(name="alarmState")
    def alarm_state(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the alarm status. The value can be:
        + ok: The alarm status is normal;
        + alarm: An alarm is generated;
        + insufficient_data: The required data is insufficient.
        """
        return pulumi.get(self, "alarm_state")

    @alarm_state.setter
    def alarm_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_state", value)

    @property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
        or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        """
        return pulumi.get(self, "alarm_type")

    @alarm_type.setter
    def alarm_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_type", value)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['AlarmruleConditionArgs']]:
        """
        Specifies the alarm triggering condition. The structure is described below.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['AlarmruleConditionArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the enterprise project id of the alarm rule. Changing
        this creates a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @enterprise_project_id.setter
    def enterprise_project_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_project_id", value)

    @property
    @pulumi.getter(name="insufficientdataActions")
    def insufficientdata_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]:
        return pulumi.get(self, "insufficientdata_actions")

    @insufficientdata_actions.setter
    def insufficientdata_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleInsufficientdataActionArgs']]]]):
        pulumi.set(self, "insufficientdata_actions", value)

    @property
    @pulumi.getter
    def metric(self) -> Optional[pulumi.Input['AlarmruleMetricArgs']]:
        """
        Specifies the alarm metrics. The structure is described below. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "metric")

    @metric.setter
    def metric(self, value: Optional[pulumi.Input['AlarmruleMetricArgs']]):
        pulumi.set(self, "metric", value)

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]:
        """
        Specifies the action triggered by the clearing of an alarm. The structure is
        described below. Changing this creates a new resource.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmruleOkActionArgs']]]]):
        pulumi.set(self, "ok_actions", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[int]]:
        """
        Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "update_time", value)


class Alarmrule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleAlarmActionArgs']]]]] = None,
                 alarm_description: Optional[pulumi.Input[str]] = None,
                 alarm_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 alarm_name: Optional[pulumi.Input[str]] = None,
                 alarm_type: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[pulumi.InputType['AlarmruleConditionArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleInsufficientdataActionArgs']]]]] = None,
                 metric: Optional[pulumi.Input[pulumi.InputType['AlarmruleMetricArgs']]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleOkActionArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages a Cloud Eye alarm rule resource within HuaweiCloud.

        ## Example Usage
        ### Basic example

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.cse.Alarmrule("alarmRule",
            alarm_name="alarm_rule",
            metric=huaweicloud.cse.AlarmruleMetricArgs(
                namespace="SYS.ECS",
                metric_name="network_outgoing_bytes_rate_inband",
                dimensions=[huaweicloud.cse.AlarmruleMetricDimensionArgs(
                    name="instance_id",
                    value=var["webserver_instance_id"],
                )],
            ),
            condition=huaweicloud.cse.AlarmruleConditionArgs(
                period=300,
                filter="average",
                comparison_operator=">",
                value=6,
                unit="B/s",
                count=1,
            ),
            alarm_actions=[huaweicloud.cse.AlarmruleAlarmActionArgs(
                type="notification",
                notification_lists=[var["smn_topic_id"]],
            )])
        ```
        ## Alarm rule for event monitoring

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.cse.Alarmrule("alarmRule",
            alarm_name="alarm_rule",
            alarm_action_enabled=True,
            alarm_type="EVENT.SYS",
            metric=huaweicloud.cse.AlarmruleMetricArgs(
                namespace="SYS.ECS",
                metric_name="stopServer",
            ),
            condition=huaweicloud.cse.AlarmruleConditionArgs(
                period=0,
                filter="average",
                comparison_operator=">=",
                value=1,
                unit="count",
                count=1,
            ),
            alarm_actions=[huaweicloud.cse.AlarmruleAlarmActionArgs(
                type="notification",
                notification_lists=[var["smn_topic_id"]],
            )])
        ```

        ## Import

        CES alarm rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/alarmrule:Alarmrule alarm_rule al1619578509719Ga0X1RGWv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleAlarmActionArgs']]]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below. Changing this creates a new resource.
        :param pulumi.Input[str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be 1, 2, 3 or 4,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is 2.
        :param pulumi.Input[str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input[str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
               or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input[pulumi.InputType['AlarmruleConditionArgs']] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
        :param pulumi.Input[pulumi.InputType['AlarmruleMetricArgs']] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleOkActionArgs']]]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmruleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cloud Eye alarm rule resource within HuaweiCloud.

        ## Example Usage
        ### Basic example

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.cse.Alarmrule("alarmRule",
            alarm_name="alarm_rule",
            metric=huaweicloud.cse.AlarmruleMetricArgs(
                namespace="SYS.ECS",
                metric_name="network_outgoing_bytes_rate_inband",
                dimensions=[huaweicloud.cse.AlarmruleMetricDimensionArgs(
                    name="instance_id",
                    value=var["webserver_instance_id"],
                )],
            ),
            condition=huaweicloud.cse.AlarmruleConditionArgs(
                period=300,
                filter="average",
                comparison_operator=">",
                value=6,
                unit="B/s",
                count=1,
            ),
            alarm_actions=[huaweicloud.cse.AlarmruleAlarmActionArgs(
                type="notification",
                notification_lists=[var["smn_topic_id"]],
            )])
        ```
        ## Alarm rule for event monitoring

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.cse.Alarmrule("alarmRule",
            alarm_name="alarm_rule",
            alarm_action_enabled=True,
            alarm_type="EVENT.SYS",
            metric=huaweicloud.cse.AlarmruleMetricArgs(
                namespace="SYS.ECS",
                metric_name="stopServer",
            ),
            condition=huaweicloud.cse.AlarmruleConditionArgs(
                period=0,
                filter="average",
                comparison_operator=">=",
                value=1,
                unit="count",
                count=1,
            ),
            alarm_actions=[huaweicloud.cse.AlarmruleAlarmActionArgs(
                type="notification",
                notification_lists=[var["smn_topic_id"]],
            )])
        ```

        ## Import

        CES alarm rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Cse/alarmrule:Alarmrule alarm_rule al1619578509719Ga0X1RGWv
        ```

        :param str resource_name: The name of the resource.
        :param AlarmruleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmruleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleAlarmActionArgs']]]]] = None,
                 alarm_description: Optional[pulumi.Input[str]] = None,
                 alarm_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 alarm_name: Optional[pulumi.Input[str]] = None,
                 alarm_type: Optional[pulumi.Input[str]] = None,
                 condition: Optional[pulumi.Input[pulumi.InputType['AlarmruleConditionArgs']]] = None,
                 enterprise_project_id: Optional[pulumi.Input[str]] = None,
                 insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleInsufficientdataActionArgs']]]]] = None,
                 metric: Optional[pulumi.Input[pulumi.InputType['AlarmruleMetricArgs']]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleOkActionArgs']]]]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmruleArgs.__new__(AlarmruleArgs)

            __props__.__dict__["alarm_action_enabled"] = alarm_action_enabled
            __props__.__dict__["alarm_actions"] = alarm_actions
            __props__.__dict__["alarm_description"] = alarm_description
            __props__.__dict__["alarm_enabled"] = alarm_enabled
            __props__.__dict__["alarm_level"] = alarm_level
            if alarm_name is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_name'")
            __props__.__dict__["alarm_name"] = alarm_name
            __props__.__dict__["alarm_type"] = alarm_type
            if condition is None and not opts.urn:
                raise TypeError("Missing required property 'condition'")
            __props__.__dict__["condition"] = condition
            __props__.__dict__["enterprise_project_id"] = enterprise_project_id
            if insufficientdata_actions is not None and not opts.urn:
                warnings.warn("""insufficientdata_actions is deprecated""", DeprecationWarning)
                pulumi.log.warn("""insufficientdata_actions is deprecated: insufficientdata_actions is deprecated""")
            __props__.__dict__["insufficientdata_actions"] = insufficientdata_actions
            if metric is None and not opts.urn:
                raise TypeError("Missing required property 'metric'")
            __props__.__dict__["metric"] = metric
            __props__.__dict__["ok_actions"] = ok_actions
            __props__.__dict__["region"] = region
            __props__.__dict__["alarm_state"] = None
            __props__.__dict__["update_time"] = None
        super(Alarmrule, __self__).__init__(
            'huaweicloud:Cse/alarmrule:Alarmrule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
            alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleAlarmActionArgs']]]]] = None,
            alarm_description: Optional[pulumi.Input[str]] = None,
            alarm_enabled: Optional[pulumi.Input[bool]] = None,
            alarm_level: Optional[pulumi.Input[int]] = None,
            alarm_name: Optional[pulumi.Input[str]] = None,
            alarm_state: Optional[pulumi.Input[str]] = None,
            alarm_type: Optional[pulumi.Input[str]] = None,
            condition: Optional[pulumi.Input[pulumi.InputType['AlarmruleConditionArgs']]] = None,
            enterprise_project_id: Optional[pulumi.Input[str]] = None,
            insufficientdata_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleInsufficientdataActionArgs']]]]] = None,
            metric: Optional[pulumi.Input[pulumi.InputType['AlarmruleMetricArgs']]] = None,
            ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleOkActionArgs']]]]] = None,
            region: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[int]] = None) -> 'Alarmrule':
        """
        Get an existing Alarmrule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm. The
               default value is true.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleAlarmActionArgs']]]] alarm_actions: Specifies the action triggered by an alarm. The structure is described
               below. Changing this creates a new resource.
        :param pulumi.Input[str] alarm_description: The value can be a string of 0 to 256 characters.
        :param pulumi.Input[bool] alarm_enabled: Specifies whether to enable the alarm. The default value is true.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be 1, 2, 3 or 4,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is 2.
        :param pulumi.Input[str] alarm_name: Specifies the name of an alarm rule. The value can be a string of 1 to 128
               characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        :param pulumi.Input[str] alarm_state: Indicates the alarm status. The value can be:
               + ok: The alarm status is normal;
               + alarm: An alarm is generated;
               + insufficient_data: The required data is insufficient.
        :param pulumi.Input[str] alarm_type: Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
               or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        :param pulumi.Input[pulumi.InputType['AlarmruleConditionArgs']] condition: Specifies the alarm triggering condition. The structure is described below.
        :param pulumi.Input[str] enterprise_project_id: Specifies the enterprise project id of the alarm rule. Changing
               this creates a new resource.
        :param pulumi.Input[pulumi.InputType['AlarmruleMetricArgs']] metric: Specifies the alarm metrics. The structure is described below. Changing this
               creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmruleOkActionArgs']]]] ok_actions: Specifies the action triggered by the clearing of an alarm. The structure is
               described below. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] update_time: Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmruleState.__new__(_AlarmruleState)

        __props__.__dict__["alarm_action_enabled"] = alarm_action_enabled
        __props__.__dict__["alarm_actions"] = alarm_actions
        __props__.__dict__["alarm_description"] = alarm_description
        __props__.__dict__["alarm_enabled"] = alarm_enabled
        __props__.__dict__["alarm_level"] = alarm_level
        __props__.__dict__["alarm_name"] = alarm_name
        __props__.__dict__["alarm_state"] = alarm_state
        __props__.__dict__["alarm_type"] = alarm_type
        __props__.__dict__["condition"] = condition
        __props__.__dict__["enterprise_project_id"] = enterprise_project_id
        __props__.__dict__["insufficientdata_actions"] = insufficientdata_actions
        __props__.__dict__["metric"] = metric
        __props__.__dict__["ok_actions"] = ok_actions
        __props__.__dict__["region"] = region
        __props__.__dict__["update_time"] = update_time
        return Alarmrule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm. The
        default value is true.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmruleAlarmAction']]]:
        """
        Specifies the action triggered by an alarm. The structure is described
        below. Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_actions")

    @property
    @pulumi.getter(name="alarmDescription")
    def alarm_description(self) -> pulumi.Output[Optional[str]]:
        """
        The value can be a string of 0 to 256 characters.
        """
        return pulumi.get(self, "alarm_description")

    @property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the alarm. The default value is true.
        """
        return pulumi.get(self, "alarm_enabled")

    @property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the alarm severity. The value can be 1, 2, 3 or 4,
        which indicates *critical*, *major*, *minor*, and *informational*, respectively.
        The default value is 2.
        """
        return pulumi.get(self, "alarm_level")

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> pulumi.Output[str]:
        """
        Specifies the name of an alarm rule. The value can be a string of 1 to 128
        characters that can consist of letters, digits, underscores (_), hyphens (-) and chinese characters.
        """
        return pulumi.get(self, "alarm_name")

    @property
    @pulumi.getter(name="alarmState")
    def alarm_state(self) -> pulumi.Output[str]:
        """
        Indicates the alarm status. The value can be:
        + ok: The alarm status is normal;
        + alarm: An alarm is generated;
        + insufficient_data: The required data is insufficient.
        """
        return pulumi.get(self, "alarm_state")

    @property
    @pulumi.getter(name="alarmType")
    def alarm_type(self) -> pulumi.Output[str]:
        """
        Specifies the alarm type. The value can be **EVENT.SYS**, **EVENT.CUSTOM**
        or **MULTI_INSTANCE**. Defaults to **MULTI_INSTANCE**.
        """
        return pulumi.get(self, "alarm_type")

    @property
    @pulumi.getter
    def condition(self) -> pulumi.Output['outputs.AlarmruleCondition']:
        """
        Specifies the alarm triggering condition. The structure is described below.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> pulumi.Output[str]:
        """
        Specifies the enterprise project id of the alarm rule. Changing
        this creates a new resource.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter(name="insufficientdataActions")
    def insufficientdata_actions(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmruleInsufficientdataAction']]]:
        return pulumi.get(self, "insufficientdata_actions")

    @property
    @pulumi.getter
    def metric(self) -> pulumi.Output['outputs.AlarmruleMetric']:
        """
        Specifies the alarm metrics. The structure is described below. Changing this
        creates a new resource.
        """
        return pulumi.get(self, "metric")

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> pulumi.Output[Optional[Sequence['outputs.AlarmruleOkAction']]]:
        """
        Specifies the action triggered by the clearing of an alarm. The structure is
        described below. Changing this creates a new resource.
        """
        return pulumi.get(self, "ok_actions")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[int]:
        """
        Indicates the time when the alarm status changed. The value is a UNIX timestamp and the unit is ms.
        """
        return pulumi.get(self, "update_time")

