# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'ClusterInstance',
    'JobConfig',
    'GetFlavorsFlavorResult',
]

@pulumi.output_type
class ClusterInstance(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "manageIp":
            suggest = "manage_ip"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "trafficIp":
            suggest = "traffic_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterInstance. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterInstance.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterInstance.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 id: Optional[str] = None,
                 manage_ip: Optional[str] = None,
                 name: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 public_ip: Optional[str] = None,
                 role: Optional[str] = None,
                 traffic_ip: Optional[str] = None,
                 type: Optional[str] = None):
        """
        :param str id: Instance ID.
        :param str manage_ip: Management IP address.
        :param str name: Specifies cluster name. Changing this parameter will create a new resource.
        :param str private_ip: Private IP.
        :param str public_ip: Public IP.
        :param str role: Instance role.
        :param str traffic_ip: Traffic IP.
        :param str type: Instance type.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if manage_ip is not None:
            pulumi.set(__self__, "manage_ip", manage_ip)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if traffic_ip is not None:
            pulumi.set(__self__, "traffic_ip", traffic_ip)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="manageIp")
    def manage_ip(self) -> Optional[str]:
        """
        Management IP address.
        """
        return pulumi.get(self, "manage_ip")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Specifies cluster name. Changing this parameter will create a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        Private IP.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        Public IP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def role(self) -> Optional[str]:
        """
        Instance role.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="trafficIp")
    def traffic_ip(self) -> Optional[str]:
        """
        Traffic IP.
        """
        return pulumi.get(self, "traffic_ip")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        Instance type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class JobConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "groupName":
            suggest = "group_name"
        elif key == "retryType":
            suggest = "retry_type"
        elif key == "schedulerCycle":
            suggest = "scheduler_cycle"
        elif key == "schedulerCycleType":
            suggest = "scheduler_cycle_type"
        elif key == "schedulerDisposableType":
            suggest = "scheduler_disposable_type"
        elif key == "schedulerEnabled":
            suggest = "scheduler_enabled"
        elif key == "schedulerRunAt":
            suggest = "scheduler_run_at"
        elif key == "schedulerStartDate":
            suggest = "scheduler_start_date"
        elif key == "schedulerStopDate":
            suggest = "scheduler_stop_date"
        elif key == "throttlingDirtyWriteToBucket":
            suggest = "throttling_dirty_write_to_bucket"
        elif key == "throttlingDirtyWriteToDirectory":
            suggest = "throttling_dirty_write_to_directory"
        elif key == "throttlingDirtyWriteToLink":
            suggest = "throttling_dirty_write_to_link"
        elif key == "throttlingExtractorsNumber":
            suggest = "throttling_extractors_number"
        elif key == "throttlingLoaderNumber":
            suggest = "throttling_loader_number"
        elif key == "throttlingMaxErrorRecords":
            suggest = "throttling_max_error_records"
        elif key == "throttlingRecordDirtyData":
            suggest = "throttling_record_dirty_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 group_name: Optional[str] = None,
                 retry_type: Optional[str] = None,
                 scheduler_cycle: Optional[int] = None,
                 scheduler_cycle_type: Optional[str] = None,
                 scheduler_disposable_type: Optional[str] = None,
                 scheduler_enabled: Optional[bool] = None,
                 scheduler_run_at: Optional[str] = None,
                 scheduler_start_date: Optional[str] = None,
                 scheduler_stop_date: Optional[str] = None,
                 throttling_dirty_write_to_bucket: Optional[str] = None,
                 throttling_dirty_write_to_directory: Optional[str] = None,
                 throttling_dirty_write_to_link: Optional[str] = None,
                 throttling_extractors_number: Optional[int] = None,
                 throttling_loader_number: Optional[int] = None,
                 throttling_max_error_records: Optional[int] = None,
                 throttling_record_dirty_data: Optional[bool] = None):
        """
        :param str group_name: Specifies group to which a job belongs. The default group is `DEFAULT`.
        :param str retry_type: Specifies whether to automatically retry if a job fails to be executed.
               The options are as follows:
               + **NONE**: Do not retry.
               + **RETRY_TRIPLE**: Retry three times.
        :param int scheduler_cycle: Specifies cycle of a scheduled task. If `scheduler_cycle_type` is set to minute
               and `scheduler_cycle` is set to 10, the scheduled task is executed every 10 minutes.
        :param str scheduler_cycle_type: Specifies cycle type of a scheduled task. The options are as follows:
               `minute`, `hour`, `day`, `week`, `month`.
        :param str scheduler_disposable_type: Specifies whether to delete a job after the job is executed.
               The options are as follows:
               + **NONE**: The job will not be deleted after it is executed.
               + **DELETE_AFTER_SUCCEED**: The job will be deleted only after it is successfully executed. It is applicable to
               massive one-time jobs.
               + **DELETE**: Thejob will be deleted after it is executed, regardless of the execution result.
        :param bool scheduler_enabled: Specifies whether to enable a scheduled task.  Default value is `false`.
        :param str scheduler_run_at: Specifies time when a scheduled task is triggered in a cycle. This parameter
               is valid only when `scheduler_cycle_type` is set to `hour`, `week`, or `month`.
               + If `scheduler_cycle_type` is set to month, cycle is set to 1, and runAt is set to 15, the scheduled task is executed
               on the 15th day of each month. You can set runAt to multiple values and separate the values with commas (,).
               For example, if runAt is set to 1,2,3,4,5, the scheduled task is executed on the first day, second day, third day,
               fourth day, and fifth day of each month.
               + If `scheduler_cycle_type` is set to week and runAt is set to mon,tue,wed,thu,fri, the scheduled task is executed on
               Monday to Friday.
               + If `scheduler_cycle_type` is set to hour and runAt is set to 27,57, the scheduled task is executed at the 27th and
               57th minute in the cycle.
        :param str scheduler_start_date: Specifies start time of a scheduled task.
               For example, `2018-01-24 19:56:19`
        :param str scheduler_stop_date: Specifies End time of a scheduled task. For example, `2018-01-27 23:59:00`.
               If you do not set the end time, the scheduled task is always executed and will never stop.
        :param str throttling_dirty_write_to_bucket: Specifies name of the OBS bucket to which dirty data is
               written. This parameter is valid only when dirty data is written to `OBS`.
        :param str throttling_dirty_write_to_directory: Specifies the directory in the OBS bucket or HDFS which
               dirty data is written to. For example, `/data/dirtydata/`.
        :param str throttling_dirty_write_to_link: Specifies the link name to which dirty data is written to.
               The Dirty data can be written only to `OBS` or `HDFS`.
        :param int throttling_extractors_number: Specifies maximum number of concurrent extraction jobs.
        :param int throttling_loader_number: Specifies maximum number of loading jobs. This parameter is available
               only when HBase or Hive serves as the destination data source.
        :param int throttling_max_error_records: Specifies maximum number of error records in a single
               shard. When the number of error records of a map exceeds the upper limit, the task automatically ends.
        :param bool throttling_record_dirty_data: Specifies whether to write dirty data.
        """
        if group_name is not None:
            pulumi.set(__self__, "group_name", group_name)
        if retry_type is not None:
            pulumi.set(__self__, "retry_type", retry_type)
        if scheduler_cycle is not None:
            pulumi.set(__self__, "scheduler_cycle", scheduler_cycle)
        if scheduler_cycle_type is not None:
            pulumi.set(__self__, "scheduler_cycle_type", scheduler_cycle_type)
        if scheduler_disposable_type is not None:
            pulumi.set(__self__, "scheduler_disposable_type", scheduler_disposable_type)
        if scheduler_enabled is not None:
            pulumi.set(__self__, "scheduler_enabled", scheduler_enabled)
        if scheduler_run_at is not None:
            pulumi.set(__self__, "scheduler_run_at", scheduler_run_at)
        if scheduler_start_date is not None:
            pulumi.set(__self__, "scheduler_start_date", scheduler_start_date)
        if scheduler_stop_date is not None:
            pulumi.set(__self__, "scheduler_stop_date", scheduler_stop_date)
        if throttling_dirty_write_to_bucket is not None:
            pulumi.set(__self__, "throttling_dirty_write_to_bucket", throttling_dirty_write_to_bucket)
        if throttling_dirty_write_to_directory is not None:
            pulumi.set(__self__, "throttling_dirty_write_to_directory", throttling_dirty_write_to_directory)
        if throttling_dirty_write_to_link is not None:
            pulumi.set(__self__, "throttling_dirty_write_to_link", throttling_dirty_write_to_link)
        if throttling_extractors_number is not None:
            pulumi.set(__self__, "throttling_extractors_number", throttling_extractors_number)
        if throttling_loader_number is not None:
            pulumi.set(__self__, "throttling_loader_number", throttling_loader_number)
        if throttling_max_error_records is not None:
            pulumi.set(__self__, "throttling_max_error_records", throttling_max_error_records)
        if throttling_record_dirty_data is not None:
            pulumi.set(__self__, "throttling_record_dirty_data", throttling_record_dirty_data)

    @property
    @pulumi.getter(name="groupName")
    def group_name(self) -> Optional[str]:
        """
        Specifies group to which a job belongs. The default group is `DEFAULT`.
        """
        return pulumi.get(self, "group_name")

    @property
    @pulumi.getter(name="retryType")
    def retry_type(self) -> Optional[str]:
        """
        Specifies whether to automatically retry if a job fails to be executed.
        The options are as follows:
        + **NONE**: Do not retry.
        + **RETRY_TRIPLE**: Retry three times.
        """
        return pulumi.get(self, "retry_type")

    @property
    @pulumi.getter(name="schedulerCycle")
    def scheduler_cycle(self) -> Optional[int]:
        """
        Specifies cycle of a scheduled task. If `scheduler_cycle_type` is set to minute
        and `scheduler_cycle` is set to 10, the scheduled task is executed every 10 minutes.
        """
        return pulumi.get(self, "scheduler_cycle")

    @property
    @pulumi.getter(name="schedulerCycleType")
    def scheduler_cycle_type(self) -> Optional[str]:
        """
        Specifies cycle type of a scheduled task. The options are as follows:
        `minute`, `hour`, `day`, `week`, `month`.
        """
        return pulumi.get(self, "scheduler_cycle_type")

    @property
    @pulumi.getter(name="schedulerDisposableType")
    def scheduler_disposable_type(self) -> Optional[str]:
        """
        Specifies whether to delete a job after the job is executed.
        The options are as follows:
        + **NONE**: The job will not be deleted after it is executed.
        + **DELETE_AFTER_SUCCEED**: The job will be deleted only after it is successfully executed. It is applicable to
        massive one-time jobs.
        + **DELETE**: Thejob will be deleted after it is executed, regardless of the execution result.
        """
        return pulumi.get(self, "scheduler_disposable_type")

    @property
    @pulumi.getter(name="schedulerEnabled")
    def scheduler_enabled(self) -> Optional[bool]:
        """
        Specifies whether to enable a scheduled task.  Default value is `false`.
        """
        return pulumi.get(self, "scheduler_enabled")

    @property
    @pulumi.getter(name="schedulerRunAt")
    def scheduler_run_at(self) -> Optional[str]:
        """
        Specifies time when a scheduled task is triggered in a cycle. This parameter
        is valid only when `scheduler_cycle_type` is set to `hour`, `week`, or `month`.
        + If `scheduler_cycle_type` is set to month, cycle is set to 1, and runAt is set to 15, the scheduled task is executed
        on the 15th day of each month. You can set runAt to multiple values and separate the values with commas (,).
        For example, if runAt is set to 1,2,3,4,5, the scheduled task is executed on the first day, second day, third day,
        fourth day, and fifth day of each month.
        + If `scheduler_cycle_type` is set to week and runAt is set to mon,tue,wed,thu,fri, the scheduled task is executed on
        Monday to Friday.
        + If `scheduler_cycle_type` is set to hour and runAt is set to 27,57, the scheduled task is executed at the 27th and
        57th minute in the cycle.
        """
        return pulumi.get(self, "scheduler_run_at")

    @property
    @pulumi.getter(name="schedulerStartDate")
    def scheduler_start_date(self) -> Optional[str]:
        """
        Specifies start time of a scheduled task.
        For example, `2018-01-24 19:56:19`
        """
        return pulumi.get(self, "scheduler_start_date")

    @property
    @pulumi.getter(name="schedulerStopDate")
    def scheduler_stop_date(self) -> Optional[str]:
        """
        Specifies End time of a scheduled task. For example, `2018-01-27 23:59:00`.
        If you do not set the end time, the scheduled task is always executed and will never stop.
        """
        return pulumi.get(self, "scheduler_stop_date")

    @property
    @pulumi.getter(name="throttlingDirtyWriteToBucket")
    def throttling_dirty_write_to_bucket(self) -> Optional[str]:
        """
        Specifies name of the OBS bucket to which dirty data is
        written. This parameter is valid only when dirty data is written to `OBS`.
        """
        return pulumi.get(self, "throttling_dirty_write_to_bucket")

    @property
    @pulumi.getter(name="throttlingDirtyWriteToDirectory")
    def throttling_dirty_write_to_directory(self) -> Optional[str]:
        """
        Specifies the directory in the OBS bucket or HDFS which
        dirty data is written to. For example, `/data/dirtydata/`.
        """
        return pulumi.get(self, "throttling_dirty_write_to_directory")

    @property
    @pulumi.getter(name="throttlingDirtyWriteToLink")
    def throttling_dirty_write_to_link(self) -> Optional[str]:
        """
        Specifies the link name to which dirty data is written to.
        The Dirty data can be written only to `OBS` or `HDFS`.
        """
        return pulumi.get(self, "throttling_dirty_write_to_link")

    @property
    @pulumi.getter(name="throttlingExtractorsNumber")
    def throttling_extractors_number(self) -> Optional[int]:
        """
        Specifies maximum number of concurrent extraction jobs.
        """
        return pulumi.get(self, "throttling_extractors_number")

    @property
    @pulumi.getter(name="throttlingLoaderNumber")
    def throttling_loader_number(self) -> Optional[int]:
        """
        Specifies maximum number of loading jobs. This parameter is available
        only when HBase or Hive serves as the destination data source.
        """
        return pulumi.get(self, "throttling_loader_number")

    @property
    @pulumi.getter(name="throttlingMaxErrorRecords")
    def throttling_max_error_records(self) -> Optional[int]:
        """
        Specifies maximum number of error records in a single
        shard. When the number of error records of a map exceeds the upper limit, the task automatically ends.
        """
        return pulumi.get(self, "throttling_max_error_records")

    @property
    @pulumi.getter(name="throttlingRecordDirtyData")
    def throttling_record_dirty_data(self) -> Optional[bool]:
        """
        Specifies whether to write dirty data.
        """
        return pulumi.get(self, "throttling_record_dirty_data")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 id: str,
                 name: str):
        """
        :param str id: The id of the cdm flavor.
        :param str name: The name of the cdm flavor.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the cdm flavor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the cdm flavor.
        """
        return pulumi.get(self, "name")


