# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamespacesResult',
    'AwaitableGetNamespacesResult',
    'get_namespaces',
    'get_namespaces_output',
]

@pulumi.output_type
class GetNamespacesResult:
    """
    A collection of values returned by getNamespaces.
    """
    def __init__(__self__, enterprise_project_id=None, id=None, name=None, namespaces=None, region=None, type=None):
        if enterprise_project_id and not isinstance(enterprise_project_id, str):
            raise TypeError("Expected argument 'enterprise_project_id' to be a str")
        pulumi.set(__self__, "enterprise_project_id", enterprise_project_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespaces and not isinstance(namespaces, list):
            raise TypeError("Expected argument 'namespaces' to be a list")
        pulumi.set(__self__, "namespaces", namespaces)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="enterpriseProjectId")
    def enterprise_project_id(self) -> Optional[str]:
        """
        The enterprise project ID in UUID format.
        """
        return pulumi.get(self, "enterprise_project_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The CCI network name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespaces(self) -> Sequence['outputs.GetNamespacesNamespaceResult']:
        """
        All CCI namespaces that meet the query parameters.
        """
        return pulumi.get(self, "namespaces")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The CCI namespace type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNamespacesResult(GetNamespacesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamespacesResult(
            enterprise_project_id=self.enterprise_project_id,
            id=self.id,
            name=self.name,
            namespaces=self.namespaces,
            region=self.region,
            type=self.type)


def get_namespaces(enterprise_project_id: Optional[str] = None,
                   name: Optional[str] = None,
                   region: Optional[str] = None,
                   type: Optional[str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamespacesResult:
    """
    Use this data source to obtain CCI namespaces within HuaweiCloud.

    ## Example Usage
    ### Get the specified namespace details

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    namespace_name = config.require_object("namespaceName")
    test = huaweicloud.Cci.get_namespaces(name=namespace_name)
    ```


    :param str enterprise_project_id: Specifies the enterprise project ID in UUID format.
    :param str name: Specifies th name of the specified CCI namespace.
           This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
           and must start and end with lowercase letters and digits.
    :param str region: Specifies the region in which to obtain the CCI namespace list.
           If omitted, the provider-level region will be used.
    :param str type: Specifies the CCI namespace type.
           The valid values are **general-computing** and **gpu-accelerated**.
    """
    __args__ = dict()
    __args__['enterpriseProjectId'] = enterprise_project_id
    __args__['name'] = name
    __args__['region'] = region
    __args__['type'] = type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cci/getNamespaces:getNamespaces', __args__, opts=opts, typ=GetNamespacesResult).value

    return AwaitableGetNamespacesResult(
        enterprise_project_id=__ret__.enterprise_project_id,
        id=__ret__.id,
        name=__ret__.name,
        namespaces=__ret__.namespaces,
        region=__ret__.region,
        type=__ret__.type)


@_utilities.lift_output_func(get_namespaces)
def get_namespaces_output(enterprise_project_id: Optional[pulumi.Input[Optional[str]]] = None,
                          name: Optional[pulumi.Input[Optional[str]]] = None,
                          region: Optional[pulumi.Input[Optional[str]]] = None,
                          type: Optional[pulumi.Input[Optional[str]]] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNamespacesResult]:
    """
    Use this data source to obtain CCI namespaces within HuaweiCloud.

    ## Example Usage
    ### Get the specified namespace details

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    namespace_name = config.require_object("namespaceName")
    test = huaweicloud.Cci.get_namespaces(name=namespace_name)
    ```


    :param str enterprise_project_id: Specifies the enterprise project ID in UUID format.
    :param str name: Specifies th name of the specified CCI namespace.
           This parameter can contain a maximum of 63 characters, which may consist of lowercase letters, digits and hyphens,
           and must start and end with lowercase letters and digits.
    :param str region: Specifies the region in which to obtain the CCI namespace list.
           If omitted, the provider-level region will be used.
    :param str type: Specifies the CCI namespace type.
           The valid values are **general-computing** and **gpu-accelerated**.
    """
    ...
