# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetNodePoolResult',
    'AwaitableGetNodePoolResult',
    'get_node_pool',
    'get_node_pool_output',
]

@pulumi.output_type
class GetNodePoolResult:
    """
    A collection of values returned by getNodePool.
    """
    def __init__(__self__, availability_zone=None, cluster_id=None, current_node_count=None, data_volumes=None, extend_param=None, flavor_id=None, id=None, initial_node_count=None, key_pair=None, labels=None, max_node_count=None, max_pods=None, min_node_count=None, name=None, node_pool_id=None, os=None, priority=None, region=None, root_volumes=None, scale_down_cooldown_time=None, scall_enable=None, status=None, subnet_id=None, tags=None, type=None):
        if availability_zone and not isinstance(availability_zone, str):
            raise TypeError("Expected argument 'availability_zone' to be a str")
        pulumi.set(__self__, "availability_zone", availability_zone)
        if cluster_id and not isinstance(cluster_id, str):
            raise TypeError("Expected argument 'cluster_id' to be a str")
        pulumi.set(__self__, "cluster_id", cluster_id)
        if current_node_count and not isinstance(current_node_count, int):
            raise TypeError("Expected argument 'current_node_count' to be a int")
        pulumi.set(__self__, "current_node_count", current_node_count)
        if data_volumes and not isinstance(data_volumes, list):
            raise TypeError("Expected argument 'data_volumes' to be a list")
        pulumi.set(__self__, "data_volumes", data_volumes)
        if extend_param and not isinstance(extend_param, dict):
            raise TypeError("Expected argument 'extend_param' to be a dict")
        pulumi.set(__self__, "extend_param", extend_param)
        if flavor_id and not isinstance(flavor_id, str):
            raise TypeError("Expected argument 'flavor_id' to be a str")
        pulumi.set(__self__, "flavor_id", flavor_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if initial_node_count and not isinstance(initial_node_count, int):
            raise TypeError("Expected argument 'initial_node_count' to be a int")
        pulumi.set(__self__, "initial_node_count", initial_node_count)
        if key_pair and not isinstance(key_pair, str):
            raise TypeError("Expected argument 'key_pair' to be a str")
        pulumi.set(__self__, "key_pair", key_pair)
        if labels and not isinstance(labels, dict):
            raise TypeError("Expected argument 'labels' to be a dict")
        pulumi.set(__self__, "labels", labels)
        if max_node_count and not isinstance(max_node_count, int):
            raise TypeError("Expected argument 'max_node_count' to be a int")
        pulumi.set(__self__, "max_node_count", max_node_count)
        if max_pods and not isinstance(max_pods, int):
            raise TypeError("Expected argument 'max_pods' to be a int")
        pulumi.set(__self__, "max_pods", max_pods)
        if min_node_count and not isinstance(min_node_count, int):
            raise TypeError("Expected argument 'min_node_count' to be a int")
        pulumi.set(__self__, "min_node_count", min_node_count)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if node_pool_id and not isinstance(node_pool_id, str):
            raise TypeError("Expected argument 'node_pool_id' to be a str")
        pulumi.set(__self__, "node_pool_id", node_pool_id)
        if os and not isinstance(os, str):
            raise TypeError("Expected argument 'os' to be a str")
        pulumi.set(__self__, "os", os)
        if priority and not isinstance(priority, int):
            raise TypeError("Expected argument 'priority' to be a int")
        pulumi.set(__self__, "priority", priority)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if root_volumes and not isinstance(root_volumes, list):
            raise TypeError("Expected argument 'root_volumes' to be a list")
        pulumi.set(__self__, "root_volumes", root_volumes)
        if scale_down_cooldown_time and not isinstance(scale_down_cooldown_time, int):
            raise TypeError("Expected argument 'scale_down_cooldown_time' to be a int")
        pulumi.set(__self__, "scale_down_cooldown_time", scale_down_cooldown_time)
        if scall_enable and not isinstance(scall_enable, bool):
            raise TypeError("Expected argument 'scall_enable' to be a bool")
        pulumi.set(__self__, "scall_enable", scall_enable)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if subnet_id and not isinstance(subnet_id, str):
            raise TypeError("Expected argument 'subnet_id' to be a str")
        pulumi.set(__self__, "subnet_id", subnet_id)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> str:
        """
        The name of the available partition (AZ).
        """
        return pulumi.get(self, "availability_zone")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="currentNodeCount")
    def current_node_count(self) -> int:
        """
        Current number of nodes in the node pool.
        """
        return pulumi.get(self, "current_node_count")

    @property
    @pulumi.getter(name="dataVolumes")
    def data_volumes(self) -> Sequence['outputs.GetNodePoolDataVolumeResult']:
        """
        Represents the data disk to be created. Structure is documented below.
        """
        return pulumi.get(self, "data_volumes")

    @property
    @pulumi.getter(name="extendParam")
    def extend_param(self) -> Mapping[str, str]:
        """
        Extended parameter.
        """
        return pulumi.get(self, "extend_param")

    @property
    @pulumi.getter(name="flavorId")
    def flavor_id(self) -> str:
        """
        The flavor ID.
        """
        return pulumi.get(self, "flavor_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialNodeCount")
    def initial_node_count(self) -> int:
        """
        Initial number of nodes in the node pool.
        """
        return pulumi.get(self, "initial_node_count")

    @property
    @pulumi.getter(name="keyPair")
    def key_pair(self) -> str:
        """
        Key pair name when logging in to select the key pair mode.
        """
        return pulumi.get(self, "key_pair")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Tags of a Kubernetes node, key/value pair format.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodeCount")
    def max_node_count(self) -> int:
        """
        Maximum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "max_node_count")

    @property
    @pulumi.getter(name="maxPods")
    def max_pods(self) -> int:
        """
        The maximum number of instances a node is allowed to create.
        """
        return pulumi.get(self, "max_pods")

    @property
    @pulumi.getter(name="minNodeCount")
    def min_node_count(self) -> int:
        """
        Minimum number of nodes allowed if auto scaling is enabled.
        """
        return pulumi.get(self, "min_node_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> str:
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter
    def os(self) -> str:
        """
        Operating System of the node.
        """
        return pulumi.get(self, "os")

    @property
    @pulumi.getter
    def priority(self) -> int:
        """
        Weight of a node pool. A node pool with a higher weight has a higher priority during scaling.
        """
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def region(self) -> str:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="rootVolumes")
    def root_volumes(self) -> Sequence['outputs.GetNodePoolRootVolumeResult']:
        """
        It corresponds to the system disk related configuration. Structure is documented below.
        """
        return pulumi.get(self, "root_volumes")

    @property
    @pulumi.getter(name="scaleDownCooldownTime")
    def scale_down_cooldown_time(self) -> int:
        """
        Interval between two scaling operations, in minutes.
        """
        return pulumi.get(self, "scale_down_cooldown_time")

    @property
    @pulumi.getter(name="scallEnable")
    def scall_enable(self) -> bool:
        """
        Whether auto scaling is enabled.
        """
        return pulumi.get(self, "scall_enable")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The ID of the subnet to which the NIC belongs.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Mapping[str, str]]:
        """
        Tags of a VM node, key/value pair format.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Node Pool type.
        """
        return pulumi.get(self, "type")


class AwaitableGetNodePoolResult(GetNodePoolResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNodePoolResult(
            availability_zone=self.availability_zone,
            cluster_id=self.cluster_id,
            current_node_count=self.current_node_count,
            data_volumes=self.data_volumes,
            extend_param=self.extend_param,
            flavor_id=self.flavor_id,
            id=self.id,
            initial_node_count=self.initial_node_count,
            key_pair=self.key_pair,
            labels=self.labels,
            max_node_count=self.max_node_count,
            max_pods=self.max_pods,
            min_node_count=self.min_node_count,
            name=self.name,
            node_pool_id=self.node_pool_id,
            os=self.os,
            priority=self.priority,
            region=self.region,
            root_volumes=self.root_volumes,
            scale_down_cooldown_time=self.scale_down_cooldown_time,
            scall_enable=self.scall_enable,
            status=self.status,
            subnet_id=self.subnet_id,
            tags=self.tags,
            type=self.type)


def get_node_pool(cluster_id: Optional[str] = None,
                  name: Optional[str] = None,
                  node_pool_id: Optional[str] = None,
                  region: Optional[str] = None,
                  status: Optional[str] = None,
                  tags: Optional[Mapping[str, str]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNodePoolResult:
    """
    To get the specified node pool in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_pool_name = config.require_object("nodePoolName")
    node_pool = huaweicloud.Cce.get_node_pool(cluster_id=cluster_id,
        name=node_pool_name)
    ```


    :param str cluster_id: Specifies the ID of container cluster.
    :param str name: Specifies the name of the node pool.
    :param str node_pool_id: Specifies the ID of the node pool.
    :param str region: Specifies the region in which to obtain the CCE node pools.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the state of the node pool.
    :param Mapping[str, str] tags: Tags of a VM node, key/value pair format.
    """
    __args__ = dict()
    __args__['clusterId'] = cluster_id
    __args__['name'] = name
    __args__['nodePoolId'] = node_pool_id
    __args__['region'] = region
    __args__['status'] = status
    __args__['tags'] = tags
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('huaweicloud:Cce/getNodePool:getNodePool', __args__, opts=opts, typ=GetNodePoolResult).value

    return AwaitableGetNodePoolResult(
        availability_zone=__ret__.availability_zone,
        cluster_id=__ret__.cluster_id,
        current_node_count=__ret__.current_node_count,
        data_volumes=__ret__.data_volumes,
        extend_param=__ret__.extend_param,
        flavor_id=__ret__.flavor_id,
        id=__ret__.id,
        initial_node_count=__ret__.initial_node_count,
        key_pair=__ret__.key_pair,
        labels=__ret__.labels,
        max_node_count=__ret__.max_node_count,
        max_pods=__ret__.max_pods,
        min_node_count=__ret__.min_node_count,
        name=__ret__.name,
        node_pool_id=__ret__.node_pool_id,
        os=__ret__.os,
        priority=__ret__.priority,
        region=__ret__.region,
        root_volumes=__ret__.root_volumes,
        scale_down_cooldown_time=__ret__.scale_down_cooldown_time,
        scall_enable=__ret__.scall_enable,
        status=__ret__.status,
        subnet_id=__ret__.subnet_id,
        tags=__ret__.tags,
        type=__ret__.type)


@_utilities.lift_output_func(get_node_pool)
def get_node_pool_output(cluster_id: Optional[pulumi.Input[str]] = None,
                         name: Optional[pulumi.Input[Optional[str]]] = None,
                         node_pool_id: Optional[pulumi.Input[Optional[str]]] = None,
                         region: Optional[pulumi.Input[Optional[str]]] = None,
                         status: Optional[pulumi.Input[Optional[str]]] = None,
                         tags: Optional[pulumi.Input[Optional[Mapping[str, str]]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNodePoolResult]:
    """
    To get the specified node pool in a cluster.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_huaweicloud as huaweicloud

    config = pulumi.Config()
    cluster_id = config.require_object("clusterId")
    node_pool_name = config.require_object("nodePoolName")
    node_pool = huaweicloud.Cce.get_node_pool(cluster_id=cluster_id,
        name=node_pool_name)
    ```


    :param str cluster_id: Specifies the ID of container cluster.
    :param str name: Specifies the name of the node pool.
    :param str node_pool_id: Specifies the ID of the node pool.
    :param str region: Specifies the region in which to obtain the CCE node pools.
           If omitted, the provider-level region will be used.
    :param str status: Specifies the state of the node pool.
    :param Mapping[str, str] tags: Tags of a VM node, key/value pair format.
    """
    ...
