# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'InstanceDataDisk',
    'InstanceNic',
    'GetFlavorsFlavorResult',
]

@pulumi.output_type
class InstanceDataDisk(dict):
    def __init__(__self__, *,
                 size: int,
                 type: str):
        """
        :param int size: Specifies the data disk size, in GB. The value ranges form 10 to 32768. Changing
               this creates a new instance.
        :param str type: Specifies the BMS data disk type, which must be one of available disk types,
               contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        Specifies the data disk size, in GB. The value ranges form 10 to 32768. Changing
        this creates a new instance.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Specifies the BMS data disk type, which must be one of available disk types,
        contains of *SSD*, *GPSSD* and *SAS*. Changing this creates a new instance.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class InstanceNic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "macAddress":
            suggest = "mac_address"
        elif key == "portId":
            suggest = "port_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 ip_address: Optional[str] = None,
                 mac_address: Optional[str] = None,
                 port_id: Optional[str] = None):
        """
        :param str subnet_id: Specifies the ID of subnet to attach to the instance. Changing this creates
               a new instance.
        :param str ip_address: Specifies a fixed IPv4 address to be used on this network. Changing this
               creates a new instance.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if mac_address is not None:
            pulumi.set(__self__, "mac_address", mac_address)
        if port_id is not None:
            pulumi.set(__self__, "port_id", port_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        Specifies the ID of subnet to attach to the instance. Changing this creates
        a new instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        Specifies a fixed IPv4 address to be used on this network. Changing this
        creates a new instance.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="macAddress")
    def mac_address(self) -> Optional[str]:
        return pulumi.get(self, "mac_address")

    @property
    @pulumi.getter(name="portId")
    def port_id(self) -> Optional[str]:
        return pulumi.get(self, "port_id")


@pulumi.output_type
class GetFlavorsFlavorResult(dict):
    def __init__(__self__, *,
                 cpu_arch: str,
                 id: str,
                 memory: int,
                 operation: str,
                 vcpus: int):
        """
        :param str cpu_arch: Specifies the CPU architecture of the BMS flavor.
               The value can be x86_64 and aarch64, defaults to **x86_64**.
        :param str id: The id or name of the BMS flavor.
        :param int memory: Specifies the memory size(GB) in the BMS flavor.
        :param str operation: The operation status of the BMS flavor in an each AZs.
        :param int vcpus: Specifies the number of vCPUs in the BMS flavor.
        """
        pulumi.set(__self__, "cpu_arch", cpu_arch)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "operation", operation)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter(name="cpuArch")
    def cpu_arch(self) -> str:
        """
        Specifies the CPU architecture of the BMS flavor.
        The value can be x86_64 and aarch64, defaults to **x86_64**.
        """
        return pulumi.get(self, "cpu_arch")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id or name of the BMS flavor.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Specifies the memory size(GB) in the BMS flavor.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def operation(self) -> str:
        """
        The operation status of the BMS flavor in an each AZs.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        Specifies the number of vCPUs in the BMS flavor.
        """
        return pulumi.get(self, "vcpus")


