# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PolicyArgs', 'Policy']

@pulumi.input_type
class PolicyArgs:
    def __init__(__self__, *,
                 scaling_group_id: pulumi.Input[str],
                 scaling_policy_name: pulumi.Input[str],
                 scaling_policy_type: pulumi.Input[str],
                 alarm_id: Optional[pulumi.Input[str]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_policy_action: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']] = None,
                 scheduled_policy: Optional[pulumi.Input['PolicyScheduledPolicyArgs']] = None):
        """
        The set of arguments for constructing a Policy resource.
        :param pulumi.Input[str] scaling_group_id: The AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input[str] scaling_policy_name: The name of the AS policy. The name can contain letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[str] scaling_policy_type: The AS policy type. The values can be `ALARM`, `SCHEDULED`,
               and `RECURRENCE`.
        :param pulumi.Input[str] alarm_id: The alarm rule ID. This argument is mandatory when `scaling_policy_type`
               is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds), and is 900 by default.
        :param pulumi.Input[str] region: The region in which to create the AS policy. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS policy.
        :param pulumi.Input['PolicyScalingPolicyActionArgs'] scaling_policy_action: The action of the AS policy. The scaling_policy_action structure is
               documented below.
        :param pulumi.Input['PolicyScheduledPolicyArgs'] scheduled_policy: The periodic or scheduled AS policy. This argument is mandatory
               when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        pulumi.set(__self__, "scaling_policy_name", scaling_policy_name)
        pulumi.set(__self__, "scaling_policy_type", scaling_policy_type)
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_policy_action is not None:
            pulumi.set(__self__, "scaling_policy_action", scaling_policy_action)
        if scheduled_policy is not None:
            pulumi.set(__self__, "scheduled_policy", scheduled_policy)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Input[str]:
        """
        The AS group ID. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> pulumi.Input[str]:
        """
        The name of the AS policy. The name can contain letters, digits,
        underscores(_), and hyphens(-), and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_policy_name")

    @scaling_policy_name.setter
    def scaling_policy_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_policy_name", value)

    @property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> pulumi.Input[str]:
        """
        The AS policy type. The values can be `ALARM`, `SCHEDULED`,
        and `RECURRENCE`.
        """
        return pulumi.get(self, "scaling_policy_type")

    @scaling_policy_type.setter
    def scaling_policy_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "scaling_policy_type", value)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The alarm rule ID. This argument is mandatory when `scaling_policy_type`
        is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        """
        return pulumi.get(self, "alarm_id")

    @alarm_id.setter
    def alarm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_id", value)

    @property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[int]]:
        """
        The cooling duration (in seconds), and is 900 by default.
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_time", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the AS policy. If omitted, the `region` argument
        of the provider is used. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingPolicyAction")
    def scaling_policy_action(self) -> Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]:
        """
        The action of the AS policy. The scaling_policy_action structure is
        documented below.
        """
        return pulumi.get(self, "scaling_policy_action")

    @scaling_policy_action.setter
    def scaling_policy_action(self, value: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]):
        pulumi.set(self, "scaling_policy_action", value)

    @property
    @pulumi.getter(name="scheduledPolicy")
    def scheduled_policy(self) -> Optional[pulumi.Input['PolicyScheduledPolicyArgs']]:
        """
        The periodic or scheduled AS policy. This argument is mandatory
        when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        return pulumi.get(self, "scheduled_policy")

    @scheduled_policy.setter
    def scheduled_policy(self, value: Optional[pulumi.Input['PolicyScheduledPolicyArgs']]):
        pulumi.set(self, "scheduled_policy", value)


@pulumi.input_type
class _PolicyState:
    def __init__(__self__, *,
                 alarm_id: Optional[pulumi.Input[str]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_action: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']] = None,
                 scaling_policy_name: Optional[pulumi.Input[str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy: Optional[pulumi.Input['PolicyScheduledPolicyArgs']] = None):
        """
        Input properties used for looking up and filtering Policy resources.
        :param pulumi.Input[str] alarm_id: The alarm rule ID. This argument is mandatory when `scaling_policy_type`
               is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds), and is 900 by default.
        :param pulumi.Input[str] region: The region in which to create the AS policy. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS policy.
        :param pulumi.Input[str] scaling_group_id: The AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input['PolicyScalingPolicyActionArgs'] scaling_policy_action: The action of the AS policy. The scaling_policy_action structure is
               documented below.
        :param pulumi.Input[str] scaling_policy_name: The name of the AS policy. The name can contain letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[str] scaling_policy_type: The AS policy type. The values can be `ALARM`, `SCHEDULED`,
               and `RECURRENCE`.
        :param pulumi.Input['PolicyScheduledPolicyArgs'] scheduled_policy: The periodic or scheduled AS policy. This argument is mandatory
               when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        if alarm_id is not None:
            pulumi.set(__self__, "alarm_id", alarm_id)
        if cool_down_time is not None:
            pulumi.set(__self__, "cool_down_time", cool_down_time)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if scaling_group_id is not None:
            pulumi.set(__self__, "scaling_group_id", scaling_group_id)
        if scaling_policy_action is not None:
            pulumi.set(__self__, "scaling_policy_action", scaling_policy_action)
        if scaling_policy_name is not None:
            pulumi.set(__self__, "scaling_policy_name", scaling_policy_name)
        if scaling_policy_type is not None:
            pulumi.set(__self__, "scaling_policy_type", scaling_policy_type)
        if scheduled_policy is not None:
            pulumi.set(__self__, "scheduled_policy", scheduled_policy)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[pulumi.Input[str]]:
        """
        The alarm rule ID. This argument is mandatory when `scaling_policy_type`
        is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        """
        return pulumi.get(self, "alarm_id")

    @alarm_id.setter
    def alarm_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_id", value)

    @property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> Optional[pulumi.Input[int]]:
        """
        The cooling duration (in seconds), and is 900 by default.
        """
        return pulumi.get(self, "cool_down_time")

    @cool_down_time.setter
    def cool_down_time(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cool_down_time", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the AS policy. If omitted, the `region` argument
        of the provider is used. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The AS group ID. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "scaling_group_id")

    @scaling_group_id.setter
    def scaling_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_group_id", value)

    @property
    @pulumi.getter(name="scalingPolicyAction")
    def scaling_policy_action(self) -> Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]:
        """
        The action of the AS policy. The scaling_policy_action structure is
        documented below.
        """
        return pulumi.get(self, "scaling_policy_action")

    @scaling_policy_action.setter
    def scaling_policy_action(self, value: Optional[pulumi.Input['PolicyScalingPolicyActionArgs']]):
        pulumi.set(self, "scaling_policy_action", value)

    @property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the AS policy. The name can contain letters, digits,
        underscores(_), and hyphens(-), and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_policy_name")

    @scaling_policy_name.setter
    def scaling_policy_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy_name", value)

    @property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> Optional[pulumi.Input[str]]:
        """
        The AS policy type. The values can be `ALARM`, `SCHEDULED`,
        and `RECURRENCE`.
        """
        return pulumi.get(self, "scaling_policy_type")

    @scaling_policy_type.setter
    def scaling_policy_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scaling_policy_type", value)

    @property
    @pulumi.getter(name="scheduledPolicy")
    def scheduled_policy(self) -> Optional[pulumi.Input['PolicyScheduledPolicyArgs']]:
        """
        The periodic or scheduled AS policy. This argument is mandatory
        when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        return pulumi.get(self, "scheduled_policy")

    @scheduled_policy.setter
    def scheduled_policy(self, value: Optional[pulumi.Input['PolicyScheduledPolicyArgs']]):
        pulumi.set(self, "scheduled_policy", value)


class Policy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_id: Optional[pulumi.Input[str]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_action: Optional[pulumi.Input[pulumi.InputType['PolicyScalingPolicyActionArgs']]] = None,
                 scaling_policy_name: Optional[pulumi.Input[str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy: Optional[pulumi.Input[pulumi.InputType['PolicyScheduledPolicyArgs']]] = None,
                 __props__=None):
        """
        Manages a AS Policy resource within HuaweiCloud.

        ## Example Usage
        ### AS Recurrence Policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_aspolicy = huaweicloud.as_.Policy("myAspolicy",
            cool_down_time=900,
            scaling_group_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
            scaling_policy_action=huaweicloud.as_.PolicyScalingPolicyActionArgs(
                instance_number=1,
                operation="ADD",
            ),
            scaling_policy_name="my_aspolicy",
            scaling_policy_type="RECURRENCE",
            scheduled_policy=huaweicloud.as_.PolicyScheduledPolicyArgs(
                end_time="2020-12-30T12:00Z",
                launch_time="07:00",
                recurrence_type="Daily",
                start_time="2020-11-30T12:00Z",
            ))
        ```
        ### AS Scheduled Policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_aspolicy1 = huaweicloud.as_.Policy("myAspolicy1",
            cool_down_time=900,
            scaling_group_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
            scaling_policy_action=huaweicloud.as_.PolicyScalingPolicyActionArgs(
                instance_number=1,
                operation="REMOVE",
            ),
            scaling_policy_name="my_aspolicy_1",
            scaling_policy_type="SCHEDULED",
            scheduled_policy=huaweicloud.as_.PolicyScheduledPolicyArgs(
                launch_time="2020-12-22T12:00Z",
            ))
        ```

        Please note that the `launch_time` of the `SCHEDULED` policy cannot be earlier than the current time.
        ### AS Alarm Policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.cse.Alarmrule("alarmRule",
            alarm_name="as_alarm_rule",
            metric=huaweicloud.cse.AlarmruleMetricArgs(
                namespace="SYS.AS",
                metric_name="cpu_util",
                dimensions=[huaweicloud.cse.AlarmruleMetricDimensionArgs(
                    name="AutoScalingGroup",
                    value="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
                )],
            ),
            condition=huaweicloud.cse.AlarmruleConditionArgs(
                period=300,
                filter="average",
                comparison_operator=">=",
                value=60,
                unit="%",
                count=1,
            ),
            alarm_actions=[huaweicloud.cse.AlarmruleAlarmActionArgs(
                type="autoscaling",
                notification_lists=[],
            )])
        my_aspolicy2 = huaweicloud.as_.Policy("myAspolicy2",
            scaling_policy_name="my_aspolicy_2",
            scaling_policy_type="ALARM",
            scaling_group_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
            alarm_id=alarm_rule.id,
            cool_down_time=900,
            scaling_policy_action=huaweicloud.as_.PolicyScalingPolicyActionArgs(
                operation="ADD",
                instance_number=1,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alarm_id: The alarm rule ID. This argument is mandatory when `scaling_policy_type`
               is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds), and is 900 by default.
        :param pulumi.Input[str] region: The region in which to create the AS policy. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS policy.
        :param pulumi.Input[str] scaling_group_id: The AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input[pulumi.InputType['PolicyScalingPolicyActionArgs']] scaling_policy_action: The action of the AS policy. The scaling_policy_action structure is
               documented below.
        :param pulumi.Input[str] scaling_policy_name: The name of the AS policy. The name can contain letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[str] scaling_policy_type: The AS policy type. The values can be `ALARM`, `SCHEDULED`,
               and `RECURRENCE`.
        :param pulumi.Input[pulumi.InputType['PolicyScheduledPolicyArgs']] scheduled_policy: The periodic or scheduled AS policy. This argument is mandatory
               when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a AS Policy resource within HuaweiCloud.

        ## Example Usage
        ### AS Recurrence Policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_aspolicy = huaweicloud.as_.Policy("myAspolicy",
            cool_down_time=900,
            scaling_group_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
            scaling_policy_action=huaweicloud.as_.PolicyScalingPolicyActionArgs(
                instance_number=1,
                operation="ADD",
            ),
            scaling_policy_name="my_aspolicy",
            scaling_policy_type="RECURRENCE",
            scheduled_policy=huaweicloud.as_.PolicyScheduledPolicyArgs(
                end_time="2020-12-30T12:00Z",
                launch_time="07:00",
                recurrence_type="Daily",
                start_time="2020-11-30T12:00Z",
            ))
        ```
        ### AS Scheduled Policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        my_aspolicy1 = huaweicloud.as_.Policy("myAspolicy1",
            cool_down_time=900,
            scaling_group_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
            scaling_policy_action=huaweicloud.as_.PolicyScalingPolicyActionArgs(
                instance_number=1,
                operation="REMOVE",
            ),
            scaling_policy_name="my_aspolicy_1",
            scaling_policy_type="SCHEDULED",
            scheduled_policy=huaweicloud.as_.PolicyScheduledPolicyArgs(
                launch_time="2020-12-22T12:00Z",
            ))
        ```

        Please note that the `launch_time` of the `SCHEDULED` policy cannot be earlier than the current time.
        ### AS Alarm Policy

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.cse.Alarmrule("alarmRule",
            alarm_name="as_alarm_rule",
            metric=huaweicloud.cse.AlarmruleMetricArgs(
                namespace="SYS.AS",
                metric_name="cpu_util",
                dimensions=[huaweicloud.cse.AlarmruleMetricDimensionArgs(
                    name="AutoScalingGroup",
                    value="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
                )],
            ),
            condition=huaweicloud.cse.AlarmruleConditionArgs(
                period=300,
                filter="average",
                comparison_operator=">=",
                value=60,
                unit="%",
                count=1,
            ),
            alarm_actions=[huaweicloud.cse.AlarmruleAlarmActionArgs(
                type="autoscaling",
                notification_lists=[],
            )])
        my_aspolicy2 = huaweicloud.as_.Policy("myAspolicy2",
            scaling_policy_name="my_aspolicy_2",
            scaling_policy_type="ALARM",
            scaling_group_id="4579f2f5-cbe8-425a-8f32-53dcb9d9053a",
            alarm_id=alarm_rule.id,
            cool_down_time=900,
            scaling_policy_action=huaweicloud.as_.PolicyScalingPolicyActionArgs(
                operation="ADD",
                instance_number=1,
            ))
        ```

        :param str resource_name: The name of the resource.
        :param PolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_id: Optional[pulumi.Input[str]] = None,
                 cool_down_time: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 scaling_group_id: Optional[pulumi.Input[str]] = None,
                 scaling_policy_action: Optional[pulumi.Input[pulumi.InputType['PolicyScalingPolicyActionArgs']]] = None,
                 scaling_policy_name: Optional[pulumi.Input[str]] = None,
                 scaling_policy_type: Optional[pulumi.Input[str]] = None,
                 scheduled_policy: Optional[pulumi.Input[pulumi.InputType['PolicyScheduledPolicyArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PolicyArgs.__new__(PolicyArgs)

            __props__.__dict__["alarm_id"] = alarm_id
            __props__.__dict__["cool_down_time"] = cool_down_time
            __props__.__dict__["region"] = region
            if scaling_group_id is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_group_id'")
            __props__.__dict__["scaling_group_id"] = scaling_group_id
            __props__.__dict__["scaling_policy_action"] = scaling_policy_action
            if scaling_policy_name is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_policy_name'")
            __props__.__dict__["scaling_policy_name"] = scaling_policy_name
            if scaling_policy_type is None and not opts.urn:
                raise TypeError("Missing required property 'scaling_policy_type'")
            __props__.__dict__["scaling_policy_type"] = scaling_policy_type
            __props__.__dict__["scheduled_policy"] = scheduled_policy
        super(Policy, __self__).__init__(
            'huaweicloud:As/policy:Policy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_id: Optional[pulumi.Input[str]] = None,
            cool_down_time: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            scaling_group_id: Optional[pulumi.Input[str]] = None,
            scaling_policy_action: Optional[pulumi.Input[pulumi.InputType['PolicyScalingPolicyActionArgs']]] = None,
            scaling_policy_name: Optional[pulumi.Input[str]] = None,
            scaling_policy_type: Optional[pulumi.Input[str]] = None,
            scheduled_policy: Optional[pulumi.Input[pulumi.InputType['PolicyScheduledPolicyArgs']]] = None) -> 'Policy':
        """
        Get an existing Policy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alarm_id: The alarm rule ID. This argument is mandatory when `scaling_policy_type`
               is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        :param pulumi.Input[int] cool_down_time: The cooling duration (in seconds), and is 900 by default.
        :param pulumi.Input[str] region: The region in which to create the AS policy. If omitted, the `region` argument
               of the provider is used. Changing this creates a new AS policy.
        :param pulumi.Input[str] scaling_group_id: The AS group ID. Changing this creates a new AS policy.
        :param pulumi.Input[pulumi.InputType['PolicyScalingPolicyActionArgs']] scaling_policy_action: The action of the AS policy. The scaling_policy_action structure is
               documented below.
        :param pulumi.Input[str] scaling_policy_name: The name of the AS policy. The name can contain letters, digits,
               underscores(_), and hyphens(-), and cannot exceed 64 characters.
        :param pulumi.Input[str] scaling_policy_type: The AS policy type. The values can be `ALARM`, `SCHEDULED`,
               and `RECURRENCE`.
        :param pulumi.Input[pulumi.InputType['PolicyScheduledPolicyArgs']] scheduled_policy: The periodic or scheduled AS policy. This argument is mandatory
               when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PolicyState.__new__(_PolicyState)

        __props__.__dict__["alarm_id"] = alarm_id
        __props__.__dict__["cool_down_time"] = cool_down_time
        __props__.__dict__["region"] = region
        __props__.__dict__["scaling_group_id"] = scaling_group_id
        __props__.__dict__["scaling_policy_action"] = scaling_policy_action
        __props__.__dict__["scaling_policy_name"] = scaling_policy_name
        __props__.__dict__["scaling_policy_type"] = scaling_policy_type
        __props__.__dict__["scheduled_policy"] = scheduled_policy
        return Policy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> pulumi.Output[Optional[str]]:
        """
        The alarm rule ID. This argument is mandatory when `scaling_policy_type`
        is set to `ALARM`. You can create an alarm rule with `Cse.Alarmrule`.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="coolDownTime")
    def cool_down_time(self) -> pulumi.Output[Optional[int]]:
        """
        The cooling duration (in seconds), and is 900 by default.
        """
        return pulumi.get(self, "cool_down_time")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the AS policy. If omitted, the `region` argument
        of the provider is used. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="scalingGroupId")
    def scaling_group_id(self) -> pulumi.Output[str]:
        """
        The AS group ID. Changing this creates a new AS policy.
        """
        return pulumi.get(self, "scaling_group_id")

    @property
    @pulumi.getter(name="scalingPolicyAction")
    def scaling_policy_action(self) -> pulumi.Output['outputs.PolicyScalingPolicyAction']:
        """
        The action of the AS policy. The scaling_policy_action structure is
        documented below.
        """
        return pulumi.get(self, "scaling_policy_action")

    @property
    @pulumi.getter(name="scalingPolicyName")
    def scaling_policy_name(self) -> pulumi.Output[str]:
        """
        The name of the AS policy. The name can contain letters, digits,
        underscores(_), and hyphens(-), and cannot exceed 64 characters.
        """
        return pulumi.get(self, "scaling_policy_name")

    @property
    @pulumi.getter(name="scalingPolicyType")
    def scaling_policy_type(self) -> pulumi.Output[str]:
        """
        The AS policy type. The values can be `ALARM`, `SCHEDULED`,
        and `RECURRENCE`.
        """
        return pulumi.get(self, "scaling_policy_type")

    @property
    @pulumi.getter(name="scheduledPolicy")
    def scheduled_policy(self) -> pulumi.Output['outputs.PolicyScheduledPolicy']:
        """
        The periodic or scheduled AS policy. This argument is mandatory
        when `scaling_policy_type` is set to `SCHEDULED` or `RECURRENCE`. The scheduled_policy structure is documented below.
        """
        return pulumi.get(self, "scheduled_policy")

