# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'BandwidthPolicyScalingPolicyActionArgs',
    'BandwidthPolicyScheduledPolicyArgs',
    'ConfigurationInstanceConfigArgs',
    'ConfigurationInstanceConfigDiskArgs',
    'ConfigurationInstanceConfigPersonalityArgs',
    'ConfigurationInstanceConfigPublicIpArgs',
    'ConfigurationInstanceConfigPublicIpEipArgs',
    'ConfigurationInstanceConfigPublicIpEipBandwidthArgs',
    'GroupLbaasListenerArgs',
    'GroupNetworkArgs',
    'GroupSecurityGroupArgs',
    'PolicyScalingPolicyActionArgs',
    'PolicyScheduledPolicyArgs',
]

@pulumi.input_type
class BandwidthPolicyScalingPolicyActionArgs:
    def __init__(__self__, *,
                 limits: Optional[pulumi.Input[int]] = None,
                 operation: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[int] limits: Specifies the operation restrictions.
               - If operation is not SET, this parameter takes effect and the unit is Mbit/s.
               - If operation is set to ADD, this parameter indicates the maximum bandwidth allowed.
               - If operation is set to REDUCE, this parameter indicates the minimum bandwidth allowed.
        :param pulumi.Input[str] operation: Specifies the operation to be performed. The default operation is ADD.
               The options are as follows:
               - **ADD**: indicates adding the bandwidth size.
               - **REDUCE**: indicates reducing the bandwidth size.
               - **SET**: indicates setting the bandwidth size to a specified value.
        :param pulumi.Input[int] size: Specifies the bandwidth (Mbit/s).
               The value is an integer from 1 to 2000. The default value is 1.
        """
        if limits is not None:
            pulumi.set(__self__, "limits", limits)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)
        if size is not None:
            pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter
    def limits(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the operation restrictions.
        - If operation is not SET, this parameter takes effect and the unit is Mbit/s.
        - If operation is set to ADD, this parameter indicates the maximum bandwidth allowed.
        - If operation is set to REDUCE, this parameter indicates the minimum bandwidth allowed.
        """
        return pulumi.get(self, "limits")

    @limits.setter
    def limits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "limits", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the operation to be performed. The default operation is ADD.
        The options are as follows:
        - **ADD**: indicates adding the bandwidth size.
        - **REDUCE**: indicates reducing the bandwidth size.
        - **SET**: indicates setting the bandwidth size to a specified value.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the bandwidth (Mbit/s).
        The value is an integer from 1 to 2000. The default value is 1.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class BandwidthPolicyScheduledPolicyArgs:
    def __init__(__self__, *,
                 launch_time: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 recurrence_type: Optional[pulumi.Input[str]] = None,
                 recurrence_value: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] launch_time: Specifies the time when the scaling action is triggered.
               The time format complies with UTC.
               - If scaling_policy_type is set to SCHEDULED, the time format is YYYY-MM-DDThh:mmZ.
               - If scaling_policy_type is set to RECURRENCE, the time format is hh:mm.
        :param pulumi.Input[str] end_time: Specifies the end time of the scaling action triggered periodically.
               The time format complies with UTC. This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
               When the scaling action is triggered periodically, the end time cannot be earlier than the current and start time.
               The time format is YYYY-MM-DDThh:mmZ.
        :param pulumi.Input[str] recurrence_type: Specifies the periodic triggering type.
               This parameter is mandatory when scaling_policy_type is set to RECURRENCE. The options are as follows:
               - **Daily**: indicates that the scaling action is triggered once a day.
               - **Weekly**: indicates that the scaling action is triggered once a week.
               - **Monthly**: indicates that the scaling action is triggered once a month.
        :param pulumi.Input[str] recurrence_value: Specifies the day when a periodic scaling action is triggered.
               This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
               - If recurrence_type is set to Daily, the value is null, indicating that the scaling action is triggered once a day.
               - If recurrence_type is set to Weekly, the value ranges from 1 (Sunday) to 7 (Saturday).
               The digits refer to dates in each week and separated by a comma, such as 1,3,5.
               - If recurrence_type is set to Monthly, the value ranges from 1 to 31.
               The digits refer to the dates in each month and separated by a comma, such as 1,10,13,28.
        :param pulumi.Input[str] start_time: Specifies the start time of the scaling action triggered periodically.
               The time format complies with UTC. The default value is the local time.
               The time format is YYYY-MM-DDThh:mmZ.
        """
        pulumi.set(__self__, "launch_time", launch_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)
        if recurrence_value is not None:
            pulumi.set(__self__, "recurrence_value", recurrence_value)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> pulumi.Input[str]:
        """
        Specifies the time when the scaling action is triggered.
        The time format complies with UTC.
        - If scaling_policy_type is set to SCHEDULED, the time format is YYYY-MM-DDThh:mmZ.
        - If scaling_policy_type is set to RECURRENCE, the time format is hh:mm.
        """
        return pulumi.get(self, "launch_time")

    @launch_time.setter
    def launch_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "launch_time", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the end time of the scaling action triggered periodically.
        The time format complies with UTC. This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
        When the scaling action is triggered periodically, the end time cannot be earlier than the current and start time.
        The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the periodic triggering type.
        This parameter is mandatory when scaling_policy_type is set to RECURRENCE. The options are as follows:
        - **Daily**: indicates that the scaling action is triggered once a day.
        - **Weekly**: indicates that the scaling action is triggered once a week.
        - **Monthly**: indicates that the scaling action is triggered once a month.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the day when a periodic scaling action is triggered.
        This parameter is mandatory when scaling_policy_type is set to RECURRENCE.
        - If recurrence_type is set to Daily, the value is null, indicating that the scaling action is triggered once a day.
        - If recurrence_type is set to Weekly, the value ranges from 1 (Sunday) to 7 (Saturday).
        The digits refer to dates in each week and separated by a comma, such as 1,3,5.
        - If recurrence_type is set to Monthly, the value ranges from 1 to 31.
        The digits refer to the dates in each month and separated by a comma, such as 1,10,13,28.
        """
        return pulumi.get(self, "recurrence_value")

    @recurrence_value.setter
    def recurrence_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence_value", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the start time of the scaling action triggered periodically.
        The time format complies with UTC. The default value is the local time.
        The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class ConfigurationInstanceConfigArgs:
    def __init__(__self__, *,
                 key_name: pulumi.Input[str],
                 disks: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigDiskArgs']]]] = None,
                 flavor: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 personalities: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigPersonalityArgs']]]] = None,
                 public_ip: Optional[pulumi.Input['ConfigurationInstanceConfigPublicIpArgs']] = None,
                 user_data: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] key_name: Specifies the name of the SSH key pair used to log in to the instance.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigDiskArgs']]] disks: Specifies the disk group information. System disks are mandatory and
               data disks are optional. The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[str] flavor: Specifies the ECS flavor name. A maximum of 10 flavors can be selected.
               Use a comma (,) to separate multiple flavor names. Changing this will create a new resource.
        :param pulumi.Input[str] image: Specifies the ECS image ID. Changing this will create a new resource.
        :param pulumi.Input[str] instance_id: Specifies the ECS instance ID when using its specification
               as the template to create AS configurations. In this case, `flavor`, `image`, and `disk` arguments do not take effect.
               If this argument is not specified, `flavor`, `image`, and `disk` arguments are mandatory.
               Changing this will create a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] metadata: Specifies the key/value pairs to make available from within the instance.
               Changing this will create a new resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigPersonalityArgs']]] personalities: Specifies the customize personality of an instance by defining one or
               more files and their contents. The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input['ConfigurationInstanceConfigPublicIpArgs'] public_ip: Specifies the EIP of the ECS instance.
               The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[str] user_data: Specifies the user data to provide when launching the instance.
               The file content must be encoded with Base64. Changing this will create a new resource.
        """
        pulumi.set(__self__, "key_name", key_name)
        if disks is not None:
            pulumi.set(__self__, "disks", disks)
        if flavor is not None:
            pulumi.set(__self__, "flavor", flavor)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if personalities is not None:
            pulumi.set(__self__, "personalities", personalities)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)

    @property
    @pulumi.getter(name="keyName")
    def key_name(self) -> pulumi.Input[str]:
        """
        Specifies the name of the SSH key pair used to log in to the instance.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_name", value)

    @property
    @pulumi.getter
    def disks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigDiskArgs']]]]:
        """
        Specifies the disk group information. System disks are mandatory and
        data disks are optional. The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "disks")

    @disks.setter
    def disks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigDiskArgs']]]]):
        pulumi.set(self, "disks", value)

    @property
    @pulumi.getter
    def flavor(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS flavor name. A maximum of 10 flavors can be selected.
        Use a comma (,) to separate multiple flavor names. Changing this will create a new resource.
        """
        return pulumi.get(self, "flavor")

    @flavor.setter
    def flavor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "flavor", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS image ID. Changing this will create a new resource.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ECS instance ID when using its specification
        as the template to create AS configurations. In this case, `flavor`, `image`, and `disk` arguments do not take effect.
        If this argument is not specified, `flavor`, `image`, and `disk` arguments are mandatory.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies the key/value pairs to make available from within the instance.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def personalities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigPersonalityArgs']]]]:
        """
        Specifies the customize personality of an instance by defining one or
        more files and their contents. The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "personalities")

    @personalities.setter
    def personalities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigurationInstanceConfigPersonalityArgs']]]]):
        pulumi.set(self, "personalities", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input['ConfigurationInstanceConfigPublicIpArgs']]:
        """
        Specifies the EIP of the ECS instance.
        The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input['ConfigurationInstanceConfigPublicIpArgs']]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the user data to provide when launching the instance.
        The file content must be encoded with Base64. Changing this will create a new resource.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)


@pulumi.input_type
class ConfigurationInstanceConfigDiskArgs:
    def __init__(__self__, *,
                 disk_type: pulumi.Input[str],
                 size: pulumi.Input[int],
                 volume_type: pulumi.Input[str],
                 kms_id: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] disk_type: Specifies whether the disk is a system disk or a data disk.
               Option **DATA** indicates a data disk, option **SYS** indicates a system disk.
               Changing this will create a new resource.
        :param pulumi.Input[int] size: Specifies the bandwidth (Mbit/s). The value range for bandwidth billed by bandwidth
               is 1 to 2000 and that for bandwidth billed by traffic is 1 to 300.
               Changing this creates a new resource.
        :param pulumi.Input[str] volume_type: Specifies the disk type. Changing this will create a new resource.
               Available options are:
               + `SAS`: high I/O disk type.
               + `SSD`: ultra-high I/O disk type.
               + `GPSSD`: general purpose SSD disk type.
        :param pulumi.Input[str] kms_id: Specifies the encryption KMS ID of the **DATA** disk.
               Changing this will create a new resource.
        """
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "volume_type", volume_type)
        if kms_id is not None:
            pulumi.set(__self__, "kms_id", kms_id)

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> pulumi.Input[str]:
        """
        Specifies whether the disk is a system disk or a data disk.
        Option **DATA** indicates a data disk, option **SYS** indicates a system disk.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "disk_type")

    @disk_type.setter
    def disk_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "disk_type", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the bandwidth (Mbit/s). The value range for bandwidth billed by bandwidth
        is 1 to 2000 and that for bandwidth billed by traffic is 1 to 300.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> pulumi.Input[str]:
        """
        Specifies the disk type. Changing this will create a new resource.
        Available options are:
        + `SAS`: high I/O disk type.
        + `SSD`: ultra-high I/O disk type.
        + `GPSSD`: general purpose SSD disk type.
        """
        return pulumi.get(self, "volume_type")

    @volume_type.setter
    def volume_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume_type", value)

    @property
    @pulumi.getter(name="kmsId")
    def kms_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the encryption KMS ID of the **DATA** disk.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "kms_id")

    @kms_id.setter
    def kms_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_id", value)


@pulumi.input_type
class ConfigurationInstanceConfigPersonalityArgs:
    def __init__(__self__, *,
                 content: pulumi.Input[str],
                 path: pulumi.Input[str]):
        """
        :param pulumi.Input[str] path: Specifies the path of the injected file. Changing this creates a new resource.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def content(self) -> pulumi.Input[str]:
        return pulumi.get(self, "content")

    @content.setter
    def content(self, value: pulumi.Input[str]):
        pulumi.set(self, "content", value)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Specifies the path of the injected file. Changing this creates a new resource.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)


@pulumi.input_type
class ConfigurationInstanceConfigPublicIpArgs:
    def __init__(__self__, *,
                 eip: pulumi.Input['ConfigurationInstanceConfigPublicIpEipArgs']):
        """
        :param pulumi.Input['ConfigurationInstanceConfigPublicIpEipArgs'] eip: Specifies the EIP configuration that will be automatically assigned to the instance.
               The object structure is documented below. Changing this will create a new resource.
        """
        pulumi.set(__self__, "eip", eip)

    @property
    @pulumi.getter
    def eip(self) -> pulumi.Input['ConfigurationInstanceConfigPublicIpEipArgs']:
        """
        Specifies the EIP configuration that will be automatically assigned to the instance.
        The object structure is documented below. Changing this will create a new resource.
        """
        return pulumi.get(self, "eip")

    @eip.setter
    def eip(self, value: pulumi.Input['ConfigurationInstanceConfigPublicIpEipArgs']):
        pulumi.set(self, "eip", value)


@pulumi.input_type
class ConfigurationInstanceConfigPublicIpEipArgs:
    def __init__(__self__, *,
                 bandwidth: pulumi.Input['ConfigurationInstanceConfigPublicIpEipBandwidthArgs'],
                 ip_type: pulumi.Input[str]):
        """
        :param pulumi.Input['ConfigurationInstanceConfigPublicIpEipBandwidthArgs'] bandwidth: Specifies the bandwidth information. The object structure is documented below.
               Changing this will create a new resource.
        :param pulumi.Input[str] ip_type: Specifies the EIP type. Possible values are **5_bgp** (dynamic BGP)
               and **5_sbgp** (static BGP). Changing this will create a new resource.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "ip_type", ip_type)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Input['ConfigurationInstanceConfigPublicIpEipBandwidthArgs']:
        """
        Specifies the bandwidth information. The object structure is documented below.
        Changing this will create a new resource.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: pulumi.Input['ConfigurationInstanceConfigPublicIpEipBandwidthArgs']):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="ipType")
    def ip_type(self) -> pulumi.Input[str]:
        """
        Specifies the EIP type. Possible values are **5_bgp** (dynamic BGP)
        and **5_sbgp** (static BGP). Changing this will create a new resource.
        """
        return pulumi.get(self, "ip_type")

    @ip_type.setter
    def ip_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "ip_type", value)


@pulumi.input_type
class ConfigurationInstanceConfigPublicIpEipBandwidthArgs:
    def __init__(__self__, *,
                 charging_mode: pulumi.Input[str],
                 share_type: pulumi.Input[str],
                 size: pulumi.Input[int]):
        """
        :param pulumi.Input[str] charging_mode: Specifies whether the bandwidth is billed by traffic or by bandwidth
               size. The value can be **traffic** or **bandwidth**. Changing this creates a new resource.
        :param pulumi.Input[str] share_type: Specifies the bandwidth sharing type. The system only supports
               **PER** (indicates exclusive bandwidth). Changing this will create a new resource.
        :param pulumi.Input[int] size: Specifies the bandwidth (Mbit/s). The value range for bandwidth billed by bandwidth
               is 1 to 2000 and that for bandwidth billed by traffic is 1 to 300.
               Changing this creates a new resource.
        """
        pulumi.set(__self__, "charging_mode", charging_mode)
        pulumi.set(__self__, "share_type", share_type)
        pulumi.set(__self__, "size", size)

    @property
    @pulumi.getter(name="chargingMode")
    def charging_mode(self) -> pulumi.Input[str]:
        """
        Specifies whether the bandwidth is billed by traffic or by bandwidth
        size. The value can be **traffic** or **bandwidth**. Changing this creates a new resource.
        """
        return pulumi.get(self, "charging_mode")

    @charging_mode.setter
    def charging_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "charging_mode", value)

    @property
    @pulumi.getter(name="shareType")
    def share_type(self) -> pulumi.Input[str]:
        """
        Specifies the bandwidth sharing type. The system only supports
        **PER** (indicates exclusive bandwidth). Changing this will create a new resource.
        """
        return pulumi.get(self, "share_type")

    @share_type.setter
    def share_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "share_type", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[int]:
        """
        Specifies the bandwidth (Mbit/s). The value range for bandwidth billed by bandwidth
        is 1 to 2000 and that for bandwidth billed by traffic is 1 to 300.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[int]):
        pulumi.set(self, "size", value)


@pulumi.input_type
class GroupLbaasListenerArgs:
    def __init__(__self__, *,
                 pool_id: pulumi.Input[str],
                 protocol_port: pulumi.Input[int],
                 weight: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[str] pool_id: Specifies the backend ECS group ID.
        :param pulumi.Input[int] protocol_port: Specifies the backend protocol, which is the port on which a backend ECS listens for
               traffic. The number of the port ranges from 1 to 65535.
        :param pulumi.Input[int] weight: Specifies the weight, which determines the portion of requests a backend ECS processes
               compared to other backend ECSs added to the same listener. The value of this parameter ranges from 0 to 100. The
               default value is 1.
        """
        pulumi.set(__self__, "pool_id", pool_id)
        pulumi.set(__self__, "protocol_port", protocol_port)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="poolId")
    def pool_id(self) -> pulumi.Input[str]:
        """
        Specifies the backend ECS group ID.
        """
        return pulumi.get(self, "pool_id")

    @pool_id.setter
    def pool_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "pool_id", value)

    @property
    @pulumi.getter(name="protocolPort")
    def protocol_port(self) -> pulumi.Input[int]:
        """
        Specifies the backend protocol, which is the port on which a backend ECS listens for
        traffic. The number of the port ranges from 1 to 65535.
        """
        return pulumi.get(self, "protocol_port")

    @protocol_port.setter
    def protocol_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "protocol_port", value)

    @property
    @pulumi.getter
    def weight(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the weight, which determines the portion of requests a backend ECS processes
        compared to other backend ECSs added to the same listener. The value of this parameter ranges from 0 to 100. The
        default value is 1.
        """
        return pulumi.get(self, "weight")

    @weight.setter
    def weight(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "weight", value)


@pulumi.input_type
class GroupNetworkArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: The UUID of the security group.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The UUID of the security group.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class GroupSecurityGroupArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str]):
        """
        :param pulumi.Input[str] id: The UUID of the security group.
        """
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        The UUID of the security group.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class PolicyScalingPolicyActionArgs:
    def __init__(__self__, *,
                 instance_number: Optional[pulumi.Input[int]] = None,
                 operation: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[int] instance_number: The number of instances to be operated. The default number is 1.
        :param pulumi.Input[str] operation: The operation to be performed. The options include `ADD` (default), `REMOVE`,
               and `SET`.
        """
        if instance_number is not None:
            pulumi.set(__self__, "instance_number", instance_number)
        if operation is not None:
            pulumi.set(__self__, "operation", operation)

    @property
    @pulumi.getter(name="instanceNumber")
    def instance_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of instances to be operated. The default number is 1.
        """
        return pulumi.get(self, "instance_number")

    @instance_number.setter
    def instance_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "instance_number", value)

    @property
    @pulumi.getter
    def operation(self) -> Optional[pulumi.Input[str]]:
        """
        The operation to be performed. The options include `ADD` (default), `REMOVE`,
        and `SET`.
        """
        return pulumi.get(self, "operation")

    @operation.setter
    def operation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operation", value)


@pulumi.input_type
class PolicyScheduledPolicyArgs:
    def __init__(__self__, *,
                 launch_time: pulumi.Input[str],
                 end_time: Optional[pulumi.Input[str]] = None,
                 recurrence_type: Optional[pulumi.Input[str]] = None,
                 recurrence_value: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] launch_time: The time when the scaling action is triggered.
               + If `scaling_policy_type` is set to `SCHEDULED`, the time format is YYYY-MM-DDThh:mmZ.
               + If `scaling_policy_type` is set to `RECURRENCE`, the time format is hh:mm.
        :param pulumi.Input[str] end_time: The end time of the scaling action triggered periodically. The time format complies
               with UTC. This argument is mandatory when `scaling_policy_type`
               is set to `RECURRENCE`. The time format is YYYY-MM-DDThh:mmZ.
        :param pulumi.Input[str] recurrence_type: The periodic triggering type. This argument is mandatory when
               `scaling_policy_type` is set to `RECURRENCE`. The options include `Daily`, `Weekly`, and `Monthly`.
        :param pulumi.Input[str] recurrence_value: The frequency at which scaling actions are triggered.
        :param pulumi.Input[str] start_time: The start time of the scaling action triggered periodically. The time format
               complies with UTC. The current time is used by default. The time format is YYYY-MM-DDThh:mmZ.
        """
        pulumi.set(__self__, "launch_time", launch_time)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence_type is not None:
            pulumi.set(__self__, "recurrence_type", recurrence_type)
        if recurrence_value is not None:
            pulumi.set(__self__, "recurrence_value", recurrence_value)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="launchTime")
    def launch_time(self) -> pulumi.Input[str]:
        """
        The time when the scaling action is triggered.
        + If `scaling_policy_type` is set to `SCHEDULED`, the time format is YYYY-MM-DDThh:mmZ.
        + If `scaling_policy_type` is set to `RECURRENCE`, the time format is hh:mm.
        """
        return pulumi.get(self, "launch_time")

    @launch_time.setter
    def launch_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "launch_time", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        The end time of the scaling action triggered periodically. The time format complies
        with UTC. This argument is mandatory when `scaling_policy_type`
        is set to `RECURRENCE`. The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="recurrenceType")
    def recurrence_type(self) -> Optional[pulumi.Input[str]]:
        """
        The periodic triggering type. This argument is mandatory when
        `scaling_policy_type` is set to `RECURRENCE`. The options include `Daily`, `Weekly`, and `Monthly`.
        """
        return pulumi.get(self, "recurrence_type")

    @recurrence_type.setter
    def recurrence_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence_type", value)

    @property
    @pulumi.getter(name="recurrenceValue")
    def recurrence_value(self) -> Optional[pulumi.Input[str]]:
        """
        The frequency at which scaling actions are triggered.
        """
        return pulumi.get(self, "recurrence_value")

    @recurrence_value.setter
    def recurrence_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence_value", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        The start time of the scaling action triggered periodically. The time format
        complies with UTC. The current time is used by default. The time format is YYYY-MM-DDThh:mmZ.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


