# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmRuleArgs', 'AlarmRule']

@pulumi.input_type
class AlarmRuleArgs:
    def __init__(__self__, *,
                 comparison_operator: pulumi.Input[str],
                 dimensions: pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]],
                 evaluation_periods: pulumi.Input[int],
                 metric_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 period: pulumi.Input[int],
                 statistic: pulumi.Input[str],
                 threshold: pulumi.Input[str],
                 unit: pulumi.Input[str],
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AlarmRule resource.
        :param pulumi.Input[str] comparison_operator: Specifies the comparison condition of alarm thresholds.
               The value can be **>**, **=**, **<**, **>=** or **<=**.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]] dimensions: Specifies the list of metric dimensions. The structure is described below.
               Changing this creates a new resource.
        :param pulumi.Input[int] evaluation_periods: Specifies the alarm checking evaluation periods.
               The value can be **1**, **2**, **3**, **4** and **5**.
        :param pulumi.Input[str] metric_name: Specifies the alarm metric name. Changing this creates a new resource.
        :param pulumi.Input[str] namespace: Specifies the alarm namespace. Changing this creates a new resource.
        :param pulumi.Input[int] period: Specifies the alarm checking period in milliseconds.
               The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        :param pulumi.Input[str] statistic: Specifies the data rollup methods. The value can be **maximum**,
               **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        :param pulumi.Input[str] threshold: Specifies the alarm threshold.
        :param pulumi.Input[str] unit: Specifies the data unit. Changing this creates a new resource.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm.
               The default value is true. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alarm_actions: Specifies the action triggered by an alarm. This is a list of strings.
               Changing this creates a new resource.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is **2**.
        :param pulumi.Input[str] description: Specifies the description of the alarm rule.
               The value can be a string of 0 to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] insufficient_data_actions: Specifies the action triggered when the data is not enough.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the dimension name. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ok_actions: Specifies the action triggered by the clearing of an alarm.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "comparison_operator", comparison_operator)
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        pulumi.set(__self__, "metric_name", metric_name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "statistic", statistic)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "unit", unit)
        if alarm_action_enabled is not None:
            pulumi.set(__self__, "alarm_action_enabled", alarm_action_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_level is not None:
            pulumi.set(__self__, "alarm_level", alarm_level)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if insufficient_data_actions is not None:
            pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Input[str]:
        """
        Specifies the comparison condition of alarm thresholds.
        The value can be **>**, **=**, **<**, **>=** or **<=**.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: pulumi.Input[str]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]]:
        """
        Specifies the list of metric dimensions. The structure is described below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Input[int]:
        """
        Specifies the alarm checking evaluation periods.
        The value can be **1**, **2**, **3**, **4** and **5**.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: pulumi.Input[int]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Input[str]:
        """
        Specifies the alarm metric name. Changing this creates a new resource.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        Specifies the alarm namespace. Changing this creates a new resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def period(self) -> pulumi.Input[int]:
        """
        Specifies the alarm checking period in milliseconds.
        The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: pulumi.Input[int]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Input[str]:
        """
        Specifies the data rollup methods. The value can be **maximum**,
        **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: pulumi.Input[str]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Input[str]:
        """
        Specifies the alarm threshold.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: pulumi.Input[str]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Input[str]:
        """
        Specifies the data unit. Changing this creates a new resource.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: pulumi.Input[str]):
        pulumi.set(self, "unit", value)

    @property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm.
        The default value is true. Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @alarm_action_enabled.setter
    def alarm_action_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_action_enabled", value)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the action triggered by an alarm. This is a list of strings.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alarm_actions", value)

    @property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
        which indicates *critical*, *major*, *minor*, and *informational*, respectively.
        The default value is **2**.
        """
        return pulumi.get(self, "alarm_level")

    @alarm_level.setter
    def alarm_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alarm_level", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the alarm rule.
        The value can be a string of 0 to 1000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the action triggered when the data is not enough.
        This is a list of strings. Changing this creates a new resource.
        """
        return pulumi.get(self, "insufficient_data_actions")

    @insufficient_data_actions.setter
    def insufficient_data_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "insufficient_data_actions", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dimension name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the action triggered by the clearing of an alarm.
        This is a list of strings. Changing this creates a new resource.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ok_actions", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _AlarmRuleState:
    def __init__(__self__, *,
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 alarm_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 state_reason: Optional[pulumi.Input[str]] = None,
                 state_value: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AlarmRule resources.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm.
               The default value is true. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alarm_actions: Specifies the action triggered by an alarm. This is a list of strings.
               Changing this creates a new resource.
        :param pulumi.Input[bool] alarm_enabled: Indicates whether the alarm rule is enabled.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is **2**.
        :param pulumi.Input[str] comparison_operator: Specifies the comparison condition of alarm thresholds.
               The value can be **>**, **=**, **<**, **>=** or **<=**.
        :param pulumi.Input[str] description: Specifies the description of the alarm rule.
               The value can be a string of 0 to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]] dimensions: Specifies the list of metric dimensions. The structure is described below.
               Changing this creates a new resource.
        :param pulumi.Input[int] evaluation_periods: Specifies the alarm checking evaluation periods.
               The value can be **1**, **2**, **3**, **4** and **5**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] insufficient_data_actions: Specifies the action triggered when the data is not enough.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[str] metric_name: Specifies the alarm metric name. Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the dimension name. Changing this creates a new resource.
        :param pulumi.Input[str] namespace: Specifies the alarm namespace. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ok_actions: Specifies the action triggered by the clearing of an alarm.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[int] period: Specifies the alarm checking period in milliseconds.
               The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] state_reason: Indicates the reason of alarm status.
        :param pulumi.Input[str] state_value: Indicates the alarm status.
        :param pulumi.Input[str] statistic: Specifies the data rollup methods. The value can be **maximum**,
               **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        :param pulumi.Input[str] threshold: Specifies the alarm threshold.
        :param pulumi.Input[str] unit: Specifies the data unit. Changing this creates a new resource.
        """
        if alarm_action_enabled is not None:
            pulumi.set(__self__, "alarm_action_enabled", alarm_action_enabled)
        if alarm_actions is not None:
            pulumi.set(__self__, "alarm_actions", alarm_actions)
        if alarm_enabled is not None:
            pulumi.set(__self__, "alarm_enabled", alarm_enabled)
        if alarm_level is not None:
            pulumi.set(__self__, "alarm_level", alarm_level)
        if comparison_operator is not None:
            pulumi.set(__self__, "comparison_operator", comparison_operator)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if evaluation_periods is not None:
            pulumi.set(__self__, "evaluation_periods", evaluation_periods)
        if insufficient_data_actions is not None:
            pulumi.set(__self__, "insufficient_data_actions", insufficient_data_actions)
        if metric_name is not None:
            pulumi.set(__self__, "metric_name", metric_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ok_actions is not None:
            pulumi.set(__self__, "ok_actions", ok_actions)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if state_reason is not None:
            pulumi.set(__self__, "state_reason", state_reason)
        if state_value is not None:
            pulumi.set(__self__, "state_value", state_value)
        if statistic is not None:
            pulumi.set(__self__, "statistic", statistic)
        if threshold is not None:
            pulumi.set(__self__, "threshold", threshold)
        if unit is not None:
            pulumi.set(__self__, "unit", unit)

    @property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm.
        The default value is true. Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @alarm_action_enabled.setter
    def alarm_action_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_action_enabled", value)

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the action triggered by an alarm. This is a list of strings.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_actions")

    @alarm_actions.setter
    def alarm_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alarm_actions", value)

    @property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates whether the alarm rule is enabled.
        """
        return pulumi.get(self, "alarm_enabled")

    @alarm_enabled.setter
    def alarm_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "alarm_enabled", value)

    @property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
        which indicates *critical*, *major*, *minor*, and *informational*, respectively.
        The default value is **2**.
        """
        return pulumi.get(self, "alarm_level")

    @alarm_level.setter
    def alarm_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "alarm_level", value)

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the comparison condition of alarm thresholds.
        The value can be **>**, **=**, **<**, **>=** or **<=**.
        """
        return pulumi.get(self, "comparison_operator")

    @comparison_operator.setter
    def comparison_operator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comparison_operator", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the description of the alarm rule.
        The value can be a string of 0 to 1000 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def dimensions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]]]:
        """
        Specifies the list of metric dimensions. The structure is described below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "dimensions")

    @dimensions.setter
    def dimensions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmRuleDimensionArgs']]]]):
        pulumi.set(self, "dimensions", value)

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the alarm checking evaluation periods.
        The value can be **1**, **2**, **3**, **4** and **5**.
        """
        return pulumi.get(self, "evaluation_periods")

    @evaluation_periods.setter
    def evaluation_periods(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "evaluation_periods", value)

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the action triggered when the data is not enough.
        This is a list of strings. Changing this creates a new resource.
        """
        return pulumi.get(self, "insufficient_data_actions")

    @insufficient_data_actions.setter
    def insufficient_data_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "insufficient_data_actions", value)

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the alarm metric name. Changing this creates a new resource.
        """
        return pulumi.get(self, "metric_name")

    @metric_name.setter
    def metric_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "metric_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the dimension name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the alarm namespace. Changing this creates a new resource.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the action triggered by the clearing of an alarm.
        This is a list of strings. Changing this creates a new resource.
        """
        return pulumi.get(self, "ok_actions")

    @ok_actions.setter
    def ok_actions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ok_actions", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the alarm checking period in milliseconds.
        The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the reason of alarm status.
        """
        return pulumi.get(self, "state_reason")

    @state_reason.setter
    def state_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_reason", value)

    @property
    @pulumi.getter(name="stateValue")
    def state_value(self) -> Optional[pulumi.Input[str]]:
        """
        Indicates the alarm status.
        """
        return pulumi.get(self, "state_value")

    @state_value.setter
    def state_value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state_value", value)

    @property
    @pulumi.getter
    def statistic(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data rollup methods. The value can be **maximum**,
        **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        """
        return pulumi.get(self, "statistic")

    @statistic.setter
    def statistic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "statistic", value)

    @property
    @pulumi.getter
    def threshold(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the alarm threshold.
        """
        return pulumi.get(self, "threshold")

    @threshold.setter
    def threshold(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "threshold", value)

    @property
    @pulumi.getter
    def unit(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the data unit. Changing this creates a new resource.
        """
        return pulumi.get(self, "unit")

    @unit.setter
    def unit(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unit", value)


class AlarmRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmRuleDimensionArgs']]]]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an AOM alarm rule resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.aom.AlarmRule("alarmRule",
            alarm_level=3,
            description="test rule",
            namespace="PAAS.NODE",
            metric_name="cupUsage",
            dimensions=[huaweicloud.aom.AlarmRuleDimensionArgs(
                name="hostID",
                value=var["instance_id"],
            )],
            comparison_operator=">=",
            period=60000,
            statistic="average",
            threshold="3",
            unit="Percent",
            evaluation_periods=2)
        ```

        ## Import

        AOM alarm rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Aom/alarmRule:AlarmRule alarm_rule 966746116613832710
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm.
               The default value is true. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alarm_actions: Specifies the action triggered by an alarm. This is a list of strings.
               Changing this creates a new resource.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is **2**.
        :param pulumi.Input[str] comparison_operator: Specifies the comparison condition of alarm thresholds.
               The value can be **>**, **=**, **<**, **>=** or **<=**.
        :param pulumi.Input[str] description: Specifies the description of the alarm rule.
               The value can be a string of 0 to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmRuleDimensionArgs']]]] dimensions: Specifies the list of metric dimensions. The structure is described below.
               Changing this creates a new resource.
        :param pulumi.Input[int] evaluation_periods: Specifies the alarm checking evaluation periods.
               The value can be **1**, **2**, **3**, **4** and **5**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] insufficient_data_actions: Specifies the action triggered when the data is not enough.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[str] metric_name: Specifies the alarm metric name. Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the dimension name. Changing this creates a new resource.
        :param pulumi.Input[str] namespace: Specifies the alarm namespace. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ok_actions: Specifies the action triggered by the clearing of an alarm.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[int] period: Specifies the alarm checking period in milliseconds.
               The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] statistic: Specifies the data rollup methods. The value can be **maximum**,
               **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        :param pulumi.Input[str] threshold: Specifies the alarm threshold.
        :param pulumi.Input[str] unit: Specifies the data unit. Changing this creates a new resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AOM alarm rule resource within HuaweiCloud.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        alarm_rule = huaweicloud.aom.AlarmRule("alarmRule",
            alarm_level=3,
            description="test rule",
            namespace="PAAS.NODE",
            metric_name="cupUsage",
            dimensions=[huaweicloud.aom.AlarmRuleDimensionArgs(
                name="hostID",
                value=var["instance_id"],
            )],
            comparison_operator=">=",
            period=60000,
            statistic="average",
            threshold="3",
            unit="Percent",
            evaluation_periods=2)
        ```

        ## Import

        AOM alarm rules can be imported using the `id`, e.g.

        ```sh
         $ pulumi import huaweicloud:Aom/alarmRule:AlarmRule alarm_rule 966746116613832710
        ```

        :param str resource_name: The name of the resource.
        :param AlarmRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
                 alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 alarm_level: Optional[pulumi.Input[int]] = None,
                 comparison_operator: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmRuleDimensionArgs']]]]] = None,
                 evaluation_periods: Optional[pulumi.Input[int]] = None,
                 insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metric_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 statistic: Optional[pulumi.Input[str]] = None,
                 threshold: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmRuleArgs.__new__(AlarmRuleArgs)

            __props__.__dict__["alarm_action_enabled"] = alarm_action_enabled
            __props__.__dict__["alarm_actions"] = alarm_actions
            __props__.__dict__["alarm_level"] = alarm_level
            if comparison_operator is None and not opts.urn:
                raise TypeError("Missing required property 'comparison_operator'")
            __props__.__dict__["comparison_operator"] = comparison_operator
            __props__.__dict__["description"] = description
            if dimensions is None and not opts.urn:
                raise TypeError("Missing required property 'dimensions'")
            __props__.__dict__["dimensions"] = dimensions
            if evaluation_periods is None and not opts.urn:
                raise TypeError("Missing required property 'evaluation_periods'")
            __props__.__dict__["evaluation_periods"] = evaluation_periods
            __props__.__dict__["insufficient_data_actions"] = insufficient_data_actions
            if metric_name is None and not opts.urn:
                raise TypeError("Missing required property 'metric_name'")
            __props__.__dict__["metric_name"] = metric_name
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ok_actions"] = ok_actions
            if period is None and not opts.urn:
                raise TypeError("Missing required property 'period'")
            __props__.__dict__["period"] = period
            __props__.__dict__["region"] = region
            if statistic is None and not opts.urn:
                raise TypeError("Missing required property 'statistic'")
            __props__.__dict__["statistic"] = statistic
            if threshold is None and not opts.urn:
                raise TypeError("Missing required property 'threshold'")
            __props__.__dict__["threshold"] = threshold
            if unit is None and not opts.urn:
                raise TypeError("Missing required property 'unit'")
            __props__.__dict__["unit"] = unit
            __props__.__dict__["alarm_enabled"] = None
            __props__.__dict__["state_reason"] = None
            __props__.__dict__["state_value"] = None
        super(AlarmRule, __self__).__init__(
            'huaweicloud:Aom/alarmRule:AlarmRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_action_enabled: Optional[pulumi.Input[bool]] = None,
            alarm_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            alarm_enabled: Optional[pulumi.Input[bool]] = None,
            alarm_level: Optional[pulumi.Input[int]] = None,
            comparison_operator: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            dimensions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmRuleDimensionArgs']]]]] = None,
            evaluation_periods: Optional[pulumi.Input[int]] = None,
            insufficient_data_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            metric_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            ok_actions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            period: Optional[pulumi.Input[int]] = None,
            region: Optional[pulumi.Input[str]] = None,
            state_reason: Optional[pulumi.Input[str]] = None,
            state_value: Optional[pulumi.Input[str]] = None,
            statistic: Optional[pulumi.Input[str]] = None,
            threshold: Optional[pulumi.Input[str]] = None,
            unit: Optional[pulumi.Input[str]] = None) -> 'AlarmRule':
        """
        Get an existing AlarmRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] alarm_action_enabled: Specifies whether to enable the action to be triggered by an alarm.
               The default value is true. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alarm_actions: Specifies the action triggered by an alarm. This is a list of strings.
               Changing this creates a new resource.
        :param pulumi.Input[bool] alarm_enabled: Indicates whether the alarm rule is enabled.
        :param pulumi.Input[int] alarm_level: Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
               which indicates *critical*, *major*, *minor*, and *informational*, respectively.
               The default value is **2**.
        :param pulumi.Input[str] comparison_operator: Specifies the comparison condition of alarm thresholds.
               The value can be **>**, **=**, **<**, **>=** or **<=**.
        :param pulumi.Input[str] description: Specifies the description of the alarm rule.
               The value can be a string of 0 to 1000 characters.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmRuleDimensionArgs']]]] dimensions: Specifies the list of metric dimensions. The structure is described below.
               Changing this creates a new resource.
        :param pulumi.Input[int] evaluation_periods: Specifies the alarm checking evaluation periods.
               The value can be **1**, **2**, **3**, **4** and **5**.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] insufficient_data_actions: Specifies the action triggered when the data is not enough.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[str] metric_name: Specifies the alarm metric name. Changing this creates a new resource.
        :param pulumi.Input[str] name: Specifies the dimension name. Changing this creates a new resource.
        :param pulumi.Input[str] namespace: Specifies the alarm namespace. Changing this creates a new resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ok_actions: Specifies the action triggered by the clearing of an alarm.
               This is a list of strings. Changing this creates a new resource.
        :param pulumi.Input[int] period: Specifies the alarm checking period in milliseconds.
               The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        :param pulumi.Input[str] region: The region in which to create the alarm rule resource. If omitted, the
               provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] state_reason: Indicates the reason of alarm status.
        :param pulumi.Input[str] state_value: Indicates the alarm status.
        :param pulumi.Input[str] statistic: Specifies the data rollup methods. The value can be **maximum**,
               **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        :param pulumi.Input[str] threshold: Specifies the alarm threshold.
        :param pulumi.Input[str] unit: Specifies the data unit. Changing this creates a new resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmRuleState.__new__(_AlarmRuleState)

        __props__.__dict__["alarm_action_enabled"] = alarm_action_enabled
        __props__.__dict__["alarm_actions"] = alarm_actions
        __props__.__dict__["alarm_enabled"] = alarm_enabled
        __props__.__dict__["alarm_level"] = alarm_level
        __props__.__dict__["comparison_operator"] = comparison_operator
        __props__.__dict__["description"] = description
        __props__.__dict__["dimensions"] = dimensions
        __props__.__dict__["evaluation_periods"] = evaluation_periods
        __props__.__dict__["insufficient_data_actions"] = insufficient_data_actions
        __props__.__dict__["metric_name"] = metric_name
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ok_actions"] = ok_actions
        __props__.__dict__["period"] = period
        __props__.__dict__["region"] = region
        __props__.__dict__["state_reason"] = state_reason
        __props__.__dict__["state_value"] = state_value
        __props__.__dict__["statistic"] = statistic
        __props__.__dict__["threshold"] = threshold
        __props__.__dict__["unit"] = unit
        return AlarmRule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmActionEnabled")
    def alarm_action_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies whether to enable the action to be triggered by an alarm.
        The default value is true. Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_action_enabled")

    @property
    @pulumi.getter(name="alarmActions")
    def alarm_actions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the action triggered by an alarm. This is a list of strings.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "alarm_actions")

    @property
    @pulumi.getter(name="alarmEnabled")
    def alarm_enabled(self) -> pulumi.Output[bool]:
        """
        Indicates whether the alarm rule is enabled.
        """
        return pulumi.get(self, "alarm_enabled")

    @property
    @pulumi.getter(name="alarmLevel")
    def alarm_level(self) -> pulumi.Output[Optional[int]]:
        """
        Specifies the alarm severity. The value can be **1**, **2**, **3** or **4**,
        which indicates *critical*, *major*, *minor*, and *informational*, respectively.
        The default value is **2**.
        """
        return pulumi.get(self, "alarm_level")

    @property
    @pulumi.getter(name="comparisonOperator")
    def comparison_operator(self) -> pulumi.Output[str]:
        """
        Specifies the comparison condition of alarm thresholds.
        The value can be **>**, **=**, **<**, **>=** or **<=**.
        """
        return pulumi.get(self, "comparison_operator")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the description of the alarm rule.
        The value can be a string of 0 to 1000 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def dimensions(self) -> pulumi.Output[Sequence['outputs.AlarmRuleDimension']]:
        """
        Specifies the list of metric dimensions. The structure is described below.
        Changing this creates a new resource.
        """
        return pulumi.get(self, "dimensions")

    @property
    @pulumi.getter(name="evaluationPeriods")
    def evaluation_periods(self) -> pulumi.Output[int]:
        """
        Specifies the alarm checking evaluation periods.
        The value can be **1**, **2**, **3**, **4** and **5**.
        """
        return pulumi.get(self, "evaluation_periods")

    @property
    @pulumi.getter(name="insufficientDataActions")
    def insufficient_data_actions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the action triggered when the data is not enough.
        This is a list of strings. Changing this creates a new resource.
        """
        return pulumi.get(self, "insufficient_data_actions")

    @property
    @pulumi.getter(name="metricName")
    def metric_name(self) -> pulumi.Output[str]:
        """
        Specifies the alarm metric name. Changing this creates a new resource.
        """
        return pulumi.get(self, "metric_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the dimension name. Changing this creates a new resource.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        Specifies the alarm namespace. Changing this creates a new resource.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="okActions")
    def ok_actions(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the action triggered by the clearing of an alarm.
        This is a list of strings. Changing this creates a new resource.
        """
        return pulumi.get(self, "ok_actions")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[int]:
        """
        Specifies the alarm checking period in milliseconds.
        The value can be **60,000**, **300,000**, **900,000** and **3,600,000**.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region in which to create the alarm rule resource. If omitted, the
        provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="stateReason")
    def state_reason(self) -> pulumi.Output[str]:
        """
        Indicates the reason of alarm status.
        """
        return pulumi.get(self, "state_reason")

    @property
    @pulumi.getter(name="stateValue")
    def state_value(self) -> pulumi.Output[str]:
        """
        Indicates the alarm status.
        """
        return pulumi.get(self, "state_value")

    @property
    @pulumi.getter
    def statistic(self) -> pulumi.Output[str]:
        """
        Specifies the data rollup methods. The value can be **maximum**,
        **minimum**, **average**, **sum** and **sampleCount**. Changing this creates a new resource.
        """
        return pulumi.get(self, "statistic")

    @property
    @pulumi.getter
    def threshold(self) -> pulumi.Output[str]:
        """
        Specifies the alarm threshold.
        """
        return pulumi.get(self, "threshold")

    @property
    @pulumi.getter
    def unit(self) -> pulumi.Output[str]:
        """
        Specifies the data unit. Changing this creates a new resource.
        """
        return pulumi.get(self, "unit")

