# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BasicArgs', 'Basic']

@pulumi.input_type
class BasicArgs:
    def __init__(__self__, *,
                 eip_id: pulumi.Input[str],
                 traffic_threshold: pulumi.Input[int],
                 region: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Basic resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of an EIP. Changing this creates a new resource.
        :param pulumi.Input[int] traffic_threshold: Specifies the traffic cleaning threshold in Mbps.
               The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        :param pulumi.Input[str] region: Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        pulumi.set(__self__, "eip_id", eip_id)
        pulumi.set(__self__, "traffic_threshold", traffic_threshold)
        if region is not None:
            pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Input[str]:
        """
        Specifies the ID of an EIP. Changing this creates a new resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="trafficThreshold")
    def traffic_threshold(self) -> pulumi.Input[int]:
        """
        Specifies the traffic cleaning threshold in Mbps.
        The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        """
        return pulumi.get(self, "traffic_threshold")

    @traffic_threshold.setter
    def traffic_threshold(self, value: pulumi.Input[int]):
        pulumi.set(self, "traffic_threshold", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)


@pulumi.input_type
class _BasicState:
    def __init__(__self__, *,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 public_ip: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 traffic_threshold: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Basic resources.
        :param pulumi.Input[str] eip_id: Specifies the ID of an EIP. Changing this creates a new resource.
        :param pulumi.Input[str] public_ip: The public address of the EIP.
        :param pulumi.Input[str] region: Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] status: The Anti-DDos status.
        :param pulumi.Input[int] traffic_threshold: Specifies the traffic cleaning threshold in Mbps.
               The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        """
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if public_ip is not None:
            pulumi.set(__self__, "public_ip", public_ip)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if traffic_threshold is not None:
            pulumi.set(__self__, "traffic_threshold", traffic_threshold)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the ID of an EIP. Changing this creates a new resource.
        """
        return pulumi.get(self, "eip_id")

    @eip_id.setter
    def eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_id", value)

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The public address of the EIP.
        """
        return pulumi.get(self, "public_ip")

    @public_ip.setter
    def public_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_ip", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The Anti-DDos status.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="trafficThreshold")
    def traffic_threshold(self) -> Optional[pulumi.Input[int]]:
        """
        Specifies the traffic cleaning threshold in Mbps.
        The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        """
        return pulumi.get(self, "traffic_threshold")

    @traffic_threshold.setter
    def traffic_threshold(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "traffic_threshold", value)


class Basic(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 traffic_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages Cloud Native Anti-DDos Basic resource within HuaweiCloud.

        > The Cloud Native Anti-DDos Basic resource will be set to the default traffic cleaning threshold when destroyed,
          instead of deleting it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        eip_id = config.require_object("eipId")
        antiddos1 = huaweicloud.anti_d_dos.Basic("antiddos1",
            eip_id=eip_id,
            traffic_threshold=150)
        ```

        ## Import

        Cloud Native Anti-DDos Basic resources can be imported using `eip_id`. e.g.

        ```sh
         $ pulumi import huaweicloud:AntiDDos/basic:Basic antiddos_1 c5256d47-8f9e-4ae7-9943-6e77e3d8bd2d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of an EIP. Changing this creates a new resource.
        :param pulumi.Input[str] region: Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[int] traffic_threshold: Specifies the traffic cleaning threshold in Mbps.
               The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BasicArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages Cloud Native Anti-DDos Basic resource within HuaweiCloud.

        > The Cloud Native Anti-DDos Basic resource will be set to the default traffic cleaning threshold when destroyed,
          instead of deleting it.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_huaweicloud as huaweicloud

        config = pulumi.Config()
        eip_id = config.require_object("eipId")
        antiddos1 = huaweicloud.anti_d_dos.Basic("antiddos1",
            eip_id=eip_id,
            traffic_threshold=150)
        ```

        ## Import

        Cloud Native Anti-DDos Basic resources can be imported using `eip_id`. e.g.

        ```sh
         $ pulumi import huaweicloud:AntiDDos/basic:Basic antiddos_1 c5256d47-8f9e-4ae7-9943-6e77e3d8bd2d
        ```

        :param str resource_name: The name of the resource.
        :param BasicArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BasicArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 eip_id: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 traffic_threshold: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BasicArgs.__new__(BasicArgs)

            if eip_id is None and not opts.urn:
                raise TypeError("Missing required property 'eip_id'")
            __props__.__dict__["eip_id"] = eip_id
            __props__.__dict__["region"] = region
            if traffic_threshold is None and not opts.urn:
                raise TypeError("Missing required property 'traffic_threshold'")
            __props__.__dict__["traffic_threshold"] = traffic_threshold
            __props__.__dict__["public_ip"] = None
            __props__.__dict__["status"] = None
        super(Basic, __self__).__init__(
            'huaweicloud:AntiDDos/basic:Basic',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            eip_id: Optional[pulumi.Input[str]] = None,
            public_ip: Optional[pulumi.Input[str]] = None,
            region: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            traffic_threshold: Optional[pulumi.Input[int]] = None) -> 'Basic':
        """
        Get an existing Basic resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] eip_id: Specifies the ID of an EIP. Changing this creates a new resource.
        :param pulumi.Input[str] public_ip: The public address of the EIP.
        :param pulumi.Input[str] region: Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
               If omitted, the provider-level region will be used. Changing this creates a new resource.
        :param pulumi.Input[str] status: The Anti-DDos status.
        :param pulumi.Input[int] traffic_threshold: Specifies the traffic cleaning threshold in Mbps.
               The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BasicState.__new__(_BasicState)

        __props__.__dict__["eip_id"] = eip_id
        __props__.__dict__["public_ip"] = public_ip
        __props__.__dict__["region"] = region
        __props__.__dict__["status"] = status
        __props__.__dict__["traffic_threshold"] = traffic_threshold
        return Basic(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> pulumi.Output[str]:
        """
        Specifies the ID of an EIP. Changing this creates a new resource.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> pulumi.Output[str]:
        """
        The public address of the EIP.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        Specifies the region in which to manage the Cloud Native Anti-DDos Basic resource.
        If omitted, the provider-level region will be used. Changing this creates a new resource.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The Anti-DDos status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="trafficThreshold")
    def traffic_threshold(self) -> pulumi.Output[int]:
        """
        Specifies the traffic cleaning threshold in Mbps.
        The value can be 10, 30, 50, 70, 100, 120, 150, 200, 250, 300, 1000 Mbps.
        """
        return pulumi.get(self, "traffic_threshold")

