# Configuration file for the Sphinx documentation builder.
#
# For information on options, see
#   http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import subprocess

sys.path.insert(0, os.path.abspath("../xml"))
sys.path.insert(0, os.path.abspath("../unbaffeld/database"))

# Ignore missing imports, they may not have been installed yet.
autodoc_mock_imports = ["h5py"]

project = "unbaffeld Documentation"
copyright = "2021, EFIT-AI team"
author = "EFIT-AI Team"


release = "0.0.1"

# -- General configuration ---------------------------------------------------
needs_sphinx = "3.2"
nitpicky = True  # checks internal links
master_doc = "index"

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The language for content generated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
# language = 'fortran'

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]
numfig = True


# -- Extensions ----------------------------------------------------------------
# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinxcontrib.bibtex",
    "sphinx.ext.autodoc",
]

bibtex_bibfiles = ["unbaffeld.bib"]


# -- Options for HTML output -------------------------------------------------

html_theme = "pydata_sphinx_theme"

html_theme_options = {
    "icon_links": [
        {
            "name": "GitLab",
            "url": "https://gitlab.com/efit-ai/unbaffeld",
            "icon": "fab fa-gitlab",
        },
    ],
    "use_edit_page_button": True,
    "footer_items": ["copyright", "sphinx-version", "last-updated"],
}

html_context = {
    "github_url": "https://gitlab.com",
    "github_user": "efit-ai",
    "github_repo": "unbaffeld",
    "github_version": "main",
    "doc_path": "doc",
}

git_describe_version = (
    subprocess.check_output(["git", "describe", "--always"]).strip().decode("utf-8")
)
# html_logo = os.path.join('images', 'logos',  'efit.svg')
# html_favicon = os.path.join('images', 'logos', 'efit_favicon.png')
html_last_updated_fmt = r"%Y-%m-%dT%H:%M:%S%z (" + git_describe_version + ")"
