"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnGroupAccessToProject = exports.CfnGroupAccessToProjectPropsAccessLevel = exports.toJson_CfnGroupAccessToProjectProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnGroupAccessToProjectProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnGroupAccessToProjectProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ProjectId': obj.projectId,
        'GroupId': obj.groupId,
        'AccessLevel': obj.accessLevel,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnGroupAccessToProjectProps = toJson_CfnGroupAccessToProjectProps;
/* eslint-enable max-len, quote-props */
/**
 * The access level to grant to this group for the project, e.g. 'guest', 'developer', or 'maintainer'. Note the GitLab API may not allow all values.
 *
 * @schema CfnGroupAccessToProjectPropsAccessLevel
 */
var CfnGroupAccessToProjectPropsAccessLevel;
(function (CfnGroupAccessToProjectPropsAccessLevel) {
    /** None */
    CfnGroupAccessToProjectPropsAccessLevel["NONE"] = "None";
    /** Minimal Access */
    CfnGroupAccessToProjectPropsAccessLevel["MINIMAL_ACCESS"] = "Minimal Access";
    /** Guest */
    CfnGroupAccessToProjectPropsAccessLevel["GUEST"] = "Guest";
    /** Reporter */
    CfnGroupAccessToProjectPropsAccessLevel["REPORTER"] = "Reporter";
    /** Developer */
    CfnGroupAccessToProjectPropsAccessLevel["DEVELOPER"] = "Developer";
    /** Maintainer */
    CfnGroupAccessToProjectPropsAccessLevel["MAINTAINER"] = "Maintainer";
    /** Owner */
    CfnGroupAccessToProjectPropsAccessLevel["OWNER"] = "Owner";
    /** Admin */
    CfnGroupAccessToProjectPropsAccessLevel["ADMIN"] = "Admin";
})(CfnGroupAccessToProjectPropsAccessLevel = exports.CfnGroupAccessToProjectPropsAccessLevel || (exports.CfnGroupAccessToProjectPropsAccessLevel = {}));
/**
 * A CloudFormation `GitLab::Projects::GroupAccessToProject`
 *
 * @cloudformationResource GitLab::Projects::GroupAccessToProject
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
class CfnGroupAccessToProject extends cdk.CfnResource {
    /**
     * Create a new `GitLab::Projects::GroupAccessToProject`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnGroupAccessToProject.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnGroupAccessToProjectProps(props) });
        this.props = props;
        this.attrMembershipId = cdk.Token.asString(this.getAtt('MembershipId'));
    }
}
exports.CfnGroupAccessToProject = CfnGroupAccessToProject;
_a = JSII_RTTI_SYMBOL_1;
CfnGroupAccessToProject[_a] = { fqn: "@cdk-cloudformation/gitlab-projects-groupaccesstoproject.CfnGroupAccessToProject", version: "1.3.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnGroupAccessToProject.CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::GroupAccessToProject";
//# sourceMappingURL=data:application/json;base64,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