import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Adds a group as a member of a GitLab project
 *
 * @schema CfnGroupAccessToProjectProps
 */
export interface CfnGroupAccessToProjectProps {
    /**
     * ID of the project to which the group should be added
     *
     * @schema CfnGroupAccessToProjectProps#ProjectId
     */
    readonly projectId: number;
    /**
     * ID of the group which should be added to the project
     *
     * @schema CfnGroupAccessToProjectProps#GroupId
     */
    readonly groupId: number;
    /**
     * The access level to grant to this group for the project, e.g. 'guest', 'developer', or 'maintainer'. Note the GitLab API may not allow all values.
     *
     * @schema CfnGroupAccessToProjectProps#AccessLevel
     */
    readonly accessLevel: CfnGroupAccessToProjectPropsAccessLevel;
}
/**
 * Converts an object of type 'CfnGroupAccessToProjectProps' to JSON representation.
 */
export declare function toJson_CfnGroupAccessToProjectProps(obj: CfnGroupAccessToProjectProps | undefined): Record<string, any> | undefined;
/**
 * The access level to grant to this group for the project, e.g. 'guest', 'developer', or 'maintainer'. Note the GitLab API may not allow all values.
 *
 * @schema CfnGroupAccessToProjectPropsAccessLevel
 */
export declare enum CfnGroupAccessToProjectPropsAccessLevel {
    /** None */
    NONE = "None",
    /** Minimal Access */
    MINIMAL_ACCESS = "Minimal Access",
    /** Guest */
    GUEST = "Guest",
    /** Reporter */
    REPORTER = "Reporter",
    /** Developer */
    DEVELOPER = "Developer",
    /** Maintainer */
    MAINTAINER = "Maintainer",
    /** Owner */
    OWNER = "Owner",
    /** Admin */
    ADMIN = "Admin"
}
/**
 * A CloudFormation `GitLab::Projects::GroupAccessToProject`
 *
 * @cloudformationResource GitLab::Projects::GroupAccessToProject
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
 */
export declare class CfnGroupAccessToProject extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "GitLab::Projects::GroupAccessToProject";
    /**
     * Resource props.
     */
    readonly props: CfnGroupAccessToProjectProps;
    /**
     * Attribute `GitLab::Projects::GroupAccessToProject.MembershipId`
     * @link https://github.com/aws-ia/cloudformation-gitlab-resource-providers.git
     */
    readonly attrMembershipId: string;
    /**
     * Create a new `GitLab::Projects::GroupAccessToProject`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnGroupAccessToProjectProps);
}
