# AUTOGENERATED! DO NOT EDIT! File to edit: 03_functions.ipynb (unless otherwise specified).

__all__ = ['normalize', 'split_by_newline', 'rm_useless_spaces', 'make_sentences', 'write_to_file_cleaned', 'clean']

# Cell
import os
import pandas as pd
import pickle
import numpy as np
import seaborn as sns
import matplotlib.pyplot as plt
from sklearn.metrics.pairwise import cosine_similarity
import nltk
nltk.download('punkt')
from nltk.tokenize import sent_tokenize
from nltk.tokenize import word_tokenize

import unidecode
import re


# Cell
def normalize(data):
    """
    The function takes an array, matrix as input and normalizes
    it between 0 and 1

    Args:
        data (ndarray): any 1-D, or 2-D numpy array

    Returns:
        (ndarray): normalized ndarray
    """
    return (data - np.min(data)) / (np.max(data) - np.min(data))

# Cell
def split_by_newline(all):
    """
    Only use when sentences are already tokenized
    returns sentences split by '\\n' if len(line) > 0

    Args:
        all (str): tokenized string to be split by '\\n'

    Returns:
        list: list of sentences split by '\\n'
    """
    return [line.lower() for line in all.split('\n') if len(line) > 0]

# Cell
def rm_useless_spaces(t):
    "Remove multiple spaces"
    _re_space = re.compile(' {2,}')
    return _re_space.sub(' ', t)

# Cell
def make_sentences(all):
    all_cleaned = all.replace('\n',' ')
    all_cleaned = rm_useless_spaces(all_cleaned)
    all_cleaned = all_cleaned.strip()
    all_cleaned = unidecode.unidecode(all_cleaned)
    sentences = sent_tokenize(all_cleaned)
    return sentences

# Cell
def write_to_file_cleaned(sentences, fname):
    with open(fname[:-4]+'_cleaned.txt', 'w') as f:
        for line in sentences:
            f.write(line + '\n')
    f.close()

# Cell
def clean(fname):
    all = get_data(fname)
    sentences = make_sentences(all)
    print(fname[:-4].title() + ' contains {} sentences'.format(len(sentences)))
    write_to_file_cleaned(sentences, fname)