"""Deletion of the mined table

Revision ID: e04e8301d1a2
Revises: d8893cd406db
Create Date: 2020-12-07 12:33:43.650514

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy.dialects import mysql

# pylint: skip-file

# revision identifiers, used by Alembic.
revision = "e04e8301d1a2"
down_revision = "d8893cd406db"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_pyfunceble_mined_mined", table_name="pyfunceble_mined")
    op.drop_table("pyfunceble_mined")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pyfunceble_mined",
        sa.Column(
            "id", mysql.INTEGER(display_width=11), autoincrement=True, nullable=False
        ),
        sa.Column("created", mysql.DATETIME(), nullable=False),
        sa.Column("modified", mysql.DATETIME(), nullable=True),
        sa.Column(
            "subject_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "file_id",
            mysql.INTEGER(display_width=11),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("mined", mysql.TEXT(collation="utf8mb4_unicode_ci"), nullable=False),
        sa.ForeignKeyConstraint(
            ["file_id"],
            ["pyfunceble_file.id"],
            name="pyfunceble_mined_ibfk_1",
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["subject_id"],
            ["pyfunceble_status.id"],
            name="pyfunceble_mined_ibfk_2",
            onupdate="CASCADE",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id"),
        mysql_collate="utf8mb4_unicode_ci",
        mysql_default_charset="utf8mb4",
        mysql_engine="InnoDB",
    )
    op.create_index(
        "ix_pyfunceble_mined_mined", "pyfunceble_mined", ["mined"], unique=False
    )
    # ### end Alembic commands ###
