# EUMDAC - EUMETSAT Data Access Client

**EUMDAC** is the **EUM**ETSAT **D**ata **A**ccess **C**lient. It provides simple access to the EUMETSAT data of all satellite missions. As a **Python library**, it comes with many methods and helpers to use EUMETSATs APIs and services, like Data Store and Data Tailor. As a **CLI**, it provides a variety of useful command line utilities for data search, translation and processing.

Check the [EUMDAC knowledge base](https://eumetsatspace.atlassian.net/wiki/spaces/EUMDAC/overview) for more information on installing and using the CLI and library.

## Prerequisites
 
You will need a python environment to run the library implementation of this code. EUMDAC requires Python 3.7 or higher. We recommend that you install the latest Anaconda Python distribution for your operating system (https://www.anaconda.com/). No prerequisites are identified for running the CLI binary.

## Installing the EUMDAC library and CLI

### Installing with PIP

The EUMDAC Python package is available through [PyPI](https://pypi.org/):
```bash
pip install eumdac
```

### Installing with Conda

To install EUMDAC on the Anaconda Python distribution, please visit the [EUMETSAT conda-forge page](https://anaconda.org/Eumetsat/repo) for install instructions.
```bash
conda install -c eumetsat-forge eumdac
```

### Installing from source

To install EUMDAC from the development source, clone the repository and install it locally.

```bash
git clone https://gitlab.eumetsat.int/eumetlab/data-services/eumdac.git
cd eumdac
pip install .
```

## Using the EUMDAC CLI binaries (no installation required)
If an installation of EUMDAC is not possible due to missing technical prerequisites, we recommend to use our binaries. These executable applications allow you to use all the functions of the CLI without installation. 

The binaries are available for Windows, Linux and Mac in the [Releases section](https://gitlab.eumetsat.int/eumetlab/data-services/eumdac/-/releases).

You can find more information in the [EUMDAC knowledge base](https://eumetsatspace.atlassian.net/wiki/spaces/EUMDAC/pages/1759805454/Command+Line+User+Guide).

## Contributing
If you feel like something is missing, should work differently or you find a bug in EUMDAC you are encouraged to provide feedback to the development team on EUMDAC. Please contact us via the [EUMETSAT User Support Helpdesk](mailto:ops@eumetsat.int) if you have suggestions or questions.

## Authors
* [**Carlos Horn**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)
* [**Ben Loveday**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)
* [**Niklas Jordan**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)
* [**Paulo Carmo**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)
* [**Christopher Saloman**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)
* [**Matthias Schwarz**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)
* [**Joaquin Rodríguez-Guerra**](mailto://ops@eumetsat.int) - [EUMETSAT](https://eumetsat.int)
* [**Rafa de la Hoz**](mailto://ops@eumetsat.int) - [EUMETSAT](http://www.eumetsat.int)

## Dependencies
requests,   ver. 2.26.0, License: Apache-2.0 (LICENSE_APACHE_v2.txt), Copyright 2014 Kenneth Reitz,   info: https://anaconda.org/conda-forge/requests  \
responses,  ver. 0.16.0, License: Apache-2.0 (LICENSE_APACHE_v2.txt), Copyright 2015 David Cramer,    info: https://anaconda.org/conda-forge/responses  \
setuptools, ver. 58.0.4, License: MIT (LICENSE_MIT.txt),              Copyright 2020 Jason R. Coombs, info: https://anaconda.org/conda-forge/setuptools  

## License
 
This code is licensed under an MIT license. See file LICENSE.txt for details on the usage and distribution terms. No dependencies are distributed as part of this package.

All product names, logos, and brands are property of their respective owners. All company, product and service names used in this website are for identification purposes only
