"""
    NCBI Datasets API

    ### NCBI Datasets is a resource that lets you easily gather data from NCBI. The Datasets API is still in alpha, and we're updating it often to add new functionality, iron out bugs and enhance usability. For some larger downloads, you may want to download a [dehydrated bag](https://www.ncbi.nlm.nih.gov/datasets/docs/rehydrate/), and retrieve the individual data files at a later time.   # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from ncbi.datasets.openapi.api_client import ApiClient, Endpoint as _Endpoint
from ncbi.datasets.openapi.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from ncbi.datasets.openapi.model.rpc_status import RpcStatus
from ncbi.datasets.openapi.model.v1_annotation_for_virus_type import V1AnnotationForVirusType
from ncbi.datasets.openapi.model.v1_download_summary import V1DownloadSummary
from ncbi.datasets.openapi.model.v1_table_format import V1TableFormat
from ncbi.datasets.openapi.model.v1_tabular_output import V1TabularOutput
from ncbi.datasets.openapi.model.v1_virus_data_report_request import V1VirusDataReportRequest
from ncbi.datasets.openapi.model.v1_virus_data_report_request_content_type import V1VirusDataReportRequestContentType
from ncbi.datasets.openapi.model.v1_virus_dataset_request import V1VirusDatasetRequest
from ncbi.datasets.openapi.model.v1_virus_table_field import V1VirusTableField
from ncbi.datasets.openapi.model.v1reports_virus_data_report_page import V1reportsVirusDataReportPage


class VirusApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.sars2_protein_download_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/sars2/protein/{proteins}/download',
                'operation_id': 'sars2_protein_download',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'proteins',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'geo_location',
                    'complete_only',
                    'include_annotation_type',
                    'filename',
                ],
                'required': [
                    'proteins',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'proteins':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'proteins': 'proteins',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'include_annotation_type': 'include_annotation_type',
                    'filename': 'filename',
                },
                'location_map': {
                    'proteins': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'include_annotation_type': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'proteins': 'csv',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sars2_protein_summary_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/sars2/protein/{proteins}',
                'operation_id': 'sars2_protein_summary',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'proteins',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'geo_location',
                    'complete_only',
                    'include_annotation_type',
                ],
                'required': [
                    'proteins',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'proteins':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                },
                'attribute_map': {
                    'proteins': 'proteins',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'include_annotation_type': 'include_annotation_type',
                },
                'location_map': {
                    'proteins': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'include_annotation_type': 'query',
                },
                'collection_format_map': {
                    'proteins': 'csv',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.sars2_protein_table_endpoint = _Endpoint(
            settings={
                'response_type': (V1TabularOutput,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/sars2/protein/{proteins}/table',
                'operation_id': 'sars2_protein_table',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'proteins',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'geo_location',
                    'complete_only',
                    'table_fields',
                    'format',
                ],
                'required': [
                    'proteins',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'proteins':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'table_fields':
                        ([V1VirusTableField],),
                    'format':
                        (V1TableFormat,),
                },
                'attribute_map': {
                    'proteins': 'proteins',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'table_fields': 'table_fields',
                    'format': 'format',
                },
                'location_map': {
                    'proteins': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'table_fields': 'query',
                    'format': 'query',
                },
                'collection_format_map': {
                    'proteins': 'csv',
                    'table_fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_download_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/genome/download',
                'operation_id': 'virus_genome_download',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'exclude_sequence',
                    'include_annotation_type',
                    'filename',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                    'filename': 'filename',
                },
                'location_map': {
                    'taxon': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_download_accession_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/accession/{accessions}/genome/download',
                'operation_id': 'virus_genome_download_accession',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'exclude_sequence',
                    'include_annotation_type',
                    'filename',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                    'filename': 'filename',
                },
                'location_map': {
                    'accessions': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                    'filename': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_download_post_endpoint = _Endpoint(
            settings={
                'response_type': (file_type,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/genome/download',
                'operation_id': 'virus_genome_download_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_virus_dataset_request',
                    'filename',
                ],
                'required': [
                    'v1_virus_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_virus_dataset_request':
                        (V1VirusDatasetRequest,),
                    'filename':
                        (str,),
                },
                'attribute_map': {
                    'filename': 'filename',
                },
                'location_map': {
                    'v1_virus_dataset_request': 'body',
                    'filename': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/zip',
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.virus_genome_summary_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/genome',
                'operation_id': 'virus_genome_summary',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'exclude_sequence',
                    'include_annotation_type',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                },
                'location_map': {
                    'taxon': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                },
                'collection_format_map': {
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_summary_accession_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/accession/{accessions}/genome',
                'operation_id': 'virus_genome_summary_accession',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'exclude_sequence',
                    'include_annotation_type',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'exclude_sequence':
                        (bool,),
                    'include_annotation_type':
                        ([V1AnnotationForVirusType],),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'exclude_sequence': 'exclude_sequence',
                    'include_annotation_type': 'include_annotation_type',
                },
                'location_map': {
                    'accessions': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'exclude_sequence': 'query',
                    'include_annotation_type': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'include_annotation_type': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_genome_summary_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1DownloadSummary,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/genome',
                'operation_id': 'virus_genome_summary_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_virus_dataset_request',
                ],
                'required': [
                    'v1_virus_dataset_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_virus_dataset_request':
                        (V1VirusDatasetRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_virus_dataset_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.virus_genome_table_endpoint = _Endpoint(
            settings={
                'response_type': (V1TabularOutput,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/genome/table',
                'operation_id': 'virus_genome_table',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'refseq_only',
                    'annotated_only',
                    'released_since',
                    'host',
                    'pangolin_classification',
                    'geo_location',
                    'complete_only',
                    'table_fields',
                    'format',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'refseq_only':
                        (bool,),
                    'annotated_only':
                        (bool,),
                    'released_since':
                        (datetime,),
                    'host':
                        (str,),
                    'pangolin_classification':
                        (str,),
                    'geo_location':
                        (str,),
                    'complete_only':
                        (bool,),
                    'table_fields':
                        ([V1VirusTableField],),
                    'format':
                        (V1TableFormat,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'refseq_only': 'refseq_only',
                    'annotated_only': 'annotated_only',
                    'released_since': 'released_since',
                    'host': 'host',
                    'pangolin_classification': 'pangolin_classification',
                    'geo_location': 'geo_location',
                    'complete_only': 'complete_only',
                    'table_fields': 'table_fields',
                    'format': 'format',
                },
                'location_map': {
                    'taxon': 'path',
                    'refseq_only': 'query',
                    'annotated_only': 'query',
                    'released_since': 'query',
                    'host': 'query',
                    'pangolin_classification': 'query',
                    'geo_location': 'query',
                    'complete_only': 'query',
                    'table_fields': 'query',
                    'format': 'query',
                },
                'collection_format_map': {
                    'table_fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_reports_by_acessions_endpoint = _Endpoint(
            settings={
                'response_type': (V1reportsVirusDataReportPage,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/accession/{accessions}/dataset_report',
                'operation_id': 'virus_reports_by_acessions',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'accessions',
                    'filter_refseq_only',
                    'filter_annotated_only',
                    'filter_released_since',
                    'filter_host',
                    'filter_pangolin_classification',
                    'filter_geo_location',
                    'filter_complete_only',
                    'returned_content',
                    'table_fields',
                    'page_size',
                    'page_token',
                ],
                'required': [
                    'accessions',
                ],
                'nullable': [
                ],
                'enum': [
                    'table_fields',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('table_fields',): {

                        "ACCESSION": "accession",
                        "BIOPROJECTS": "bioprojects",
                        "BIOSAMPLE-ACC": "biosample-acc",
                        "COMPLETENESS": "completeness",
                        "GENE-COUNT": "gene-count",
                        "GEO-LOCATION": "geo-location",
                        "GEO-REGION": "geo-region",
                        "HOST-COMMON-NAME": "host-common-name",
                        "HOST-INFRASPECIFIC-BREED": "host-infraspecific-breed",
                        "HOST-INFRASPECIFIC-CULTIVAR": "host-infraspecific-cultivar",
                        "HOST-INFRASPECIFIC-ECOTYPE": "host-infraspecific-ecotype",
                        "HOST-INFRASPECIFIC-ISOLATE": "host-infraspecific-isolate",
                        "HOST-INFRASPECIFIC-SEX": "host-infraspecific-sex",
                        "HOST-INFRASPECIFIC-STRAIN": "host-infraspecific-strain",
                        "HOST-NAME": "host-name",
                        "HOST-PANGOLIN": "host-pangolin",
                        "HOST-TAX-ID": "host-tax-id",
                        "IS-ANNOTATED": "is-annotated",
                        "IS-COMPLETE": "is-complete",
                        "ISOLATE-COLLECTION-DATE": "isolate-collection-date",
                        "ISOLATE-LINEAGE": "isolate-lineage",
                        "ISOLATE-LINEAGE-SOURCE": "isolate-lineage-source",
                        "LENGTH": "length",
                        "MATPEPTIDE-COUNT": "matpeptide-count",
                        "MOL-TYPE": "mol-type",
                        "NUCLEOTIDE-COMPLETENESS": "nucleotide-completeness",
                        "PROTEIN-COUNT": "protein-count",
                        "PURPOSE-OF-SAMPLING": "purpose-of-sampling",
                        "RELEASE-DATE": "release-date",
                        "SOURCEDB": "sourcedb",
                        "SRA-ACCS": "sra-accs",
                        "UPDATE-DATE": "update-date",
                        "VIRUS-COMMON-NAME": "virus-common-name",
                        "VIRUS-INFRASPECIFIC-BREED": "virus-infraspecific-breed",
                        "VIRUS-INFRASPECIFIC-CULTIVAR": "virus-infraspecific-cultivar",
                        "VIRUS-INFRASPECIFIC-ECOTYPE": "virus-infraspecific-ecotype",
                        "VIRUS-INFRASPECIFIC-ISOLATE": "virus-infraspecific-isolate",
                        "VIRUS-INFRASPECIFIC-SEX": "virus-infraspecific-sex",
                        "VIRUS-INFRASPECIFIC-STRAIN": "virus-infraspecific-strain",
                        "VIRUS-NAME": "virus-name",
                        "VIRUS-PANGOLIN": "virus-pangolin",
                        "VIRUS-TAX-ID": "virus-tax-id"
                    },
                },
                'openapi_types': {
                    'accessions':
                        ([str],),
                    'filter_refseq_only':
                        (bool,),
                    'filter_annotated_only':
                        (bool,),
                    'filter_released_since':
                        (datetime,),
                    'filter_host':
                        (str,),
                    'filter_pangolin_classification':
                        (str,),
                    'filter_geo_location':
                        (str,),
                    'filter_complete_only':
                        (bool,),
                    'returned_content':
                        (V1VirusDataReportRequestContentType,),
                    'table_fields':
                        ([str],),
                    'page_size':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'accessions': 'accessions',
                    'filter_refseq_only': 'filter.refseq_only',
                    'filter_annotated_only': 'filter.annotated_only',
                    'filter_released_since': 'filter.released_since',
                    'filter_host': 'filter.host',
                    'filter_pangolin_classification': 'filter.pangolin_classification',
                    'filter_geo_location': 'filter.geo_location',
                    'filter_complete_only': 'filter.complete_only',
                    'returned_content': 'returned_content',
                    'table_fields': 'table_fields',
                    'page_size': 'page_size',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'accessions': 'path',
                    'filter_refseq_only': 'query',
                    'filter_annotated_only': 'query',
                    'filter_released_since': 'query',
                    'filter_host': 'query',
                    'filter_pangolin_classification': 'query',
                    'filter_geo_location': 'query',
                    'filter_complete_only': 'query',
                    'returned_content': 'query',
                    'table_fields': 'query',
                    'page_size': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                    'accessions': 'csv',
                    'table_fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/tab-separated-values',
                    'application/x-tabular'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.virus_reports_by_post_endpoint = _Endpoint(
            settings={
                'response_type': (V1reportsVirusDataReportPage,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus',
                'operation_id': 'virus_reports_by_post',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'v1_virus_data_report_request',
                ],
                'required': [
                    'v1_virus_data_report_request',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'v1_virus_data_report_request':
                        (V1VirusDataReportRequest,),
                },
                'attribute_map': {
                },
                'location_map': {
                    'v1_virus_data_report_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/tab-separated-values',
                    'application/x-tabular'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client
        )
        self.virus_reports_by_taxon_endpoint = _Endpoint(
            settings={
                'response_type': (V1reportsVirusDataReportPage,),
                'auth': [
                    'ApiKeyAuthHeader'
                ],
                'endpoint_path': '/virus/taxon/{taxon}/dataset_report',
                'operation_id': 'virus_reports_by_taxon',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'taxon',
                    'filter_refseq_only',
                    'filter_annotated_only',
                    'filter_released_since',
                    'filter_host',
                    'filter_pangolin_classification',
                    'filter_geo_location',
                    'filter_complete_only',
                    'returned_content',
                    'table_fields',
                    'page_size',
                    'page_token',
                ],
                'required': [
                    'taxon',
                ],
                'nullable': [
                ],
                'enum': [
                    'table_fields',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('table_fields',): {

                        "ACCESSION": "accession",
                        "BIOPROJECTS": "bioprojects",
                        "BIOSAMPLE-ACC": "biosample-acc",
                        "COMPLETENESS": "completeness",
                        "GENE-COUNT": "gene-count",
                        "GEO-LOCATION": "geo-location",
                        "GEO-REGION": "geo-region",
                        "HOST-COMMON-NAME": "host-common-name",
                        "HOST-INFRASPECIFIC-BREED": "host-infraspecific-breed",
                        "HOST-INFRASPECIFIC-CULTIVAR": "host-infraspecific-cultivar",
                        "HOST-INFRASPECIFIC-ECOTYPE": "host-infraspecific-ecotype",
                        "HOST-INFRASPECIFIC-ISOLATE": "host-infraspecific-isolate",
                        "HOST-INFRASPECIFIC-SEX": "host-infraspecific-sex",
                        "HOST-INFRASPECIFIC-STRAIN": "host-infraspecific-strain",
                        "HOST-NAME": "host-name",
                        "HOST-PANGOLIN": "host-pangolin",
                        "HOST-TAX-ID": "host-tax-id",
                        "IS-ANNOTATED": "is-annotated",
                        "IS-COMPLETE": "is-complete",
                        "ISOLATE-COLLECTION-DATE": "isolate-collection-date",
                        "ISOLATE-LINEAGE": "isolate-lineage",
                        "ISOLATE-LINEAGE-SOURCE": "isolate-lineage-source",
                        "LENGTH": "length",
                        "MATPEPTIDE-COUNT": "matpeptide-count",
                        "MOL-TYPE": "mol-type",
                        "NUCLEOTIDE-COMPLETENESS": "nucleotide-completeness",
                        "PROTEIN-COUNT": "protein-count",
                        "PURPOSE-OF-SAMPLING": "purpose-of-sampling",
                        "RELEASE-DATE": "release-date",
                        "SOURCEDB": "sourcedb",
                        "SRA-ACCS": "sra-accs",
                        "UPDATE-DATE": "update-date",
                        "VIRUS-COMMON-NAME": "virus-common-name",
                        "VIRUS-INFRASPECIFIC-BREED": "virus-infraspecific-breed",
                        "VIRUS-INFRASPECIFIC-CULTIVAR": "virus-infraspecific-cultivar",
                        "VIRUS-INFRASPECIFIC-ECOTYPE": "virus-infraspecific-ecotype",
                        "VIRUS-INFRASPECIFIC-ISOLATE": "virus-infraspecific-isolate",
                        "VIRUS-INFRASPECIFIC-SEX": "virus-infraspecific-sex",
                        "VIRUS-INFRASPECIFIC-STRAIN": "virus-infraspecific-strain",
                        "VIRUS-NAME": "virus-name",
                        "VIRUS-PANGOLIN": "virus-pangolin",
                        "VIRUS-TAX-ID": "virus-tax-id"
                    },
                },
                'openapi_types': {
                    'taxon':
                        (str,),
                    'filter_refseq_only':
                        (bool,),
                    'filter_annotated_only':
                        (bool,),
                    'filter_released_since':
                        (datetime,),
                    'filter_host':
                        (str,),
                    'filter_pangolin_classification':
                        (str,),
                    'filter_geo_location':
                        (str,),
                    'filter_complete_only':
                        (bool,),
                    'returned_content':
                        (V1VirusDataReportRequestContentType,),
                    'table_fields':
                        ([str],),
                    'page_size':
                        (int,),
                    'page_token':
                        (str,),
                },
                'attribute_map': {
                    'taxon': 'taxon',
                    'filter_refseq_only': 'filter.refseq_only',
                    'filter_annotated_only': 'filter.annotated_only',
                    'filter_released_since': 'filter.released_since',
                    'filter_host': 'filter.host',
                    'filter_pangolin_classification': 'filter.pangolin_classification',
                    'filter_geo_location': 'filter.geo_location',
                    'filter_complete_only': 'filter.complete_only',
                    'returned_content': 'returned_content',
                    'table_fields': 'table_fields',
                    'page_size': 'page_size',
                    'page_token': 'page_token',
                },
                'location_map': {
                    'taxon': 'path',
                    'filter_refseq_only': 'query',
                    'filter_annotated_only': 'query',
                    'filter_released_since': 'query',
                    'filter_host': 'query',
                    'filter_pangolin_classification': 'query',
                    'filter_geo_location': 'query',
                    'filter_complete_only': 'query',
                    'returned_content': 'query',
                    'table_fields': 'query',
                    'page_size': 'query',
                    'page_token': 'query',
                },
                'collection_format_map': {
                    'table_fields': 'multi',
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/tab-separated-values',
                    'application/x-tabular'
                ],
                'content_type': [],
            },
            api_client=api_client
        )

    def sars2_protein_download(
        self,
        proteins,
        **kwargs
    ):
        """Download SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sars2_protein_download(proteins, async_req=True)
        >>> result = thread.get()

        Args:
            proteins ([str]): Which proteins to retrieve in the data package

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['proteins'] = \
            proteins
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.sars2_protein_download_endpoint.call_with_http_info(**kwargs)

    def sars2_protein_summary(
        self,
        proteins,
        **kwargs
    ):
        """Summary of SARS-CoV-2 protein and CDS datasets by protein name  # noqa: E501

        Download a summary of available SARS-CoV-2 protein datasets  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sars2_protein_summary(proteins, async_req=True)
        >>> result = thread.get()

        Args:
            proteins ([str]): Which proteins to retrieve in the data package

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['proteins'] = \
            proteins
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.sars2_protein_summary_endpoint.call_with_http_info(**kwargs)

    def sars2_protein_table(
        self,
        proteins,
        **kwargs
    ):
        """Get SARS-CoV-2 protein metadata in a tabular format.  # noqa: E501

        Get protein metadata in tabular format for SARS-CoV-2 genomes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.sars2_protein_table(proteins, async_req=True)
        >>> result = thread.get()

        Args:
            proteins ([str]): Which proteins to retrieve in the data package

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            table_fields ([V1VirusTableField]): Specify which fields to include in the tabular report. [optional]
            format (V1TableFormat): Choose download format (tsv, csv or jsonl). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1TabularOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['proteins'] = \
            proteins
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.sars2_protein_table_endpoint.call_with_http_info(**kwargs)

    def virus_genome_download(
        self,
        taxon,
        **kwargs
    ):
        """Download a coronavirus genome dataset by taxon  # noqa: E501

        Download a coronavirus genome dataset by taxon  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_download(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_download_endpoint.call_with_http_info(**kwargs)

    def virus_genome_download_accession(
        self,
        accessions,
        **kwargs
    ):
        """Download a coronavirus genome dataset by accession  # noqa: E501

        Download a coronavirus genome dataset by accession  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_download_accession(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): Accessions accessions = 16;

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_download_accession_endpoint.call_with_http_info(**kwargs)

    def virus_genome_download_post(
        self,
        v1_virus_dataset_request,
        **kwargs
    ):
        """Get a coronavirus genome dataset by post  # noqa: E501

        The 'GET' version of download is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_download_post(v1_virus_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_virus_dataset_request (V1VirusDatasetRequest):

        Keyword Args:
            filename (str): Output file name.. [optional] if omitted the server will use the default value of "ncbi_dataset.zip"
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            file_type
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_virus_dataset_request'] = \
            v1_virus_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_download_post_endpoint.call_with_http_info(**kwargs)

    def virus_genome_summary(
        self,
        taxon,
        **kwargs
    ):
        """Get summary data for Coronaviridae genomes by taxon  # noqa: E501

        Get summary data and download by command line instructions for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_summary(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_summary_endpoint.call_with_http_info(**kwargs)

    def virus_genome_summary_accession(
        self,
        accessions,
        **kwargs
    ):
        """Get summary data for Coronaviridae genomes by accession  # noqa: E501

        Get summary data for Coronaviridae genomes by accession  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_summary_accession(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): Accessions accessions = 16;

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            exclude_sequence (bool): Set to true to omit the genomic sequence.. [optional] if omitted the server will use the default value of False
            include_annotation_type ([V1AnnotationForVirusType]): Select additional types of annotation to include in the data package.  If unset, no annotation is provided.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_summary_accession_endpoint.call_with_http_info(**kwargs)

    def virus_genome_summary_post(
        self,
        v1_virus_dataset_request,
        **kwargs
    ):
        """Get summary data for Coronaviridae genomes by post  # noqa: E501

        The 'GET' version is limited by the size of the GET URL (2KB, which works out to about 140 genomic accessions).  The POST operation is provided to allow users to supply a larger number of accessions in a single request.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_summary_post(v1_virus_dataset_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_virus_dataset_request (V1VirusDatasetRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1DownloadSummary
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_virus_dataset_request'] = \
            v1_virus_dataset_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_summary_post_endpoint.call_with_http_info(**kwargs)

    def virus_genome_table(
        self,
        taxon,
        **kwargs
    ):
        """Get viral genomic metadata in a tabular format.  # noqa: E501

        Get viral genomic metadata in tabular format for Coronaviridae genomes by taxon.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_genome_table(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            table_fields ([V1VirusTableField]): Specify which fields to include in the tabular report. [optional]
            format (V1TableFormat): Choose download format (tsv, csv or jsonl). [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1TabularOutput
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_genome_table_endpoint.call_with_http_info(**kwargs)

    def virus_reports_by_acessions(
        self,
        accessions,
        **kwargs
    ):
        """Get virus metadata by accession  # noqa: E501

        Get virus metadata by accesion. By default, in paged JSON format, but also available as tabular (accept: x-tabular) or json-lines (accept: x-jsonlines)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_reports_by_acessions(accessions, async_req=True)
        >>> result = thread.get()

        Args:
            accessions ([str]): genome sequence accessions

        Keyword Args:
            filter_refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            filter_annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            filter_released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            filter_host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            filter_pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            filter_geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            filter_complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            returned_content (V1VirusDataReportRequestContentType): Return either virus genome accessions, or complete virus metadata. [optional]
            table_fields ([str]): Specify which fields to include in the tabular report. [optional]
            page_size (int): The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.. [optional] if omitted the server will use the default value of 20
            page_token (str): A page token is returned from a `GetVirusDataReports` call with more than `page_size` results. Use this token, along with the previous `VirusDataReportRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1reportsVirusDataReportPage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['accessions'] = \
            accessions
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_reports_by_acessions_endpoint.call_with_http_info(**kwargs)

    def virus_reports_by_post(
        self,
        v1_virus_data_report_request,
        **kwargs
    ):
        """Get virus metadata by POST  # noqa: E501

        Get virus metadata. By default, in paged JSON format, but also available as tabular (accept: x-tabular) or json-lines (accept: x-jsonlines)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_reports_by_post(v1_virus_data_report_request, async_req=True)
        >>> result = thread.get()

        Args:
            v1_virus_data_report_request (V1VirusDataReportRequest):

        Keyword Args:
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1reportsVirusDataReportPage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['v1_virus_data_report_request'] = \
            v1_virus_data_report_request
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_reports_by_post_endpoint.call_with_http_info(**kwargs)

    def virus_reports_by_taxon(
        self,
        taxon,
        **kwargs
    ):
        """Get virus metadata by taxon  # noqa: E501

        Get virus metadata by taxon. By default, in paged JSON format, but also available as tabular (accept: x-tabular) or json-lines (accept: x-jsonlines)  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.virus_reports_by_taxon(taxon, async_req=True)
        >>> result = thread.get()

        Args:
            taxon (str): NCBI Taxonomy ID or name (common or scientific) at any taxonomic rank

        Keyword Args:
            filter_refseq_only (bool): If true, limit results to RefSeq genomes.. [optional] if omitted the server will use the default value of False
            filter_annotated_only (bool): If true, limit results to annotated genomes.. [optional] if omitted the server will use the default value of False
            filter_released_since (datetime): If set, limit results to viral genomes that have been released after a specified date (and optionally, time). April 1, 2020 midnight UTC should be formatted as '2020-04-01T00:00:00.000Z'. [optional]
            filter_host (str): If set, limit results to genomes extracted from this host (Taxonomy ID or name) All hosts by default. [optional]
            filter_pangolin_classification (str): If set, limit results to genomes classified to this lineage by the PangoLearn tool.. [optional]
            filter_geo_location (str): Assemblies from this location (country and state, or continent). [optional]
            filter_complete_only (bool): only include complete genomes.. [optional] if omitted the server will use the default value of False
            returned_content (V1VirusDataReportRequestContentType): Return either virus genome accessions, or complete virus metadata. [optional]
            table_fields ([str]): Specify which fields to include in the tabular report. [optional]
            page_size (int): The maximum number of virus data reports to return. Default is 20 and maximum is 1000. If the number of results exceeds the page size, `page_token` can be used to retrieve the remaining results.. [optional] if omitted the server will use the default value of 20
            page_token (str): A page token is returned from a `GetVirusDataReports` call with more than `page_size` results. Use this token, along with the previous `VirusDataReportRequest` parameters, to retrieve the next page of results. When `page_token` is empty, all results have been retrieved.. [optional]
            _return_http_data_only (bool): response data without head status
                code and headers. Default is True.
            _preload_content (bool): if False, the urllib3.HTTPResponse object
                will be returned without reading/decoding response data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _check_input_type (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _check_return_type (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            async_req (bool): execute request asynchronously

        Returns:
            V1reportsVirusDataReportPage
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['async_req'] = kwargs.get(
            'async_req', False
        )
        kwargs['_return_http_data_only'] = kwargs.get(
            '_return_http_data_only', True
        )
        kwargs['_preload_content'] = kwargs.get(
            '_preload_content', True
        )
        kwargs['_request_timeout'] = kwargs.get(
            '_request_timeout', None
        )
        kwargs['_check_input_type'] = kwargs.get(
            '_check_input_type', True
        )
        kwargs['_check_return_type'] = kwargs.get(
            '_check_return_type', True
        )
        kwargs['_host_index'] = kwargs.get('_host_index')
        kwargs['taxon'] = \
            taxon
        headers = kwargs.get('headers', {})
        if headers:
            accept = headers.get('accept') or headers.get('Accept')
            if accept and accept in self.gene_download_summary_by_accession_endpoint.headers_map:
                self.gene_download_summary_by_accession_endpoint.headers_map['accept'] = accept

            for key in headers.keys():
                self.gene_download_summary_by_accession_endpoint.headers_map[key] = headers[key]

        return self.virus_reports_by_taxon_endpoint.call_with_http_info(**kwargs)

