# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['emus_web',
 'emus_web.apps.activitypub',
 'emus_web.apps.games',
 'emus_web.apps.games.api',
 'emus_web.apps.games.management',
 'emus_web.apps.games.management.commands',
 'emus_web.apps.games.migrations',
 'emus_web.apps.profiles',
 'emus_web.apps.profiles.migrations',
 'emus_web.apps.scraper',
 'emus_web.apps.search',
 'emus_web.static.js.webretro.bundle']

package_data = \
{'': ['*'],
 'emus_web': ['static/css/*',
              'static/img/*',
              'static/js/webretro/*',
              'static/js/webretro/assets/*',
              'static/js/webretro/embed/*',
              'static/js/webretro/embed/roms/*',
              'static/js/webretro/info/*',
              'static/js/webretro/source/*',
              'static/js/webretro/source/overrides/RetroArch/*',
              'static/js/webretro/source/overrides/RetroArch/emscripten/*',
              'static/js/webretro/source/overrides/RetroArch/frontend/drivers/*',
              'static/js/webretro/source/overrides/RetroArch/menu/drivers/*',
              'static/js/webretro/source/overrides/RetroArch/menu/drivers/ozone/*',
              'static/js/webretro/source/overrides/RetroArch/tasks/*',
              'static/js/webretro/source/overrides/cores/Genesis-Plus-GX/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/GLideN64/src/Graphics/OpenGLContext/ThreadedOpenGl/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/custom/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/custom/dependencies/libzlib/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/libretro-common/libco/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/libretro/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/mupen64plus-core/src/device/r4300/*',
              'static/js/webretro/source/overrides/cores/mupen64plus-libretro-nx/mupen64plus-core/src/main/*',
              'static/js/webretro/uauth/*',
              'templates/*',
              'templates/account/*',
              'templates/games/*',
              'templates/search/*'],
 'emus_web.static.js.webretro.bundle': ['assets/menu_widgets/*',
                                        'assets/ozone/*',
                                        'assets/ozone/png/*',
                                        'assets/ozone/png/dark/*',
                                        'assets/ozone/png/sidebar/*',
                                        'assets/xmb/monochrome/png/*',
                                        'shaders/*',
                                        'shaders/shaders_glsl/*',
                                        'shaders/shaders_glsl/anti-aliasing/*',
                                        'shaders/shaders_glsl/anti-aliasing/shaders/*',
                                        'shaders/shaders_glsl/anti-aliasing/shaders/aa-shader-4.0-level2/*',
                                        'shaders/shaders_glsl/anti-aliasing/shaders/reverse-aa-post3x/*',
                                        'shaders/shaders_glsl/cubic/*',
                                        'shaders/shaders_glsl/cubic/shaders/*',
                                        'shaders/shaders_glsl/interpolation/*',
                                        'shaders/shaders_glsl/interpolation/shaders/*',
                                        'shaders/shaders_glsl/linear/*',
                                        'shaders/shaders_glsl/scalehq/*',
                                        'shaders/shaders_glsl/scalehq/shaders/*']}

install_requires = \
['Django>=4.0.3,<5.0.0',
 'Markdown>=3.3.6,<4.0.0',
 'Pillow>=9.0.1,<10.0.0',
 'colorlog>=6.6.0,<7.0.0',
 'dj-database-url>=0.5.0,<0.6.0',
 'django-allauth>=0.50.0,<0.51.0',
 'django-celery-results>=2.3.0,<3.0.0',
 'django-extensions>=3.1.5,<4.0.0',
 'django-filter>=21.1,<22.0',
 'django-markdownify>=0.9.1,<0.10.0',
 'django-mathfilters>=1.0.0,<2.0.0',
 'django-simple-history>=3.1.1,<4.0.0',
 'django-taggit>=2.1.0,<3.0.0',
 'djangorestframework>=3.13.1,<4.0.0',
 'gunicorn>=20.1.0,<21.0.0',
 'psycopg2[production]>=2.9.3,<3.0.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'python-dotenv>=0.20.0,<0.21.0',
 'python-json-logger>=2.0.2,<3.0.0',
 'redis>=4.2.2,<5.0.0',
 'whitenoise>=6.3.0,<7.0.0']

entry_points = \
{'console_scripts': ['emus = emus_web.cli:main']}

setup_kwargs = {
    'name': 'emus-web',
    'version': '0.1.0',
    'description': 'A hacky web frontend for Emulation Station rom collections',
    'long_description': 'None',
    'author': 'Colin Powell',
    'author_email': 'colin@unbl.ink',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
