# Generated by Django 4.1.3 on 2023-01-05 02:25

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_extensions.db.fields
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        ('games', '0021_remove_game_finished_on_remove_game_started_on'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('profiles', '0004_alter_userprofile_user_historicalusergameprogress'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalUserGamePlaythrough',
            fields=[
                (
                    'id',
                    models.BigIntegerField(
                        auto_created=True,
                        blank=True,
                        db_index=True,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                (
                    'started_ts',
                    models.DateTimeField(
                        blank=True, default=django.utils.timezone.now
                    ),
                ),
                ('finished_ts', models.DateTimeField(blank=True, null=True)),
                (
                    'percent',
                    models.IntegerField(
                        default=0,
                        help_text='Keeps track of how far through the game you are',
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    'history_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('history_date', models.DateTimeField(db_index=True)),
                (
                    'history_change_reason',
                    models.CharField(max_length=100, null=True),
                ),
                (
                    'history_type',
                    models.CharField(
                        choices=[
                            ('+', 'Created'),
                            ('~', 'Changed'),
                            ('-', 'Deleted'),
                        ],
                        max_length=1,
                    ),
                ),
                (
                    'game',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='games.game',
                    ),
                ),
                (
                    'history_user',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'verbose_name': 'historical user game playthrough',
                'verbose_name_plural': 'historical user game playthroughs',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='UserGamePlaythrough',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                (
                    'started_ts',
                    models.DateTimeField(
                        blank=True, default=django.utils.timezone.now
                    ),
                ),
                ('finished_ts', models.DateTimeField(blank=True, null=True)),
                (
                    'percent',
                    models.IntegerField(
                        default=0,
                        help_text='Keeps track of how far through the game you are',
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    'game',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to='games.game',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'ordering': ('-started_ts',),
            },
        ),
        migrations.CreateModel(
            name='UserGamePlaythroughUpdate',
            fields=[
                (
                    'id',
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                (
                    'percent',
                    models.IntegerField(
                        default=0,
                        help_text='Keeps track of how far through the game you are',
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    'playthrough',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        to='profiles.usergameplaythrough',
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'get_latest_by': 'modified',
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='usergameprogress',
            name='game',
        ),
        migrations.RemoveField(
            model_name='usergameprogress',
            name='user',
        ),
        migrations.AddField(
            model_name='userprofile',
            name='last_active',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.DeleteModel(
            name='HistoricalUserGameProgress',
        ),
        migrations.DeleteModel(
            name='UserGameProgress',
        ),
        migrations.AddConstraint(
            model_name='usergameplaythrough',
            constraint=models.CheckConstraint(
                check=models.Q(('finished_ts__gte', models.F('started_ts'))),
                name='chronology',
            ),
        ),
    ]
