# Generated by Django 4.1 on 2022-09-07 13:38

from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import django_extensions.db.fields
import simple_history.models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        (
            'games',
            '0020_developer_uuid_game_uuid_gamecollection_uuid_and_more',
        ),
        ('profiles', '0003_alter_usergameprogress_user'),
    ]

    operations = [
        migrations.AlterField(
            model_name='userprofile',
            name='user',
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE,
                related_name='profile',
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.CreateModel(
            name='HistoricalUserGameProgress',
            fields=[
                (
                    'id',
                    models.BigIntegerField(
                        auto_created=True,
                        blank=True,
                        db_index=True,
                        verbose_name='ID',
                    ),
                ),
                (
                    'created',
                    django_extensions.db.fields.CreationDateTimeField(
                        auto_now_add=True, verbose_name='created'
                    ),
                ),
                (
                    'modified',
                    django_extensions.db.fields.ModificationDateTimeField(
                        auto_now=True, verbose_name='modified'
                    ),
                ),
                (
                    'started_ts',
                    models.DateTimeField(
                        blank=True, default=django.utils.timezone.now
                    ),
                ),
                ('finished_ts', models.DateTimeField(blank=True, null=True)),
                (
                    'percent',
                    models.IntegerField(
                        default=0,
                        help_text='Keeps track of how far through the game you are',
                        validators=[
                            django.core.validators.MaxValueValidator(100),
                            django.core.validators.MinValueValidator(0),
                        ],
                    ),
                ),
                (
                    'history_id',
                    models.AutoField(primary_key=True, serialize=False),
                ),
                ('history_date', models.DateTimeField(db_index=True)),
                (
                    'history_change_reason',
                    models.CharField(max_length=100, null=True),
                ),
                (
                    'history_type',
                    models.CharField(
                        choices=[
                            ('+', 'Created'),
                            ('~', 'Changed'),
                            ('-', 'Deleted'),
                        ],
                        max_length=1,
                    ),
                ),
                (
                    'game',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to='games.game',
                    ),
                ),
                (
                    'history_user',
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    'user',
                    models.ForeignKey(
                        blank=True,
                        db_constraint=False,
                        null=True,
                        on_delete=django.db.models.deletion.DO_NOTHING,
                        related_name='+',
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'verbose_name': 'historical user game progress',
                'verbose_name_plural': 'historical user game progresss',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': ('history_date', 'history_id'),
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
    ]
