# Generated by Django 4.0.3 on 2022-03-31 04:12

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import django_extensions.db.fields
import games.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Developer',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='GameSystem',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
                ('retropie_slug', models.CharField(blank=True, max_length=50, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Genre',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Publisher',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Game',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('slug', django_extensions.db.fields.AutoSlugField(blank=True, editable=False, populate_from='name')),
                ('release_date', models.DateTimeField(blank=True, null=True)),
                ('players', models.SmallIntegerField()),
                ('kid_game', models.BooleanField(default=False)),
                ('description', models.TextField(blank=True, null=True)),
                ('rating', models.FloatField(blank=True, null=True, validators=[django.core.validators.MaxValueValidator(1), django.core.validators.MinValueValidator(0)])),
                ('video', models.FileField(blank=True, null=True, upload_to=games.models.get_video_upload_path)),
                ('marquee', models.FileField(blank=True, null=True, upload_to=games.models.get_marquee_upload_path)),
                ('screenshot', models.FileField(blank=True, null=True, upload_to=games.models.get_screenshot_upload_path)),
                ('rom_file', models.FileField(blank=True, null=True, upload_to=games.models.get_rom_upload_path)),
                ('developer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='games.publisher')),
                ('game_system', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='games.gamesystem')),
                ('genre', models.ManyToManyField(to='games.genre')),
                ('publisher', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='games.developer')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
