# aiopdhttp
Robot REST API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.8.2
- Package version: 1.8.2.dev20200818133858
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import aiopdhttp 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import aiopdhttp
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import aiopdhttp
from aiopdhttp.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = aiopdhttp.BaseApi(aiopdhttp.ApiClient(configuration))
body = aiopdhttp.Position() # Position | Request Body

try:
    # Setting a new zero point position
    api_response = api_instance.change_base(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling BaseApi->change_base: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *http://robot:8081*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BaseApi* | [**change_base**](docs/BaseApi.md#change_base) | **POST** /base | Setting a new zero point position
*BaseApi* | [**get_base**](docs/BaseApi.md#get_base) | **GET** /base | Getting the actual position of the arm base
*DefaultApi* | [**read_motors_log**](docs/DefaultApi.md#read_motors_log) | **POST** /motors-log | Reads logs from all motors.
*EnvironmentApi* | [**add_to_environment**](docs/EnvironmentApi.md#add_to_environment) | **PUT** /environment | Add obstacle to robot environment.
*EnvironmentApi* | [**get_all_from_environment**](docs/EnvironmentApi.md#get_all_from_environment) | **GET** /environment | Getting robot environment.
*EnvironmentApi* | [**get_from_environment_by_name**](docs/EnvironmentApi.md#get_from_environment_by_name) | **GET** /environment/{obstacle} | Getting obstacle from robot environment by name.
*EnvironmentApi* | [**remove_all_from_environment**](docs/EnvironmentApi.md#remove_all_from_environment) | **DELETE** /environment | Remove all obstacles from robot environment.
*EnvironmentApi* | [**remove_from_environment_by_name**](docs/EnvironmentApi.md#remove_from_environment_by_name) | **DELETE** /environment/{obstacle} | Remove obstacle from robot environment by name.
*GripperApi* | [**close_gripper**](docs/GripperApi.md#close_gripper) | **PUT** /gripper/close | Asking the arm to close the gripper
*GripperApi* | [**disable_gripper**](docs/GripperApi.md#disable_gripper) | **POST** /gripper/disable | Disables gripper
*GripperApi* | [**enable_gripper**](docs/GripperApi.md#enable_gripper) | **POST** /gripper/enable | Enables gripper
*GripperApi* | [**open_gripper**](docs/GripperApi.md#open_gripper) | **PUT** /gripper/open | Asking the arm to open the gripper
*OtherApi* | [**identifier**](docs/OtherApi.md#identifier) | **GET** /robot/id | Getting the arm ID
*OtherApi* | [**information**](docs/OtherApi.md#information) | **GET** /robot/info | Getting the information about robot
*OtherApi* | [**pack**](docs/OtherApi.md#pack) | **PUT** /pack | Asking the arm to reach a compact pose for transportation
*OtherApi* | [**recover**](docs/OtherApi.md#recover) | **PUT** /recover | Recover robot after emergency if it is possible.
*OtherApi* | [**relax**](docs/OtherApi.md#relax) | **PUT** /relax | Asking the arm to relax
*PoseApi* | [**get_pose**](docs/PoseApi.md#get_pose) | **GET** /pose | Getting the actual arm pose
*PoseApi* | [**run_joint_poses**](docs/PoseApi.md#run_joint_poses) | **PUT** /run/joint/poses | Asking the arm to follow the joint trajectory in Cartesian Space via waypoints represented in poses.
*PoseApi* | [**run_linear_poses**](docs/PoseApi.md#run_linear_poses) | **PUT** /run/linear/poses | Asking the arm to follow the linear trajectory in Cartesian Space via waypoints represented in poses
*PoseApi* | [**run_poses**](docs/PoseApi.md#run_poses) | **PUT** /poses/run | Asking the arm to move to a pose
*PoseApi* | [**set_pose**](docs/PoseApi.md#set_pose) | **PUT** /pose | Setting a new arm pose
*PositionApi* | [**get_position**](docs/PositionApi.md#get_position) | **GET** /position | Getting the actual arm position
*PositionApi* | [**run_joint_positions**](docs/PositionApi.md#run_joint_positions) | **PUT** /run/joint/positions | Asking the arm to follow the joint trajectory in Cartesian Space via waypoints represented in positions
*PositionApi* | [**run_linear_positions**](docs/PositionApi.md#run_linear_positions) | **PUT** /run/linear/positions | Asking the arm to follow the linear trajectory in Cartesian Space via waypoints represented in positions
*PositionApi* | [**run_positions**](docs/PositionApi.md#run_positions) | **PUT** /positions/run | Asking the arm to move to a position
*PositionApi* | [**set_position**](docs/PositionApi.md#set_position) | **PUT** /position | Setting a new arm position
*RobotApi* | [**add_to_environment**](docs/RobotApi.md#add_to_environment) | **PUT** /environment | Add obstacle to robot environment.
*RobotApi* | [**bind_stop_port_high**](docs/RobotApi.md#bind_stop_port_high) | **PUT** /stop/bind/{port}/high | Bind stop command to high input signal on a specific port
*RobotApi* | [**bind_stop_port_low**](docs/RobotApi.md#bind_stop_port_low) | **PUT** /stop/bind/{port}/low | Bind stop command to low input signal on a specific port
*RobotApi* | [**change_base**](docs/RobotApi.md#change_base) | **POST** /base | Setting a new zero point position
*RobotApi* | [**change_tool_info**](docs/RobotApi.md#change_tool_info) | **POST** /tool/info | Setting tool properties
*RobotApi* | [**change_tool_shape**](docs/RobotApi.md#change_tool_shape) | **POST** /tool/shape | Setting tool shape
*RobotApi* | [**close_gripper**](docs/RobotApi.md#close_gripper) | **PUT** /gripper/close | Asking the arm to close the gripper
*RobotApi* | [**disable_gripper**](docs/RobotApi.md#disable_gripper) | **POST** /gripper/disable | Disables gripper
*RobotApi* | [**enable_gripper**](docs/RobotApi.md#enable_gripper) | **POST** /gripper/enable | Enables gripper
*RobotApi* | [**freeze**](docs/RobotApi.md#freeze) | **PUT** /freeze | Asking the arm to go to the freeze state
*RobotApi* | [**get_all_from_environment**](docs/RobotApi.md#get_all_from_environment) | **GET** /environment | Getting robot environment.
*RobotApi* | [**get_base**](docs/RobotApi.md#get_base) | **GET** /base | Getting the actual position of the arm base
*RobotApi* | [**get_digital_input**](docs/RobotApi.md#get_digital_input) | **GET** /signal/input/{port} | Get level of digital input signal
*RobotApi* | [**get_digital_output**](docs/RobotApi.md#get_digital_output) | **GET** /signal/output/{port} | Get level of digital output signal
*RobotApi* | [**get_from_environment_by_name**](docs/RobotApi.md#get_from_environment_by_name) | **GET** /environment/{obstacle} | Getting obstacle from robot environment by name.
*RobotApi* | [**get_pose**](docs/RobotApi.md#get_pose) | **GET** /pose | Getting the actual arm pose
*RobotApi* | [**get_position**](docs/RobotApi.md#get_position) | **GET** /position | Getting the actual arm position
*RobotApi* | [**get_tool_info**](docs/RobotApi.md#get_tool_info) | **GET** /tool/info | Getting actual tool properties
*RobotApi* | [**get_tool_shape**](docs/RobotApi.md#get_tool_shape) | **GET** /tool/shape | Getting tool shape
*RobotApi* | [**identifier**](docs/RobotApi.md#identifier) | **GET** /robot/id | Getting the arm ID
*RobotApi* | [**information**](docs/RobotApi.md#information) | **GET** /robot/info | Getting the information about robot
*RobotApi* | [**jogging**](docs/RobotApi.md#jogging) | **PUT** /jogging | Controls the robotic arm in &#39;jogging&#39; mode.
*RobotApi* | [**open_gripper**](docs/RobotApi.md#open_gripper) | **PUT** /gripper/open | Asking the arm to open the gripper
*RobotApi* | [**pack**](docs/RobotApi.md#pack) | **PUT** /pack | Asking the arm to reach a compact pose for transportation
*RobotApi* | [**recover**](docs/RobotApi.md#recover) | **PUT** /recover | Recover robot after emergency if it is possible.
*RobotApi* | [**relax**](docs/RobotApi.md#relax) | **PUT** /relax | Asking the arm to relax
*RobotApi* | [**remove_all_from_environment**](docs/RobotApi.md#remove_all_from_environment) | **DELETE** /environment | Remove all obstacles from robot environment.
*RobotApi* | [**remove_from_environment_by_name**](docs/RobotApi.md#remove_from_environment_by_name) | **DELETE** /environment/{obstacle} | Remove obstacle from robot environment by name.
*RobotApi* | [**run_joint_poses**](docs/RobotApi.md#run_joint_poses) | **PUT** /run/joint/poses | Asking the arm to follow the joint trajectory in Cartesian Space via waypoints represented in poses.
*RobotApi* | [**run_joint_positions**](docs/RobotApi.md#run_joint_positions) | **PUT** /run/joint/positions | Asking the arm to follow the joint trajectory in Cartesian Space via waypoints represented in positions
*RobotApi* | [**run_linear_poses**](docs/RobotApi.md#run_linear_poses) | **PUT** /run/linear/poses | Asking the arm to follow the linear trajectory in Cartesian Space via waypoints represented in poses
*RobotApi* | [**run_linear_positions**](docs/RobotApi.md#run_linear_positions) | **PUT** /run/linear/positions | Asking the arm to follow the linear trajectory in Cartesian Space via waypoints represented in positions
*RobotApi* | [**run_poses**](docs/RobotApi.md#run_poses) | **PUT** /poses/run | Asking the arm to move to a pose
*RobotApi* | [**run_positions**](docs/RobotApi.md#run_positions) | **PUT** /positions/run | Asking the arm to move to a position
*RobotApi* | [**set_digital_output_high**](docs/RobotApi.md#set_digital_output_high) | **PUT** /signal/output/{port}/high | Set high level of digital output signal
*RobotApi* | [**set_digital_output_low**](docs/RobotApi.md#set_digital_output_low) | **PUT** /signal/output/{port}/low | Set low level of digital output signal
*RobotApi* | [**set_pose**](docs/RobotApi.md#set_pose) | **PUT** /pose | Setting a new arm pose
*RobotApi* | [**set_position**](docs/RobotApi.md#set_position) | **PUT** /position | Setting a new arm position
*RobotApi* | [**status**](docs/RobotApi.md#status) | **GET** /status | Getting the actual robot status
*RobotApi* | [**status_failure**](docs/RobotApi.md#status_failure) | **GET** /status/failure | Returns complete list of recent failures
*RobotApi* | [**status_motion**](docs/RobotApi.md#status_motion) | **GET** /status/motion | Getting the actual motion status
*RobotApi* | [**status_motors**](docs/RobotApi.md#status_motors) | **GET** /status/motors | Getting the actual status of servo motors
*RobotApi* | [**stop**](docs/RobotApi.md#stop) | **POST** /stop | Asking the arm to go to the \&quot;Protection mode\&quot;
*RobotApi* | [**stop_untwisting**](docs/RobotApi.md#stop_untwisting) | **PUT** /untwisting/finish | Try to exit from twisted mode
*RobotApi* | [**unbind_stop**](docs/RobotApi.md#unbind_stop) | **DELETE** /stop | Unbinds stop from inputs
*RobotApi* | [**zg_off**](docs/RobotApi.md#zg_off) | **PUT** /zg/off | Disable Freedrive Mode
*RobotApi* | [**zg_on**](docs/RobotApi.md#zg_on) | **PUT** /zg/on | Enable Freedrive Mode
*SignalsApi* | [**bind_stop_port_high**](docs/SignalsApi.md#bind_stop_port_high) | **PUT** /stop/bind/{port}/high | Bind stop command to high input signal on a specific port
*SignalsApi* | [**bind_stop_port_low**](docs/SignalsApi.md#bind_stop_port_low) | **PUT** /stop/bind/{port}/low | Bind stop command to low input signal on a specific port
*SignalsApi* | [**get_digital_input**](docs/SignalsApi.md#get_digital_input) | **GET** /signal/input/{port} | Get level of digital input signal
*SignalsApi* | [**get_digital_output**](docs/SignalsApi.md#get_digital_output) | **GET** /signal/output/{port} | Get level of digital output signal
*SignalsApi* | [**set_digital_output_high**](docs/SignalsApi.md#set_digital_output_high) | **PUT** /signal/output/{port}/high | Set high level of digital output signal
*SignalsApi* | [**set_digital_output_low**](docs/SignalsApi.md#set_digital_output_low) | **PUT** /signal/output/{port}/low | Set low level of digital output signal
*StatusApi* | [**status**](docs/StatusApi.md#status) | **GET** /status | Getting the actual robot status
*StatusApi* | [**status_failure**](docs/StatusApi.md#status_failure) | **GET** /status/failure | Returns complete list of recent failures
*StatusApi* | [**status_motion**](docs/StatusApi.md#status_motion) | **GET** /status/motion | Getting the actual motion status
*StatusApi* | [**status_motors**](docs/StatusApi.md#status_motors) | **GET** /status/motors | Getting the actual status of servo motors
*ToolApi* | [**change_tool_info**](docs/ToolApi.md#change_tool_info) | **POST** /tool/info | Setting tool properties
*ToolApi* | [**change_tool_shape**](docs/ToolApi.md#change_tool_shape) | **POST** /tool/shape | Setting tool shape
*ToolApi* | [**get_tool_info**](docs/ToolApi.md#get_tool_info) | **GET** /tool/info | Getting actual tool properties
*ToolApi* | [**get_tool_shape**](docs/ToolApi.md#get_tool_shape) | **GET** /tool/shape | Getting tool shape
*VersionApi* | [**get_hardware_version**](docs/VersionApi.md#get_hardware_version) | **GET** /version/hardware | Get all devices hardware version.
*VersionApi* | [**get_robot_software_version**](docs/VersionApi.md#get_robot_software_version) | **GET** /version/software/robot | Get robot version.
*VersionApi* | [**get_software_version**](docs/VersionApi.md#get_software_version) | **GET** /version/software | Get all devices software version.
*VersionApi* | [**information**](docs/VersionApi.md#information) | **GET** /robot/info | Getting the information about robot


## Documentation For Models

 - [BoxObstacle](docs/BoxObstacle.md)
 - [CapsuleObstacle](docs/CapsuleObstacle.md)
 - [Error400](docs/Error400.md)
 - [ErrorEmergency503](docs/ErrorEmergency503.md)
 - [ErrorPort412](docs/ErrorPort412.md)
 - [ErrorPose412](docs/ErrorPose412.md)
 - [ErrorPosition412](docs/ErrorPosition412.md)
 - [Failure](docs/Failure.md)
 - [FailureLevel](docs/FailureLevel.md)
 - [FailureType](docs/FailureType.md)
 - [InterpolationType](docs/InterpolationType.md)
 - [JoggingAcceleration](docs/JoggingAcceleration.md)
 - [JoggingAccelerationAcceleration](docs/JoggingAccelerationAcceleration.md)
 - [JointMotionParameters](docs/JointMotionParameters.md)
 - [JointPoses](docs/JointPoses.md)
 - [JointPositions](docs/JointPositions.md)
 - [LinearMotionParameters](docs/LinearMotionParameters.md)
 - [LinearPoses](docs/LinearPoses.md)
 - [LinearPositions](docs/LinearPositions.md)
 - [MotionStatus](docs/MotionStatus.md)
 - [MotionType](docs/MotionType.md)
 - [MotorStatus](docs/MotorStatus.md)
 - [Obstacle](docs/Obstacle.md)
 - [PlaneObstacle](docs/PlaneObstacle.md)
 - [Point](docs/Point.md)
 - [Pose](docs/Pose.md)
 - [PoseTimestamp](docs/PoseTimestamp.md)
 - [Position](docs/Position.md)
 - [PositionTimestamp](docs/PositionTimestamp.md)
 - [RecoverState](docs/RecoverState.md)
 - [RobotAction](docs/RobotAction.md)
 - [RobotActionType](docs/RobotActionType.md)
 - [RobotInfo](docs/RobotInfo.md)
 - [Rotation](docs/Rotation.md)
 - [Session](docs/Session.md)
 - [Signal](docs/Signal.md)
 - [SimplifiedCapsuleObstacle](docs/SimplifiedCapsuleObstacle.md)
 - [SystemState](docs/SystemState.md)
 - [ToolInfo](docs/ToolInfo.md)
 - [ToolShape](docs/ToolShape.md)
 - [Version](docs/Version.md)
 - [WristButtonState](docs/WristButtonState.md)
 - [WristButtonStates](docs/WristButtonStates.md)
 - [GripperRobotAction](docs/GripperRobotAction.md)
 - [OutputRobotAction](docs/OutputRobotAction.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



