<img src="https://drive.google.com/uc?export=view&id=16rzdY9IfiiuLZ1SP62jxJMy5ZdjbhXn8" width="80"/> pygmid
=================================================================================================================================

pygmid is a Python 3 port of the gm/ID starter kit by Prof. Boris Murmann 
of Stanford University. 

For the gm/ID starter kit, written for MATLAB, please refer to the 'Links'
section at Prof. Murmann's website: https://web.stanford.edu/~murmann.
For the Python 2 version of this port, please see https://github.com/ashwith/pyMOSChar.

## Installation

To install pygmid from source, download from Github and run pip:

`pip install .`

 in the root directory.

 pygmid can also be installed from PyPI:

`pip install pygmid`

## Usage

### Scripting with the Lookup Class
A gm/ID lookup object can be generated with the `Lookup` class. The lookup object requires lookup data for initialisation. Currently, only `.mat` files are supported.

You can create a lookup object as follows:

```python
from pygmid import Lookup as lk

NCH = lk('180nch.mat')
```
### Access MOS Data
The `Lookup` class allows for pseudo array access of the MOS matrix data. You can access data as follows:

```python
# get VGS data as array from NCH
VGS_array = NCH['VGS']
```

Data is returned as a deep copy of the array contained in the `Lookup` object.

### Lookup functionality 

Lookup of interpolated data occurs as follows:

```python
VDSs = NCH['VDS'] 
VGSs = np.arange(0.4, 0.6, 0.05)
# Plot ID versus VDS
ID = NCH.look_up('ID', vds=VDSs, vgs=VGSs)
# alias function lookup can also be used
ID = NCH.lookup('ID', vds=VDSs, vgs=VGSs)

plt.plot(VDSs, np.transpose(ID))
```

~~Currently only lookup modes 1 and 2 are implemented.~~

### Examples

Usage of lookup scripts are given in `test_lookup.py`.

Sample outputs are given below:

![image](https://drive.google.com/uc?export=view&id=1IXmZ2OI9wwbYcMLE-SS2hA6b3auyiWIE)

![image](https://drive.google.com/uc?export=view&id=1Md_qAKvHZEDhxmKGtyRDJf_MHEmSVgfU)

![image](https://drive.google.com/uc?export=view&id=1uep_k0ghzQ79BKCIKQlyu-0F9BIe0QeR)

![image](https://drive.google.com/uc?export=view&id=1zxdLVirM6HPjpQQYlLa_OBA2qRXXS0SG)

![image](https://drive.google.com/uc?export=view&id=1cPS-FzYxdFn5gnwieAEW4gz177t3nnix)

## Command Line Interface (CLI)

`pygmid` also features a CLI which can be used to run techweeps to generate transistor data

## !TODO
- ~~look_up MODE 3 (ratio vs ratio)~~
- look_upVGS and lookupVGS
- SPECTRE techsweep
- Support for non .mat data structures
- Improved logging for error generation
