"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.scrutinizableResourceTypes = exports.scrutinizablePropertyNames = exports.filteredSpecification = exports.namespaces = exports.resourceTypes = exports.propertySpecification = exports.cfnLintAnnotations = exports.resourceAugmentation = exports.resourceSpecification = exports.specification = exports.schema = void 0;
const crypto = require("crypto");
const schema = require("./schema");
exports.schema = schema;
__exportStar(require("./canned-metrics"), exports);
/**
 * The complete AWS CloudFormation Resource specification, having any CDK patches and enhancements included in it.
 */
function specification() {
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    return require('../spec/specification.json');
}
exports.specification = specification;
/**
 * Return the resource specification for the given typename
 *
 * Validates that the resource exists. If you don't want this validating behavior, read from
 * specification() directly.
 */
function resourceSpecification(typeName) {
    const ret = specification().ResourceTypes[typeName];
    if (!ret) {
        throw new Error(`No such resource type: ${typeName}`);
    }
    return ret;
}
exports.resourceSpecification = resourceSpecification;
/**
 * Get the resource augmentations for a given type
 */
function resourceAugmentation(typeName) {
    const fileName = typeName.replace(/::/g, '_');
    try {
        // eslint-disable-next-line @typescript-eslint/no-require-imports
        return require(`./augmentations/${fileName}.json`);
    }
    catch (e) {
        return {};
    }
}
exports.resourceAugmentation = resourceAugmentation;
/**
 * Get the resource augmentations for a given type
 */
function cfnLintAnnotations(typeName) {
    var _a, _b;
    // eslint-disable-next-line @typescript-eslint/no-require-imports
    const allAnnotations = require('../spec/cfn-lint.json');
    return {
        stateful: !!allAnnotations.StatefulResources.ResourceTypes[typeName],
        mustBeEmptyToDelete: (_b = (_a = allAnnotations.StatefulResources.ResourceTypes[typeName]) === null || _a === void 0 ? void 0 : _a.DeleteRequiresEmptyResource) !== null && _b !== void 0 ? _b : false,
    };
}
exports.cfnLintAnnotations = cfnLintAnnotations;
/**
 * Return the property specification for the given resource's property
 */
function propertySpecification(typeName, propertyName) {
    const ret = resourceSpecification(typeName).Properties[propertyName];
    if (!ret) {
        throw new Error(`Resource ${typeName} has no property: ${propertyName}`);
    }
    return ret;
}
exports.propertySpecification = propertySpecification;
/**
 * The list of resource type names defined in the ``specification``.
 */
function resourceTypes() {
    return Object.keys(specification().ResourceTypes);
}
exports.resourceTypes = resourceTypes;
/**
 * The list of namespaces defined in the ``specification``, that is resource name prefixes down to the second ``::``.
 */
function namespaces() {
    return Array.from(new Set(resourceTypes().map(n => n.split('::', 2).join('::'))));
}
exports.namespaces = namespaces;
/**
 * Obtain a filtered version of the AWS CloudFormation specification.
 *
 * @param filter the predicate to be used in order to filter which resource types from the ``Specification`` to extract.
 *         When passed as a ``string``, only the specified resource type will be extracted. When passed as a
 *         ``RegExp``, all matching resource types will be extracted. When passed as a ``function``, all resource
 *         types for which the function returned ``true`` will be extracted.
 *
 * @return a coherent sub-set of the AWS CloudFormation Resource specification, including all property types related
 *     to the selected resource types.
 */
function filteredSpecification(filter) {
    const spec = specification();
    const result = { ResourceTypes: {}, PropertyTypes: {}, Fingerprint: spec.Fingerprint };
    const predicate = makePredicate(filter);
    for (const type of resourceTypes()) {
        if (!predicate(type)) {
            continue;
        }
        result.ResourceTypes[type] = spec.ResourceTypes[type];
        const prefix = `${type}.`;
        for (const propType of Object.keys(spec.PropertyTypes).filter(n => n.startsWith(prefix))) {
            result.PropertyTypes[propType] = spec.PropertyTypes[propType];
        }
    }
    result.Fingerprint = crypto.createHash('sha256').update(JSON.stringify(result)).digest('base64');
    return result;
}
exports.filteredSpecification = filteredSpecification;
/**
 * Creates a predicate function from a given filter.
 *
 * @param filter when provided as a ``string``, performs an exact match comparison.
 *         when provided as a ``RegExp``, performs uses ``str.match(RegExp)``.
 *         when provided as a ``function``, use the function as-is.
 *
 * @returns a predicate function.
 */
function makePredicate(filter) {
    if (typeof filter === 'string') {
        return s => s === filter;
    }
    else if (typeof filter === 'function') {
        return filter;
    }
    else {
        return s => s.match(filter) != null;
    }
}
/**
 * Return the properties of the given type that require the given scrutiny type
 */
function scrutinizablePropertyNames(resourceType, scrutinyTypes) {
    const impl = specification().ResourceTypes[resourceType];
    if (!impl) {
        return [];
    }
    const ret = new Array();
    for (const [propertyName, propertySpec] of Object.entries(impl.Properties || {})) {
        if (scrutinyTypes.includes(propertySpec.ScrutinyType || schema.PropertyScrutinyType.None)) {
            ret.push(propertyName);
        }
    }
    return ret;
}
exports.scrutinizablePropertyNames = scrutinizablePropertyNames;
/**
 * Return the names of the resource types that need to be subjected to additional scrutiny
 */
function scrutinizableResourceTypes(scrutinyTypes) {
    const ret = new Array();
    for (const [resourceType, resourceSpec] of Object.entries(specification().ResourceTypes)) {
        if (scrutinyTypes.includes(resourceSpec.ScrutinyType || schema.ResourceScrutinyType.None)) {
            ret.push(resourceType);
        }
    }
    return ret;
}
exports.scrutinizableResourceTypes = scrutinizableResourceTypes;
//# sourceMappingURL=data:application/json;base64,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