"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.hasResource = void 0;
const match_1 = require("./match");
const matcher_1 = require("./matcher");
function hasResource(inspector, type, props) {
    var _a;
    const matcher = matcher_1.Matcher.isMatcher(props) ? props : match_1.Match.objectLike(props);
    let closestResult = undefined;
    let closestResource = undefined;
    let count = 0;
    for (const logicalId of Object.keys((_a = inspector.value.Resources) !== null && _a !== void 0 ? _a : {})) {
        const resource = inspector.value.Resources[logicalId];
        if (resource.Type === type) {
            count++;
            const result = matcher.test(resource);
            if (!result.hasFailed()) {
                return;
            }
            if (closestResult === undefined || closestResult.failCount > result.failCount) {
                closestResult = result;
                closestResource = resource;
            }
        }
    }
    if (closestResult === undefined) {
        return `No resource with type ${type} found`;
    }
    if (!closestResource) {
        throw new Error('unexpected: closestResult is null');
    }
    return [
        `${count} resources with type ${type} found, but none match as expected.`,
        formatMessage(closestResult, closestResource),
    ].join('\n');
}
exports.hasResource = hasResource;
function formatMessage(closestResult, closestResource) {
    return [
        'The closest result is:',
        reindent(JSON.stringify(closestResource, undefined, 2)),
        'with the following mismatches:',
        ...closestResult.toHumanStrings().map(s => `\t${s}`),
    ].join('\n');
}
function reindent(x, indent = 2) {
    const pad = ' '.repeat(indent);
    return pad + x.split('\n').join(`\n${pad}`);
}
//# sourceMappingURL=data:application/json;base64,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