import * as glue from '@aws-cdk/aws-glue';
import * as kdf from '@aws-cdk/aws-kinesisfirehose';
import * as logs from '@aws-cdk/aws-logs';
import * as cdk from '@aws-cdk/core';
export interface TargetGlueTableConfig {
    readonly columns: glue.Column[];
    readonly glueDatabaseArn: string;
    readonly targetS3BucketArn?: string;
    readonly targetS3prefix?: string;
    readonly tableName: string;
}
export interface SourceBackupConfig {
    readonly columns: glue.Column[];
    readonly glueDatabaseArn: string;
    readonly targetS3BucketArn?: string;
    readonly targetS3prefix?: string;
    readonly tableName: string;
}
export interface LogsConfig {
    readonly logsRetentionDays?: logs.RetentionDays;
    readonly logsRemovalPolicy?: cdk.RemovalPolicy;
    readonly logsGroupName: string;
}
export interface KinesisFirehoseTransformerProps {
    readonly targetTableConfig: TargetGlueTableConfig;
    readonly sourceBackupConfig?: SourceBackupConfig;
    readonly processingConfig?: kdf.CfnDeliveryStream.ProcessingConfigurationProperty;
    readonly logsConfig?: LogsConfig;
    readonly deliveryStreamName: string;
    readonly enableCloudwatchLogging: boolean;
    readonly createEncryptionKey: boolean;
}
export declare class KinesisFirehoseTransformer extends cdk.Construct {
    readonly kinesisFirehoseArn: string;
    constructor(scope: cdk.Construct, id: string, props: KinesisFirehoseTransformerProps);
}
