"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SourceMapMode = exports.LogLevel = void 0;
/**
 * Log level for esbuild
 */
var LogLevel;
(function (LogLevel) {
    /** Show everything */
    LogLevel["INFO"] = "info";
    /** Show warnings and errors */
    LogLevel["WARNING"] = "warning";
    /** Show errors only */
    LogLevel["ERROR"] = "error";
    /** Show nothing */
    LogLevel["SILENT"] = "silent";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
/**
 * SourceMap mode for esbuild
 * @see https://esbuild.github.io/api/#sourcemap
 */
var SourceMapMode;
(function (SourceMapMode) {
    /**
     * Default sourceMap mode - will generate a .js.map file alongside any generated .js file and add a special //# sourceMappingURL=
     * comment to the bottom of the .js file pointing to the .js.map file
     */
    SourceMapMode["DEFAULT"] = "default";
    /**
     *  External sourceMap mode - If you want to omit the special //# sourceMappingURL= comment from the generated .js file but you still
     *  want to generate the .js.map files
     */
    SourceMapMode["EXTERNAL"] = "external";
    /**
     * Inline sourceMap mode - If you want to insert the entire source map into the .js file instead of generating a separate .js.map file
     */
    SourceMapMode["INLINE"] = "inline";
    /**
     * Both sourceMap mode - If you want to have the effect of both inline and external simultaneously
     */
    SourceMapMode["BOTH"] = "both";
})(SourceMapMode = exports.SourceMapMode || (exports.SourceMapMode = {}));
//# sourceMappingURL=data:application/json;base64,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