"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualGatewayListener = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const utils_1 = require("./private/utils");
const shared_interfaces_1 = require("./shared-interfaces");
/**
 * Represents the properties needed to define listeners for a VirtualGateway.
 *
 * @stability stable
 */
class VirtualGatewayListener {
    /**
     * Returns an HTTP Listener for a VirtualGateway.
     *
     * @stability stable
     */
    static http(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * Returns an HTTP2 Listener for a VirtualGateway.
     *
     * @stability stable
     */
    static http2(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.HTTP2, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
    /**
     * Returns a GRPC Listener for a VirtualGateway.
     *
     * @stability stable
     */
    static grpc(options = {}) {
        return new VirtualGatewayListenerImpl(shared_interfaces_1.Protocol.GRPC, options.healthCheck, options.port, options.tls, options.connectionPool);
    }
}
exports.VirtualGatewayListener = VirtualGatewayListener;
_a = JSII_RTTI_SYMBOL_1;
VirtualGatewayListener[_a] = { fqn: "@aws-cdk/aws-appmesh.VirtualGatewayListener", version: "1.117.0" };
/**
 * Represents the properties needed to define an HTTP Listener for a VirtualGateway
 */
class VirtualGatewayListenerImpl extends VirtualGatewayListener {
    constructor(protocol, healthCheck, port = 8080, listenerTls, connectionPool) {
        super();
        this.protocol = protocol;
        this.healthCheck = healthCheck;
        this.port = port;
        this.listenerTls = listenerTls;
        this.connectionPool = connectionPool;
    }
    /**
     * Called when the GatewayListener type is initialized. Can be used to enforce
     * mutual exclusivity
     */
    bind(scope) {
        var _b;
        return {
            listener: {
                portMapping: {
                    port: this.port,
                    protocol: this.protocol,
                },
                healthCheck: (_b = this.healthCheck) === null || _b === void 0 ? void 0 : _b.bind(scope, { defaultPort: this.port }).virtualGatewayHealthCheck,
                tls: utils_1.renderListenerTlsOptions(scope, this.listenerTls),
                connectionPool: this.connectionPool ? renderConnectionPool(this.connectionPool, this.protocol) : undefined,
            },
        };
    }
}
function renderConnectionPool(connectionPool, listenerProtocol) {
    return ({
        [listenerProtocol]: {
            maxRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxRequests) !== undefined ? connectionPool.maxRequests : undefined,
            maxConnections: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxConnections) !== undefined ? connectionPool.maxConnections : undefined,
            maxPendingRequests: (connectionPool === null || connectionPool === void 0 ? void 0 : connectionPool.maxPendingRequests) !== undefined ? connectionPool.maxPendingRequests : undefined,
        },
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmlydHVhbC1nYXRld2F5LWxpc3RlbmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidmlydHVhbC1nYXRld2F5LWxpc3RlbmVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBR0EsMkNBQWlGO0FBQ2pGLDJEQUs2Qjs7Ozs7O0FBNkM3QixNQUFzQixzQkFBc0I7Ozs7OztJQUVuQyxNQUFNLENBQUMsSUFBSSxDQUFDLFVBQXNDLEVBQUU7UUFDekQsT0FBTyxJQUFJLDBCQUEwQixDQUFDLDRCQUFRLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxXQUFXLEVBQUUsT0FBTyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUMvSCxDQUFDOzs7Ozs7SUFHTSxNQUFNLENBQUMsS0FBSyxDQUFDLFVBQXVDLEVBQUU7UUFDM0QsT0FBTyxJQUFJLDBCQUEwQixDQUFDLDRCQUFRLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxXQUFXLEVBQUUsT0FBTyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUNoSSxDQUFDOzs7Ozs7SUFHTSxNQUFNLENBQUMsSUFBSSxDQUFDLFVBQXNDLEVBQUU7UUFDekQsT0FBTyxJQUFJLDBCQUEwQixDQUFDLDRCQUFRLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxXQUFXLEVBQUUsT0FBTyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsR0FBRyxFQUFFLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQztJQUMvSCxDQUFDOztBQWRILHdEQWtCQzs7O0FBRUQ7O0dBRUc7QUFDSCxNQUFNLDBCQUEyQixTQUFRLHNCQUFzQjtJQUU3RCxZQUE2QixRQUFrQixFQUM1QixXQUFvQyxFQUNwQyxPQUFlLElBQUksRUFDbkIsV0FBMkMsRUFDM0MsY0FBZ0Q7UUFDakUsS0FBSyxFQUFFLENBQUM7UUFMbUIsYUFBUSxHQUFSLFFBQVEsQ0FBVTtRQUM1QixnQkFBVyxHQUFYLFdBQVcsQ0FBeUI7UUFDcEMsU0FBSSxHQUFKLElBQUksQ0FBZTtRQUNuQixnQkFBVyxHQUFYLFdBQVcsQ0FBZ0M7UUFDM0MsbUJBQWMsR0FBZCxjQUFjLENBQWtDO0lBRW5FLENBQUM7SUFFRDs7O09BR0c7SUFDSSxJQUFJLENBQUMsS0FBZ0I7O1FBQzFCLE9BQU87WUFDTCxRQUFRLEVBQUU7Z0JBQ1IsV0FBVyxFQUFFO29CQUNYLElBQUksRUFBRSxJQUFJLENBQUMsSUFBSTtvQkFDZixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7aUJBQ3hCO2dCQUNELFdBQVcsUUFBRSxJQUFJLENBQUMsV0FBVywwQ0FBRSxJQUFJLENBQUMsS0FBSyxFQUFFLEVBQUUsV0FBVyxFQUFFLElBQUksQ0FBQyxJQUFJLEVBQUUsRUFBRSx5QkFBeUI7Z0JBQ2hHLEdBQUcsRUFBRSxnQ0FBd0IsQ0FBQyxLQUFLLEVBQUUsSUFBSSxDQUFDLFdBQVcsQ0FBQztnQkFDdEQsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxjQUFjLEVBQUUsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTO2FBQzNHO1NBQ0YsQ0FBQztJQUNKLENBQUM7Q0FDRjtBQUVELFNBQVMsb0JBQW9CLENBQUMsY0FBb0MsRUFBRSxnQkFBMEI7SUFFNUYsT0FBTyxDQUFDO1FBQ04sQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFO1lBQ2xCLFdBQVcsRUFBRSxDQUFBLGNBQWMsYUFBZCxjQUFjLHVCQUFkLGNBQWMsQ0FBRSxXQUFXLE1BQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQy9GLGNBQWMsRUFBRSxDQUFBLGNBQWMsYUFBZCxjQUFjLHVCQUFkLGNBQWMsQ0FBRSxjQUFjLE1BQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsY0FBYyxDQUFDLENBQUMsQ0FBQyxTQUFTO1lBQ3hHLGtCQUFrQixFQUFFLENBQUEsY0FBYyxhQUFkLGNBQWMsdUJBQWQsY0FBYyxDQUFFLGtCQUFrQixNQUFLLFNBQVMsQ0FBQyxDQUFDLENBQUMsY0FBYyxDQUFDLGtCQUFrQixDQUFDLENBQUMsQ0FBQyxTQUFTO1NBQ3JIO0tBQ0YsQ0FBQyxDQUFDO0FBQ0wsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENmblZpcnR1YWxHYXRld2F5IH0gZnJvbSAnLi9hcHBtZXNoLmdlbmVyYXRlZCc7XG5pbXBvcnQgeyBIZWFsdGhDaGVjayB9IGZyb20gJy4vaGVhbHRoLWNoZWNrcyc7XG5pbXBvcnQgeyBMaXN0ZW5lclRsc09wdGlvbnMgfSBmcm9tICcuL2xpc3RlbmVyLXRscy1vcHRpb25zJztcbmltcG9ydCB7IENvbm5lY3Rpb25Qb29sQ29uZmlnLCByZW5kZXJMaXN0ZW5lclRsc09wdGlvbnMgfSBmcm9tICcuL3ByaXZhdGUvdXRpbHMnO1xuaW1wb3J0IHtcbiAgR3JwY0Nvbm5lY3Rpb25Qb29sLFxuICBIdHRwMkNvbm5lY3Rpb25Qb29sLFxuICBIdHRwQ29ubmVjdGlvblBvb2wsXG4gIFByb3RvY29sLFxufSBmcm9tICcuL3NoYXJlZC1pbnRlcmZhY2VzJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ0Bhd3MtY2RrL2NvcmUnO1xuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIHByb3BlcnRpZXMgbmVlZGVkIHRvIGRlZmluZSBhIExpc3RlbmVycyBmb3IgYSBWaXJ0dWFsR2F0ZXdheVxuICovXG5pbnRlcmZhY2UgVmlydHVhbEdhdGV3YXlMaXN0ZW5lckNvbW1vbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBwb3J0PzogbnVtYmVyXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGhlYWx0aENoZWNrPzogSGVhbHRoQ2hlY2s7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSB0bHM/OiBMaXN0ZW5lclRsc09wdGlvbnM7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEh0dHBHYXRld2F5TGlzdGVuZXJPcHRpb25zIGV4dGVuZHMgVmlydHVhbEdhdGV3YXlMaXN0ZW5lckNvbW1vbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29ubmVjdGlvblBvb2w/OiBIdHRwQ29ubmVjdGlvblBvb2w7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBIdHRwMkdhdGV3YXlMaXN0ZW5lck9wdGlvbnMgZXh0ZW5kcyBWaXJ0dWFsR2F0ZXdheUxpc3RlbmVyQ29tbW9uT3B0aW9ucyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBjb25uZWN0aW9uUG9vbD86IEh0dHAyQ29ubmVjdGlvblBvb2w7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEdycGNHYXRld2F5TGlzdGVuZXJPcHRpb25zIGV4dGVuZHMgVmlydHVhbEdhdGV3YXlMaXN0ZW5lckNvbW1vbk9wdGlvbnMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgY29ubmVjdGlvblBvb2w/OiBHcnBjQ29ubmVjdGlvblBvb2w7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBWaXJ0dWFsR2F0ZXdheUxpc3RlbmVyQ29uZmlnIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBsaXN0ZW5lcjogQ2ZuVmlydHVhbEdhdGV3YXkuVmlydHVhbEdhdGV3YXlMaXN0ZW5lclByb3BlcnR5O1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBWaXJ0dWFsR2F0ZXdheUxpc3RlbmVyIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBzdGF0aWMgaHR0cChvcHRpb25zOiBIdHRwR2F0ZXdheUxpc3RlbmVyT3B0aW9ucyA9IHt9KTogVmlydHVhbEdhdGV3YXlMaXN0ZW5lciB7XG4gICAgcmV0dXJuIG5ldyBWaXJ0dWFsR2F0ZXdheUxpc3RlbmVySW1wbChQcm90b2NvbC5IVFRQLCBvcHRpb25zLmhlYWx0aENoZWNrLCBvcHRpb25zLnBvcnQsIG9wdGlvbnMudGxzLCBvcHRpb25zLmNvbm5lY3Rpb25Qb29sKTtcbiAgfVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBodHRwMihvcHRpb25zOiBIdHRwMkdhdGV3YXlMaXN0ZW5lck9wdGlvbnMgPSB7fSk6IFZpcnR1YWxHYXRld2F5TGlzdGVuZXIge1xuICAgIHJldHVybiBuZXcgVmlydHVhbEdhdGV3YXlMaXN0ZW5lckltcGwoUHJvdG9jb2wuSFRUUDIsIG9wdGlvbnMuaGVhbHRoQ2hlY2ssIG9wdGlvbnMucG9ydCwgb3B0aW9ucy50bHMsIG9wdGlvbnMuY29ubmVjdGlvblBvb2wpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBncnBjKG9wdGlvbnM6IEdycGNHYXRld2F5TGlzdGVuZXJPcHRpb25zID0ge30pOiBWaXJ0dWFsR2F0ZXdheUxpc3RlbmVyIHtcbiAgICByZXR1cm4gbmV3IFZpcnR1YWxHYXRld2F5TGlzdGVuZXJJbXBsKFByb3RvY29sLkdSUEMsIG9wdGlvbnMuaGVhbHRoQ2hlY2ssIG9wdGlvbnMucG9ydCwgb3B0aW9ucy50bHMsIG9wdGlvbnMuY29ubmVjdGlvblBvb2wpO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHB1YmxpYyBhYnN0cmFjdCBiaW5kKHNjb3BlOiBDb25zdHJ1Y3QpOiBWaXJ0dWFsR2F0ZXdheUxpc3RlbmVyQ29uZmlnO1xufVxuXG4vKipcbiAqIFJlcHJlc2VudHMgdGhlIHByb3BlcnRpZXMgbmVlZGVkIHRvIGRlZmluZSBhbiBIVFRQIExpc3RlbmVyIGZvciBhIFZpcnR1YWxHYXRld2F5XG4gKi9cbmNsYXNzIFZpcnR1YWxHYXRld2F5TGlzdGVuZXJJbXBsIGV4dGVuZHMgVmlydHVhbEdhdGV3YXlMaXN0ZW5lciB7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSByZWFkb25seSBwcm90b2NvbDogUHJvdG9jb2wsXG4gICAgcHJpdmF0ZSByZWFkb25seSBoZWFsdGhDaGVjazogSGVhbHRoQ2hlY2sgfCB1bmRlZmluZWQsXG4gICAgcHJpdmF0ZSByZWFkb25seSBwb3J0OiBudW1iZXIgPSA4MDgwLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgbGlzdGVuZXJUbHM6IExpc3RlbmVyVGxzT3B0aW9ucyB8IHVuZGVmaW5lZCxcbiAgICBwcml2YXRlIHJlYWRvbmx5IGNvbm5lY3Rpb25Qb29sOiBDb25uZWN0aW9uUG9vbENvbmZpZyB8IHVuZGVmaW5lZCkge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICAvKipcbiAgICogQ2FsbGVkIHdoZW4gdGhlIEdhdGV3YXlMaXN0ZW5lciB0eXBlIGlzIGluaXRpYWxpemVkLiBDYW4gYmUgdXNlZCB0byBlbmZvcmNlXG4gICAqIG11dHVhbCBleGNsdXNpdml0eVxuICAgKi9cbiAgcHVibGljIGJpbmQoc2NvcGU6IENvbnN0cnVjdCk6IFZpcnR1YWxHYXRld2F5TGlzdGVuZXJDb25maWcge1xuICAgIHJldHVybiB7XG4gICAgICBsaXN0ZW5lcjoge1xuICAgICAgICBwb3J0TWFwcGluZzoge1xuICAgICAgICAgIHBvcnQ6IHRoaXMucG9ydCxcbiAgICAgICAgICBwcm90b2NvbDogdGhpcy5wcm90b2NvbCxcbiAgICAgICAgfSxcbiAgICAgICAgaGVhbHRoQ2hlY2s6IHRoaXMuaGVhbHRoQ2hlY2s/LmJpbmQoc2NvcGUsIHsgZGVmYXVsdFBvcnQ6IHRoaXMucG9ydCB9KS52aXJ0dWFsR2F0ZXdheUhlYWx0aENoZWNrLFxuICAgICAgICB0bHM6IHJlbmRlckxpc3RlbmVyVGxzT3B0aW9ucyhzY29wZSwgdGhpcy5saXN0ZW5lclRscyksXG4gICAgICAgIGNvbm5lY3Rpb25Qb29sOiB0aGlzLmNvbm5lY3Rpb25Qb29sID8gcmVuZGVyQ29ubmVjdGlvblBvb2wodGhpcy5jb25uZWN0aW9uUG9vbCwgdGhpcy5wcm90b2NvbCkgOiB1bmRlZmluZWQsXG4gICAgICB9LFxuICAgIH07XG4gIH1cbn1cblxuZnVuY3Rpb24gcmVuZGVyQ29ubmVjdGlvblBvb2woY29ubmVjdGlvblBvb2w6IENvbm5lY3Rpb25Qb29sQ29uZmlnLCBsaXN0ZW5lclByb3RvY29sOiBQcm90b2NvbCk6XG5DZm5WaXJ0dWFsR2F0ZXdheS5WaXJ0dWFsR2F0ZXdheUNvbm5lY3Rpb25Qb29sUHJvcGVydHkge1xuICByZXR1cm4gKHtcbiAgICBbbGlzdGVuZXJQcm90b2NvbF06IHtcbiAgICAgIG1heFJlcXVlc3RzOiBjb25uZWN0aW9uUG9vbD8ubWF4UmVxdWVzdHMgIT09IHVuZGVmaW5lZCA/IGNvbm5lY3Rpb25Qb29sLm1heFJlcXVlc3RzIDogdW5kZWZpbmVkLFxuICAgICAgbWF4Q29ubmVjdGlvbnM6IGNvbm5lY3Rpb25Qb29sPy5tYXhDb25uZWN0aW9ucyAhPT0gdW5kZWZpbmVkID8gY29ubmVjdGlvblBvb2wubWF4Q29ubmVjdGlvbnMgOiB1bmRlZmluZWQsXG4gICAgICBtYXhQZW5kaW5nUmVxdWVzdHM6IGNvbm5lY3Rpb25Qb29sPy5tYXhQZW5kaW5nUmVxdWVzdHMgIT09IHVuZGVmaW5lZCA/IGNvbm5lY3Rpb25Qb29sLm1heFBlbmRpbmdSZXF1ZXN0cyA6IHVuZGVmaW5lZCxcbiAgICB9LFxuICB9KTtcbn1cbiJdfQ==