# AUTOGENERATED! DO NOT EDIT! File to edit: module_notebooks/01_test_helper.ipynb (unless otherwise specified).

__all__ = ['test_data_dir']

# Cell

from pathlib import Path

def test_data_dir(test_data_dir_name: str = 'test_data') -> Path:
    '''
    1. **test_data_dir_name** -- Name of the test data folder.

    **returns** the directory to the test data folder.

    A lot of this code has been taken and slightly adapted form the
    [Config class](https://github.com/fastai/fastcore/blob/875988a7ed359a3eb16fd2166bf8fb42b190881c/fastcore/foundation.py#L255)
    from the [fast core library.](https://github.com/fastai/fastcore)
    '''
    cwd_dir = Path.cwd()
    while cwd_dir != cwd_dir.parent and not (cwd_dir/test_data_dir_name).exists():
        cwd_dir = cwd_dir.parent
    test_data_dir_path = Path(cwd_dir, test_data_dir_name)
    if not test_data_dir_path.exists():
        raise FileNotFoundError('Cannot find test data folder '
                                f'{test_data_dir_name}')
    return test_data_dir_path.resolve()
