#ifndef __LIBMAIX_NN_DECODER_YOLO2_H
#define __LIBMAIX_NN_DECODER_YOLO2_H



#ifdef __cplusplus
extern "C"
{
#endif
#include <stdint.h>
#include <stdbool.h>
#include "libmaix_err.h"
#include "libmaix_nn_decoder.h"

typedef struct
{
    float x;
    float y;
    float w;
    float h;
}libmaix_nn_decoder_yolo2_box_t;

typedef struct
{
    uint32_t classes_num;
    float    threshold;
    float    nms_value;
    uint32_t anchors_num;
    float*   anchors;
    uint32_t net_in_width;     // net input width, e.g. 224
    uint32_t net_in_height;
    uint32_t net_out_width;    // net output width, e.g. 7
    uint32_t net_out_height;
    uint32_t input_width;      // input image width, e.g. 320, if it not the same as net input, the output box max width is the same as image width
    uint32_t input_height;
}libmaix_nn_decoder_yolo2_config_t;


typedef struct
{
    libmaix_nn_decoder_yolo2_config_t* config;
    uint32_t coords;          // coord length, 4: xmin, ymin, xmax, ymax
    uint32_t net_out_wh;
    uint32_t boxes_number;
    uint32_t output_number;
    uint32_t one_box_output_number;
    uint32_t one_ch_output_number;
    float scale;
    float bias;
    libmaix_nn_decoder_yolo2_box_t* boxes;
    //uint8_t *input;
    float *output;
    float *probs_buf;
    float **probs;
    float *activate;
    float *softmax;
} region_layer_t;

typedef struct
{
    int index;
    int class_id;
    float **probs;
}sortable_box_t;




typedef struct
{
    uint32_t                        boxes_num;
    libmaix_nn_decoder_yolo2_box_t* boxes;
    float**                         probs;      // shape: (boxes_num, classes_num, dtype='float')
}libmaix_nn_decoder_yolo2_result_t;


typedef void (*callback_draw_result_func_t)(uint32_t id, uint32_t x, uint32_t y, uint32_t w, uint32_t h, uint32_t class_id, float prob, char* label, void* arg);

libmaix_err_t libmaix_nn_decoder_yolo2_init(struct libmaix_nn_decoder* obj, void* config);
libmaix_err_t libmaix_nn_decoder_yolo2_deinit(struct libmaix_nn_decoder* obj);
libmaix_err_t libmaix_nn_decoder_yolo2_decode(struct libmaix_nn_decoder* obj, libmaix_nn_layer_t* feature_map, void* result);
void libmaix_nn_decoder_yolo2_draw_result(struct libmaix_nn_decoder* obj, libmaix_nn_decoder_yolo2_result_t* result, uint32_t id, char** labels, callback_draw_result_func_t callback, void* arg);

libmaix_nn_decoder_t* libmaix_nn_decoder_yolo2_create(libmaic_nn_decoder_init_func_t init_func, libmaic_nn_decoder_deinit_func_t deinit_func,
                                                libmaic_nn_decoder_decode_func_t decode_func);
void libmaix_nn_decoder_yolo2_destroy(libmaix_nn_decoder_t** obj);


#ifdef __cplusplus
}
#endif

#endif
