# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FusionAuthFormFieldArgs', 'FusionAuthFormField']

@pulumi.input_type
class FusionAuthFormFieldArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 confirm: Optional[pulumi.Input[bool]] = None,
                 consent_id: Optional[pulumi.Input[str]] = None,
                 control: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 form_field_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input['FusionAuthFormFieldValidatorArgs']] = None):
        """
        The set of arguments for constructing a FusionAuthFormField resource.
        :param pulumi.Input[str] key: The key is the path to the value in the user or registration object.
        :param pulumi.Input[bool] confirm: Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        :param pulumi.Input[str] consent_id: The Id of an existing Consent. This field will be required when the type is set to consent.
        :param pulumi.Input[str] control: The Form Field control
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Form Field that should be persisted.
        :param pulumi.Input[str] description: A description of the Form Field.
        :param pulumi.Input[str] form_field_id: The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] name: The unique name of the Form Field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: A list of options that are applied to checkbox, radio, or select controls.
        :param pulumi.Input[bool] required: Determines if a value is required to complete the form.
        :param pulumi.Input[str] type: The data type used to store the value in FusionAuth.
        """
        pulumi.set(__self__, "key", key)
        if confirm is not None:
            pulumi.set(__self__, "confirm", confirm)
        if consent_id is not None:
            pulumi.set(__self__, "consent_id", consent_id)
        if control is not None:
            pulumi.set(__self__, "control", control)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if form_field_id is not None:
            pulumi.set(__self__, "form_field_id", form_field_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validator is not None:
            pulumi.set(__self__, "validator", validator)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key is the path to the value in the user or registration object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def confirm(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        """
        return pulumi.get(self, "confirm")

    @confirm.setter
    def confirm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confirm", value)

    @property
    @pulumi.getter(name="consentId")
    def consent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of an existing Consent. This field will be required when the type is set to consent.
        """
        return pulumi.get(self, "consent_id")

    @consent_id.setter
    def consent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent_id", value)

    @property
    @pulumi.getter
    def control(self) -> Optional[pulumi.Input[str]]:
        """
        The Form Field control
        """
        return pulumi.get(self, "control")

    @control.setter
    def control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Form Field that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Form Field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="formFieldId")
    def form_field_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "form_field_id")

    @form_field_id.setter
    def form_field_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "form_field_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the Form Field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of options that are applied to checkbox, radio, or select controls.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if a value is required to complete the form.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type used to store the value in FusionAuth.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validator(self) -> Optional[pulumi.Input['FusionAuthFormFieldValidatorArgs']]:
        return pulumi.get(self, "validator")

    @validator.setter
    def validator(self, value: Optional[pulumi.Input['FusionAuthFormFieldValidatorArgs']]):
        pulumi.set(self, "validator", value)


@pulumi.input_type
class _FusionAuthFormFieldState:
    def __init__(__self__, *,
                 confirm: Optional[pulumi.Input[bool]] = None,
                 consent_id: Optional[pulumi.Input[str]] = None,
                 control: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 form_field_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input['FusionAuthFormFieldValidatorArgs']] = None):
        """
        Input properties used for looking up and filtering FusionAuthFormField resources.
        :param pulumi.Input[bool] confirm: Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        :param pulumi.Input[str] consent_id: The Id of an existing Consent. This field will be required when the type is set to consent.
        :param pulumi.Input[str] control: The Form Field control
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Form Field that should be persisted.
        :param pulumi.Input[str] description: A description of the Form Field.
        :param pulumi.Input[str] form_field_id: The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] key: The key is the path to the value in the user or registration object.
        :param pulumi.Input[str] name: The unique name of the Form Field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: A list of options that are applied to checkbox, radio, or select controls.
        :param pulumi.Input[bool] required: Determines if a value is required to complete the form.
        :param pulumi.Input[str] type: The data type used to store the value in FusionAuth.
        """
        if confirm is not None:
            pulumi.set(__self__, "confirm", confirm)
        if consent_id is not None:
            pulumi.set(__self__, "consent_id", consent_id)
        if control is not None:
            pulumi.set(__self__, "control", control)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if form_field_id is not None:
            pulumi.set(__self__, "form_field_id", form_field_id)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if required is not None:
            pulumi.set(__self__, "required", required)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validator is not None:
            pulumi.set(__self__, "validator", validator)

    @property
    @pulumi.getter
    def confirm(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        """
        return pulumi.get(self, "confirm")

    @confirm.setter
    def confirm(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "confirm", value)

    @property
    @pulumi.getter(name="consentId")
    def consent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of an existing Consent. This field will be required when the type is set to consent.
        """
        return pulumi.get(self, "consent_id")

    @consent_id.setter
    def consent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consent_id", value)

    @property
    @pulumi.getter
    def control(self) -> Optional[pulumi.Input[str]]:
        """
        The Form Field control
        """
        return pulumi.get(self, "control")

    @control.setter
    def control(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "control", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Form Field that should be persisted.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description of the Form Field.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="formFieldId")
    def form_field_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "form_field_id")

    @form_field_id.setter
    def form_field_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "form_field_id", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The key is the path to the value in the user or registration object.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The unique name of the Form Field.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of options that are applied to checkbox, radio, or select controls.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def required(self) -> Optional[pulumi.Input[bool]]:
        """
        Determines if a value is required to complete the form.
        """
        return pulumi.get(self, "required")

    @required.setter
    def required(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "required", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The data type used to store the value in FusionAuth.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def validator(self) -> Optional[pulumi.Input['FusionAuthFormFieldValidatorArgs']]:
        return pulumi.get(self, "validator")

    @validator.setter
    def validator(self, value: Optional[pulumi.Input['FusionAuthFormFieldValidatorArgs']]):
        pulumi.set(self, "validator", value)


class FusionAuthFormField(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confirm: Optional[pulumi.Input[bool]] = None,
                 consent_id: Optional[pulumi.Input[str]] = None,
                 control: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 form_field_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input[pulumi.InputType['FusionAuthFormFieldValidatorArgs']]] = None,
                 __props__=None):
        """
        ## # Form Field Resource

        A FusionAuth Form Field is an object that can be customized to receive input within a FusionAuth Form.

        [Form Field API](https://fusionauth.io/docs/v1/tech/apis/form-fields/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        field = fusionauth.FusionAuthFormField("field",
            confirm=True,
            data={
                "leftAddOn": "send",
            },
            description="Information about this custom field",
            key="user.firstName",
            required=True)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] confirm: Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        :param pulumi.Input[str] consent_id: The Id of an existing Consent. This field will be required when the type is set to consent.
        :param pulumi.Input[str] control: The Form Field control
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Form Field that should be persisted.
        :param pulumi.Input[str] description: A description of the Form Field.
        :param pulumi.Input[str] form_field_id: The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] key: The key is the path to the value in the user or registration object.
        :param pulumi.Input[str] name: The unique name of the Form Field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: A list of options that are applied to checkbox, radio, or select controls.
        :param pulumi.Input[bool] required: Determines if a value is required to complete the form.
        :param pulumi.Input[str] type: The data type used to store the value in FusionAuth.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthFormFieldArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Form Field Resource

        A FusionAuth Form Field is an object that can be customized to receive input within a FusionAuth Form.

        [Form Field API](https://fusionauth.io/docs/v1/tech/apis/form-fields/)

        ## Example Usage

        ```python
        import pulumi
        import theogravity_pulumi-fusionauth as fusionauth

        field = fusionauth.FusionAuthFormField("field",
            confirm=True,
            data={
                "leftAddOn": "send",
            },
            description="Information about this custom field",
            key="user.firstName",
            required=True)
        ```

        :param str resource_name: The name of the resource.
        :param FusionAuthFormFieldArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthFormFieldArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 confirm: Optional[pulumi.Input[bool]] = None,
                 consent_id: Optional[pulumi.Input[str]] = None,
                 control: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 form_field_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 required: Optional[pulumi.Input[bool]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 validator: Optional[pulumi.Input[pulumi.InputType['FusionAuthFormFieldValidatorArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthFormFieldArgs.__new__(FusionAuthFormFieldArgs)

            __props__.__dict__["confirm"] = confirm
            __props__.__dict__["consent_id"] = consent_id
            __props__.__dict__["control"] = control
            __props__.__dict__["data"] = data
            __props__.__dict__["description"] = description
            __props__.__dict__["form_field_id"] = form_field_id
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["name"] = name
            __props__.__dict__["options"] = options
            __props__.__dict__["required"] = required
            __props__.__dict__["type"] = type
            __props__.__dict__["validator"] = validator
        super(FusionAuthFormField, __self__).__init__(
            'fusionauth:index/fusionAuthFormField:FusionAuthFormField',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            confirm: Optional[pulumi.Input[bool]] = None,
            consent_id: Optional[pulumi.Input[str]] = None,
            control: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            form_field_id: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            required: Optional[pulumi.Input[bool]] = None,
            type: Optional[pulumi.Input[str]] = None,
            validator: Optional[pulumi.Input[pulumi.InputType['FusionAuthFormFieldValidatorArgs']]] = None) -> 'FusionAuthFormField':
        """
        Get an existing FusionAuthFormField resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] confirm: Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        :param pulumi.Input[str] consent_id: The Id of an existing Consent. This field will be required when the type is set to consent.
        :param pulumi.Input[str] control: The Form Field control
        :param pulumi.Input[Mapping[str, Any]] data: An object that can hold any information about the Form Field that should be persisted.
        :param pulumi.Input[str] description: A description of the Form Field.
        :param pulumi.Input[str] form_field_id: The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] key: The key is the path to the value in the user or registration object.
        :param pulumi.Input[str] name: The unique name of the Form Field.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] options: A list of options that are applied to checkbox, radio, or select controls.
        :param pulumi.Input[bool] required: Determines if a value is required to complete the form.
        :param pulumi.Input[str] type: The data type used to store the value in FusionAuth.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthFormFieldState.__new__(_FusionAuthFormFieldState)

        __props__.__dict__["confirm"] = confirm
        __props__.__dict__["consent_id"] = consent_id
        __props__.__dict__["control"] = control
        __props__.__dict__["data"] = data
        __props__.__dict__["description"] = description
        __props__.__dict__["form_field_id"] = form_field_id
        __props__.__dict__["key"] = key
        __props__.__dict__["name"] = name
        __props__.__dict__["options"] = options
        __props__.__dict__["required"] = required
        __props__.__dict__["type"] = type
        __props__.__dict__["validator"] = validator
        return FusionAuthFormField(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def confirm(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if the user input should be confirmed by requiring the value to be entered twice. If true, a confirmation field is included.
        """
        return pulumi.get(self, "confirm")

    @property
    @pulumi.getter(name="consentId")
    def consent_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id of an existing Consent. This field will be required when the type is set to consent.
        """
        return pulumi.get(self, "consent_id")

    @property
    @pulumi.getter
    def control(self) -> pulumi.Output[str]:
        """
        The Form Field control
        """
        return pulumi.get(self, "control")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        An object that can hold any information about the Form Field that should be persisted.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        A description of the Form Field.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="formFieldId")
    def form_field_id(self) -> pulumi.Output[Optional[str]]:
        """
        The Id to use for the new Form Field. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "form_field_id")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The key is the path to the value in the user or registration object.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The unique name of the Form Field.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of options that are applied to checkbox, radio, or select controls.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def required(self) -> pulumi.Output[Optional[bool]]:
        """
        Determines if a value is required to complete the form.
        """
        return pulumi.get(self, "required")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        The data type used to store the value in FusionAuth.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def validator(self) -> pulumi.Output['outputs.FusionAuthFormFieldValidator']:
        return pulumi.get(self, "validator")

