# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthEntityTypePermissionArgs', 'FusionAuthEntityTypePermission']

@pulumi.input_type
class FusionAuthEntityTypePermissionArgs:
    def __init__(__self__, *,
                 entity_type_id: pulumi.Input[str],
                 data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthEntityTypePermission resource.
        :param pulumi.Input[str] entity_type_id: The Id of the Entity Type.
        :param pulumi.Input[str] data: An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        :param pulumi.Input[str] description: The description of the Permission.
        :param pulumi.Input[bool] is_default: Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
               this type if no permissions are provided in a grant request.
        :param pulumi.Input[str] name: The name of the Permission.
        :param pulumi.Input[str] permission_id: The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        pulumi.set(__self__, "entity_type_id", entity_type_id)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission_id is not None:
            pulumi.set(__self__, "permission_id", permission_id)

    @property
    @pulumi.getter(name="entityTypeId")
    def entity_type_id(self) -> pulumi.Input[str]:
        """
        The Id of the Entity Type.
        """
        return pulumi.get(self, "entity_type_id")

    @entity_type_id.setter
    def entity_type_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type_id", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Permission.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
        this type if no permissions are provided in a grant request.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Permission.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="permissionId")
    def permission_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "permission_id")

    @permission_id.setter
    def permission_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_id", value)


@pulumi.input_type
class _FusionAuthEntityTypePermissionState:
    def __init__(__self__, *,
                 data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_type_id: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthEntityTypePermission resources.
        :param pulumi.Input[str] data: An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        :param pulumi.Input[str] description: The description of the Permission.
        :param pulumi.Input[str] entity_type_id: The Id of the Entity Type.
        :param pulumi.Input[bool] is_default: Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
               this type if no permissions are provided in a grant request.
        :param pulumi.Input[str] name: The name of the Permission.
        :param pulumi.Input[str] permission_id: The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        if data is not None:
            pulumi.set(__self__, "data", data)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if entity_type_id is not None:
            pulumi.set(__self__, "entity_type_id", entity_type_id)
        if is_default is not None:
            pulumi.set(__self__, "is_default", is_default)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if permission_id is not None:
            pulumi.set(__self__, "permission_id", permission_id)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Permission.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="entityTypeId")
    def entity_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id of the Entity Type.
        """
        return pulumi.get(self, "entity_type_id")

    @entity_type_id.setter
    def entity_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type_id", value)

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
        this type if no permissions are provided in a grant request.
        """
        return pulumi.get(self, "is_default")

    @is_default.setter
    def is_default(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Permission.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="permissionId")
    def permission_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "permission_id")

    @permission_id.setter
    def permission_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permission_id", value)


class FusionAuthEntityTypePermission(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_type_id: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Create a FusionAuthEntityTypePermission resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        :param pulumi.Input[str] description: The description of the Permission.
        :param pulumi.Input[str] entity_type_id: The Id of the Entity Type.
        :param pulumi.Input[bool] is_default: Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
               this type if no permissions are provided in a grant request.
        :param pulumi.Input[str] name: The name of the Permission.
        :param pulumi.Input[str] permission_id: The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthEntityTypePermissionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a FusionAuthEntityTypePermission resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param FusionAuthEntityTypePermissionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthEntityTypePermissionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 entity_type_id: Optional[pulumi.Input[str]] = None,
                 is_default: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 permission_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthEntityTypePermissionArgs.__new__(FusionAuthEntityTypePermissionArgs)

            __props__.__dict__["data"] = data
            __props__.__dict__["description"] = description
            if entity_type_id is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type_id'")
            __props__.__dict__["entity_type_id"] = entity_type_id
            __props__.__dict__["is_default"] = is_default
            __props__.__dict__["name"] = name
            __props__.__dict__["permission_id"] = permission_id
        super(FusionAuthEntityTypePermission, __self__).__init__(
            'fusionauth:index/fusionAuthEntityTypePermission:FusionAuthEntityTypePermission',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            entity_type_id: Optional[pulumi.Input[str]] = None,
            is_default: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            permission_id: Optional[pulumi.Input[str]] = None) -> 'FusionAuthEntityTypePermission':
        """
        Get an existing FusionAuthEntityTypePermission resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] data: An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        :param pulumi.Input[str] description: The description of the Permission.
        :param pulumi.Input[str] entity_type_id: The Id of the Entity Type.
        :param pulumi.Input[bool] is_default: Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
               this type if no permissions are provided in a grant request.
        :param pulumi.Input[str] name: The name of the Permission.
        :param pulumi.Input[str] permission_id: The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthEntityTypePermissionState.__new__(_FusionAuthEntityTypePermissionState)

        __props__.__dict__["data"] = data
        __props__.__dict__["description"] = description
        __props__.__dict__["entity_type_id"] = entity_type_id
        __props__.__dict__["is_default"] = is_default
        __props__.__dict__["name"] = name
        __props__.__dict__["permission_id"] = permission_id
        return FusionAuthEntityTypePermission(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[str]]:
        """
        An object that can hold any information about the Permission that should be persisted. Must be a JSON string.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the Permission.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="entityTypeId")
    def entity_type_id(self) -> pulumi.Output[str]:
        """
        The Id of the Entity Type.
        """
        return pulumi.get(self, "entity_type_id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether or not the Permission is a default permission. A default permission is automatically granted to an entity of
        this type if no permissions are provided in a grant request.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Permission.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="permissionId")
    def permission_id(self) -> pulumi.Output[str]:
        """
        The Id to use for the new permission. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "permission_id")

