# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['FusionAuthEntityArgs', 'FusionAuthEntity']

@pulumi.input_type
class FusionAuthEntityArgs:
    def __init__(__self__, *,
                 entity_type_id: pulumi.Input[str],
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a FusionAuthEntity resource.
        :param pulumi.Input[str] entity_type_id: The ID of the Entity Type. Types are consulted for permission checks.
        :param pulumi.Input[str] client_id: The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
               be used. Must be a UUID.
        :param pulumi.Input[str] client_secret: The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
               generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
               and update you can provide a value and it will be stored.
        :param pulumi.Input[str] data: An object that can hold any information about the Entity that should be persisted. Please review
               the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        :param pulumi.Input[str] entity_id: The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] name: A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        :param pulumi.Input[str] tenant_id: The unique ID of the tenant used to scope this API request.
        """
        pulumi.set(__self__, "entity_type_id", entity_type_id)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="entityTypeId")
    def entity_type_id(self) -> pulumi.Input[str]:
        """
        The ID of the Entity Type. Types are consulted for permission checks.
        """
        return pulumi.get(self, "entity_type_id")

    @entity_type_id.setter
    def entity_type_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_type_id", value)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
        be used. Must be a UUID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
        generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
        and update you can provide a value and it will be stored.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        An object that can hold any information about the Entity that should be persisted. Please review
        the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


@pulumi.input_type
class _FusionAuthEntityState:
    def __init__(__self__, *,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 entity_type_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering FusionAuthEntity resources.
        :param pulumi.Input[str] client_id: The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
               be used. Must be a UUID.
        :param pulumi.Input[str] client_secret: The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
               generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
               and update you can provide a value and it will be stored.
        :param pulumi.Input[str] data: An object that can hold any information about the Entity that should be persisted. Please review
               the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        :param pulumi.Input[str] entity_id: The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] entity_type_id: The ID of the Entity Type. Types are consulted for permission checks.
        :param pulumi.Input[str] name: A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        :param pulumi.Input[str] tenant_id: The unique ID of the tenant used to scope this API request.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if data is not None:
            pulumi.set(__self__, "data", data)
        if entity_id is not None:
            pulumi.set(__self__, "entity_id", entity_id)
        if entity_type_id is not None:
            pulumi.set(__self__, "entity_type_id", entity_type_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
        be used. Must be a UUID.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_id", value)

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
        generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
        and update you can provide a value and it will be stored.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_secret", value)

    @property
    @pulumi.getter
    def data(self) -> Optional[pulumi.Input[str]]:
        """
        An object that can hold any information about the Entity that should be persisted. Please review
        the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        """
        return pulumi.get(self, "data")

    @data.setter
    def data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data", value)

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "entity_id")

    @entity_id.setter
    def entity_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_id", value)

    @property
    @pulumi.getter(name="entityTypeId")
    def entity_type_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the Entity Type. Types are consulted for permission checks.
        """
        return pulumi.get(self, "entity_type_id")

    @entity_type_id.setter
    def entity_type_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_type_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[str]]:
        """
        The unique ID of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenant_id", value)


class FusionAuthEntity(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 entity_type_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## # Entity Resource

        Entities are arbitrary objects which can be modeled in FusionAuth. Anything which is not a user but might need
        permissions managed by FusionAuth is a possible entity. Examples might include devices, cars, computers, customers,
        companies, etc.

        FusionAuth’s Entity Management has the following major concepts:

        * Entity Types categorize Entities. An Entity Type could be `Device`, `API` or `Company`.
        * Permissions are defined on an Entity Type. These are arbitrary strings which can fit the business domain. A Permission
          could be `read`, `write`, or `file-lawsuit`.
        * Entities are instances of a single type. An Entity could be a `nest device`, an `Email API` or `Raviga`.
        * Entities can have Grants. Grants are relationships between a target Entity and one of two other types: a recipient
          Entity or a User. Grants can have zero or more Permissions associated with them.

        You can use the Client Credentials grant to see if an Entity has permission to access another Entity.

        [Entity API](https://fusionauth.io/docs/v1/tech/apis/entity-management/entities)

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
               be used. Must be a UUID.
        :param pulumi.Input[str] client_secret: The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
               generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
               and update you can provide a value and it will be stored.
        :param pulumi.Input[str] data: An object that can hold any information about the Entity that should be persisted. Please review
               the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        :param pulumi.Input[str] entity_id: The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] entity_type_id: The ID of the Entity Type. Types are consulted for permission checks.
        :param pulumi.Input[str] name: A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        :param pulumi.Input[str] tenant_id: The unique ID of the tenant used to scope this API request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FusionAuthEntityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## # Entity Resource

        Entities are arbitrary objects which can be modeled in FusionAuth. Anything which is not a user but might need
        permissions managed by FusionAuth is a possible entity. Examples might include devices, cars, computers, customers,
        companies, etc.

        FusionAuth’s Entity Management has the following major concepts:

        * Entity Types categorize Entities. An Entity Type could be `Device`, `API` or `Company`.
        * Permissions are defined on an Entity Type. These are arbitrary strings which can fit the business domain. A Permission
          could be `read`, `write`, or `file-lawsuit`.
        * Entities are instances of a single type. An Entity could be a `nest device`, an `Email API` or `Raviga`.
        * Entities can have Grants. Grants are relationships between a target Entity and one of two other types: a recipient
          Entity or a User. Grants can have zero or more Permissions associated with them.

        You can use the Client Credentials grant to see if an Entity has permission to access another Entity.

        [Entity API](https://fusionauth.io/docs/v1/tech/apis/entity-management/entities)

        :param str resource_name: The name of the resource.
        :param FusionAuthEntityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FusionAuthEntityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_id: Optional[pulumi.Input[str]] = None,
                 client_secret: Optional[pulumi.Input[str]] = None,
                 data: Optional[pulumi.Input[str]] = None,
                 entity_id: Optional[pulumi.Input[str]] = None,
                 entity_type_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tenant_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FusionAuthEntityArgs.__new__(FusionAuthEntityArgs)

            __props__.__dict__["client_id"] = client_id
            __props__.__dict__["client_secret"] = client_secret
            __props__.__dict__["data"] = data
            __props__.__dict__["entity_id"] = entity_id
            if entity_type_id is None and not opts.urn:
                raise TypeError("Missing required property 'entity_type_id'")
            __props__.__dict__["entity_type_id"] = entity_type_id
            __props__.__dict__["name"] = name
            __props__.__dict__["tenant_id"] = tenant_id
        super(FusionAuthEntity, __self__).__init__(
            'fusionauth:index/fusionAuthEntity:FusionAuthEntity',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_id: Optional[pulumi.Input[str]] = None,
            client_secret: Optional[pulumi.Input[str]] = None,
            data: Optional[pulumi.Input[str]] = None,
            entity_id: Optional[pulumi.Input[str]] = None,
            entity_type_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            tenant_id: Optional[pulumi.Input[str]] = None) -> 'FusionAuthEntity':
        """
        Get an existing FusionAuthEntity resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_id: The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
               be used. Must be a UUID.
        :param pulumi.Input[str] client_secret: The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
               generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
               and update you can provide a value and it will be stored.
        :param pulumi.Input[str] data: An object that can hold any information about the Entity that should be persisted. Please review
               the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        :param pulumi.Input[str] entity_id: The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        :param pulumi.Input[str] entity_type_id: The ID of the Entity Type. Types are consulted for permission checks.
        :param pulumi.Input[str] name: A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        :param pulumi.Input[str] tenant_id: The unique ID of the tenant used to scope this API request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FusionAuthEntityState.__new__(_FusionAuthEntityState)

        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["data"] = data
        __props__.__dict__["entity_id"] = entity_id
        __props__.__dict__["entity_type_id"] = entity_type_id
        __props__.__dict__["name"] = name
        __props__.__dict__["tenant_id"] = tenant_id
        return FusionAuthEntity(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[str]:
        """
        The OAuth 2.0 client ID. If you leave this blank on create, the value of the Entity ID will
        be used. Must be a UUID.
        """
        return pulumi.get(self, "client_id")

    @property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[str]:
        """
        The OAuth 2.0 client secret. If you leave this blank on create, a secure secret will be
        generated for you. If you leave this blank during an update, the previous value will be maintained. For both create
        and update you can provide a value and it will be stored.
        """
        return pulumi.get(self, "client_secret")

    @property
    @pulumi.getter
    def data(self) -> pulumi.Output[Optional[str]]:
        """
        An object that can hold any information about the Entity that should be persisted. Please review
        the limits on data field types as you plan for and build your custom data schema. Must be a JSON serialised string.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="entityId")
    def entity_id(self) -> pulumi.Output[str]:
        """
        The ID to use for the new Entity. If not specified a secure random UUID will be generated.
        """
        return pulumi.get(self, "entity_id")

    @property
    @pulumi.getter(name="entityTypeId")
    def entity_type_id(self) -> pulumi.Output[str]:
        """
        The ID of the Entity Type. Types are consulted for permission checks.
        """
        return pulumi.get(self, "entity_type_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A descriptive name for the Entity (i.e. "Raviga" or "Email Service").
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[str]]:
        """
        The unique ID of the tenant used to scope this API request.
        """
        return pulumi.get(self, "tenant_id")

