# bestpy
A module to prove your friends (or adversaries) wrong.

Ever needed to decide on what is the best thing out? That's exactly what bestpy does.
We may or may not try to make the answers support your view. Here's a quick demo:

```python
>>> best.language
"python"
>>> best.module
"bestpy"
```

## Installation
This is simple with pip. Just run the following in your command line or terminal (available soon):

```
pip install bestpy
```

You can also use your magic powers to get the module from source code with the following:

```
pip install git+https://github.com/gustavwilliam/bestpy.git@main
``` 
Note: you will likely need to restart your terminal before using the module

## Basic usage
We were kind and made importing it super simple and nice. Just do the following to import bestpy, once the installation is complete:

```python
>>> from bestpy import best
```

Now you'll be ready to take on any of life's greatest challenges, all with the help of bestpy.

Here's how you can find out some hard coded, fundamental laws of the universe:

```py
>>> best.year
1984
>>> best.phone
BlackBerry
```

There are also a few things that may sneakily check your preferences and adjust based on it, like the following.
You'll get your current OS back, since you obviously have a good taste in what OS you use.

```python
>>> best.os
```

There are also a few ones that use randomness to find the truth, like this:

```py
>>> best.name
Guido
>>> best.name
Gustav
```

At the end of the day, I'd recommend just playing around with it and seeing what's available.
We'll be adding a lot of fun categories. If there's something you'd like to see added,
feel free to open an issue or submit a PR. The available categories will expand over time,
thanks to our awesome contributors.

## Final words
Good luck proving what things are actually best. Bestpy is never wrong,
so you now know everything you need to use the single source of truth. 
Feel free to share what you create with bestpy; I can't wait to see what you do.

May the bestpy be with you. The bestpy is strong with this one.
