"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SNS2Telegram = exports.Moderation = exports.ModerationLabels = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const aws_lambda_nodejs_1 = require("@aws-cdk/aws-lambda-nodejs");
const s3 = require("@aws-cdk/aws-s3");
const s3n = require("@aws-cdk/aws-s3-notifications");
const sns = require("@aws-cdk/aws-sns");
const snss = require("@aws-cdk/aws-sns-subscriptions");
const cdk = require("@aws-cdk/core");
/**
 * content moderation labels.
 *
 * @see https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html
 * @stability stable
 */
var ModerationLabels;
(function (ModerationLabels) {
    ModerationLabels["EXPLICIT_NUDITY"] = "Explicit Nudity";
    ModerationLabels["NUDITY"] = "Nudity";
    ModerationLabels["SEXUAL_ACTIVITY"] = "Sexual Activity";
    ModerationLabels["SUGGESTIVE"] = "Suggestive";
    ModerationLabels["PARTIAL_NUDITY"] = "Partial Nudity";
    ModerationLabels["VIOLENCE"] = "Violence";
    ModerationLabels["VISUALLY_DISTURBING"] = "Visually Disturbing";
    ModerationLabels["RUDE_GESTURES"] = "Rude Gestures";
    ModerationLabels["DRUGS"] = "Drugs";
    ModerationLabels["TOBACCO"] = "Tobacco";
    ModerationLabels["ALCOHOL"] = "Alcohol";
    ModerationLabels["GAMBLING"] = "Gambling";
    ModerationLabels["HATE_SYMBOLS"] = "Hate Symbols";
})(ModerationLabels = exports.ModerationLabels || (exports.ModerationLabels = {}));
/**
 * @stability stable
 */
class Moderation extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _c;
        super(scope, id);
        this.bucketOptions = props.bucketOptions;
        this.topic = (_c = props.topic) !== null && _c !== void 0 ? _c : this._createTopic();
        this.handler = new aws_lambda_nodejs_1.NodejsFunction(this, 'Handler', {
            entry: path.join(__dirname, '../lambda/moderation/index.ts'),
            runtime: lambda.Runtime.NODEJS_14_X,
            bundling: {
                define: {
                    'process.env.ONLY_LABELS': props.moderationLabels ?
                        JSON.stringify(props.moderationLabels.map(x => x.valueOf())) : '',
                },
            },
            environment: {
                TOPIC_ARN: this.topic.topicArn,
                PREVIEW_TTL: props.previewTtl ? props.previewTtl.toSeconds().toString() : '10',
            },
        });
        this.topic.grantPublish(this.handler);
        this.handler.addToRolePolicy(new iam.PolicyStatement({
            actions: ['rekognition:DetectModerationLabels'],
            resources: ['*'],
        }));
        this.bucket = this._createBucket();
        this.bucket.grantRead(this.handler);
        new cdk.CfnOutput(this, 'bucket', { value: `s3://${this.bucket.bucketName}` });
    }
    _createBucket() {
        const bucket = new s3.Bucket(this, 'Bucket', this.bucketOptions);
        // bucket.addObjectCreatedNotification(new s3n.SnsDestination(this.topic));
        bucket.addObjectCreatedNotification(new s3n.LambdaDestination(this.handler));
        return bucket;
    }
    _createTopic() {
        return new sns.Topic(this, 'Topic');
    }
}
exports.Moderation = Moderation;
_a = JSII_RTTI_SYMBOL_1;
Moderation[_a] = { fqn: "cdk-image-moderation.Moderation", version: "0.1.50" };
/**
 * forward SNS messages to Telegram chat via Lambda.
 *
 * @stability stable
 */
class SNS2Telegram extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _c;
        super(scope, id);
        const telegramToken = process.env.TELEGRAM_TOKEN || this.node.tryGetContext('TELEGRAM_TOKEN');
        if (!telegramToken) {
            throw new Error('missing TELEGRAM_TOKEN in env var or context variable');
        }
        const fn = new aws_lambda_nodejs_1.NodejsFunction(this, 'SNS2TG', {
            entry: path.join(__dirname, '../lambda/sns2telegram/index.ts'),
            runtime: lambda.Runtime.NODEJS_14_X,
            environment: {
                TELEGRAM_TOKEN: telegramToken,
                TELEGRAM_CHAT_ID: props.chatid,
            },
        });
        const topic = (_c = props.topic) !== null && _c !== void 0 ? _c : this._createTopic();
        topic.addSubscription(new snss.LambdaSubscription(fn));
    }
    _createTopic() {
        return new sns.Topic(this, 'Topic', {
            fifo: true,
        });
    }
}
exports.SNS2Telegram = SNS2Telegram;
_b = JSII_RTTI_SYMBOL_1;
SNS2Telegram[_b] = { fqn: "cdk-image-moderation.SNS2Telegram", version: "0.1.50" };
//# sourceMappingURL=data:application/json;base64,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