# Generated by Django 3.0.5 on 2020-05-04 12:01

from django.db import migrations, models

import aleksis.core.mixins


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Absence",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("absence_id", models.IntegerField(db_column="ABSENCE_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "typea",
                    models.SmallIntegerField(blank=True, db_column="TypeA", null=True),
                ),
                ("ida", models.IntegerField(blank=True, db_column="IDA", null=True)),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "absence_reason_id",
                    models.IntegerField(
                        blank=True, db_column="ABSENCE_REASON_ID", null=True
                    ),
                ),
                (
                    "lessonfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonFrom", null=True
                    ),
                ),
                (
                    "lessonto",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonTo", null=True
                    ),
                ),
                (
                    "transfer_id",
                    models.IntegerField(blank=True, db_column="TRANSFER_ID", null=True),
                ),
                (
                    "event_id",
                    models.IntegerField(blank=True, db_column="EVENT_ID", null=True),
                ),
                (
                    "valuededuction",
                    models.IntegerField(
                        blank=True, db_column="ValueDeduction", null=True
                    ),
                ),
                (
                    "prebookingnr",
                    models.IntegerField(
                        blank=True, db_column="PrebookingNr", null=True
                    ),
                ),
                (
                    "timefrom",
                    models.IntegerField(blank=True, db_column="TimeFrom", null=True),
                ),
                (
                    "timeto",
                    models.IntegerField(blank=True, db_column="TimeTo", null=True),
                ),
            ],
            options={"db_table": "Absence", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Absencereason",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                (
                    "absence_reason_id",
                    models.IntegerField(db_column="ABSENCE_REASON_ID"),
                ),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
            ],
            options={"db_table": "AbsenceReason", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Adminlesson",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("ls_id", models.IntegerField(db_column="LS_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "startdate",
                    models.IntegerField(blank=True, db_column="StartDate", null=True),
                ),
                (
                    "enddate",
                    models.IntegerField(blank=True, db_column="EndDate", null=True),
                ),
                (
                    "subjectid",
                    models.IntegerField(blank=True, db_column="SubjectId", null=True),
                ),
                (
                    "studentgroupid",
                    models.IntegerField(
                        blank=True, db_column="StudentGroupId", null=True
                    ),
                ),
                (
                    "classids",
                    models.CharField(
                        blank=True, db_column="ClassIds", max_length=600, null=True
                    ),
                ),
                (
                    "teacherassignments",
                    models.TextField(
                        blank=True, db_column="TeacherAssignments", null=True
                    ),
                ),
            ],
            options={"db_table": "AdminLesson", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Alias",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("type", models.SmallIntegerField(db_column="Type")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                ("alias_id", models.IntegerField(db_column="ALIAS_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "elementids",
                    models.CharField(
                        blank=True, db_column="ElementIds", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "Alias", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Calendar",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("date", models.IntegerField(db_column="Date")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=150, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "absence_reason_id",
                    models.IntegerField(
                        blank=True, db_column="ABSENCE_REASON_ID", null=True
                    ),
                ),
                (
                    "note",
                    models.CharField(
                        blank=True, db_column="Note", max_length=150, null=True
                    ),
                ),
                (
                    "freelessons",
                    models.CharField(
                        blank=True, db_column="FreeLessons", max_length=255, null=True
                    ),
                ),
                (
                    "daytext",
                    models.CharField(
                        blank=True, db_column="DayText", max_length=2000, null=True
                    ),
                ),
                (
                    "elementids",
                    models.CharField(
                        blank=True, db_column="ElementIds", max_length=2000, null=True
                    ),
                ),
                (
                    "textguid",
                    models.CharField(
                        blank=True, db_column="TextGuid", max_length=2000, null=True
                    ),
                ),
                (
                    "additionaldays",
                    models.CharField(
                        blank=True,
                        db_column="AdditionalDays",
                        max_length=255,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "Calendar", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Class",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("class_id", models.IntegerField(db_column="CLASS_ID")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "statisticcodes2",
                    models.CharField(
                        blank=True,
                        db_column="StatisticCodes2",
                        max_length=10,
                        null=True,
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timerequest",
                    models.CharField(
                        blank=True, db_column="TimeRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timerequestminut",
                    models.CharField(
                        blank=True,
                        db_column="TimeRequestMinut",
                        max_length=400,
                        null=True,
                    ),
                ),
                (
                    "dayrequest",
                    models.CharField(
                        blank=True, db_column="DayRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timerequestunspecified",
                    models.CharField(
                        blank=True,
                        db_column="TimeRequestUnspecified",
                        max_length=400,
                        null=True,
                    ),
                ),
                (
                    "selmatrix",
                    models.CharField(
                        blank=True, db_column="SelMatrix", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "room_id",
                    models.IntegerField(blank=True, db_column="ROOM_ID", null=True),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "oldname",
                    models.CharField(
                        blank=True, db_column="OldName", max_length=60, null=True
                    ),
                ),
                (
                    "minutbreakmin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreakMin", null=True
                    ),
                ),
                (
                    "lunchbreakmin",
                    models.SmallIntegerField(
                        blank=True, db_column="LunchBreakMin", null=True
                    ),
                ),
                (
                    "lunchbreakmax",
                    models.SmallIntegerField(
                        blank=True, db_column="LunchBreakMax", null=True
                    ),
                ),
                (
                    "lssnperdaymin",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnPerDayMin", null=True
                    ),
                ),
                (
                    "lssnperdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnPerDayMax", null=True
                    ),
                ),
                (
                    "minutminutesperdaymin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutMinutesPerDayMin", null=True
                    ),
                ),
                (
                    "minutminutesperdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutMinutesPerDayMax", null=True
                    ),
                ),
                (
                    "minutlunchbreakperdaymin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLunchBreakPerDayMin", null=True
                    ),
                ),
                (
                    "minutlunchbreakperdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLunchBreakPerDayMax", null=True
                    ),
                ),
                (
                    "blocksnodays",
                    models.SmallIntegerField(
                        blank=True, db_column="BlocksNoDays", null=True
                    ),
                ),
                (
                    "blockslssnfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="BlocksLssnFrom", null=True
                    ),
                ),
                (
                    "blockslssnto",
                    models.SmallIntegerField(
                        blank=True, db_column="BlocksLssnTo", null=True
                    ),
                ),
                (
                    "weekquotamin",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekQuotaMin", null=True
                    ),
                ),
                (
                    "weekquotamax",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekQuotaMax", null=True
                    ),
                ),
                (
                    "weekquotaideal",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekQuotaIdeal", null=True
                    ),
                ),
                (
                    "nameyearbefore",
                    models.CharField(
                        blank=True, db_column="NameYearBefore", max_length=20, null=True
                    ),
                ),
                (
                    "periods_table_id",
                    models.IntegerField(
                        blank=True, db_column="PERIODS_TABLE_ID", null=True
                    ),
                ),
                (
                    "mainclass",
                    models.CharField(
                        blank=True, db_column="MainClass", max_length=255, null=True
                    ),
                ),
                (
                    "teacherids",
                    models.CharField(
                        blank=True, db_column="TeacherIds", max_length=50, null=True
                    ),
                ),
                (
                    "teacher_id",
                    models.IntegerField(blank=True, db_column="TEACHER_ID", null=True),
                ),
                (
                    "department_id",
                    models.IntegerField(
                        blank=True, db_column="DEPARTMENT_ID", null=True
                    ),
                ),
                (
                    "ownschool",
                    models.CharField(
                        blank=True, db_column="OwnSchool", max_length=20, null=True
                    ),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "msubjsuccmax",
                    models.SmallIntegerField(
                        blank=True, db_column="MSubjSuccMax", null=True
                    ),
                ),
                (
                    "msubjdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="MSubjDayMax", null=True
                    ),
                ),
                (
                    "classgroup",
                    models.CharField(
                        blank=True, db_column="ClassGroup", max_length=1, null=True
                    ),
                ),
                (
                    "classlevel",
                    models.CharField(
                        blank=True, db_column="ClassLevel", max_length=50, null=True
                    ),
                ),
                (
                    "nostudentmale",
                    models.SmallIntegerField(
                        blank=True, db_column="NoStudentMale", null=True
                    ),
                ),
                (
                    "nostudentfemale",
                    models.SmallIntegerField(
                        blank=True, db_column="NoStudentFemale", null=True
                    ),
                ),
                (
                    "minutmsubjdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutMSubjDayMax", null=True
                    ),
                ),
                (
                    "minutbreakmax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreakMax", null=True
                    ),
                ),
                (
                    "notlastperiod",
                    models.CharField(
                        blank=True, db_column="NotLastPeriod", max_length=255, null=True
                    ),
                ),
                (
                    "doubleorsingle",
                    models.CharField(
                        blank=True,
                        db_column="DoubleOrSingle",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "substplgrid",
                    models.CharField(
                        blank=True, db_column="SubstPlGrid", max_length=1000, null=True
                    ),
                ),
                (
                    "nrtimegrid",
                    models.SmallIntegerField(
                        blank=True, db_column="NrTimeGrid", null=True
                    ),
                ),
                (
                    "difflessonmax",
                    models.SmallIntegerField(
                        blank=True, db_column="DiffLessonMax", null=True
                    ),
                ),
                (
                    "text1",
                    models.CharField(
                        blank=True, db_column="Text1", max_length=100, null=True
                    ),
                ),
                (
                    "text2",
                    models.CharField(
                        blank=True, db_column="Text2", max_length=100, null=True
                    ),
                ),
                (
                    "plannedyear",
                    models.IntegerField(blank=True, db_column="PlannedYear", null=True),
                ),
                (
                    "externname",
                    models.CharField(
                        blank=True, db_column="ExternName", max_length=60, null=True
                    ),
                ),
                (
                    "weeklytargetclasses",
                    models.IntegerField(
                        blank=True, db_column="WeeklyTargetClasses", null=True
                    ),
                ),
            ],
            options={"db_table": "Class", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Commondata",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("id", models.SmallIntegerField(db_column="ID")),
                ("owner", models.SmallIntegerField(db_column="Owner")),
                ("number", models.SmallIntegerField(db_column="Number")),
                ("number1", models.SmallIntegerField(db_column="Number1")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "fieldbool1",
                    models.IntegerField(blank=True, db_column="FieldBool1", null=True),
                ),
                (
                    "fieldbool2",
                    models.IntegerField(blank=True, db_column="FieldBool2", null=True),
                ),
                (
                    "fieldbool3",
                    models.IntegerField(blank=True, db_column="FieldBool3", null=True),
                ),
                (
                    "fieldbool4",
                    models.IntegerField(blank=True, db_column="FieldBool4", null=True),
                ),
                (
                    "fieldbool5",
                    models.IntegerField(blank=True, db_column="FieldBool5", null=True),
                ),
                (
                    "fieldbool6",
                    models.IntegerField(blank=True, db_column="FieldBool6", null=True),
                ),
                (
                    "fieldbool7",
                    models.IntegerField(blank=True, db_column="FieldBool7", null=True),
                ),
                (
                    "fieldbool8",
                    models.IntegerField(blank=True, db_column="FieldBool8", null=True),
                ),
                (
                    "fieldbyte1",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte1", null=True
                    ),
                ),
                (
                    "fieldbyte2",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte2", null=True
                    ),
                ),
                (
                    "fieldbyte3",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte3", null=True
                    ),
                ),
                (
                    "fieldbyte4",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte4", null=True
                    ),
                ),
                (
                    "fieldbyte5",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte5", null=True
                    ),
                ),
                (
                    "fieldbyte6",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte6", null=True
                    ),
                ),
                (
                    "fieldbyte7",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte7", null=True
                    ),
                ),
                (
                    "fieldbyte8",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldByte8", null=True
                    ),
                ),
                (
                    "fieldint1",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt1", null=True
                    ),
                ),
                (
                    "fieldint2",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt2", null=True
                    ),
                ),
                (
                    "fieldint3",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt3", null=True
                    ),
                ),
                (
                    "fieldint4",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt4", null=True
                    ),
                ),
                (
                    "fieldint5",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt5", null=True
                    ),
                ),
                (
                    "fieldint6",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt6", null=True
                    ),
                ),
                (
                    "fieldint7",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt7", null=True
                    ),
                ),
                (
                    "fieldint8",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt8", null=True
                    ),
                ),
                (
                    "fieldlong1",
                    models.IntegerField(blank=True, db_column="FieldLong1", null=True),
                ),
                (
                    "fieldlong2",
                    models.IntegerField(blank=True, db_column="FieldLong2", null=True),
                ),
                (
                    "fieldlong3",
                    models.IntegerField(blank=True, db_column="FieldLong3", null=True),
                ),
                (
                    "fieldlong4",
                    models.IntegerField(blank=True, db_column="FieldLong4", null=True),
                ),
                (
                    "fieldtext10a",
                    models.CharField(
                        blank=True, db_column="FieldText10A", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext10b",
                    models.CharField(
                        blank=True, db_column="FieldText10B", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext10c",
                    models.CharField(
                        blank=True, db_column="FieldText10C", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext10d",
                    models.CharField(
                        blank=True, db_column="FieldText10D", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext20a",
                    models.CharField(
                        blank=True, db_column="FieldText20A", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext20b",
                    models.CharField(
                        blank=True, db_column="FieldText20B", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext20c",
                    models.CharField(
                        blank=True, db_column="FieldText20C", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext20d",
                    models.CharField(
                        blank=True, db_column="FieldText20D", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext50a",
                    models.CharField(
                        blank=True, db_column="FieldText50A", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext50b",
                    models.CharField(
                        blank=True, db_column="FieldText50B", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext50c",
                    models.CharField(
                        blank=True, db_column="FieldText50C", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext50d",
                    models.CharField(
                        blank=True, db_column="FieldText50D", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext100a",
                    models.CharField(
                        blank=True, db_column="FieldText100A", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext100b",
                    models.CharField(
                        blank=True, db_column="FieldText100B", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext100c",
                    models.CharField(
                        blank=True, db_column="FieldText100C", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext100d",
                    models.CharField(
                        blank=True, db_column="FieldText100D", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtextlonga",
                    models.CharField(
                        blank=True,
                        db_column="FieldTextLongA",
                        max_length=1000,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "CommonData", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Corridor",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("corridor_id", models.IntegerField(db_column="CORRIDOR_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "dislocation",
                    models.CharField(
                        blank=True, db_column="Dislocation", max_length=1, null=True
                    ),
                ),
                (
                    "breaksupervision1",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision1",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision2",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision2",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision3",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision3",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision4",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision4",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision5",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision5",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision6",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision6",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision7",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision7",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision8",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision8",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision9",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision9",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision10",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision10",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision11",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision11",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision12",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision12",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision13",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision13",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision14",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision14",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision15",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision15",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "breaksupervision16",
                    models.CharField(
                        blank=True,
                        db_column="BreakSupervision16",
                        max_length=1000,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "Corridor", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Countvalue",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("count_value_id", models.IntegerField(db_column="COUNT_VALUE_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "lesson_id",
                    models.IntegerField(blank=True, db_column="LESSON_ID", null=True),
                ),
                (
                    "value",
                    models.IntegerField(blank=True, db_column="Value", null=True),
                ),
                (
                    "cv_reason_id",
                    models.IntegerField(
                        blank=True, db_column="CV_REASON_ID", null=True
                    ),
                ),
                (
                    "teacher_id",
                    models.IntegerField(blank=True, db_column="TEACHER_ID", null=True),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "valueyear",
                    models.IntegerField(blank=True, db_column="ValueYear", null=True),
                ),
                (
                    "percentvalue",
                    models.SmallIntegerField(
                        blank=True, db_column="PercentValue", null=True
                    ),
                ),
                (
                    "percentbase",
                    models.CharField(
                        blank=True, db_column="PercentBase", max_length=1, null=True
                    ),
                ),
                (
                    "valueweekminut",
                    models.IntegerField(
                        blank=True, db_column="ValueWeekMinut", null=True
                    ),
                ),
                (
                    "valueyearminut",
                    models.IntegerField(
                        blank=True, db_column="ValueYearMinut", null=True
                    ),
                ),
            ],
            options={"db_table": "CountValue", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Couplcond",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("coupl_cond_id", models.IntegerField(db_column="COUPL_COND_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "conflict_coupl_cond_id",
                    models.IntegerField(
                        blank=True, db_column="Conflict_COUPL_COND_ID", null=True
                    ),
                ),
                (
                    "maxcourses",
                    models.SmallIntegerField(
                        blank=True, db_column="MaxCourses", null=True
                    ),
                ),
                (
                    "lessonids",
                    models.CharField(
                        blank=True, db_column="LessonIds", max_length=255, null=True
                    ),
                ),
                (
                    "subjectids",
                    models.CharField(
                        blank=True, db_column="SubjectIds", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "CouplCond", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="CvReason",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("cv_reason_id", models.IntegerField(db_column="CV_REASON_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
            ],
            options={"db_table": "CV_Reason", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Department",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("department_id", models.IntegerField(db_column="DEPARTMENT_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
            ],
            options={"db_table": "Department", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Description",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("description_id", models.IntegerField(db_column="DESCRIPTION_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
            ],
            options={"db_table": "Description", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("event_id", models.IntegerField(db_column="EVENT_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "absence_reason_id",
                    models.IntegerField(
                        blank=True, db_column="ABSENCE_REASON_ID", null=True
                    ),
                ),
                (
                    "lessonfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonFrom", null=True
                    ),
                ),
                (
                    "lessonto",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonTo", null=True
                    ),
                ),
                (
                    "eventelement1",
                    models.CharField(
                        blank=True,
                        db_column="EventElement1",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement2",
                    models.CharField(
                        blank=True,
                        db_column="EventElement2",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement3",
                    models.CharField(
                        blank=True,
                        db_column="EventElement3",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement4",
                    models.CharField(
                        blank=True,
                        db_column="EventElement4",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement5",
                    models.CharField(
                        blank=True,
                        db_column="EventElement5",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement6",
                    models.CharField(
                        blank=True,
                        db_column="EventElement6",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement7",
                    models.CharField(
                        blank=True,
                        db_column="EventElement7",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement8",
                    models.CharField(
                        blank=True,
                        db_column="EventElement8",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement9",
                    models.CharField(
                        blank=True,
                        db_column="EventElement9",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "eventelement10",
                    models.CharField(
                        blank=True,
                        db_column="EventElement10",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "subject_id",
                    models.IntegerField(blank=True, db_column="SUBJECT_ID", null=True),
                ),
                (
                    "timefrom",
                    models.IntegerField(blank=True, db_column="TimeFrom", null=True),
                ),
                (
                    "timeto",
                    models.IntegerField(blank=True, db_column="TimeTo", null=True),
                ),
                (
                    "studentgroup",
                    models.CharField(
                        blank=True, db_column="StudentGroup", max_length=100, null=True
                    ),
                ),
                (
                    "studentgroup_id",
                    models.IntegerField(
                        blank=True, db_column="STUDENTGROUP_ID", null=True
                    ),
                ),
            ],
            options={"db_table": "Event", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Exam",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("exam_id", models.IntegerField(db_column="EXAM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "lessonfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonFrom", null=True
                    ),
                ),
                (
                    "lessonto",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonTo", null=True
                    ),
                ),
                (
                    "examelement1",
                    models.CharField(
                        blank=True, db_column="ExamElement1", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement2",
                    models.CharField(
                        blank=True, db_column="ExamElement2", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement3",
                    models.CharField(
                        blank=True, db_column="ExamElement3", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement4",
                    models.CharField(
                        blank=True, db_column="ExamElement4", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement5",
                    models.CharField(
                        blank=True, db_column="ExamElement5", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement6",
                    models.CharField(
                        blank=True, db_column="ExamElement6", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement7",
                    models.CharField(
                        blank=True, db_column="ExamElement7", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement8",
                    models.CharField(
                        blank=True, db_column="ExamElement8", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement9",
                    models.CharField(
                        blank=True, db_column="ExamElement9", max_length=1000, null=True
                    ),
                ),
                (
                    "examelement10",
                    models.CharField(
                        blank=True,
                        db_column="ExamElement10",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "substactive",
                    models.IntegerField(blank=True, db_column="SubstActive", null=True),
                ),
                (
                    "noprintperiods",
                    models.CharField(
                        blank=True,
                        db_column="NoPrintPeriods",
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "contrarytoabsence",
                    models.CharField(
                        blank=True,
                        db_column="ContraryToAbsence",
                        max_length=150,
                        null=True,
                    ),
                ),
                (
                    "messagesent",
                    models.CharField(
                        blank=True, db_column="MessageSent", max_length=150, null=True
                    ),
                ),
                (
                    "examperiodtexts",
                    models.CharField(
                        blank=True,
                        db_column="ExamPeriodTexts",
                        max_length=2000,
                        null=True,
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
            ],
            options={"db_table": "Exam", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Externelement",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("exel_id", models.IntegerField(db_column="EXEL_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "elementtype",
                    models.SmallIntegerField(
                        blank=True, db_column="ElementType", null=True
                    ),
                ),
                (
                    "ownerschool",
                    models.IntegerField(blank=True, db_column="OwnerSchool", null=True),
                ),
                (
                    "allowedschools",
                    models.CharField(
                        blank=True,
                        db_column="AllowedSchools",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "lastchangedbyschool",
                    models.IntegerField(
                        blank=True, db_column="LastChangedBySchool", null=True
                    ),
                ),
            ],
            options={"db_table": "ExternElement", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Externindex",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("number", models.SmallIntegerField(db_column="Number")),
                ("exel_id", models.IntegerField(db_column="EXEL_ID")),
                ("school_id1", models.IntegerField(db_column="SCHOOL_ID1")),
                ("year", models.SmallIntegerField(db_column="Year")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
            ],
            options={"db_table": "ExternIndex", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Externtime",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("number", models.IntegerField(db_column="Number")),
                ("exel_id", models.IntegerField(db_column="EXEL_ID")),
                ("school_id1", models.IntegerField(db_column="SCHOOL_ID1")),
                ("year", models.SmallIntegerField(db_column="Year")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "weekday",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekDay", null=True
                    ),
                ),
                (
                    "timefrom",
                    models.SmallIntegerField(
                        blank=True, db_column="TimeFrom", null=True
                    ),
                ),
                (
                    "timeto",
                    models.SmallIntegerField(blank=True, db_column="TimeTo", null=True),
                ),
                (
                    "weeks",
                    models.CharField(
                        blank=True, db_column="Weeks", max_length=255, null=True
                    ),
                ),
                (
                    "elements",
                    models.CharField(
                        blank=True, db_column="Elements", max_length=1000, null=True
                    ),
                ),
            ],
            options={"db_table": "ExternTime", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Glaettung",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("number", models.SmallIntegerField(db_column="Number")),
                ("teacher_id", models.IntegerField(db_column="TEACHER_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "weekfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekFrom", null=True
                    ),
                ),
                (
                    "weekto",
                    models.SmallIntegerField(blank=True, db_column="WeekTo", null=True),
                ),
                (
                    "glaettung",
                    models.IntegerField(blank=True, db_column="Glaettung", null=True),
                ),
            ],
            options={"db_table": "Glaettung", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="GlobalPermissions",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "permissions": (
                    ("assign_subjects_to_groups", "Can assign subjects to groups"),
                ),
                "managed": False,
            },
        ),
        migrations.CreateModel(
            name="Holiday",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("holiday_id", models.IntegerField(db_column="HOLIDAY_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "nextweek",
                    models.SmallIntegerField(
                        blank=True, db_column="NextWeek", null=True
                    ),
                ),
                (
                    "nextschoolweek",
                    models.SmallIntegerField(
                        blank=True, db_column="NextSchoolWeek", null=True
                    ),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
            ],
            options={"db_table": "Holiday", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Inputformat",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("input_format_id", models.IntegerField(db_column="INPUT_FORMAT_ID")),
                ("owner", models.SmallIntegerField(db_column="Owner")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "window",
                    models.CharField(
                        blank=True, db_column="Window", max_length=255, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "miscdata",
                    models.CharField(
                        blank=True, db_column="MiscData", max_length=255, null=True
                    ),
                ),
                (
                    "picturedata1",
                    models.CharField(
                        blank=True, db_column="PictureData1", max_length=100, null=True
                    ),
                ),
                (
                    "picturedata2",
                    models.CharField(
                        blank=True, db_column="PictureData2", max_length=100, null=True
                    ),
                ),
                (
                    "font",
                    models.CharField(
                        blank=True, db_column="Font", max_length=120, null=True
                    ),
                ),
                (
                    "printer",
                    models.CharField(
                        blank=True, db_column="Printer", max_length=60, null=True
                    ),
                ),
                (
                    "printfont",
                    models.CharField(
                        blank=True, db_column="PrintFont", max_length=120, null=True
                    ),
                ),
                (
                    "actualelement_id2",
                    models.IntegerField(
                        blank=True, db_column="ActualELEMENT_ID2", null=True
                    ),
                ),
                (
                    "headerfields",
                    models.CharField(
                        blank=True, db_column="HeaderFields", max_length=100, null=True
                    ),
                ),
                (
                    "type2",
                    models.SmallIntegerField(blank=True, db_column="Type2", null=True),
                ),
                (
                    "columnsstr",
                    models.CharField(
                        blank=True, db_column="ColumnsStr", max_length=255, null=True
                    ),
                ),
                (
                    "columnsactivestr",
                    models.CharField(
                        blank=True,
                        db_column="ColumnsActiveStr",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "colwidthsstr",
                    models.CharField(
                        blank=True, db_column="ColWidthsStr", max_length=255, null=True
                    ),
                ),
                (
                    "layouthaeder",
                    models.SmallIntegerField(
                        blank=True, db_column="LayoutHaeder", null=True
                    ),
                ),
                (
                    "colsfixed",
                    models.SmallIntegerField(
                        blank=True, db_column="ColsFixed", null=True
                    ),
                ),
                (
                    "nocol",
                    models.SmallIntegerField(blank=True, db_column="NoCol", null=True),
                ),
                (
                    "colwidth",
                    models.SmallIntegerField(
                        blank=True, db_column="ColWidth", null=True
                    ),
                ),
                (
                    "nocolteacher",
                    models.SmallIntegerField(
                        blank=True, db_column="NoColTeacher", null=True
                    ),
                ),
                (
                    "typex",
                    models.CharField(
                        blank=True, db_column="TypeX", max_length=1, null=True
                    ),
                ),
                (
                    "field1",
                    models.CharField(
                        blank=True, db_column="Field1", max_length=1000, null=True
                    ),
                ),
                (
                    "field2",
                    models.CharField(
                        blank=True, db_column="Field2", max_length=1000, null=True
                    ),
                ),
                (
                    "field3",
                    models.CharField(
                        blank=True, db_column="Field3", max_length=1000, null=True
                    ),
                ),
                (
                    "field4",
                    models.CharField(
                        blank=True, db_column="Field4", max_length=1000, null=True
                    ),
                ),
                (
                    "field5",
                    models.CharField(
                        blank=True, db_column="Field5", max_length=1000, null=True
                    ),
                ),
                (
                    "field6",
                    models.CharField(
                        blank=True, db_column="Field6", max_length=1000, null=True
                    ),
                ),
                (
                    "field7",
                    models.CharField(
                        blank=True, db_column="Field7", max_length=1000, null=True
                    ),
                ),
                (
                    "field8",
                    models.CharField(
                        blank=True, db_column="Field8", max_length=1000, null=True
                    ),
                ),
                (
                    "field9",
                    models.CharField(
                        blank=True, db_column="Field9", max_length=1000, null=True
                    ),
                ),
                (
                    "field10",
                    models.CharField(
                        blank=True, db_column="Field10", max_length=1000, null=True
                    ),
                ),
                (
                    "flags1",
                    models.CharField(
                        blank=True, db_column="Flags1", max_length=100, null=True
                    ),
                ),
            ],
            options={"db_table": "InputFormat", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Lesson",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("lesson_id", models.IntegerField(db_column="LESSON_ID")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=200, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "timerequest",
                    models.CharField(
                        blank=True, db_column="TimeRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "miscdata",
                    models.CharField(
                        blank=True, db_column="MiscData", max_length=255, null=True
                    ),
                ),
                (
                    "sortidfinper",
                    models.SmallIntegerField(
                        blank=True, db_column="SortIdFinPer", null=True
                    ),
                ),
                (
                    "lessonnr",
                    models.IntegerField(blank=True, db_column="LessonNr", null=True),
                ),
                (
                    "periods",
                    models.IntegerField(blank=True, db_column="Periods", null=True),
                ),
                (
                    "doublemin",
                    models.IntegerField(blank=True, db_column="DoubleMin", null=True),
                ),
                (
                    "doublemax",
                    models.IntegerField(blank=True, db_column="DoubleMax", null=True),
                ),
                (
                    "periodsroom",
                    models.IntegerField(blank=True, db_column="PeriodsRoom", null=True),
                ),
                (
                    "periodsroommax",
                    models.IntegerField(
                        blank=True, db_column="PeriodsRoomMax", null=True
                    ),
                ),
                (
                    "priority",
                    models.SmallIntegerField(
                        blank=True, db_column="Priority", null=True
                    ),
                ),
                (
                    "plannedyear",
                    models.SmallIntegerField(
                        blank=True, db_column="PlannedYear", null=True
                    ),
                ),
                (
                    "subjectseqcla",
                    models.CharField(
                        blank=True, db_column="SubjectSeqCla", max_length=1, null=True
                    ),
                ),
                (
                    "subjectseqtea",
                    models.CharField(
                        blank=True, db_column="SubjectSeqTea", max_length=1, null=True
                    ),
                ),
                (
                    "classcollision",
                    models.CharField(
                        blank=True, db_column="ClassCollision", max_length=1, null=True
                    ),
                ),
                (
                    "optflag",
                    models.CharField(
                        blank=True, db_column="OptFlag", max_length=1, null=True
                    ),
                ),
                (
                    "lesngroups",
                    models.CharField(
                        blank=True, db_column="LesnGroups", max_length=255, null=True
                    ),
                ),
                (
                    "lessonelement1",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement1",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement2",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement2",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement3",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement3",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement4",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement4",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement5",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement5",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement6",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement6",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement7",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement7",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement8",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement8",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement9",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement9",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lessonelement10",
                    models.CharField(
                        blank=True,
                        db_column="LessonElement10",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "lesson_tt",
                    models.TextField(blank=True, db_column="Lesson_TT", null=True),
                ),
                (
                    "lesson_ttminut",
                    models.TextField(blank=True, db_column="Lesson_TTMinut", null=True),
                ),
                (
                    "plannedweekminut",
                    models.SmallIntegerField(
                        blank=True, db_column="PlannedWeekMinut", null=True
                    ),
                ),
                (
                    "plannedyearminut",
                    models.IntegerField(
                        blank=True, db_column="PlannedYearMinut", null=True
                    ),
                ),
                (
                    "lesson_group_id",
                    models.IntegerField(
                        blank=True, db_column="LESSON_GROUP_ID", null=True
                    ),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "reasonnotplanned",
                    models.SmallIntegerField(
                        blank=True, db_column="ReasonNotPlanned", null=True
                    ),
                ),
                (
                    "timenotplanned",
                    models.SmallIntegerField(
                        blank=True, db_column="TimeNotPlanned", null=True
                    ),
                ),
                (
                    "block1",
                    models.SmallIntegerField(blank=True, db_column="Block1", null=True),
                ),
                (
                    "block2",
                    models.SmallIntegerField(blank=True, db_column="Block2", null=True),
                ),
                (
                    "block3",
                    models.SmallIntegerField(blank=True, db_column="Block3", null=True),
                ),
                (
                    "block4",
                    models.SmallIntegerField(blank=True, db_column="Block4", null=True),
                ),
                (
                    "block5",
                    models.SmallIntegerField(blank=True, db_column="Block5", null=True),
                ),
                (
                    "nostudentmin",
                    models.SmallIntegerField(
                        blank=True, db_column="NoStudentMin", null=True
                    ),
                ),
                (
                    "nostudentmax",
                    models.SmallIntegerField(
                        blank=True, db_column="NoStudentMax", null=True
                    ),
                ),
                (
                    "ypperperiod1",
                    models.CharField(
                        blank=True, db_column="YPPerPeriod1", max_length=255, null=True
                    ),
                ),
                (
                    "ypperperiod2",
                    models.CharField(
                        blank=True, db_column="YPPerPeriod2", max_length=255, null=True
                    ),
                ),
                (
                    "intensiveterm",
                    models.CharField(
                        blank=True, db_column="IntensiveTerm", max_length=255, null=True
                    ),
                ),
                (
                    "partnos",
                    models.CharField(
                        blank=True, db_column="PartNos", max_length=255, null=True
                    ),
                ),
                (
                    "blockn",
                    models.CharField(
                        blank=True, db_column="BlockN", max_length=200, null=True
                    ),
                ),
                (
                    "isyearperiods",
                    models.SmallIntegerField(
                        blank=True, db_column="IsYearPeriods", null=True
                    ),
                ),
            ],
            options={"db_table": "Lesson", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Lessongroup",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("lesson_group_id", models.IntegerField(db_column="LESSON_GROUP_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "room_id",
                    models.IntegerField(blank=True, db_column="ROOM_ID", null=True),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                ("week", models.IntegerField(blank=True, db_column="Week", null=True)),
                (
                    "inrerruptionsfrom",
                    models.CharField(
                        blank=True,
                        db_column="InrerruptionsFrom",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "inrerruptionsto",
                    models.CharField(
                        blank=True,
                        db_column="InrerruptionsTo",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "interruptionsfrom1",
                    models.CharField(
                        blank=True,
                        db_column="InterruptionsFrom1",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "interruptionsto1",
                    models.CharField(
                        blank=True,
                        db_column="InterruptionsTo1",
                        max_length=1000,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "LessonGroup", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Lessonsequence",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("type", models.SmallIntegerField(db_column="Type")),
                (
                    "lesson_sequence_id",
                    models.IntegerField(db_column="LESSON_SEQUENCE_ID"),
                ),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "periods",
                    models.IntegerField(blank=True, db_column="Periods", null=True),
                ),
                (
                    "doubleperiods",
                    models.IntegerField(
                        blank=True, db_column="DoublePeriods", null=True
                    ),
                ),
                (
                    "lessonids",
                    models.CharField(
                        blank=True, db_column="LessonIds", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "LessonSequence", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Lessonstack",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("user_id", models.SmallIntegerField(db_column="USER_ID")),
                ("stack_id", models.IntegerField(db_column="STACK_ID")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                ("typestack", models.SmallIntegerField(db_column="TypeStack")),
                ("typeelement", models.SmallIntegerField(db_column="TypeElement")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "coordinates",
                    models.CharField(
                        blank=True, db_column="Coordinates", max_length=2000, null=True
                    ),
                ),
            ],
            options={"db_table": "LessonStack", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Periodstable",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("periods_table_id", models.IntegerField(db_column="PERIODS_TABLE_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "pertabelement1",
                    models.CharField(
                        blank=True,
                        db_column="PerTabElement1",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "pertabelement2",
                    models.CharField(
                        blank=True,
                        db_column="PerTabElement2",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "pertabelement3",
                    models.CharField(
                        blank=True,
                        db_column="PerTabElement3",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "pertabelement4",
                    models.CharField(
                        blank=True,
                        db_column="PerTabElement4",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "pertabelement5",
                    models.CharField(
                        blank=True,
                        db_column="PerTabElement5",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "pertabelement6",
                    models.CharField(
                        blank=True,
                        db_column="PerTabElement6",
                        max_length=1000,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "PeriodsTable", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Prebooking",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("prebooking_id", models.IntegerField(db_column="PREBOOKING_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "room_id",
                    models.IntegerField(blank=True, db_column="ROOM_ID", null=True),
                ),
                (
                    "periods",
                    models.SmallIntegerField(
                        blank=True, db_column="Periods", null=True
                    ),
                ),
                (
                    "teacher_id",
                    models.IntegerField(blank=True, db_column="TEACHER_ID", null=True),
                ),
                (
                    "subject_id",
                    models.IntegerField(blank=True, db_column="SUBJECT_ID", null=True),
                ),
                (
                    "lesson_id",
                    models.IntegerField(blank=True, db_column="LESSON_ID", null=True),
                ),
                (
                    "substitution_id",
                    models.IntegerField(
                        blank=True, db_column="SUBSTITUTION_ID", null=True
                    ),
                ),
                (
                    "classids",
                    models.CharField(
                        blank=True, db_column="ClassIds", max_length=1000, null=True
                    ),
                ),
                (
                    "studentids",
                    models.CharField(
                        blank=True, db_column="StudentIds", max_length=1000, null=True
                    ),
                ),
            ],
            options={"db_table": "Prebooking", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Room",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("room_id", models.IntegerField(db_column="ROOM_ID")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timerequest",
                    models.CharField(
                        blank=True, db_column="TimeRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timerequestminut",
                    models.CharField(
                        blank=True,
                        db_column="TimeRequestMinut",
                        max_length=400,
                        null=True,
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "oldname",
                    models.CharField(
                        blank=True, db_column="OldName", max_length=60, null=True
                    ),
                ),
                (
                    "alternate_room_id",
                    models.IntegerField(
                        blank=True, db_column="ALTERNATE_ROOM_ID", null=True
                    ),
                ),
                (
                    "department_id",
                    models.IntegerField(
                        blank=True, db_column="DEPARTMENT_ID", null=True
                    ),
                ),
                (
                    "corridor1",
                    models.CharField(
                        blank=True, db_column="Corridor1", max_length=60, null=True
                    ),
                ),
                (
                    "corridor2",
                    models.CharField(
                        blank=True, db_column="Corridor2", max_length=60, null=True
                    ),
                ),
                (
                    "corridors",
                    models.CharField(
                        blank=True, db_column="Corridors", max_length=255, null=True
                    ),
                ),
                (
                    "dislocation",
                    models.CharField(
                        blank=True, db_column="Dislocation", max_length=1, null=True
                    ),
                ),
                (
                    "capacity",
                    models.SmallIntegerField(
                        blank=True, db_column="Capacity", null=True
                    ),
                ),
                (
                    "weighting",
                    models.SmallIntegerField(
                        blank=True, db_column="Weighting", null=True
                    ),
                ),
                (
                    "minutbreakmin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreakMin", null=True
                    ),
                ),
                (
                    "externname",
                    models.CharField(
                        blank=True, db_column="ExternName", max_length=60, null=True
                    ),
                ),
                (
                    "departments",
                    models.CharField(
                        blank=True, db_column="Departments", max_length=20, null=True
                    ),
                ),
            ],
            options={"db_table": "Room", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Roomgroup",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("roomgroup_id", models.IntegerField(db_column="ROOMGROUP_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "roomids",
                    models.CharField(
                        blank=True, db_column="RoomIds", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "RoomGroup", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="School",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "schoolno",
                    models.CharField(
                        blank=True, db_column="SchoolNo", max_length=20, null=True
                    ),
                ),
                (
                    "lizense1",
                    models.CharField(
                        blank=True, db_column="Lizense1", max_length=50, null=True
                    ),
                ),
                (
                    "lizense2",
                    models.CharField(
                        blank=True, db_column="Lizense2", max_length=50, null=True
                    ),
                ),
                (
                    "lizensenr1",
                    models.CharField(
                        blank=True, db_column="LizenseNr1", max_length=8, null=True
                    ),
                ),
                (
                    "lizensenr2",
                    models.CharField(
                        blank=True, db_column="LizenseNr2", max_length=7, null=True
                    ),
                ),
                (
                    "lizensenr3",
                    models.CharField(
                        blank=True, db_column="LizenseNr3", max_length=7, null=True
                    ),
                ),
                (
                    "expirationdate",
                    models.IntegerField(
                        blank=True, db_column="ExpirationDate", null=True
                    ),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "time",
                    models.SmallIntegerField(blank=True, db_column="Time", null=True),
                ),
                (
                    "version_id",
                    models.SmallIntegerField(
                        blank=True, db_column="VERSION_ID", null=True
                    ),
                ),
                (
                    "lightmodus",
                    models.IntegerField(blank=True, db_column="LightModus", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=50, null=True
                    ),
                ),
                (
                    "numberstudents",
                    models.IntegerField(
                        blank=True, db_column="NumberStudents", null=True
                    ),
                ),
            ],
            options={"db_table": "School", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Schoolyear",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                (
                    "counterlast",
                    models.IntegerField(blank=True, db_column="CounterLast", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                ("time", models.IntegerField(blank=True, db_column="Time", null=True)),
                (
                    "schoolyearzoned",
                    models.CharField(
                        blank=True,
                        db_column="SchoolYearZoned",
                        max_length=20,
                        null=True,
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=50, null=True
                    ),
                ),
            ],
            options={"db_table": "SchoolYear", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Screenset",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("screenset_id", models.IntegerField(db_column="SCREENSET_ID")),
                ("owner", models.SmallIntegerField(db_column="Owner")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "modus",
                    models.CharField(
                        blank=True, db_column="Modus", max_length=1, null=True
                    ),
                ),
                (
                    "numbers",
                    models.SmallIntegerField(
                        blank=True, db_column="NumberS", null=True
                    ),
                ),
                (
                    "windows1",
                    models.CharField(
                        blank=True, db_column="Windows1", max_length=255, null=True
                    ),
                ),
                (
                    "windows2",
                    models.CharField(
                        blank=True, db_column="Windows2", max_length=255, null=True
                    ),
                ),
                (
                    "windows3",
                    models.CharField(
                        blank=True, db_column="Windows3", max_length=255, null=True
                    ),
                ),
                (
                    "windows4",
                    models.CharField(
                        blank=True, db_column="Windows4", max_length=255, null=True
                    ),
                ),
                (
                    "windows5",
                    models.CharField(
                        blank=True, db_column="Windows5", max_length=255, null=True
                    ),
                ),
                (
                    "windows6",
                    models.CharField(
                        blank=True, db_column="Windows6", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "ScreenSet", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Student",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("student_id", models.IntegerField(db_column="STUDENT_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "oldname",
                    models.CharField(
                        blank=True, db_column="OldName", max_length=60, null=True
                    ),
                ),
                (
                    "firstname",
                    models.CharField(
                        blank=True, db_column="FirstName", max_length=150, null=True
                    ),
                ),
                (
                    "studnumber",
                    models.CharField(
                        blank=True, db_column="StudNumber", max_length=20, null=True
                    ),
                ),
                (
                    "email",
                    models.CharField(
                        blank=True, db_column="Email", max_length=80, null=True
                    ),
                ),
                (
                    "birthdate",
                    models.IntegerField(blank=True, db_column="BirthDate", null=True),
                ),
                (
                    "optsign",
                    models.CharField(
                        blank=True, db_column="OptSign", max_length=1, null=True
                    ),
                ),
                (
                    "class_id",
                    models.IntegerField(blank=True, db_column="CLASS_ID", null=True),
                ),
                (
                    "class_id2",
                    models.SmallIntegerField(
                        blank=True, db_column="CLASS_ID2", null=True
                    ),
                ),
                (
                    "class_id3",
                    models.SmallIntegerField(
                        blank=True, db_column="CLASS_ID3", null=True
                    ),
                ),
                (
                    "class_id4",
                    models.SmallIntegerField(
                        blank=True, db_column="CLASS_ID4", null=True
                    ),
                ),
                (
                    "class_id5",
                    models.SmallIntegerField(
                        blank=True, db_column="CLASS_ID5", null=True
                    ),
                ),
                (
                    "class_id6",
                    models.SmallIntegerField(
                        blank=True, db_column="CLASS_ID6", null=True
                    ),
                ),
            ],
            options={"db_table": "Student", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Studentchoice",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("student_id", models.IntegerField(db_column="STUDENT_ID")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                ("number", models.SmallIntegerField(db_column="Number")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "numberalternativegiven",
                    models.SmallIntegerField(
                        blank=True, db_column="NumberAlternativeGiven", null=True
                    ),
                ),
                (
                    "alternativecourses",
                    models.CharField(
                        blank=True,
                        db_column="AlternativeCourses",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "standbycourses",
                    models.CharField(
                        blank=True,
                        db_column="StandByCourses",
                        max_length=255,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "StudentChoice", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Studentgroup",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("studentgroup_id", models.IntegerField(db_column="STUDENTGROUP_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "oldname",
                    models.CharField(
                        blank=True, db_column="OldName", max_length=60, null=True
                    ),
                ),
                (
                    "subject_id",
                    models.IntegerField(blank=True, db_column="SUBJECT_ID", null=True),
                ),
                (
                    "classids",
                    models.CharField(
                        blank=True, db_column="ClassIds", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "StudentGroup", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Subjectgroup",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("subjectgroup_id", models.IntegerField(db_column="SUBJECTGROUP_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "subjectids",
                    models.CharField(
                        blank=True, db_column="SubjectIds", max_length=255, null=True
                    ),
                ),
            ],
            options={"db_table": "SubjectGroup", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Subjects",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("subject_id", models.IntegerField(db_column="SUBJECT_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timerequest",
                    models.CharField(
                        blank=True, db_column="TimeRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timerequestminut",
                    models.CharField(
                        blank=True,
                        db_column="TimeRequestMinut",
                        max_length=400,
                        null=True,
                    ),
                ),
                (
                    "selmatrix",
                    models.CharField(
                        blank=True, db_column="SelMatrix", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "room_id",
                    models.IntegerField(blank=True, db_column="ROOM_ID", null=True),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "miscdata",
                    models.CharField(
                        blank=True, db_column="MiscData", max_length=255, null=True
                    ),
                ),
                (
                    "oldname",
                    models.CharField(
                        blank=True, db_column="OldName", max_length=60, null=True
                    ),
                ),
                (
                    "sujectgroup",
                    models.CharField(
                        blank=True, db_column="SujectGroup", max_length=20, null=True
                    ),
                ),
                (
                    "subjectseqcla",
                    models.CharField(
                        blank=True, db_column="SubjectSeqCla", max_length=1, null=True
                    ),
                ),
                (
                    "subjectseqtea",
                    models.CharField(
                        blank=True, db_column="SubjectSeqTea", max_length=1, null=True
                    ),
                ),
                (
                    "lssnpmmin",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnPMmin", null=True
                    ),
                ),
                (
                    "lssnpmmax",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnPMmax", null=True
                    ),
                ),
                (
                    "lssnweekmin",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnWeekMin", null=True
                    ),
                ),
                (
                    "lssnweekmax",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnWeekMax", null=True
                    ),
                ),
                (
                    "minutpmmin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutPMmin", null=True
                    ),
                ),
                (
                    "minutpmmax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutPMmax", null=True
                    ),
                ),
                (
                    "minutbreak1",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreak1", null=True
                    ),
                ),
                (
                    "minutbreak2",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreak2", null=True
                    ),
                ),
                (
                    "minutlssn",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLssn", null=True
                    ),
                ),
                (
                    "minutlssnweekmin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLssnWeekMin", null=True
                    ),
                ),
                (
                    "minutlssnweekmax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLssnWeekMax", null=True
                    ),
                ),
                (
                    "departments",
                    models.CharField(
                        blank=True, db_column="Departments", max_length=120, null=True
                    ),
                ),
            ],
            options={"db_table": "Subjects", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Substitution",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("substitution_id", models.IntegerField(db_column="SUBSTITUTION_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "lesson",
                    models.SmallIntegerField(blank=True, db_column="Lesson", null=True),
                ),
                (
                    "teacher_idsubst",
                    models.IntegerField(
                        blank=True, db_column="TEACHER_IDSubst", null=True
                    ),
                ),
                (
                    "teacher_idlessn",
                    models.IntegerField(
                        blank=True, db_column="TEACHER_IDLessn", null=True
                    ),
                ),
                (
                    "subject_idsubst",
                    models.IntegerField(
                        blank=True, db_column="SUBJECT_IDSubst", null=True
                    ),
                ),
                (
                    "room_idsubst",
                    models.IntegerField(
                        blank=True, db_column="ROOM_IDSubst", null=True
                    ),
                ),
                (
                    "lesson_idsubst",
                    models.IntegerField(
                        blank=True, db_column="LESSON_IDSubst", null=True
                    ),
                ),
                (
                    "corridor_id",
                    models.IntegerField(blank=True, db_column="CORRIDOR_ID", null=True),
                ),
                (
                    "transfer_id",
                    models.IntegerField(blank=True, db_column="TRANSFER_ID", null=True),
                ),
                (
                    "exam_id",
                    models.IntegerField(blank=True, db_column="EXAM_ID", null=True),
                ),
                (
                    "caused_by_exam_id",
                    models.IntegerField(
                        blank=True, db_column="CAUSED_BY_EXAM_ID", null=True
                    ),
                ),
                (
                    "coupling",
                    models.SmallIntegerField(
                        blank=True, db_column="Coupling", null=True
                    ),
                ),
                (
                    "text2",
                    models.CharField(
                        blank=True, db_column="Text2", max_length=100, null=True
                    ),
                ),
                (
                    "classids",
                    models.CharField(
                        blank=True, db_column="ClassIds", max_length=255, null=True
                    ),
                ),
                (
                    "absenceids",
                    models.CharField(
                        blank=True, db_column="AbsenceIds", max_length=255, null=True
                    ),
                ),
                (
                    "prebookingnr",
                    models.IntegerField(
                        blank=True, db_column="PrebookingNr", null=True
                    ),
                ),
                (
                    "prebookingnrtransfer",
                    models.IntegerField(
                        blank=True, db_column="PrebookingNrTransfer", null=True
                    ),
                ),
                (
                    "studentids",
                    models.CharField(
                        blank=True, db_column="StudentIds", max_length=1000, null=True
                    ),
                ),
                (
                    "substvalue",
                    models.CharField(
                        blank=True, db_column="SubstValue", max_length=9, null=True
                    ),
                ),
                (
                    "studentgroup",
                    models.CharField(
                        blank=True, db_column="StudentGroup", max_length=100, null=True
                    ),
                ),
                (
                    "roomids",
                    models.CharField(
                        blank=True, db_column="RoomIds", max_length=255, null=True
                    ),
                ),
                (
                    "bookingtype",
                    models.IntegerField(blank=True, db_column="BookingType", null=True),
                ),
                (
                    "studentgroup_id",
                    models.IntegerField(
                        blank=True, db_column="STUDENTGROUP_ID", null=True
                    ),
                ),
                (
                    "breaksubstdata",
                    models.CharField(
                        blank=True, db_column="BreakSubstData", max_length=50, null=True
                    ),
                ),
            ],
            options={"db_table": "Substitution", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Tableinfo",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("type", models.SmallIntegerField(db_column="Type")),
                ("id", models.IntegerField(db_column="ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "time",
                    models.SmallIntegerField(blank=True, db_column="Time", null=True),
                ),
                (
                    "idmax",
                    models.IntegerField(blank=True, db_column="IdMax", null=True),
                ),
                (
                    "sortidmax",
                    models.IntegerField(blank=True, db_column="SortIdMax", null=True),
                ),
                (
                    "lessonnrmax",
                    models.IntegerField(blank=True, db_column="LessonNrMax", null=True),
                ),
            ],
            options={"db_table": "TableInfo", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Teacher",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("teacher_id", models.IntegerField(db_column="TEACHER_ID")),
                ("term_id", models.SmallIntegerField(db_column="TERM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "statisticcodes",
                    models.CharField(
                        blank=True, db_column="StatisticCodes", max_length=10, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timerequest",
                    models.CharField(
                        blank=True, db_column="TimeRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timerequestminut",
                    models.CharField(
                        blank=True,
                        db_column="TimeRequestMinut",
                        max_length=400,
                        null=True,
                    ),
                ),
                (
                    "dayrequest",
                    models.CharField(
                        blank=True, db_column="DayRequest", max_length=400, null=True
                    ),
                ),
                (
                    "timerequestunspecified",
                    models.CharField(
                        blank=True,
                        db_column="TimeRequestUnspecified",
                        max_length=400,
                        null=True,
                    ),
                ),
                (
                    "address",
                    models.CharField(
                        blank=True, db_column="Address", max_length=400, null=True
                    ),
                ),
                (
                    "selmatrix",
                    models.CharField(
                        blank=True, db_column="SelMatrix", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "blankflags",
                    models.CharField(
                        blank=True, db_column="BlankFlags", max_length=80, null=True
                    ),
                ),
                (
                    "room_id",
                    models.IntegerField(blank=True, db_column="ROOM_ID", null=True),
                ),
                (
                    "description_id",
                    models.IntegerField(
                        blank=True, db_column="DESCRIPTION_ID", null=True
                    ),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "factor",
                    models.CharField(
                        blank=True, db_column="Factor", max_length=9, null=True
                    ),
                ),
                (
                    "foreigndata",
                    models.CharField(
                        blank=True, db_column="ForeignData", max_length=255, null=True
                    ),
                ),
                (
                    "foreignkey",
                    models.CharField(
                        blank=True, db_column="ForeignKey", max_length=50, null=True
                    ),
                ),
                (
                    "miscdata",
                    models.CharField(
                        blank=True, db_column="MiscData", max_length=255, null=True
                    ),
                ),
                (
                    "oldname",
                    models.CharField(
                        blank=True, db_column="OldName", max_length=60, null=True
                    ),
                ),
                (
                    "minutbreakmin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreakMin", null=True
                    ),
                ),
                (
                    "lunchbreakmin",
                    models.SmallIntegerField(
                        blank=True, db_column="LunchBreakMin", null=True
                    ),
                ),
                (
                    "lunchbreakmax",
                    models.SmallIntegerField(
                        blank=True, db_column="LunchBreakMax", null=True
                    ),
                ),
                (
                    "lssnperdaymin",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnPerDayMin", null=True
                    ),
                ),
                (
                    "lssnperdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="LssnPerDayMax", null=True
                    ),
                ),
                (
                    "minutminutesperdaymin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutMinutesPerDayMin", null=True
                    ),
                ),
                (
                    "minutminutesperdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutMinutesPerDayMax", null=True
                    ),
                ),
                (
                    "minutlunchbreakperdaymin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLunchBreakPerDayMin", null=True
                    ),
                ),
                (
                    "minutlunchbreakperdaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutLunchBreakPerDayMax", null=True
                    ),
                ),
                (
                    "blocksnodays",
                    models.SmallIntegerField(
                        blank=True, db_column="BlocksNoDays", null=True
                    ),
                ),
                (
                    "blockslssnfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="BlocksLssnFrom", null=True
                    ),
                ),
                (
                    "blockslssnto",
                    models.SmallIntegerField(
                        blank=True, db_column="BlocksLssnTo", null=True
                    ),
                ),
                (
                    "weekquotamin",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekQuotaMin", null=True
                    ),
                ),
                (
                    "weekquotamax",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekQuotaMax", null=True
                    ),
                ),
                (
                    "weekquotaideal",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekQuotaIdeal", null=True
                    ),
                ),
                (
                    "pnumber",
                    models.CharField(
                        blank=True, db_column="PNumber", max_length=20, null=True
                    ),
                ),
                (
                    "status",
                    models.CharField(
                        blank=True, db_column="Status", max_length=10, null=True
                    ),
                ),
                (
                    "firstname",
                    models.CharField(
                        blank=True, db_column="FirstName", max_length=150, null=True
                    ),
                ),
                (
                    "title",
                    models.CharField(
                        blank=True, db_column="Title", max_length=20, null=True
                    ),
                ),
                (
                    "ownschool",
                    models.CharField(
                        blank=True, db_column="OwnSchool", max_length=20, null=True
                    ),
                ),
                (
                    "ignorereason",
                    models.CharField(
                        blank=True, db_column="IgnoreReason", max_length=20, null=True
                    ),
                ),
                (
                    "department_id1",
                    models.SmallIntegerField(
                        blank=True, db_column="DEPARTMENT_ID1", null=True
                    ),
                ),
                (
                    "department_id2",
                    models.SmallIntegerField(
                        blank=True, db_column="DEPARTMENT_ID2", null=True
                    ),
                ),
                (
                    "department_id3",
                    models.SmallIntegerField(
                        blank=True, db_column="DEPARTMENT_ID3", null=True
                    ),
                ),
                (
                    "department_id4",
                    models.SmallIntegerField(
                        blank=True, db_column="DEPARTMENT_ID4", null=True
                    ),
                ),
                (
                    "department_id5",
                    models.SmallIntegerField(
                        blank=True, db_column="DEPARTMENT_ID5", null=True
                    ),
                ),
                (
                    "email",
                    models.CharField(
                        blank=True, db_column="Email", max_length=80, null=True
                    ),
                ),
                (
                    "tel",
                    models.CharField(
                        blank=True, db_column="Tel", max_length=20, null=True
                    ),
                ),
                (
                    "handy",
                    models.CharField(
                        blank=True, db_column="Handy", max_length=20, null=True
                    ),
                ),
                (
                    "externid",
                    models.CharField(
                        blank=True, db_column="ExternId", max_length=20, null=True
                    ),
                ),
                (
                    "nolessnsucc",
                    models.SmallIntegerField(
                        blank=True, db_column="NoLessnSucc", null=True
                    ),
                ),
                (
                    "cavitymin",
                    models.SmallIntegerField(
                        blank=True, db_column="CavityMin", null=True
                    ),
                ),
                (
                    "cavitymax",
                    models.SmallIntegerField(
                        blank=True, db_column="CavityMax", null=True
                    ),
                ),
                (
                    "availmax",
                    models.SmallIntegerField(
                        blank=True, db_column="AvailMax", null=True
                    ),
                ),
                (
                    "daybreak",
                    models.SmallIntegerField(
                        blank=True, db_column="DayBreak", null=True
                    ),
                ),
                (
                    "substblock",
                    models.SmallIntegerField(
                        blank=True, db_column="SubstBlock", null=True
                    ),
                ),
                (
                    "minutbreaksweekmin",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreaksWeekMin", null=True
                    ),
                ),
                (
                    "minutbreaksweekmax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutBreaksWeekMax", null=True
                    ),
                ),
                (
                    "minutsucessmax",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutSucessMax", null=True
                    ),
                ),
                (
                    "pointbreaksupmax",
                    models.SmallIntegerField(
                        blank=True, db_column="PointBreaksupMax", null=True
                    ),
                ),
                (
                    "birthdate",
                    models.IntegerField(blank=True, db_column="BirthDate", null=True),
                ),
                (
                    "arrivaldate",
                    models.IntegerField(blank=True, db_column="ArrivalDate", null=True),
                ),
                (
                    "departuredate",
                    models.IntegerField(
                        blank=True, db_column="DepartureDate", null=True
                    ),
                ),
                (
                    "plannedweek",
                    models.IntegerField(blank=True, db_column="PlannedWeek", null=True),
                ),
                (
                    "plannedweekmax",
                    models.IntegerField(
                        blank=True, db_column="PlannedWeekMax", null=True
                    ),
                ),
                (
                    "plannedyear",
                    models.IntegerField(blank=True, db_column="PlannedYear", null=True),
                ),
                (
                    "plannedyearmax",
                    models.IntegerField(
                        blank=True, db_column="PlannedYearMax", null=True
                    ),
                ),
                (
                    "salarypehour",
                    models.IntegerField(
                        blank=True, db_column="SalaryPeHour", null=True
                    ),
                ),
                (
                    "optvarteacher",
                    models.CharField(
                        blank=True, db_column="OptVarTeacher", max_length=1, null=True
                    ),
                ),
                (
                    "externname",
                    models.CharField(
                        blank=True, db_column="ExternName", max_length=60, null=True
                    ),
                ),
                (
                    "breaksvrequest",
                    models.CharField(
                        blank=True,
                        db_column="BreakSVRequest",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "teachquali1",
                    models.CharField(
                        blank=True, db_column="TeachQuali1", max_length=1000, null=True
                    ),
                ),
                (
                    "teachquali2",
                    models.CharField(
                        blank=True, db_column="TeachQuali2", max_length=1000, null=True
                    ),
                ),
                (
                    "teachquali3",
                    models.CharField(
                        blank=True, db_column="TeachQuali3", max_length=1000, null=True
                    ),
                ),
                (
                    "teachquali4",
                    models.CharField(
                        blank=True, db_column="TeachQuali4", max_length=1000, null=True
                    ),
                ),
                (
                    "text2",
                    models.CharField(
                        blank=True, db_column="Text2", max_length=100, null=True
                    ),
                ),
                (
                    "glaettdate",
                    models.IntegerField(blank=True, db_column="GlaettDate", null=True),
                ),
                (
                    "breaksvdayflags",
                    models.CharField(
                        blank=True,
                        db_column="BreakSvDayFlags",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "lengthstaymax",
                    models.SmallIntegerField(
                        blank=True, db_column="LengthStayMax", null=True
                    ),
                ),
                (
                    "statusnew",
                    models.CharField(
                        blank=True, db_column="StatusNew", max_length=10, null=True
                    ),
                ),
                (
                    "statusnewdate",
                    models.IntegerField(
                        blank=True, db_column="StatusNewDate", null=True
                    ),
                ),
                (
                    "text3",
                    models.CharField(
                        blank=True, db_column="Text3", max_length=100, null=True
                    ),
                ),
                (
                    "text4",
                    models.CharField(
                        blank=True, db_column="Text4", max_length=100, null=True
                    ),
                ),
                (
                    "plannedweekminut",
                    models.IntegerField(
                        blank=True, db_column="PlannedWeekMinut", null=True
                    ),
                ),
                (
                    "plannedyearminut",
                    models.IntegerField(
                        blank=True, db_column="PlannedYearMinut", null=True
                    ),
                ),
                (
                    "plannedweeknew",
                    models.IntegerField(
                        blank=True, db_column="PlannedWeekNew", null=True
                    ),
                ),
                (
                    "plannedperdept",
                    models.CharField(
                        blank=True,
                        db_column="PlannedPerDept",
                        max_length=1000,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "Teacher", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Teachergroup",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("teachergroup_id", models.IntegerField(db_column="TEACHERGROUP_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "timestamp",
                    models.IntegerField(blank=True, db_column="TimeStamp", null=True),
                ),
                (
                    "forecolor",
                    models.IntegerField(blank=True, db_column="ForeColor", null=True),
                ),
                (
                    "backcolor",
                    models.IntegerField(blank=True, db_column="BackColor", null=True),
                ),
                (
                    "teacherids",
                    models.CharField(
                        blank=True, db_column="TeacherIds", max_length=255, null=True
                    ),
                ),
                (
                    "dataperteacher",
                    models.CharField(
                        blank=True,
                        db_column="DataPerTeacher",
                        max_length=255,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "TeacherGroup", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Terms",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("term_id", models.IntegerField(db_column="TERM_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "term_id_mother",
                    models.IntegerField(
                        blank=True, db_column="TERM_ID_Mother", null=True
                    ),
                ),
            ],
            options={"db_table": "Terms", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Transfer",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("transfer_id", models.IntegerField(db_column="TRANSFER_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "teacher_id",
                    models.IntegerField(blank=True, db_column="TEACHER_ID", null=True),
                ),
                (
                    "lesson_id",
                    models.IntegerField(blank=True, db_column="LESSON_ID", null=True),
                ),
                (
                    "datefrom",
                    models.IntegerField(blank=True, db_column="DateFrom", null=True),
                ),
                (
                    "dateto",
                    models.IntegerField(blank=True, db_column="DateTo", null=True),
                ),
                (
                    "lessonfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonFrom", null=True
                    ),
                ),
                (
                    "lessonto",
                    models.SmallIntegerField(
                        blank=True, db_column="LessonTo", null=True
                    ),
                ),
            ],
            options={"db_table": "Transfer", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Ttelementfilter",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                (
                    "tt_element_filter_id",
                    models.IntegerField(db_column="TT_ELEMENT_FILTER_ID"),
                ),
                ("owner", models.SmallIntegerField(db_column="Owner")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "elementids",
                    models.CharField(
                        blank=True, db_column="ElementIds", max_length=1000, null=True
                    ),
                ),
            ],
            options={"db_table": "TTElementFilter", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="TtFormat",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("tt_format_id", models.IntegerField(db_column="TT_FORMAT_ID")),
                ("owner", models.SmallIntegerField(db_column="Owner")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=60, null=True
                    ),
                ),
                (
                    "longname",
                    models.CharField(
                        blank=True, db_column="Longname", max_length=100, null=True
                    ),
                ),
                (
                    "window",
                    models.CharField(
                        blank=True, db_column="Window", max_length=255, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                (
                    "picturedata1",
                    models.CharField(
                        blank=True, db_column="PictureData1", max_length=100, null=True
                    ),
                ),
                (
                    "picturedata2",
                    models.CharField(
                        blank=True, db_column="PictureData2", max_length=100, null=True
                    ),
                ),
                (
                    "font",
                    models.CharField(
                        blank=True, db_column="Font", max_length=120, null=True
                    ),
                ),
                (
                    "printer",
                    models.CharField(
                        blank=True, db_column="Printer", max_length=60, null=True
                    ),
                ),
                (
                    "header11",
                    models.SmallIntegerField(
                        blank=True, db_column="Header11", null=True
                    ),
                ),
                (
                    "headerweek",
                    models.SmallIntegerField(
                        blank=True, db_column="HeaderWeek", null=True
                    ),
                ),
                (
                    "typeheader1",
                    models.SmallIntegerField(
                        blank=True, db_column="TypeHeader1", null=True
                    ),
                ),
                (
                    "typeheader2",
                    models.SmallIntegerField(
                        blank=True, db_column="TypeHeader2", null=True
                    ),
                ),
                (
                    "format",
                    models.SmallIntegerField(blank=True, db_column="Format", null=True),
                ),
                (
                    "fixedflag",
                    models.SmallIntegerField(
                        blank=True, db_column="FixedFlag", null=True
                    ),
                ),
                (
                    "nocol",
                    models.SmallIntegerField(blank=True, db_column="NoCol", null=True),
                ),
                (
                    "col1",
                    models.SmallIntegerField(blank=True, db_column="Col1", null=True),
                ),
                (
                    "colact",
                    models.SmallIntegerField(blank=True, db_column="ColAct", null=True),
                ),
                (
                    "nocol11",
                    models.SmallIntegerField(
                        blank=True, db_column="NoCol11", null=True
                    ),
                ),
                (
                    "nocol20_30",
                    models.SmallIntegerField(
                        blank=True, db_column="NoCol20_30", null=True
                    ),
                ),
                (
                    "nocolftn",
                    models.SmallIntegerField(
                        blank=True, db_column="NoColFtn", null=True
                    ),
                ),
                (
                    "nocolftn11_30",
                    models.SmallIntegerField(
                        blank=True, db_column="NoColFtn11_30", null=True
                    ),
                ),
                (
                    "cola",
                    models.SmallIntegerField(blank=True, db_column="ColA", null=True),
                ),
                (
                    "norow",
                    models.SmallIntegerField(blank=True, db_column="NoRow", null=True),
                ),
                (
                    "row1",
                    models.SmallIntegerField(blank=True, db_column="Row1", null=True),
                ),
                (
                    "rowact",
                    models.SmallIntegerField(blank=True, db_column="RowAct", null=True),
                ),
                (
                    "norow11",
                    models.SmallIntegerField(
                        blank=True, db_column="NoRow11", null=True
                    ),
                ),
                (
                    "norow20_30",
                    models.SmallIntegerField(
                        blank=True, db_column="NoRow20_30", null=True
                    ),
                ),
                (
                    "norowtitle",
                    models.SmallIntegerField(
                        blank=True, db_column="NoRowTitle", null=True
                    ),
                ),
                (
                    "rowa",
                    models.SmallIntegerField(blank=True, db_column="RowA", null=True),
                ),
                (
                    "typetitle",
                    models.SmallIntegerField(
                        blank=True, db_column="TypeTitle", null=True
                    ),
                ),
                (
                    "intheadingrow11_30",
                    models.SmallIntegerField(
                        blank=True, db_column="IntHeadingRow11_30", null=True
                    ),
                ),
                (
                    "elperpage40",
                    models.SmallIntegerField(
                        blank=True, db_column="ElPerPage40", null=True
                    ),
                ),
                (
                    "intheadingcol11_30",
                    models.SmallIntegerField(
                        blank=True, db_column="IntHeadingCol11_30", null=True
                    ),
                ),
                (
                    "tt_version",
                    models.SmallIntegerField(
                        blank=True, db_column="TT_Version", null=True
                    ),
                ),
                (
                    "nodayspersheet",
                    models.SmallIntegerField(
                        blank=True, db_column="NoDaysPerSheet", null=True
                    ),
                ),
                (
                    "layoutheader",
                    models.SmallIntegerField(
                        blank=True, db_column="LayoutHeader", null=True
                    ),
                ),
                (
                    "layoutlessn",
                    models.SmallIntegerField(
                        blank=True, db_column="LayoutLessn", null=True
                    ),
                ),
                (
                    "layoutlessn1",
                    models.SmallIntegerField(
                        blank=True, db_column="LayoutLessn1", null=True
                    ),
                ),
                (
                    "position1",
                    models.SmallIntegerField(
                        blank=True, db_column="Position1", null=True
                    ),
                ),
                (
                    "position2",
                    models.SmallIntegerField(
                        blank=True, db_column="Position2", null=True
                    ),
                ),
                (
                    "position3",
                    models.SmallIntegerField(
                        blank=True, db_column="Position3", null=True
                    ),
                ),
                (
                    "nottperpage",
                    models.SmallIntegerField(
                        blank=True, db_column="NoTTPerPage", null=True
                    ),
                ),
                (
                    "nottperpage1",
                    models.SmallIntegerField(
                        blank=True, db_column="NoTTPerPage1", null=True
                    ),
                ),
                (
                    "nottperpage2",
                    models.SmallIntegerField(
                        blank=True, db_column="NoTTPerPage2", null=True
                    ),
                ),
                (
                    "periodfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="PeriodFrom", null=True
                    ),
                ),
                (
                    "periodto",
                    models.SmallIntegerField(
                        blank=True, db_column="PeriodTo", null=True
                    ),
                ),
                (
                    "weekperiodfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekPeriodFrom", null=True
                    ),
                ),
                (
                    "weekperiodto",
                    models.SmallIntegerField(
                        blank=True, db_column="WeekPeriodTo", null=True
                    ),
                ),
                (
                    "nonamesperline",
                    models.SmallIntegerField(
                        blank=True, db_column="NoNamesPerLine", null=True
                    ),
                ),
                (
                    "notimesperline",
                    models.SmallIntegerField(
                        blank=True, db_column="NoTimesPerLine", null=True
                    ),
                ),
                (
                    "minutdayfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutDayFrom", null=True
                    ),
                ),
                (
                    "minutdayto",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutDayTo", null=True
                    ),
                ),
                (
                    "minutperiodfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutPeriodFrom", null=True
                    ),
                ),
                (
                    "minutperiodto",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutPeriodTo", null=True
                    ),
                ),
                (
                    "minutweekperiodfrom",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutWeekPeriodFrom", null=True
                    ),
                ),
                (
                    "minutweekperiodto",
                    models.SmallIntegerField(
                        blank=True, db_column="MinutWeekPeriodTo", null=True
                    ),
                ),
                (
                    "input_format_id",
                    models.IntegerField(
                        blank=True, db_column="INPUT_FORMAT_ID", null=True
                    ),
                ),
                (
                    "sizeleftx",
                    models.SmallIntegerField(
                        blank=True, db_column="SizeLeftX", null=True
                    ),
                ),
                (
                    "sizelefty",
                    models.SmallIntegerField(
                        blank=True, db_column="SizeLeftY", null=True
                    ),
                ),
                (
                    "sizetopx",
                    models.SmallIntegerField(
                        blank=True, db_column="SizeTopX", null=True
                    ),
                ),
                (
                    "sizetopy",
                    models.SmallIntegerField(
                        blank=True, db_column="SizeTopY", null=True
                    ),
                ),
                (
                    "htmltitlewidth",
                    models.SmallIntegerField(
                        blank=True, db_column="HtmlTitleWidth", null=True
                    ),
                ),
                (
                    "htmlcolheight",
                    models.SmallIntegerField(
                        blank=True, db_column="HtmlColHeight", null=True
                    ),
                ),
                (
                    "htmlcolwidth",
                    models.SmallIntegerField(
                        blank=True, db_column="HtmlColWidth", null=True
                    ),
                ),
                (
                    "htmltitlealign",
                    models.SmallIntegerField(
                        blank=True, db_column="HtmlTitleAlign", null=True
                    ),
                ),
                (
                    "htmlcolalign",
                    models.SmallIntegerField(
                        blank=True, db_column="HtmlColAlign", null=True
                    ),
                ),
                (
                    "htmlfieldwidth",
                    models.SmallIntegerField(
                        blank=True, db_column="HtmlFieldWidth", null=True
                    ),
                ),
                (
                    "relativefont1",
                    models.CharField(
                        blank=True, db_column="RelativeFont1", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont2",
                    models.CharField(
                        blank=True, db_column="RelativeFont2", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont3",
                    models.CharField(
                        blank=True, db_column="RelativeFont3", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont4",
                    models.CharField(
                        blank=True, db_column="RelativeFont4", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont5",
                    models.CharField(
                        blank=True, db_column="RelativeFont5", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont6",
                    models.CharField(
                        blank=True, db_column="RelativeFont6", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont7",
                    models.CharField(
                        blank=True, db_column="RelativeFont7", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont8",
                    models.CharField(
                        blank=True, db_column="RelativeFont8", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont9",
                    models.CharField(
                        blank=True, db_column="RelativeFont9", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont10",
                    models.CharField(
                        blank=True, db_column="RelativeFont10", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont11",
                    models.CharField(
                        blank=True, db_column="RelativeFont11", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont12",
                    models.CharField(
                        blank=True, db_column="RelativeFont12", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont13",
                    models.CharField(
                        blank=True, db_column="RelativeFont13", max_length=60, null=True
                    ),
                ),
                (
                    "relativefont14",
                    models.CharField(
                        blank=True, db_column="RelativeFont14", max_length=60, null=True
                    ),
                ),
                (
                    "field1",
                    models.CharField(
                        blank=True, db_column="Field1", max_length=1000, null=True
                    ),
                ),
                (
                    "field2",
                    models.CharField(
                        blank=True, db_column="Field2", max_length=1000, null=True
                    ),
                ),
                (
                    "field3",
                    models.CharField(
                        blank=True, db_column="Field3", max_length=1000, null=True
                    ),
                ),
                (
                    "field4",
                    models.CharField(
                        blank=True, db_column="Field4", max_length=1000, null=True
                    ),
                ),
                (
                    "field5",
                    models.CharField(
                        blank=True, db_column="Field5", max_length=1000, null=True
                    ),
                ),
                (
                    "field6",
                    models.CharField(
                        blank=True, db_column="Field6", max_length=1000, null=True
                    ),
                ),
                (
                    "field7",
                    models.CharField(
                        blank=True, db_column="Field7", max_length=1000, null=True
                    ),
                ),
                (
                    "field8",
                    models.CharField(
                        blank=True, db_column="Field8", max_length=1000, null=True
                    ),
                ),
                (
                    "field9",
                    models.CharField(
                        blank=True, db_column="Field9", max_length=1000, null=True
                    ),
                ),
                (
                    "field10",
                    models.CharField(
                        blank=True, db_column="Field10", max_length=1000, null=True
                    ),
                ),
                (
                    "linesforheader",
                    models.CharField(
                        blank=True,
                        db_column="LinesForHeader",
                        max_length=200,
                        null=True,
                    ),
                ),
                (
                    "schoolweeks",
                    models.CharField(
                        blank=True, db_column="SchoolWeeks", max_length=255, null=True
                    ),
                ),
                (
                    "flags1",
                    models.CharField(
                        blank=True, db_column="Flags1", max_length=100, null=True
                    ),
                ),
                (
                    "noweeks",
                    models.SmallIntegerField(
                        blank=True, db_column="NoWeeks", null=True
                    ),
                ),
                ("nott", models.IntegerField(blank=True, db_column="NoTT", null=True)),
                (
                    "showlines",
                    models.CharField(
                        blank=True, db_column="ShowLines", max_length=255, null=True
                    ),
                ),
                (
                    "doublelines",
                    models.CharField(
                        blank=True, db_column="DoubleLines", max_length=255, null=True
                    ),
                ),
                (
                    "thicklines",
                    models.CharField(
                        blank=True, db_column="ThickLines", max_length=255, null=True
                    ),
                ),
                (
                    "additionalheader",
                    models.CharField(
                        blank=True,
                        db_column="AdditionalHeader",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "positionclateasub",
                    models.SmallIntegerField(
                        blank=True, db_column="PositionClaTeaSub", null=True
                    ),
                ),
                (
                    "colclateasub",
                    models.SmallIntegerField(
                        blank=True, db_column="ColClaTeaSub", null=True
                    ),
                ),
                (
                    "colclateasub_subperline",
                    models.SmallIntegerField(
                        blank=True, db_column="ColClaTeaSub_SubPerLine", null=True
                    ),
                ),
                (
                    "positionadditionaltt",
                    models.SmallIntegerField(
                        blank=True, db_column="PositionAdditionalTT", null=True
                    ),
                ),
                (
                    "nameadditionaltt",
                    models.CharField(
                        blank=True,
                        db_column="NameAdditionalTT",
                        max_length=60,
                        null=True,
                    ),
                ),
                (
                    "flags2",
                    models.CharField(
                        blank=True, db_column="Flags2", max_length=100, null=True
                    ),
                ),
            ],
            options={"db_table": "TT_Format", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Untissettings",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("option_id", models.IntegerField(db_column="OPTION_ID")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "owner",
                    models.SmallIntegerField(blank=True, db_column="Owner", null=True),
                ),
                (
                    "section",
                    models.CharField(
                        blank=True, db_column="Section", max_length=1000, null=True
                    ),
                ),
                (
                    "optionkey",
                    models.CharField(
                        blank=True, db_column="OptionKey", max_length=1000, null=True
                    ),
                ),
                ("value", models.TextField(blank=True, db_column="Value", null=True)),
            ],
            options={"db_table": "UntisSettings", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="User",
            fields=[
                (
                    "user_id",
                    models.SmallIntegerField(
                        db_column="USER_ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "user_group_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_GROUP_ID", null=True
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=32, null=True
                    ),
                ),
                (
                    "user_id2",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID2", null=True
                    ),
                ),
                (
                    "user2text",
                    models.CharField(
                        blank=True, db_column="User2Text", max_length=100, null=True
                    ),
                ),
                (
                    "password",
                    models.IntegerField(blank=True, db_column="Password", null=True),
                ),
                (
                    "loggedin",
                    models.IntegerField(blank=True, db_column="LoggedIn", null=True),
                ),
                (
                    "usercounterlast",
                    models.IntegerField(
                        blank=True, db_column="UserCounterLast", null=True
                    ),
                ),
                (
                    "logindate",
                    models.IntegerField(blank=True, db_column="LogInDate", null=True),
                ),
                (
                    "logintime",
                    models.SmallIntegerField(
                        blank=True, db_column="LogInTime", null=True
                    ),
                ),
                (
                    "logoutdate",
                    models.IntegerField(blank=True, db_column="LogOutDate", null=True),
                ),
                (
                    "logouttime",
                    models.SmallIntegerField(
                        blank=True, db_column="LogOutTime", null=True
                    ),
                ),
                (
                    "refreshdate",
                    models.IntegerField(blank=True, db_column="RefreshDate", null=True),
                ),
                (
                    "refreshtime",
                    models.SmallIntegerField(
                        blank=True, db_column="RefreshTime", null=True
                    ),
                ),
                (
                    "school_id",
                    models.IntegerField(blank=True, db_column="SCHOOL_ID", null=True),
                ),
                (
                    "schoolyear_id",
                    models.IntegerField(
                        blank=True, db_column="SCHOOLYEAR_ID", null=True
                    ),
                ),
                (
                    "version_id",
                    models.SmallIntegerField(
                        blank=True, db_column="VERSION_ID", null=True
                    ),
                ),
                (
                    "term_id",
                    models.IntegerField(blank=True, db_column="TERM_ID", null=True),
                ),
                (
                    "term",
                    models.CharField(
                        blank=True, db_column="Term", max_length=50, null=True
                    ),
                ),
                (
                    "department_id",
                    models.IntegerField(
                        blank=True, db_column="DEPARTMENT_ID", null=True
                    ),
                ),
                (
                    "department",
                    models.CharField(
                        blank=True, db_column="Department", max_length=60, null=True
                    ),
                ),
                (
                    "mode",
                    models.SmallIntegerField(blank=True, db_column="Mode", null=True),
                ),
                (
                    "process",
                    models.SmallIntegerField(
                        blank=True, db_column="Process", null=True
                    ),
                ),
                (
                    "type",
                    models.SmallIntegerField(blank=True, db_column="Type", null=True),
                ),
                (
                    "untisname",
                    models.CharField(
                        blank=True, db_column="UntisName", max_length=20, null=True
                    ),
                ),
                (
                    "userinfo",
                    models.CharField(
                        blank=True, db_column="UserInfo", max_length=255, null=True
                    ),
                ),
                (
                    "departmentrights",
                    models.CharField(
                        blank=True,
                        db_column="DepartmentRights",
                        max_length=255,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "User", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Usergroup",
            fields=[
                (
                    "user_group_id",
                    models.SmallIntegerField(
                        db_column="USER_GROUP_ID", primary_key=True, serialize=False
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        blank=True, db_column="Name", max_length=32, null=True
                    ),
                ),
                (
                    "schools",
                    models.CharField(
                        blank=True, db_column="Schools", max_length=255, null=True
                    ),
                ),
                (
                    "schoolyears",
                    models.CharField(
                        blank=True, db_column="SchoolYears", max_length=255, null=True
                    ),
                ),
                (
                    "versions",
                    models.CharField(
                        blank=True, db_column="Versions", max_length=255, null=True
                    ),
                ),
                (
                    "department",
                    models.CharField(
                        blank=True, db_column="Department", max_length=255, null=True
                    ),
                ),
                (
                    "termnames",
                    models.CharField(
                        blank=True, db_column="TermNames", max_length=255, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=255, null=True
                    ),
                ),
                (
                    "openschool",
                    models.IntegerField(blank=True, db_column="OpenSchool", null=True),
                ),
                (
                    "openschoolyear",
                    models.IntegerField(
                        blank=True, db_column="OpenSchoolYear", null=True
                    ),
                ),
                (
                    "openversion",
                    models.IntegerField(blank=True, db_column="OpenVersion", null=True),
                ),
                (
                    "useradministration",
                    models.IntegerField(
                        blank=True, db_column="UserAdministration", null=True
                    ),
                ),
                (
                    "administration",
                    models.IntegerField(
                        blank=True, db_column="Administration", null=True
                    ),
                ),
                (
                    "timetableoptimisation",
                    models.IntegerField(
                        blank=True, db_column="TimetableOptimisation", null=True
                    ),
                ),
                (
                    "rightsprint",
                    models.IntegerField(blank=True, db_column="RightsPrint", null=True),
                ),
                (
                    "save2gpn",
                    models.IntegerField(blank=True, db_column="Save2gpn", null=True),
                ),
                (
                    "infostp",
                    models.IntegerField(blank=True, db_column="InfoStp", null=True),
                ),
                (
                    "timetable",
                    models.SmallIntegerField(
                        blank=True, db_column="Timetable", null=True
                    ),
                ),
                (
                    "masterdata",
                    models.SmallIntegerField(
                        blank=True, db_column="MasterData", null=True
                    ),
                ),
                (
                    "specialdata",
                    models.SmallIntegerField(
                        blank=True, db_column="SpecialData", null=True
                    ),
                ),
                (
                    "lesson",
                    models.SmallIntegerField(blank=True, db_column="Lesson", null=True),
                ),
                (
                    "terms",
                    models.SmallIntegerField(blank=True, db_column="Terms", null=True),
                ),
                (
                    "substitution",
                    models.SmallIntegerField(
                        blank=True, db_column="Substitution", null=True
                    ),
                ),
                (
                    "absences",
                    models.SmallIntegerField(
                        blank=True, db_column="Absences", null=True
                    ),
                ),
                (
                    "coursplaning",
                    models.SmallIntegerField(
                        blank=True, db_column="Coursplaning", null=True
                    ),
                ),
                (
                    "deduction",
                    models.SmallIntegerField(
                        blank=True, db_column="Deduction", null=True
                    ),
                ),
                (
                    "importdata",
                    models.IntegerField(blank=True, db_column="ImportData", null=True),
                ),
                (
                    "webuntis",
                    models.IntegerField(blank=True, db_column="WebUntis", null=True),
                ),
                (
                    "subststatistics",
                    models.IntegerField(
                        blank=True, db_column="SubstStatistics", null=True
                    ),
                ),
            ],
            options={"db_table": "UserGroup", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Usermessage",
            fields=[
                (
                    "message_id",
                    models.IntegerField(
                        db_column="MESSAGE_ID", primary_key=True, serialize=False
                    ),
                ),
                ("user_id", models.IntegerField(db_column="USER_ID")),
                (
                    "sender_id",
                    models.SmallIntegerField(
                        blank=True, db_column="Sender_ID", null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "time",
                    models.SmallIntegerField(blank=True, db_column="Time", null=True),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "newmessage",
                    models.IntegerField(blank=True, db_column="NewMessage", null=True),
                ),
                (
                    "notread",
                    models.IntegerField(blank=True, db_column="NotRead", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=1000, null=True
                    ),
                ),
                (
                    "subject",
                    models.CharField(
                        blank=True, db_column="Subject", max_length=100, null=True
                    ),
                ),
            ],
            options={"db_table": "UserMessage", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Valuecorrection",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("teacher_id", models.IntegerField(db_column="TEACHER_ID")),
                ("number", models.SmallIntegerField(db_column="Number")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=100, null=True
                    ),
                ),
                (
                    "flags",
                    models.CharField(
                        blank=True, db_column="Flags", max_length=100, null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "type1",
                    models.CharField(
                        blank=True, db_column="Type1", max_length=1, null=True
                    ),
                ),
                (
                    "value",
                    models.IntegerField(blank=True, db_column="Value", null=True),
                ),
                (
                    "valueminutes",
                    models.IntegerField(
                        blank=True, db_column="ValueMinutes", null=True
                    ),
                ),
                (
                    "percentage",
                    models.SmallIntegerField(
                        blank=True, db_column="Percentage", null=True
                    ),
                ),
                (
                    "basis",
                    models.CharField(
                        blank=True, db_column="Basis", max_length=1, null=True
                    ),
                ),
                (
                    "schoolorig",
                    models.CharField(
                        blank=True, db_column="SchoolOrig", max_length=100, null=True
                    ),
                ),
            ],
            options={"db_table": "ValueCorrection", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Version",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                (
                    "counterlast",
                    models.IntegerField(blank=True, db_column="CounterLast", null=True),
                ),
                (
                    "usercounterlast",
                    models.IntegerField(
                        blank=True, db_column="UserCounterLast", null=True
                    ),
                ),
                (
                    "user_idlast",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_IDLast", null=True
                    ),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "mode",
                    models.SmallIntegerField(blank=True, db_column="Mode", null=True),
                ),
                (
                    "process",
                    models.SmallIntegerField(
                        blank=True, db_column="Process", null=True
                    ),
                ),
                ("date", models.IntegerField(blank=True, db_column="Date", null=True)),
                (
                    "time",
                    models.SmallIntegerField(blank=True, db_column="Time", null=True),
                ),
                (
                    "progdate",
                    models.CharField(
                        blank=True, db_column="ProgDate", max_length=12, null=True
                    ),
                ),
                (
                    "text",
                    models.CharField(
                        blank=True, db_column="Text", max_length=50, null=True
                    ),
                ),
                (
                    "only1user",
                    models.IntegerField(blank=True, db_column="Only1User", null=True),
                ),
                (
                    "action",
                    models.IntegerField(blank=True, db_column="Action", null=True),
                ),
                (
                    "updatedb",
                    models.IntegerField(blank=True, db_column="UpdateDb", null=True),
                ),
                (
                    "readdb",
                    models.IntegerField(blank=True, db_column="ReadDb", null=True),
                ),
            ],
            options={"db_table": "Version", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
        migrations.CreateModel(
            name="Views",
            fields=[
                (
                    "school_id",
                    models.IntegerField(
                        db_column="SCHOOL_ID", primary_key=True, serialize=False
                    ),
                ),
                ("schoolyear_id", models.IntegerField(db_column="SCHOOLYEAR_ID")),
                ("version_id", models.SmallIntegerField(db_column="VERSION_ID")),
                ("type", models.SmallIntegerField(db_column="Type")),
                ("views_id", models.IntegerField(db_column="VIEWS_ID")),
                ("owner", models.SmallIntegerField(db_column="Owner")),
                (
                    "counter",
                    models.IntegerField(blank=True, db_column="Counter", null=True),
                ),
                (
                    "user_id",
                    models.SmallIntegerField(
                        blank=True, db_column="USER_ID", null=True
                    ),
                ),
                (
                    "deleted",
                    models.IntegerField(blank=True, db_column="Deleted", null=True),
                ),
                (
                    "sortid",
                    models.IntegerField(blank=True, db_column="SortId", null=True),
                ),
                (
                    "window",
                    models.CharField(
                        blank=True, db_column="Window", max_length=255, null=True
                    ),
                ),
                (
                    "typem",
                    models.CharField(
                        blank=True, db_column="TypeM", max_length=2, null=True
                    ),
                ),
                (
                    "fieldbool1",
                    models.IntegerField(blank=True, db_column="FieldBool1", null=True),
                ),
                (
                    "fieldbool2",
                    models.IntegerField(blank=True, db_column="FieldBool2", null=True),
                ),
                (
                    "fieldbool3",
                    models.IntegerField(blank=True, db_column="FieldBool3", null=True),
                ),
                (
                    "fieldbool4",
                    models.IntegerField(blank=True, db_column="FieldBool4", null=True),
                ),
                (
                    "fieldbool5",
                    models.IntegerField(blank=True, db_column="FieldBool5", null=True),
                ),
                (
                    "fieldbool6",
                    models.IntegerField(blank=True, db_column="FieldBool6", null=True),
                ),
                (
                    "fieldbool7",
                    models.IntegerField(blank=True, db_column="FieldBool7", null=True),
                ),
                (
                    "fieldbool8",
                    models.IntegerField(blank=True, db_column="FieldBool8", null=True),
                ),
                (
                    "fieldbool9",
                    models.IntegerField(blank=True, db_column="FieldBool9", null=True),
                ),
                (
                    "fieldbool10",
                    models.IntegerField(blank=True, db_column="FieldBool10", null=True),
                ),
                (
                    "fieldbool11",
                    models.IntegerField(blank=True, db_column="FieldBool11", null=True),
                ),
                (
                    "fieldbool12",
                    models.IntegerField(blank=True, db_column="FieldBool12", null=True),
                ),
                (
                    "fieldbool13",
                    models.IntegerField(blank=True, db_column="FieldBool13", null=True),
                ),
                (
                    "fieldbool14",
                    models.IntegerField(blank=True, db_column="FieldBool14", null=True),
                ),
                (
                    "fieldbool15",
                    models.IntegerField(blank=True, db_column="FieldBool15", null=True),
                ),
                (
                    "fieldbool16",
                    models.IntegerField(blank=True, db_column="FieldBool16", null=True),
                ),
                (
                    "fieldbool17",
                    models.IntegerField(blank=True, db_column="FieldBool17", null=True),
                ),
                (
                    "fieldbool18",
                    models.IntegerField(blank=True, db_column="FieldBool18", null=True),
                ),
                (
                    "fieldbool19",
                    models.IntegerField(blank=True, db_column="FieldBool19", null=True),
                ),
                (
                    "fieldbool20",
                    models.IntegerField(blank=True, db_column="FieldBool20", null=True),
                ),
                (
                    "fieldint1",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt1", null=True
                    ),
                ),
                (
                    "fieldint2",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt2", null=True
                    ),
                ),
                (
                    "fieldint3",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt3", null=True
                    ),
                ),
                (
                    "fieldint4",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt4", null=True
                    ),
                ),
                (
                    "fieldint5",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt5", null=True
                    ),
                ),
                (
                    "fieldint6",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt6", null=True
                    ),
                ),
                (
                    "fieldint7",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt7", null=True
                    ),
                ),
                (
                    "fieldint8",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt8", null=True
                    ),
                ),
                (
                    "fieldint9",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt9", null=True
                    ),
                ),
                (
                    "fieldint10",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt10", null=True
                    ),
                ),
                (
                    "fieldint11",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt11", null=True
                    ),
                ),
                (
                    "fieldint12",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt12", null=True
                    ),
                ),
                (
                    "fieldint13",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt13", null=True
                    ),
                ),
                (
                    "fieldint14",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt14", null=True
                    ),
                ),
                (
                    "fieldint15",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt15", null=True
                    ),
                ),
                (
                    "fieldint16",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt16", null=True
                    ),
                ),
                (
                    "fieldint17",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt17", null=True
                    ),
                ),
                (
                    "fieldint18",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt18", null=True
                    ),
                ),
                (
                    "fieldint19",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt19", null=True
                    ),
                ),
                (
                    "fieldint20",
                    models.SmallIntegerField(
                        blank=True, db_column="FieldInt20", null=True
                    ),
                ),
                (
                    "fieldlong1",
                    models.IntegerField(blank=True, db_column="FieldLong1", null=True),
                ),
                (
                    "fieldlong2",
                    models.IntegerField(blank=True, db_column="FieldLong2", null=True),
                ),
                (
                    "fieldlong3",
                    models.IntegerField(blank=True, db_column="FieldLong3", null=True),
                ),
                (
                    "fieldlong4",
                    models.IntegerField(blank=True, db_column="FieldLong4", null=True),
                ),
                (
                    "fieldlong5",
                    models.IntegerField(blank=True, db_column="FieldLong5", null=True),
                ),
                (
                    "fieldlong6",
                    models.IntegerField(blank=True, db_column="FieldLong6", null=True),
                ),
                (
                    "fieldlong7",
                    models.IntegerField(blank=True, db_column="FieldLong7", null=True),
                ),
                (
                    "fieldlong8",
                    models.IntegerField(blank=True, db_column="FieldLong8", null=True),
                ),
                (
                    "fieldtext255a",
                    models.CharField(
                        blank=True, db_column="FieldText255A", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255b",
                    models.CharField(
                        blank=True, db_column="FieldText255B", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255c",
                    models.CharField(
                        blank=True, db_column="FieldText255C", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255d",
                    models.CharField(
                        blank=True, db_column="FieldText255D", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255e",
                    models.CharField(
                        blank=True, db_column="FieldText255E", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255f",
                    models.CharField(
                        blank=True, db_column="FieldText255F", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255g",
                    models.CharField(
                        blank=True, db_column="FieldText255G", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext255h",
                    models.CharField(
                        blank=True, db_column="FieldText255H", max_length=255, null=True
                    ),
                ),
                (
                    "fieldtext1000a",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000A",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000b",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000B",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000c",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000C",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000d",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000D",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000e",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000E",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000f",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000F",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000g",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000G",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000h",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000H",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000i",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000I",
                        max_length=1000,
                        null=True,
                    ),
                ),
                (
                    "fieldtext1000j",
                    models.CharField(
                        blank=True,
                        db_column="FieldText1000J",
                        max_length=1000,
                        null=True,
                    ),
                ),
            ],
            options={"db_table": "Views", "managed": False,},
            bases=(models.Model, aleksis.core.mixins.PureDjangoModel),
        ),
    ]
